package com.alibaba.hbase.haclient.dualservice;

import java.util.concurrent.Callable;

import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class DualScannerCallable<T> implements Callable<T> {

  private DualContext<T> context;

  private ResultScanner scanner;

  private DualExecutor.Role role;

  public DualScannerCallable(DualContext<T> context, ResultScanner scanner,
                             DualExecutor.Role role){
    this.context = context;
    this.scanner = scanner;
    this.role = role;
  }

  @Override
  public T call() throws Exception {
    try{
      Result nextResult = (Result)this.scanner.next();
      DualScannerResult result = new DualScannerResult(this.scanner, nextResult);
      if(role == DualExecutor.Role.ACTIVE) {
        this.context.onActiveComplete((T)result);
      }else{
        this.context.onStandbyComplete((T)result);
      }
      return (T)result;
    }catch(Throwable t){
      if(role == DualExecutor.Role.ACTIVE) {
        this.context.onActiveError(t);
      }else{
        this.context.onStandbyError(t);
      }
    }
    return null;
  }
}