/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.hbase.jdbc;

import org.apache.calcite.avatica.util.ByteString;

public class LindormSqlUtils {
  public static String toHexString(byte[] bytes) {
    if (bytes == null) {
      return null;
    }
    return ByteString.toString(bytes, 16);
  }

  public static byte[] fromHexString(String s) {
    if (s == null) {
      return null;
    }
    return ByteString.parse(s, 16);
  }
}
