/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.ConnectionCounter;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.ExecuteCounter;
import com.alibaba.hbase.haclient.dualservice.KeyCounter;
import com.alibaba.hbase.haclient.dualservice.TableCounter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public class AutoSwitch {
    private static final Log LOG = LogFactory.getLog(AutoSwitch.class);
    private boolean autoSwitchEnable;
    private long autoSwitchInterval;
    private Configuration conf;
    private SwitchLevel switchLevel;
    private ExecuteCounter executeCounter;
    private ExecuteCounter tableCounter;
    private volatile boolean locateAvaliable = true;
    private long switchTime = 0L;

    public AutoSwitch(Configuration conf) {
        this.conf = conf;
        this.autoSwitchEnable = conf.getBoolean("hbase.autoswitch.enable", false);
        this.switchLevel = SwitchLevel.valueOf(conf.get("hbase.autoswitch.switch.level", "CONNECTION".toString()));
        this.initExecuteCounter(this.switchLevel);
        this.autoSwitchInterval = conf.getLong("autoswitch.interval", Long.MAX_VALUE);
    }

    private void initExecuteCounter(SwitchLevel switchLevel) {
        switch (this.switchLevel) {
            case KEY: {
                this.executeCounter = new KeyCounter(this.conf);
                this.tableCounter = new TableCounter(this.conf);
                break;
            }
            case TABLE: {
                this.executeCounter = new TableCounter(this.conf);
                break;
            }
            case CONNECTION: {
                this.executeCounter = new ConnectionCounter(this.conf);
            }
        }
    }

    private <T> ExecuteCounter getExecuteCounter(DualContext<T> dualContext) {
        if (this.switchLevel == SwitchLevel.KEY) {
            if (dualContext.getActionType() != null) {
                return this.executeCounter;
            }
            return this.tableCounter;
        }
        return this.executeCounter;
    }

    public <T> void update(DualContext<T> dualContext) {
        if (!this.autoSwitchEnable) {
            return;
        }
        ExecuteCounter counter = this.getExecuteCounter(dualContext);
        counter.update(dualContext);
    }

    public synchronized <T> ExecuteStrategy getExecuteStrategy(DualContext<T> dualContext) {
        if (!this.autoSwitchEnable) {
            return ExecuteStrategy.DEFAULT;
        }
        ExecuteCounter counter = this.getExecuteCounter(dualContext);
        if (!counter.reachLimit(dualContext)) {
            if (counter.isSwitchStatus(dualContext)) {
                return ExecuteStrategy.SWITCH;
            }
            return ExecuteStrategy.DEFAULT;
        }
        if (!counter.isSwitchStatus(dualContext)) {
            this.switchTime = System.currentTimeMillis();
            counter.setSwitchStatus(dualContext, true);
            LOG.debug((Object)(TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString() + " active error count reach limit, switch to standby"));
            return ExecuteStrategy.SWITCH;
        }
        if (System.currentTimeMillis() - this.switchTime > this.autoSwitchInterval) {
            counter.setSwitchStatus(dualContext, false);
            LOG.debug((Object)(TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString() + " old active success count reach limit, switch back to old active"));
            this.locateAvaliable = true;
            return ExecuteStrategy.DEFAULT;
        }
        return ExecuteStrategy.SWITCH;
    }

    public boolean isAutoSwitchEnable() {
        return this.autoSwitchEnable;
    }

    public void setAutoSwitchEnable(boolean autoSwitchEnable) {
        this.autoSwitchEnable = autoSwitchEnable;
    }

    public SwitchLevel getSwitchLevel() {
        return this.switchLevel;
    }

    public void setSwitchLevel(SwitchLevel switchLevel) {
        this.switchLevel = switchLevel;
    }

    public boolean needKeyInfo() {
        return this.locateAvaliable && this.switchLevel == SwitchLevel.KEY;
    }

    public void reset() {
        this.initExecuteCounter(this.switchLevel);
    }

    public void setLocateAvaliable(boolean locateAvaliable) {
        this.locateAvaliable = locateAvaliable;
    }

    public static enum ExecuteStrategy {
        DEFAULT,
        SWITCH;

    }

    public static enum SwitchLevel {
        CONNECTION("CONNECTION"),
        TABLE("TABLE"),
        KEY("KEY");

        private final String value;

        private SwitchLevel(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

