/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client;

import java.util.ArrayList;
import java.util.List;

public abstract class AsyncCallback<T> {
    protected List<Runnable> completeListener;
    protected List<Runnable> errorListener;

    public void addCompleteListener(Runnable runnable) {
        if (this.completeListener == null) {
            this.completeListener = new ArrayList<Runnable>();
        }
        this.completeListener.add(runnable);
    }

    public void addErrorListener(Runnable runnable) {
        if (this.errorListener == null) {
            this.errorListener = new ArrayList<Runnable>();
        }
        this.errorListener.add(runnable);
    }

    protected void invokeErrorListener(Throwable exception) {
        if (this.errorListener == null) {
            return;
        }
        for (Runnable runnable : this.errorListener) {
            runnable.run();
        }
    }

    protected void invokeCompleteListener(T result) {
        if (this.completeListener == null) {
            return;
        }
        for (Runnable runnable : this.completeListener) {
            runnable.run();
        }
    }

    public abstract void onComplete(T var1);

    public abstract void onError(Throwable var1);

    public boolean shouldProcessResultInPool() {
        return true;
    }

    public boolean isRetrying() {
        return false;
    }

    public boolean isBlockable() {
        return true;
    }
}

