/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.meta.Entity;
import com.alibaba.lindorm.client.core.meta.EntityMeta;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.meta.TableCategory;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableState;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.tableservice.LIndexDescriptor;
import com.alibaba.lindorm.client.core.tableservice.LModifyTableRequest;
import com.alibaba.lindorm.client.core.tableservice.entity.AlterEntityOperation;
import com.alibaba.lindorm.client.core.tableservice.entity.LAlterEntityStateRequest;
import com.alibaba.lindorm.client.core.tableservice.index.BuildIndexRequest;
import com.alibaba.lindorm.client.core.tableservice.index.IndexList;
import com.alibaba.lindorm.client.core.tableservice.index.LSearchIndexDescriptor;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.EntityUtils;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import com.alibaba.lindorm.client.core.utils.ModifySchemaOperation;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.IndexNotFoundException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ActivateEntityOption;
import com.alibaba.lindorm.client.schema.BuildIndexJobStatus;
import com.alibaba.lindorm.client.schema.CHSColumnSchema;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.CreateEntityOptions;
import com.alibaba.lindorm.client.schema.CreateTableLikeOptions;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexBuildingProgress;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import com.alibaba.lindorm.client.schema.LindormEntities;
import com.alibaba.lindorm.client.schema.LindormEntityDescriptor;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormSearchIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicDDLService
extends LindormBasicService {
    public static final Log LOG = LogFactory.getLog(BasicDDLService.class);
    private static final int millisInSeconds = 1000;

    public BasicDDLService() {
    }

    public BasicDDLService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    public void useNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() throws LindormException {
        if (this.namespace == null) {
            throw new LindormException("Namespace is not specified!");
        }
        return this.namespace;
    }

    public void prefetchRouteCache(String table) throws LindormException {
        this.checkOpen();
        try {
            this.lconnection.prefetchRouteCache(this.getNamespace(), table);
        }
        catch (IOException ioe) {
            throw new LindormException("Failed to prefetchRouteCache for table " + table, ioe);
        }
    }

    public List<String> listTables() throws LindormException {
        try {
            LServerCallable<List<String>> listTablesByNamespaceCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesByNamespace(BasicDDLService.this.getNamespace());
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesByNamespaceCallable);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public List<String> listTables(final TableCategory category) throws LindormException {
        try {
            LServerCallable<List<String>> listTablesWithCategoryByNamespaceCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesWithCategoryByNamespace(BasicDDLService.this.getNamespace(), category);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesWithCategoryByNamespaceCallable);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public void createTable(LindormTableDescriptor desc) throws LindormException {
        this.checkOpen();
        this.createTable(desc, (byte[][])null);
    }

    public void createTable(LindormTableDescriptor desc, int numRegions) throws LindormException {
        this.createTable(desc, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, int numRegions, int timeout) throws LindormException {
        this.checkOpen();
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        byte[][] splitKeys = null;
        if (desc.isHashTable()) {
            if ((numRegions & numRegions - 1) != 0) {
                throw new LindormException("Number of initial regions in a hash table must be a power of 2!");
            }
            splitKeys = KeyHashFunction.evenSplit(numRegions);
        } else {
            splitKeys = SchemaUtils.isSaltPkOption(firstPK.getPkOption()) ? SchemaUtils.getSplits(DataType.VARBINARY, numRegions) : SchemaUtils.getSplits(firstPK.getDataType(), numRegions);
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws LindormException {
        this.createTable(desc, startKey, endKey, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, Object minValue, Object maxValue, int numRegions) throws LindormException {
        this.createTable(desc, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, Object minValue, Object maxValue, int numRegions, int timeout) throws LindormException {
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        if (SchemaUtils.hasTableSaltedPkOption(desc.getPkColumns())) {
            throw new LindormException("Salted table can not be created with partial range!");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(firstPK.getDataType(), minValue, maxValue, numRegions);
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions, int timeout) throws LindormException {
        this.checkOpen();
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        if (SchemaUtils.hasTableSaltedPkOption(desc.getPkColumns())) {
            throw new LindormException("Salted table can not be created with partial range!");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new LindormException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(startKey, endKey, numRegions);
        if (splitKeys.length != numRegions - 1) {
            throw new LindormException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, List<Object> partitions) throws LindormException {
        this.createTable(desc, partitions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, List<Object> partitions, int timeout) throws LindormException {
        int i;
        this.checkOpen();
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with user assigned partitions!");
        }
        if (partitions == null || partitions.isEmpty()) {
            throw new LindormException("Partition list should not be null");
        }
        byte[][] splitKeys = new byte[partitions.size()][];
        for (i = 0; i < partitions.size(); ++i) {
            splitKeys[i] = LDataTypeFactory.INSTANCE.getTypeInstance(firstPK.getDataType()).toBytes(partitions.get(i));
        }
        for (i = 1; i < splitKeys.length; ++i) {
            if (Bytes.compareTo(splitKeys[i - 1], splitKeys[i]) < 0) continue;
            throw new LindormException("Assigned partitions are not in order, please check");
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.createTable(desc, splitKeys, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, byte[][] splitKeys, int timeoutSeconds) throws LindormException {
        this.checkOpen();
        this.createTableAsync(desc, splitKeys);
        this.blockingAndWaitForSuccess(desc.getName(), AsyncDDLType.CREATE, timeoutSeconds);
    }

    public void createTableAsync(LindormTableDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateTableDescriptor(desc);
            TableMeta meta = new TableMeta(this.getNamespace(), desc);
            this.doCreateTableAsync(meta, splitKeys);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void doCreateTableAsync(final TableMeta meta, final byte[][] splitKeys) throws IOException {
        LServerCallable<Void> createTableCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

            @Override
            public Void call() throws Exception {
                this.server.createTableAsync(meta, splitKeys);
                return null;
            }
        };
        this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(createTableCallable);
    }

    public void createTableLike(String newTable, String existedTable) throws LindormException {
        this.createTableLike(newTable, existedTable, null);
    }

    public void createTableLike(String newTable, String existedTable, CreateTableLikeOptions options) throws LindormException {
        this.checkOpen();
        try {
            if (StringUtils.isNullOrEmpty(newTable)) {
                throw new LindormException("New table name must not be null or emtpy.");
            }
            if (StringUtils.isNullOrEmpty(existedTable)) {
                throw new LindormException("Existed table name must not be null or emtpy.");
            }
            TableMeta existedTableMeta = this.getTableMeta(existedTable);
            if (existedTableMeta.getType() != TableType.WIDE_COLUMN_TABLE && existedTableMeta.getType() != TableType.DATA_TABLE) {
                throw new LindormException("Only support wide column table and data table now for create like");
            }
            this.validateCreateTableLikeOptions(options);
            boolean copyIndexes = this.isCopyIndexes(existedTableMeta, options);
            boolean copySplitKeys = this.isCopySplitKeys(options);
            boolean assignedRegions = this.isAssignedRegions(options);
            TableMeta newTableMeta = TableMeta.deepCopyIgnoreIndex(existedTableMeta, newTable);
            byte[][] splitKeys = null;
            if (assignedRegions) {
                int maxRegionNumber = options.getMaxRegionNumber();
                splitKeys = this.calcNewSplitKeys(existedTable, maxRegionNumber - 1);
                LOG.info((Object)("Create table " + newTable + " like " + existedTable + " with " + maxRegionNumber + " regions"));
            } else if (copySplitKeys) {
                splitKeys = this.getTableSplitKeys(existedTable);
                LOG.info((Object)("Create table " + newTable + " like " + existedTable + " with its split keys"));
            }
            this.doCreateTableAsync(newTableMeta, splitKeys);
            this.blockingAndWaitForSuccess(newTable, AsyncDDLType.CREATE, Integer.MAX_VALUE);
            if (copyIndexes) {
                LindormTableDescriptor newTableDesc = TableMeta.buildLindormTableDescriptor(existedTableMeta);
                List<LindormIndexDescriptor> newIndexDes = newTableDesc.getIndexes();
                for (LindormIndexDescriptor desc : newIndexDes) {
                    if (desc.isLocalIndex()) {
                        throw new LindormException("Local index not support now");
                    }
                    desc.setDataTableName(newTable);
                    desc.setIndexState(IndexState.ACTIVE);
                    this.createIndex(desc);
                }
                LOG.info((Object)("Create table " + newTable + " like " + existedTable + "with its indexes"));
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private byte[][] getTableSplitKeys(String tableName) throws LindormException {
        this.prefetchRouteCache(tableName);
        LDServerLocator ldServerLocator = this.lconnection.getLdServerLocator();
        String idc = ldServerLocator.getAllIDC().get(0);
        ArrayList alltableRegions = new ArrayList();
        LocationCache lcache = ldServerLocator.getLocationCacheOfIDC(idc);
        ConcurrentSkipListMap<byte[], LocationCache.Location> tableLocationsMap = lcache.getTableLocations(this.namespace, tableName);
        for (Map.Entry location : tableLocationsMap.entrySet()) {
            alltableRegions.add(location.getValue());
        }
        int splitKeyNum = alltableRegions.size() - 1;
        Object splitKeys = null;
        if (splitKeyNum > 0) {
            splitKeys = new byte[splitKeyNum][];
            Iterator hriIter = alltableRegions.iterator();
            for (int i = 0; i < splitKeyNum && hriIter.hasNext(); ++i) {
                splitKeys[i] = ((LocationCache.Location)hriIter.next()).getEndKey();
            }
        }
        return splitKeys;
    }

    private byte[][] calcNewSplitKeys(String tableName, int maxPartitions) throws LindormException {
        assert (maxPartitions > 0);
        Object splitKeys = this.getTableSplitKeys(tableName);
        if (((byte[][])splitKeys).length <= maxPartitions) {
            return splitKeys;
        }
        float samplingRatio = (float)((byte[][])splitKeys).length / (float)maxPartitions;
        ArrayList<byte[]> samplingKeys = new ArrayList<byte[]>();
        for (int i = 0; i < maxPartitions; ++i) {
            samplingKeys.add(splitKeys[Math.round((float)i * samplingRatio)]);
        }
        splitKeys = new byte[samplingKeys.size()][];
        samplingKeys.toArray((T[])splitKeys);
        return splitKeys;
    }

    private void validateCreateTableLikeOptions(CreateTableLikeOptions options) throws LindormException {
        if (this.isCopySplitKeys(options) && this.isAssignedRegions(options)) {
            throw new LindormException("Copy split keys and assign region number at same time is conflicted");
        }
    }

    private boolean isCopySplitKeys(CreateTableLikeOptions options) {
        if (options != null) {
            return options.getWithSplit();
        }
        return false;
    }

    private boolean isAssignedRegions(CreateTableLikeOptions options) {
        if (options != null) {
            return options.maxRegionNumberHasAssigned();
        }
        return false;
    }

    private boolean isCopyIndexes(TableMeta meta, CreateTableLikeOptions options) throws LindormException {
        if (!meta.hasIndex()) {
            return false;
        }
        if (!StringUtils.isNullOrEmpty(meta.getExternalIndexConfig())) {
            throw new LindormException("Extern index not support now");
        }
        if (options != null) {
            return options.getWithIndex();
        }
        return false;
    }

    public void createLocalIndex(LindormIndexDescriptor desc) throws LindormException {
        this.createLocalIndex(desc, Integer.MAX_VALUE);
    }

    public void createLocalIndex(LindormIndexDescriptor desc, int timeoutSeconds) throws LindormException {
        this.checkOpen();
        try {
            this.createLocalIndexAsync(desc);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeoutSeconds);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createLocalIndexAsync(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            LServerCallable<Void> createLocalIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createLocalIndex(index);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createLocalIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormIndexDescriptor desc) throws LindormException {
        this.createIndex(desc, Integer.MAX_VALUE);
    }

    public void buildIndex(String namespace, String tableName, String indexName) throws LindormException {
        this.checkOpen();
        try {
            this.buildIndexAsync(namespace, tableName, indexName);
            String taskName = IndexUtils.getIndexTableName(tableName, indexName);
            this.blockingAndWaitForSuccess(taskName, AsyncDDLType.BUILD_INDEX, Integer.MAX_VALUE);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void buildIndexAsync(final String namespace, final String tableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> buildIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.buildIndex(namespace, tableName, indexName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(buildIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public boolean isBuildIndexSuccess(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        try {
            this.getNamespace();
            LServerCallable<Boolean> buildIndexCallable = new LServerCallable<Boolean>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isBuildIndexSuccess(BasicDDLService.this.namespace, tableName, indexName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(buildIndexCallable);
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().contains("NoSuchMethodException")) {
                String taskName = IndexUtils.getIndexTableName(tableName, indexName);
                Pair<Integer, Integer> pair = this.getOperationStatus(taskName, AsyncDDLType.BUILD_INDEX);
                return pair.getFirst() == 0;
            }
            throw new LindormException(t);
        }
    }

    public void cancelBuildIndex(final String namespace, final String tableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> cancelBuildIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.cancelBuildIndex(namespace, tableName, indexName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(cancelBuildIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void buildIndexAsync(final BuildIndexRequest buildIndexRequest) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> buildIndexV2Callable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.buildIndex(buildIndexRequest);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(buildIndexV2Callable);
        }
        catch (IOException e) {
            if (e.getMessage() != null && e.getMessage().contains("NoSuchMethodException")) {
                try {
                    String namespace = buildIndexRequest.getNamespace();
                    String dataTableName = buildIndexRequest.getDataTableName();
                    String indexName = buildIndexRequest.getIndexName();
                    this.buildIndexAsync(namespace, dataTableName, indexName);
                }
                catch (Throwable tt) {
                    throw new LindormException(tt);
                }
            }
            throw new LindormException(e);
        }
    }

    public IndexBuildingProgress getBuildIndexProgress(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        try {
            this.getNamespace();
            LServerCallable<IndexBuildingProgress> getProgressCallable = new LServerCallable<IndexBuildingProgress>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public IndexBuildingProgress call() throws Exception {
                    return this.server.getBuildIndexProgress(BasicDDLService.this.namespace, indexName, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(getProgressCallable);
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().contains("NoSuchMethodException")) {
                try {
                    boolean success = this.isBuildIndexSuccess(indexName, tableName);
                    BuildIndexJobStatus status = success ? BuildIndexJobStatus.DONE : BuildIndexJobStatus.EXECUTING;
                    IndexBuildingProgress progress = new IndexBuildingProgress(status, -1, -1);
                    return progress;
                }
                catch (Throwable tt) {
                    throw new LindormException(tt);
                }
            }
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormIndexDescriptor desc, int numRegions, int timeout) throws LindormException {
        DataType indexColumnType = this.getIndexedDataType(desc);
        this.createIndex(desc, indexColumnType, numRegions, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.createIndexAsync(desc);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, int numRegions) throws LindormException {
        this.createIndex(desc, indexColumnType, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, int numRegions, int timeout) throws LindormException {
        byte[][] splitKeys = null;
        if (desc.isHashTable()) {
            if ((numRegions & numRegions - 1) != 0) {
                throw new LindormException("Number of initial regions in a hash table must be a power of 2!");
            }
            splitKeys = KeyHashFunction.evenSplit(numRegions);
        } else {
            splitKeys = SchemaUtils.isSaltPkOption(desc.getFirstIndexedColumn().getPkOption()) ? SchemaUtils.getSplits(DataType.VARBINARY, numRegions) : SchemaUtils.getSplits(indexColumnType, numRegions);
        }
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, Object minValue, Object maxValue, int numRegions) throws LindormException {
        DataType columnType = this.getIndexedDataType(desc);
        this.createIndex(desc, columnType, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    private DataType getIndexedDataType(LindormIndexDescriptor desc) throws LindormException {
        IndexedColumnSchema index = desc.getFirstIndexedColumn();
        LindormTableDescriptor ltd = this.describeTable(desc.getDataTableName());
        DataType indexColumnType = null;
        List<PrimaryKeySchema> pkSchemas = ltd.getPkColumns();
        for (PrimaryKeySchema pkSchema : pkSchemas) {
            if (!pkSchema.getNameAsString().equals(index.getColumnKey().getQualifierAsString())) continue;
            indexColumnType = pkSchema.getDataType();
        }
        if (indexColumnType == null) {
            List<ColumnSchema> columnSchemas = ltd.getNonPkColumns();
            for (ColumnSchema colSchema : columnSchemas) {
                if (!colSchema.getColumnNameAsString().equals(index.getColumnKey().getQualifierAsString())) continue;
                indexColumnType = colSchema.getDataType();
            }
        }
        if (indexColumnType == null) {
            throw new LindormException("Find no valid index column for data table\uff0cindex column: " + index.getColumnKey());
        }
        return indexColumnType;
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, Object minValue, Object maxValue, int numRegions) throws LindormException {
        this.createIndex(desc, indexColumnType, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, List<Object> partitions) throws LindormException {
        DataType indexColumnType = this.getIndexedDataType(desc);
        this.createIndex(desc, indexColumnType, partitions);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, List<Object> partitions) throws LindormException {
        this.createIndex(desc, indexColumnType, partitions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, List<Object> partitions, int timeout) throws LindormException {
        int i;
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with user assigned partitions!");
        }
        if (partitions == null || partitions.isEmpty()) {
            throw new LindormException("Partition list should not be null");
        }
        byte[][] splitKeys = new byte[partitions.size()][];
        for (i = 0; i < partitions.size(); ++i) {
            splitKeys[i] = LDataTypeFactory.INSTANCE.getTypeInstance(indexColumnType).toBytes(partitions.get(i));
        }
        for (i = 1; i < splitKeys.length; ++i) {
            if (Bytes.compareTo(splitKeys[i - 1], splitKeys[i]) < 0) continue;
            throw new LindormException("Assigned partitions are not in order, please check");
        }
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, Object minValue, Object maxValue, int numRegions, int timeout) throws LindormException {
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        if (SchemaUtils.hasIndexSaltedPkOption(desc.getIndexedColumns())) {
            throw new LindormException("Salt table can not be created with partial range!");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(indexColumnType, minValue, maxValue, numRegions);
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws LindormException {
        this.createIndex(desc, startKey, endKey, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[] startKey, byte[] endKey, int numRegions, int timeoutInSeconds) throws LindormException {
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        if (SchemaUtils.hasIndexSaltedPkOption(desc.getIndexedColumns())) {
            throw new LindormException("Salt table can not be created with partial range!");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new LindormException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(startKey, endKey, numRegions);
        if (splitKeys.length != numRegions - 1) {
            throw new LindormException("Unable to split key range into enough regions");
        }
        this.createIndex(desc, splitKeys, timeoutInSeconds);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.createIndex(desc, splitKeys, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[][] splitKeys, int timeoutInSeconds) throws LindormException {
        this.checkOpen();
        try {
            this.createIndexAsync(desc, splitKeys);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeoutInSeconds);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndexAsync(LindormIndexDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            byte[][] appendSplitKeys = null;
            if (!desc.isHashTable() && !SchemaUtils.isSaltPkOption(desc.getFirstIndexedColumn().getPkOption()) && desc.isStorePkNulls()) {
                appendSplitKeys = SchemaUtils.appendNullValuePrefix(desc.getFirstIndexedColumn().getSortOrder(), splitKeys);
            }
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            final byte[][] split = appendSplitKeys != null ? appendSplitKeys : splitKeys;
            LServerCallable<Void> createIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createIndex(index, split);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Deprecated
    public void createIndexAsync(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            LServerCallable<Void> createIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createIndex(index);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteIndex(String indexName, String tableName) throws LindormException {
        this.deleteIndex(indexName, tableName, Integer.MAX_VALUE);
    }

    public void deleteIndex(String indexName, String tableName, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.deleteIndexAsync(indexName, tableName);
            this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteIndexAsync(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Index name must not be null or emtpy.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> deleteTableCallable = new LServerCallable<Void>(OperationContext.OperationType.DROP){

                @Override
                public Void call() throws Exception {
                    this.server.deleteIndex(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(deleteTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormSearchIndexDescriptor desc) throws LindormException {
        this.createIndex(desc, Integer.MAX_VALUE);
    }

    public void createIndex(LindormSearchIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.createIndexAsync(desc);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public void createIndexAsync(LindormSearchIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        try {
            this.getNamespace();
            final LSearchIndexDescriptor indexDesc = new LSearchIndexDescriptor(this.namespace, desc);
            SchemaUtils.validateSearchIndexDescriptor(indexDesc);
            LServerCallable<Void> createSearchIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.createIndex(indexDesc);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createSearchIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteTable(final String table) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must not be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> deleteTableCallable = new LServerCallable<Void>(OperationContext.OperationType.DROP){

                @Override
                public Void call() throws Exception {
                    this.server.deleteTable(namespace, Bytes.toBytes(table));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(deleteTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void onlineTable(String table) throws LindormException {
        this.onlineTable(table, Integer.MAX_VALUE);
    }

    public void onlineTable(String table, int timeout) throws LindormException {
        this.checkOpen();
        this.onlineTableAsync(table);
        this.blockingAndWaitForSuccess(table, AsyncDDLType.ONLINE, timeout);
    }

    public void onlineTableAsync(final String table) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> onlineCallable = new LServerCallable<Void>(OperationContext.OperationType.ENABLE){

                @Override
                public Void call() throws Exception {
                    this.server.enableTableAsync(namespace, Bytes.toBytes(table));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(onlineCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void offlineTable(String tableName) throws LindormException {
        this.offlineTable(tableName, Integer.MAX_VALUE);
    }

    public void offlineTable(String tableName, int timeout) throws LindormException {
        this.checkOpen();
        this.offlineTableAsync(tableName);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.OFFLINE, timeout);
    }

    public void offlineTableAsync(String tableName) throws LindormException {
        this.offlineTableAsync(tableName, false);
    }

    public void offlineTableAsync(final String tableName, boolean skipSync) throws LindormException {
        this.checkOpen();
        if (!skipSync) {
            this.disableWritingAndSync(tableName);
        }
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> offlineCallable = new LServerCallable<Void>(OperationContext.OperationType.DISABLE){

                @Override
                public Void call() throws Exception {
                    this.server.disableTableAsync(namespace, Bytes.toBytes(tableName));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(offlineCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void truncateTable(String tableName) throws LindormException {
        this.truncateTable(tableName, Integer.MAX_VALUE);
    }

    public void truncateTable(String tableName, boolean withSplit) throws LindormException {
        this.truncateTable(tableName, withSplit, Integer.MAX_VALUE);
    }

    public void truncateTable(String tableName, int timeout) throws LindormException {
        this.checkOpen();
        this.truncateTableAsync(tableName);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.TRUNCATE, timeout);
    }

    public void truncateTable(String tableName, boolean withSplit, int timeout) throws LindormException {
        this.checkOpen();
        this.truncateTableAsync(tableName, withSplit);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.TRUNCATE, timeout);
    }

    public void truncateTableAsync(String table) throws LindormException {
        this.truncateTableAsync(table, true);
    }

    public void truncateTableAsync(final String table, final boolean withSplit) throws LindormException {
        this.checkOpen();
        try {
            if (StringUtils.isNullOrEmpty(table)) {
                throw new LindormException("Table name must not be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> truncateTableCallable = new LServerCallable<Void>(OperationContext.OperationType.TRUNCATE){

                @Override
                public Void call() throws Exception {
                    if (withSplit) {
                        this.server.truncateTableAsync(namespace, Bytes.toBytes(table));
                    } else {
                        this.server.truncateTableAsync(namespace, Bytes.toBytes(table), withSplit);
                    }
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(truncateTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void addFamily(String tableName, ColumnFamilyDescriptor col) throws LindormException {
        this.addFamily(tableName, col, Integer.MAX_VALUE);
    }

    public void addFamily(String tableName, ColumnFamilyDescriptor col, int timeout) throws LindormException {
        this.checkOpen();
        this.addFamilyAsync(tableName, col);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addFamilyAsync(String tableName, ColumnFamilyDescriptor col) throws LindormException {
        if (col == null) {
            throw new IllegalRequestException("There must be at least one ColumnFamilyDescriptor to add, but has none.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot add family to index table: " + meta.getIndexName());
            }
            if (SchemaUtils.isDefaultFamily(col.getName())) {
                throw new IllegalRequestException("Cannot add system family name:f");
            }
            meta.getFamilies().add(col);
            CHSColumnSchema.validateCHSColumnSchema(meta);
            this.internalModifyTableAsync(meta, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public void addColumn(String tableName, ColumnSchema col) throws LindormException {
        this.addColumn(tableName, col, Integer.MAX_VALUE);
    }

    public void addColumn(String tableName, List<ColumnSchema> columns) throws LindormException {
        this.addColumn(tableName, columns, Integer.MAX_VALUE);
    }

    public void addColumn(String tableName, ColumnSchema col, int timeout) throws LindormException {
        this.checkOpen();
        this.addColumnAsync(tableName, col);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addColumn(String tableName, List<ColumnSchema> columns, int timeout) throws LindormException {
        this.checkOpen();
        this.addColumnAsync(tableName, columns);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addColumnAsync(String tableName, ColumnSchema col) throws LindormException {
        if (col == null) {
            throw new IllegalRequestException("New column schema must not be null.");
        }
        ArrayList<ColumnSchema> newSchema = CollectionUtils.newArrayList(col);
        this.addColumnAsync(tableName, newSchema);
    }

    public void addColumnAsync(String tableName, List<ColumnSchema> columns) throws LindormException {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalRequestException("There must be at least one ColumnSchema to add, but has none.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot add column to index table: " + meta.getIndexName());
            }
            LindormTableDescriptor desc = TableMeta.buildLindormTableDescriptor(meta);
            boolean noDefaultFamily = !SchemaUtils.hasDefaultFamily(desc.getNonPkColumns());
            for (ColumnSchema col : columns) {
                if (col == null) {
                    throw new IllegalRequestException("New column schema must not be null.");
                }
                byte[] familyName = col.getFamilyName();
                if (noDefaultFamily && (familyName == null || SchemaUtils.isDefaultFamily(familyName))) {
                    throw new IllegalDataException("Cannot add column to non-existed column family : default family.");
                }
                desc.addNonPkcolumn(col);
            }
            SchemaUtils.validateColumnSchema(desc);
            List<LColumn> allColumns = meta.getAllColumns();
            int position = allColumns.size();
            for (ColumnSchema col : columns) {
                allColumns.add(new LColumn(col, position));
                ++position;
            }
            ModifySchemaOperation schemaOperation = ModifySchemaOperation.ADD_COLUMN;
            if (SchemaUtils.needOpenRegion(meta)) {
                schemaOperation = ModifySchemaOperation.ADD_COLUMN_OPEN_REGION;
            }
            this.internalModifyTableAsync(meta, schemaOperation);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public void modifyTableAttributes(String tableName, List<LindormAttribute> attributes) throws LindormException {
        this.modifyTableAttributes(tableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyTableAttributes(String tableName, List<LindormAttribute> attributes, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableAttributesAsync(tableName, attributes);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyTableAttributesAsync(String tableName, List<LindormAttribute> attributes) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, attributes, null, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES, -1);
    }

    public void modifyIndexAttributes(String indexName, String dataTableName, List<LindormAttribute> attributes) throws LindormException {
        this.modifyIndexAttributes(indexName, dataTableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyIndexAttributes(String indexName, String dataTableName, List<LindormAttribute> attributes, int timeout) throws LindormException {
        int indexMetaVersion;
        String indexLogicalName;
        this.checkOpen();
        try {
            TableMeta dataTableMeta = this.getTableMeta(dataTableName);
            TableMeta oldIndexMeta = dataTableMeta.getIndexMeta(indexName);
            if (null == oldIndexMeta) {
                throw new IndexNotFoundException(indexName + " on " + dataTableName);
            }
            indexLogicalName = oldIndexMeta.getTableName();
            indexMetaVersion = oldIndexMeta.getMetaVersion();
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.internalModifyTableAttributeAsync(indexLogicalName, attributes, null, ModifySchemaOperation.MODIFY_INDEX_ATTRIBUTES, indexMetaVersion);
        this.blockingAndWaitForSuccess(indexLogicalName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyFamilyAttributes(String tableName, List<LindormFamilyAttributes> attributes) throws LindormException {
        this.modifyFamilyAttributes(tableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyFamilyAttributes(String tableName, List<LindormFamilyAttributes> attributes, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyFamilyAttributesAsync(tableName, attributes);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyFamilyAttributesAsync(String tableName, List<LindormFamilyAttributes> attributes) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, null, attributes, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES, -1);
    }

    private void internalModifyTableAttributeAsync(final String tableName, List<LindormAttribute> tableAttributes, List<LindormFamilyAttributes> familyAttributes, ModifySchemaOperation operation, int metaVersion) throws LindormException {
        try {
            if (metaVersion < 0) {
                TableMeta meta = this.getTableMeta(tableName);
                metaVersion = meta.getMetaVersion();
            }
            LindormAttribute.checkDuplicateAttributes(tableAttributes);
            LindormFamilyAttributes.checkDuplicateAttributes(familyAttributes);
            final LModifyTableRequest request = new LModifyTableRequest(tableName, tableAttributes, familyAttributes);
            request.setMetaVersion(metaVersion);
            request.setOperation(operation.ordinal());
            request.validate();
            LOG.info((Object)("Start to modify table " + request.toString()));
            LServerCallable<Void> modifyTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.modifyTableAsync(BasicDDLService.this.namespace, tableName, request);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Deprecated
    public void modifyTableAttributes(LindormTableDescriptor desc) throws LindormException {
        this.modifyTableAttributes(desc, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyTableAttributes(LindormTableDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableAttributesAsync(desc);
        this.blockingAndWaitForSuccess(desc.getName(), AsyncDDLType.ALTER, timeout);
    }

    @Deprecated
    public void modifyTableAttributesAsync(LindormTableDescriptor desc) throws LindormException {
        this.checkOpen();
        SchemaUtils.validateTableDescriptor(desc);
        TableMeta meta = new TableMeta(this.getNamespace(), desc);
        TableMeta oldMeta = null;
        try {
            oldMeta = this.getTableMeta(desc.getName());
        }
        catch (IOException ioe) {
            throw new LindormException("Cannot get table meta :" + desc.getName());
        }
        if (oldMeta.getTableAttributes().isHashTable() != meta.getTableAttributes().isHashTable()) {
            throw new IllegalDataException("Hash table and range table property can not be changed!");
        }
        List<LColumn> oldSchema = oldMeta.getAllColumns();
        for (LColumn col : oldSchema) {
            if (col.isPrimaryKey() || !SchemaUtils.isDefaultFamily(col.getFamilyName())) continue;
            col.setFamilyName(null);
        }
        if (oldMeta.hasIndex()) {
            SchemaUtils.checkTTL(meta);
            SchemaUtils.checkCompression(meta);
            for (TableMeta indexTable : oldMeta.getIndexMetas().values()) {
                for (LColumn pkColumn : indexTable.getPkColumns()) {
                    LColumn lColumn = oldMeta.resolveColumn(pkColumn.getDataColumnKey());
                    SchemaUtils.checkMaxVersion(lColumn, meta);
                }
            }
        }
        this.internalModifyTableAsync(meta, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES);
    }

    @Deprecated
    public void modifyFamilyAttributes(String tableName, ColumnFamilyDescriptor descriptor) throws LindormException {
        this.modifyFamilyAttributes(tableName, descriptor, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyFamilyAttributes(String tableName, ColumnFamilyDescriptor descriptor, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyFamilyAttributesAsync(tableName, descriptor);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    @Deprecated
    public void modifyFamilyAttributesAsync(String tableName, ColumnFamilyDescriptor descriptor) throws LindormException {
        this.checkOpen();
        LindormTableDescriptor desc = this.describeTable(tableName);
        if (!desc.hasFamily(descriptor.getName())) {
            throw new LindormException("Delete column family failure, Column family " + Bytes.toString(descriptor.getName()) + " not exist in table " + tableName);
        }
        desc.removeFamily(descriptor.getName());
        desc.addFamily(descriptor);
        this.modifyTableAttributesAsync(desc);
    }

    public void modifyTableConsistency(String tableName, TableAttributes.ConsistencyType target) throws LindormException {
        this.checkOpen();
        this.modifyTableConsistency(tableName, target, Integer.MAX_VALUE);
    }

    public void modifyTableConsistency(String tableName, TableAttributes.ConsistencyType target, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableConsistencyAsync(tableName, target);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER_CONSISTENCY, timeout);
    }

    public void modifyTableConsistencyAsync(String tableName, TableAttributes.ConsistencyType target) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, Collections.singletonList(new LindormAttribute("CONSISTENCY", target.toString())), null, ModifySchemaOperation.MODIFY_TABLE_CONSISTENCY, -1);
    }

    public boolean isCreateSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.CREATE);
        return pair.getFirst() == 0;
    }

    public boolean isCreateIndexSuccess(String indexName, String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isDeleteIndexSuccess(String indexName, String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isTruncateSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.TRUNCATE);
        return pair.getFirst() == 0;
    }

    public boolean isOnlineSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ONLINE);
        return pair.getFirst() == 0;
    }

    public boolean isOfflineSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.OFFLINE);
        return pair.getFirst() == 0;
    }

    public boolean isModifySuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isModifyConsistencySuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER_CONSISTENCY);
        return pair.getFirst() == 0;
    }

    public boolean isTableOffline(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Boolean> callable = new LServerCallable<Boolean>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isTableOffline(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public boolean isTableOnline(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Boolean> callable = new LServerCallable<Boolean>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isTableOnline(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public TableState getTableState(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<TableState> callable = new LServerCallable<TableState>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public TableState call() throws Exception {
                    return this.server.getTableState(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private Pair<Integer, Integer> getOperationStatus(final String table, final AsyncDDLType type) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Pair<Integer, Integer>> getOperationStatusCallable = new LServerCallable<Pair<Integer, Integer>>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Pair<Integer, Integer> call() throws Exception {
                    return this.server.getOperationStatus(namespace, Bytes.toBytes(table), type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(getOperationStatusCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LindormTableDescriptor describeTable(String table) throws LindormException {
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(table);
            return TableMeta.buildLindormTableDescriptor(meta);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LindormTableDescriptor describeTableFromCache(String tableName) {
        TableMeta meta = this.getTableMetaFromCache(tableName);
        if (meta == null) {
            return null;
        }
        return TableMeta.buildLindormTableDescriptor(meta);
    }

    @Deprecated
    public void modifyIndexAttributes(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        this.modifyIndexAttributes(desc, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyIndexAttributes(LindormIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        SchemaUtils.validateIndexTableDescriptor(desc);
        String dataTable = desc.getDataTableName();
        String indexName = desc.getIndexName();
        try {
            LindormIndexDescriptor lid = null;
            TableMeta dataTableMeta = this.getTableMeta(dataTable);
            TableMeta oldIndexMeta = dataTableMeta.getIndexMeta(indexName);
            if (null == oldIndexMeta) {
                throw new IndexNotFoundException(indexName);
            }
            lid = TableMeta.buildLindormIndexDescriptor(oldIndexMeta);
            lid.setFamilyAttributes(desc.getFamilyAttributes());
            lid.setTableAttributes(desc.getTableAttributes());
            TableMeta indexTableMeta = new TableMeta(this.getNamespace(), oldIndexMeta.getTableName(), lid, dataTableMeta);
            this.internalModifyTableAsync(indexTableMeta, ModifySchemaOperation.MODIFY_INDEX_ATTRIBUTES);
            this.blockingAndWaitForSuccess(oldIndexMeta.getTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private TableMeta getIndexTableMeta(String index, String table) throws IOException {
        TableMeta dataTableMeta = this.getTableMeta(table);
        TableMeta indexTableMeta = dataTableMeta.getIndexMeta(index);
        if (indexTableMeta == null) {
            throw new IndexNotFoundException(index);
        }
        return indexTableMeta;
    }

    public LindormIndexDescriptor describeIndex(String index, String table) throws LindormException {
        this.checkOpen();
        try {
            TableMeta indexTableMeta = this.getIndexTableMeta(index, table);
            return TableMeta.buildLindormIndexDescriptor(indexTableMeta);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public TableMeta getTableMetaFromCache(String tableName) {
        return this.getLConnection().getTableMetaCache().getTable(this.namespace, tableName);
    }

    public TableMeta getTableMeta(final String tableName) throws IOException {
        if (tableName == null || tableName.isEmpty()) {
            throw new LindormException("Table name must be null or emtpy.");
        }
        final String namespace = this.getNamespace();
        LServerCallable<TableMeta> getTableDescriptorCallable = new LServerCallable<TableMeta>(OperationContext.OperationType.DESCRIBE){

            @Override
            public TableMeta call() throws Exception {
                return this.server.getTableMeta(namespace, Bytes.toBytes(tableName));
            }
        };
        return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(getTableDescriptorCallable);
    }

    public void alterReadPermission(final String tableName, final boolean enabled) throws LindormException {
        LServerCallable<Void> alterReadOperation = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.alterReadPermission(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName), enabled, true);
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withoutRetries(alterReadOperation);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void alterWritePermission(final String tableName, final boolean enabled) throws LindormException {
        LServerCallable<Void> alterWriteOperation = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.alterWritePermission(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName), enabled, true);
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withoutRetries(alterWriteOperation);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void disableWritingAndSync(final String tableName) throws LindormException {
        this.checkOpen();
        LServerCallable<Void> disableAndSyncCallable = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.disableWritePermissionAndForceSync(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName));
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(disableAndSyncCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    protected void internalModifyTableAsync(final TableMeta tableMeta, final ModifySchemaOperation operation) throws LindormException {
        LOG.info((Object)("Start to modify table, new table meta " + tableMeta));
        LServerCallable<Void> modifyTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

            @Override
            public Void call() throws Exception {
                this.server.modifyTableAsync(tableMeta, operation.ordinal());
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void alterIndexState(String indexName, String tableName, IndexState indexState) throws LindormException {
        this.checkOpen();
        this.alterIndexStateAsync(indexName, tableName, indexState);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, Integer.MAX_VALUE);
    }

    public void alterIndexStateAsync(final String indexName, final String tableName, final IndexState indexState) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Index name must not be null or empty.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or empty.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> alterIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.alterIndexState(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName), indexState);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(alterIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public int getSearchIndexTtl(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Search Index name must not be null or empty.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or empty.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Integer> getSearchIndexCallable = new LServerCallable<Integer>(OperationContext.OperationType.DESCRIBE){

                @Override
                public Integer call() throws Exception {
                    return this.server.getSearchIndexTtl(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName));
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(getSearchIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private String getTableNameForEvent(String tableName, String indexName) {
        return tableName + "." + indexName;
    }

    public void modifySearchIndexAttributes(String indexName, String tableName, List<LindormAttribute> attributes) throws LindormException {
        this.checkOpen();
        this.modifySearchIndexAttributesAsync(indexName, tableName, attributes);
        this.blockingAndWaitForSuccess(this.getTableNameForEvent(tableName, indexName), AsyncDDLType.SEARCH_INDEX_MODIFY_ATTRIBUTES, Integer.MAX_VALUE);
    }

    public void modifySearchIndexAttributesAsync(final String indexName, final String tableName, final List<LindormAttribute> attributes) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Search Index name must not be null or empty.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or empty.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> alterIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.modifySearchIndexAttributes(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName), attributes);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(alterIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public IndexState getIndexState(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        if (tableName == null || tableName.isEmpty()) {
            throw new LindormException("Table name must be null or emtpy.");
        }
        if (indexName == null || indexName.isEmpty()) {
            throw new LindormException("Index name must be null or emtpy.");
        }
        final String namespace = this.getNamespace();
        try {
            LServerCallable<IndexState> indexState = new LServerCallable<IndexState>(OperationContext.OperationType.DESCRIBE){

                @Override
                public IndexState call() throws Exception {
                    return this.server.getIndexState(namespace, tableName, indexName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(indexState);
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().contains("NoSuchMethodException")) {
                try {
                    TableMeta indexTableMeta = this.getIndexTableMeta(indexName, tableName);
                    return indexTableMeta.getIndexState();
                }
                catch (IndexNotFoundException infe) {
                    throw new LindormException(infe);
                }
                catch (Throwable tt) {
                    throw new LindormException("Catch NoSuchMethodException getIndexState()", tt);
                }
            }
            throw new LindormException(t);
        }
    }

    public void addIndexColumns(final String dataTableName, final String indexName, final List<ColumnKey> columns) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> addIndexedColumnCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.addIndexColumns(BasicDDLService.this.namespace, dataTableName, indexName, columns);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(addIndexedColumnCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, Integer.MAX_VALUE);
    }

    public void deleteIndexColumns(final String dataTableName, final String indexName, final List<ColumnKey> columns) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> addIndexedColumnCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.deleteIndexColumns(BasicDDLService.this.namespace, dataTableName, indexName, columns);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(addIndexedColumnCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, Integer.MAX_VALUE);
    }

    protected void blockingAndWaitForSuccess(String tableName, AsyncDDLType type, int blockTimeInSecond) throws LindormException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = blockTimeInSecond;
        if (blockTimeInSecond != Integer.MAX_VALUE) {
            blockTimeInMs = blockTimeInSecond * 1000;
        }
        long retries = Math.max((long)this.maxRetryDDL, this.ddlPause == 0 ? 0L : blockTimeInMs / (long)this.ddlPause);
        long deadline = startTime + blockTimeInMs;
        int i = 0;
        while ((long)i < retries) {
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) {
                throw new LindormException("Timed out when waiting for table: " + tableName + " to finish operation: " + type);
            }
            try {
                long sleepTime = this.ddlPause;
                if (i > 60) {
                    sleepTime = this.ddlPause * 10;
                }
                sleepTime = sleepTime < remaining ? sleepTime : remaining;
                Thread.sleep(sleepTime);
                Pair<Integer, Integer> status = this.getOperationStatus(tableName, type);
                if (status.getFirst() == 0) {
                    return;
                }
                LOG.info((Object)("Progess of operation for : " + type + " " + tableName + ", undone idcs : " + status.getFirst() + " total idcs : " + status.getSecond()));
            }
            catch (LindormException e) {
                LOG.warn((Object)("failed to get table status for " + tableName + ", operation type: " + type + ", Retry count : " + i), (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new LindormException("Interrupt while waiting for " + tableName + " ddl operation to finish ", e);
            }
            ++i;
        }
        throw new LindormException("Retry exhausted for table operation " + tableName + " Max wait time : " + (System.currentTimeMillis() - startTime));
    }

    protected PrimaryKeySchema getFirstPkSchema(LindormTableDescriptor descriptor) {
        return descriptor.getPkColumns().get(0);
    }

    public void addSearchIndexColumn(String dataTableName, String indexName, ColumnKey column) throws LindormException {
        this.addSearchIndexColumn(dataTableName, indexName, column, Integer.MAX_VALUE);
    }

    private void addSearchIndexColumn(String dataTableName, String indexName, ColumnKey column, int timeout) throws LindormException {
        this.addSearchIndexColumnsAsync(dataTableName, indexName, Collections.singletonList(column));
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, timeout);
    }

    public void addSearchIndexColumns(String dataTableName, String indexName, List<ColumnKey> columns) throws LindormException {
        this.addSearchIndexColumns(dataTableName, indexName, columns, Integer.MAX_VALUE);
    }

    private void addSearchIndexColumns(String dataTableName, String indexName, List<ColumnKey> columns, int timeout) throws LindormException {
        this.addSearchIndexColumnsAsync(dataTableName, indexName, columns);
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, timeout);
    }

    private void addSearchIndexColumnsAsync(final String dataTableName, final String indexName, final List<ColumnKey> columns) throws LindormException {
        this.checkOpen();
        if (StringUtils.isNullOrEmpty(dataTableName)) {
            throw new IllegalRequestException("DataTable must be specified.");
        }
        if (StringUtils.isNullOrEmpty(indexName)) {
            throw new IllegalRequestException("Index must be specified.");
        }
        if (columns == null) {
            throw new IllegalRequestException("The columns to be added are null.");
        }
        try {
            LServerCallable<Void> addIndexedColumnCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.addSearchIndexColumns(BasicDDLService.this.namespace, dataTableName, indexName, columns);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(addIndexedColumnCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void removeSearchIndexColumn(String dataTableName, String indexName, ColumnKey column) throws LindormException {
        this.removeSearchIndexColumn(dataTableName, indexName, column, Integer.MAX_VALUE);
    }

    private void removeSearchIndexColumn(String dataTableName, String indexName, ColumnKey column, int timeout) throws LindormException {
        this.removeSearchIndexColumnsAsync(dataTableName, indexName, Collections.singletonList(column));
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, timeout);
    }

    public void removeSearchIndexColumns(String dataTableName, String indexName, List<ColumnKey> columns) throws LindormException {
        this.removeSearchIndexColumns(dataTableName, indexName, columns, Integer.MAX_VALUE);
    }

    private void removeSearchIndexColumns(String dataTableName, String indexName, List<ColumnKey> columns, int timeout) throws LindormException {
        this.removeSearchIndexColumnsAsync(dataTableName, indexName, columns);
        this.blockingAndWaitForSuccess(dataTableName, AsyncDDLType.ALTER, timeout);
    }

    private void removeSearchIndexColumnsAsync(final String dataTableName, final String indexName, final List<ColumnKey> columns) throws LindormException {
        this.checkOpen();
        if (StringUtils.isNullOrEmpty(dataTableName)) {
            throw new IllegalRequestException("DataTable must be specified.");
        }
        if (StringUtils.isNullOrEmpty(indexName)) {
            throw new IllegalRequestException("Index must be specified.");
        }
        if (columns == null) {
            throw new IllegalRequestException("The columns to be removed are null.");
        }
        try {
            LServerCallable<Void> removeIndexedColumnCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.removeSearchIndexColumns(BasicDDLService.this.namespace, dataTableName, indexName, columns);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(removeIndexedColumnCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public String describeIndexInfo(final String tableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            this.getNamespace();
            LServerCallable<String> indexInfoCallable = new LServerCallable<String>(OperationContext.OperationType.DESCRIBE){

                @Override
                public String call() throws Exception {
                    return this.server.describeIndexInfo(BasicDDLService.this.namespace, tableName, indexName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(indexInfoCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public IndexList listIndexes(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            this.getNamespace();
            if (StringUtils.isNullOrEmpty(tableName)) {
                throw new IllegalRequestException("Table name is illegal:" + tableName);
            }
            LServerCallable<IndexList> listIndexCallable = new LServerCallable<IndexList>(OperationContext.OperationType.DESCRIBE){

                @Override
                public IndexList call() throws Exception {
                    return this.server.listIndexes(BasicDDLService.this.namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(listIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createEntity(LindormEntityDescriptor desc) throws LindormException {
        this.createEntity(desc, new CreateEntityOptions());
    }

    public void createEntity(LindormEntityDescriptor desc, final CreateEntityOptions options) throws LindormException {
        this.checkOpen();
        EntityUtils.validateEntityDescriptorForCreate(desc);
        final Entity request = Entity.createFromEntityDescriptor(this.namespace, desc);
        LServerCallable<Void> createEntityCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

            @Override
            public Void call() throws Exception {
                this.server.createEntity(request, options);
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(createEntityCallable);
            this.blockingAndWaitForSuccess(request.getTableName(), AsyncDDLType.ENTITY_CREATE, Integer.MAX_VALUE);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LindormEntityDescriptor describeEntity(String tableName, String entityName) throws LindormException {
        this.checkOpen();
        EntityMeta meta = this.doListEntities(tableName);
        Entity e = meta.getEntities().get(entityName);
        if (e == null) {
            throw new LindormException("Entity [" + entityName + "] not found for table " + this.namespace + "." + tableName);
        }
        return e.buildEntityDescriptor();
    }

    public LindormEntities listEntities(String tableName) throws LindormException {
        this.checkOpen();
        EntityMeta meta = this.doListEntities(tableName);
        ArrayList<LindormEntityDescriptor> entities = new ArrayList<LindormEntityDescriptor>();
        for (Entity e : meta.getEntities().values()) {
            entities.add(e.buildEntityDescriptor());
        }
        return new LindormEntities(entities);
    }

    private EntityMeta doListEntities(final String tableName) throws LindormException {
        LServerCallable<EntityMeta> describeEntityCallable = new LServerCallable<EntityMeta>(OperationContext.OperationType.DESCRIBE){

            @Override
            public EntityMeta call() throws Exception {
                return this.server.describeEntity(BasicDDLService.this.namespace, tableName);
            }
        };
        try {
            EntityMeta meta = this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(describeEntityCallable);
            if (meta == null) {
                throw new LindormException("No entity found for table " + this.namespace + "." + tableName);
            }
            return meta;
        }
        catch (LindormException le) {
            throw le;
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void activateEntity(String tableName, String entityName) throws LindormException {
        this.activateEntity(tableName, entityName, ActivateEntityOption.EVENTUAL, Integer.MAX_VALUE);
    }

    public void activateEntity(String tableName, String entityName, int timeout) throws LindormException {
        this.activateEntity(tableName, entityName, ActivateEntityOption.EVENTUAL, timeout);
    }

    public void activateEntity(String tableName, String entityName, ActivateEntityOption option) throws LindormException {
        this.activateEntity(tableName, entityName, option, Integer.MAX_VALUE);
    }

    public void activateEntity(String tableName, String entityName, ActivateEntityOption option, int timeout) throws LindormException {
        this.checkOpen();
        LAlterEntityStateRequest request = new LAlterEntityStateRequest(this.namespace, tableName, entityName, AlterEntityOperation.ACTIVATE);
        request.setActivateOption(option);
        this.doAlterEntity(request, timeout);
    }

    public void archiveEntity(String tableName, String entityName) throws LindormException {
        this.archiveEntity(tableName, entityName, Integer.MAX_VALUE);
    }

    public void archiveEntity(String tableName, String entityName, int timeout) throws LindormException {
        this.checkOpen();
        LAlterEntityStateRequest request = new LAlterEntityStateRequest(this.namespace, tableName, entityName, AlterEntityOperation.ARCHIVE);
        this.doAlterEntity(request, timeout);
    }

    public void reuseEntity(String tableName, String entityName) throws LindormException {
        this.reuseEntity(tableName, entityName, Integer.MAX_VALUE);
    }

    public void reuseEntity(String tableName, String entityName, int timeout) throws LindormException {
        this.checkOpen();
        LAlterEntityStateRequest request = new LAlterEntityStateRequest(this.namespace, tableName, entityName, AlterEntityOperation.REUSE);
        this.doAlterEntity(request, timeout);
    }

    public void offlineEntity(String tableName, String entityName) throws LindormException {
        this.offlineEntity(tableName, entityName, Integer.MAX_VALUE);
    }

    public void offlineEntity(String tableName, String entityName, int timeout) throws LindormException {
        this.checkOpen();
        LAlterEntityStateRequest request = new LAlterEntityStateRequest(this.namespace, tableName, entityName, AlterEntityOperation.OFFLINE);
        this.doAlterEntity(request, timeout);
    }

    public void onlineEntity(String tableName, String entityName) throws LindormException {
        this.onlineEntity(tableName, entityName, Integer.MAX_VALUE);
    }

    public void onlineEntity(String tableName, String entityName, int timeout) throws LindormException {
        this.checkOpen();
        LAlterEntityStateRequest request = new LAlterEntityStateRequest(this.namespace, tableName, entityName, AlterEntityOperation.ONLINE);
        this.doAlterEntity(request, timeout);
    }

    private void doAlterEntity(final LAlterEntityStateRequest request, int timeout) throws LindormException {
        try {
            SchemaUtils.checkNullOrEmpty(request.getTableName(), "tableName");
            SchemaUtils.checkNullOrEmpty(request.getEntityName(), "entityName");
            if (request.getOperation() == null) {
                throw new IllegalRequestException("Alter entity operation must not be null or empty.");
            }
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.alterEntity(request);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
            this.blockingAndWaitForSuccess(request.getTableName(), AsyncDDLType.ENTITY_ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteEntity(final String tableName, final String entityName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.DROP){

                @Override
                public Void call() throws Exception {
                    this.server.deleteEntity(BasicDDLService.this.namespace, tableName, entityName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }
}

