/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.auth;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Hex;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.UUID;

public class AuthenticationPassport
extends VersionedObjectWithAttributes {
    private String userName;
    private byte[] token;
    private long timestamp;
    private String uniqueId;
    private static final String REMOTE_ADDRESS = "REMOTE_ADDRESS";

    public AuthenticationPassport() {
    }

    public AuthenticationPassport(String userName, byte[] token, long timestamp, String uniqueId) {
        this.userName = userName;
        this.token = token;
        this.timestamp = timestamp;
        this.uniqueId = uniqueId;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getToken() {
        return this.token;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setRemoteAddress(String remoteAddress) {
        this.setAttribute(REMOTE_ADDRESS, Bytes.toBytes(remoteAddress));
    }

    public String getRemoteAddress() {
        byte[] value = this.getAttribute(REMOTE_ADDRESS);
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public boolean matches(byte[] encodedPasswordOnStorage, long maxTimeDiffMS) throws IOException {
        try {
            if (maxTimeDiffMS > 0L && System.currentTimeMillis() - this.timestamp > maxTimeDiffMS) {
                return false;
            }
            byte[] stage1Hash2 = AuthenticationPassport.xor(this.token, AuthenticationPassport.toSHA1(Bytes.add(Bytes.toBytes(this.timestamp), Bytes.toBytes(this.uniqueId), encodedPasswordOnStorage)));
            return Bytes.equals(encodedPasswordOnStorage, AuthenticationPassport.toSHA1(Bytes.add(stage1Hash2, AuthenticationPassport.toReversed(this.userName))));
        }
        catch (Throwable t) {
            throw new IOException("Failed matching with stored password for '" + this.userName + "'", t);
        }
    }

    @Override
    public String toString() {
        return "AuthenticationPassport={'" + this.userName + "'," + new Date(this.timestamp) + "," + Hex.encodeHexString(this.token) + "}";
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.userName = WritableUtils.readString(in);
        this.token = Bytes.readByteArray(in);
        this.timestamp = in.readLong();
        this.uniqueId = WritableUtils.readString(in);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.userName);
        Bytes.writeByteArray(out, this.token);
        out.writeLong(this.timestamp);
        WritableUtils.writeString(out, this.uniqueId);
    }

    public static byte[] createEncodedPasswordOnStorage(String name, String password) throws IOException {
        try {
            return AuthenticationPassport.toSHA1(Bytes.add(AuthenticationPassport.toSHA1(Bytes.toBytes(password)), AuthenticationPassport.toReversed(name)));
        }
        catch (Throwable t) {
            throw new IOException("Failed creating encoded password for '" + name + "'", t);
        }
    }

    public static AuthenticationPassport create(String userName, String userPassword) throws IOException {
        try {
            byte[] stage1Hash = AuthenticationPassport.toSHA1(Bytes.toBytes(userPassword));
            String uniqueId = UUID.randomUUID().toString();
            long timestamp = System.currentTimeMillis();
            byte[] token = AuthenticationPassport.xor(AuthenticationPassport.toSHA1(Bytes.add(Bytes.toBytes(timestamp), Bytes.toBytes(uniqueId), AuthenticationPassport.toSHA1(Bytes.add(stage1Hash, AuthenticationPassport.toReversed(userName))))), stage1Hash);
            return new AuthenticationPassport(userName, token, timestamp, uniqueId);
        }
        catch (Throwable t) {
            throw new IOException("Failed creating authentication passport for '" + userName + "'", t);
        }
    }

    public static byte[] toSHA1(byte[] key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        return md.digest(key);
    }

    public static byte[] toReversed(String key) {
        return Bytes.toBytes(new StringBuilder(key).reverse().toString());
    }

    public static byte[] xor(byte[] left, byte[] right) {
        int i;
        byte[] shortbytes;
        byte[] longbytes;
        if (left.length >= right.length) {
            longbytes = left;
            shortbytes = right;
        } else {
            longbytes = right;
            shortbytes = left;
        }
        byte[] xorBytes = new byte[longbytes.length];
        for (i = 0; i < shortbytes.length; ++i) {
            xorBytes[i] = (byte)(shortbytes[i] ^ longbytes[i]);
        }
        while (i < longbytes.length) {
            xorBytes[i] = longbytes[i];
            ++i;
        }
        return xorBytes;
    }
}

