/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ConjunctiveClause;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.NotExistExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DisjunctiveNormalForm {
    private List<ConjunctiveClause> conjunctiveClauses;

    public DisjunctiveNormalForm() {
    }

    public DisjunctiveNormalForm(List<ConjunctiveClause> conjunctiveClauses) {
        this.conjunctiveClauses = conjunctiveClauses;
    }

    public DisjunctiveNormalForm(LColumn column, ComparisonExpression expression) throws IllegalDataException {
        this.conjunctiveClauses = Collections.singletonList(new ConjunctiveClause(column, expression));
    }

    public DisjunctiveNormalForm(LColumn column, ContainsExpression expression) throws IllegalDataException {
        this.conjunctiveClauses = Collections.singletonList(new ConjunctiveClause(column, expression));
    }

    public DisjunctiveNormalForm(LColumn column, NotExistExpression expression) {
        this.conjunctiveClauses = Collections.singletonList(new ConjunctiveClause(column, expression));
    }

    public DisjunctiveNormalForm(LColumn column, LikeExpression expression) throws LindormException {
        this.conjunctiveClauses = Collections.singletonList(new ConjunctiveClause(column, expression));
    }

    public DisjunctiveNormalForm(LColumn column, NotLikeExpression expression) throws LindormException {
        this.conjunctiveClauses = Collections.singletonList(new ConjunctiveClause(column, expression));
    }

    public void or(DisjunctiveNormalForm dnf) {
        if (this.conjunctiveClauses == null) {
            this.conjunctiveClauses = new ArrayList<ConjunctiveClause>(dnf.conjunctiveClauses.size());
        }
        this.conjunctiveClauses.addAll(dnf.conjunctiveClauses);
    }

    public void and(DisjunctiveNormalForm dnf) throws LindormException {
        if (this.conjunctiveClauses == null) {
            this.conjunctiveClauses = new ArrayList<ConjunctiveClause>(dnf.conjunctiveClauses);
            return;
        }
        if (this.conjunctiveClauses.isEmpty()) {
            return;
        }
        ArrayList<ConjunctiveClause> newConjunctiveClauses = new ArrayList<ConjunctiveClause>(this.conjunctiveClauses.size() * dnf.conjunctiveClauses.size());
        for (ConjunctiveClause clause : this.conjunctiveClauses) {
            for (ConjunctiveClause otherClause : dnf.conjunctiveClauses) {
                ConjunctiveClause result = clause.and(otherClause);
                if (result.isEmpty()) continue;
                newConjunctiveClauses.add(result);
            }
        }
        this.conjunctiveClauses = newConjunctiveClauses;
    }

    public List<ConjunctiveClause> getConjunctiveClauses() {
        return this.conjunctiveClauses;
    }

    public boolean isDegenerate() {
        return this.conjunctiveClauses == null || this.conjunctiveClauses.isEmpty();
    }

    public int hashCode() {
        if (this.conjunctiveClauses == null) {
            return 0;
        }
        int result = 1;
        for (ConjunctiveClause conjunctiveClause : this.conjunctiveClauses) {
            result = result * 31 + conjunctiveClause.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DisjunctiveNormalForm)) {
            return false;
        }
        DisjunctiveNormalForm other = (DisjunctiveNormalForm)obj;
        return this.conjunctiveClauses.equals(other.conjunctiveClauses);
    }

    public String toString() {
        StringBuilder str = new StringBuilder("(");
        boolean passTheFirst = false;
        for (ConjunctiveClause cc : this.conjunctiveClauses) {
            if (passTheFirst) {
                str.append(" or ");
            }
            str.append(cc.toString());
            passTheFirst = true;
        }
        str.append(")");
        return str.toString();
    }
}

