/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.compile.ColumnSlot;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.List;

public class QueryFilterInfo {
    private List<ColumnSlot> columnSlots;
    private int hashCode;

    private QueryFilterInfo(List<ColumnSlot> columnSlots) {
        this.columnSlots = new ArrayList<ColumnSlot>(columnSlots);
    }

    private QueryFilterInfo(List<ColumnSlot> columnSlots, int start) {
        this.columnSlots = new ArrayList<ColumnSlot>(columnSlots.size() - start);
        for (int i = start; i < columnSlots.size(); ++i) {
            this.columnSlots.add(columnSlots.get(i));
        }
    }

    public static QueryFilterInfo create(List<ColumnSlot> columnSlots) {
        if (columnSlots == null) {
            return null;
        }
        QueryFilterInfo.checkSaltedRange(columnSlots, 0);
        return new QueryFilterInfo(columnSlots);
    }

    private static void checkSaltedRange(List<ColumnSlot> columnSlots, int start) {
        for (int i = start; i < columnSlots.size(); ++i) {
            ColumnSlot columnSlot = columnSlots.get(i);
            if (!SchemaUtils.isSaltPkOption(columnSlot.getColumn().getPkOption()) || columnSlot.isNullValue() || columnSlot.getInterval().isSingleValue()) continue;
            throw new RuntimeException("Do not support scan for salted table.");
        }
    }

    public static QueryFilterInfo create(List<ColumnSlot> columnSlots, int start) {
        if (columnSlots == null || start >= columnSlots.size()) {
            return null;
        }
        QueryFilterInfo.checkSaltedRange(columnSlots, start);
        return new QueryFilterInfo(columnSlots, start);
    }

    public List<ColumnSlot> getColumnSlots() {
        return this.columnSlots;
    }

    public int hashCode() {
        if (this.hashCode == 0 && this.columnSlots != null) {
            int result = 1;
            for (ColumnSlot columnSlot : this.columnSlots) {
                result = 31 * result + columnSlot.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryFilterInfo)) {
            return false;
        }
        QueryFilterInfo other = (QueryFilterInfo)obj;
        return this.columnSlots == null ? other.columnSlots == null : this.columnSlots.equals(other.columnSlots);
    }

    public String toString() {
        if (this.columnSlots == null || this.columnSlots.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.columnSlots.size(); ++i) {
            if (i != 0) {
                builder.append(" AND ");
            }
            builder.append(this.columnSlots.get(i));
        }
        return builder.toString();
    }
}

