/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.MapType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ComparisonExpressionV2
extends ComparisonExpression {
    protected Object key;
    protected LCollectionType collectionType;

    public ComparisonExpressionV2() {
    }

    public ComparisonExpressionV2(byte[] columnName, ConditionFactory.CompareOp op, Object key, Object value, CollectionDataType type) throws LindormException {
        this(null, columnName, op, key, value, type);
    }

    public ComparisonExpressionV2(byte[] familyName, byte[] columnName, ConditionFactory.CompareOp op, Object key, Object value, CollectionDataType type) throws LindormException {
        super(familyName, columnName, op, value);
        if (!(type instanceof MapType)) {
            throw new IllegalDataException("only map collection type is supported now");
        }
        this.key = key;
        this.collectionType = (LCollectionType)LDataTypeFactory.INSTANCE.getTypeInstance(type);
        this.type = type.getDataTypeEnum();
        this.checkType();
    }

    private void checkType() throws IllegalDataException {
        try {
            this.collectionType.getKeyType().validate(this.key);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException("key type missmatch. " + e.getMessage());
        }
        try {
            this.collectionType.getValueType().validate(this.value);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException("value type missmatch. " + e.getMessage());
        }
    }

    public Object getKey() {
        return this.key;
    }

    public LCollectionType getCollectionType() {
        return this.collectionType;
    }

    public Pair<ComparisonExpression, LColumn> doSyntaxSugarTransfer(LColumn column) throws LindormException {
        byte[] prefix = column.getCollectionColumnPrefix();
        byte[] qualifier = this.key == null ? prefix : Bytes.add(prefix, this.collectionType.getKeyType().toBytes(this.key));
        ComparisonExpression expression = new ComparisonExpression(column.getFamilyName(), qualifier, this.op, this.value);
        LColumn mock = column.deepCopy(new ColumnKey(column.getFamilyName(), qualifier), this.collectionType.getValueType());
        return Pair.newPair(expression, mock);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.collectionType == null) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.columnKey.getQualifierAsString());
        String keyStr = this.collectionType.getKeyType() instanceof LCollectionType ? DataTypeUtils.valueToString(((LCollectionType)this.collectionType.getKeyType()).getCollectionDataType(), this.key) : DataTypeUtils.valueToString(this.collectionType.getKeyType().getClientType(), this.key);
        String valueStr = this.collectionType.getValueType() instanceof LCollectionType ? DataTypeUtils.valueToString(((LCollectionType)this.collectionType.getValueType()).getCollectionDataType(), this.value) : DataTypeUtils.valueToString(this.collectionType.getValueType().getClientType(), this.value);
        builder.append(String.format("[%s]", keyStr));
        builder.append(String.format(" %s ", SchemaUtils.getReadableOperator(this.op)));
        builder.append(valueStr);
        builder.append(")");
        return builder.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.columnKey.writeTo(out);
        WritableUtils.writeVInt(out, this.op.ordinal());
        byte[] typeBytes = this.collectionType.asBytes();
        Bytes.writeByteArray(out, typeBytes);
        byte[] keyBytes = this.key == null ? Bytes.EMPTY_BYTE_ARRAY : this.collectionType.getKeyType().toTransferBytes(this.key);
        Bytes.writeByteArray(out, keyBytes);
        if (!ConditionFactory.CompareOp.isNullValueOp(this.op)) {
            byte[] valueBytes = this.collectionType.getValueType().toTransferBytes(this.value);
            if (valueBytes.length > 0x200000) {
                throw new IllegalRequestException("Right operand for " + this.getBrief() + " is too big, max length is " + 0x200000 + ", but has " + valueBytes.length);
            }
            Bytes.writeByteArray(out, valueBytes);
        }
        if (this.column != null) {
            WritableUtils.writeVInt(out, 1);
            this.column.writeTo(out);
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int hasColumnMeta;
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        this.op = ConditionFactory.CompareOp.values()[WritableUtils.readVInt(in)];
        byte[] typeBytes = Bytes.readByteArray(in);
        this.collectionType = (LCollectionType)LDataType.fromBytes(typeBytes);
        this.type = this.collectionType.getClientType();
        byte[] keyBytes = Bytes.readByteArray(in);
        Object object = this.key = keyBytes.length == 0 ? null : this.collectionType.getKeyType().fromTransferBytes(keyBytes);
        if (!ConditionFactory.CompareOp.isNullValueOp(this.op)) {
            byte[] valueBytes = Bytes.readByteArray(in);
            this.value = this.collectionType.getValueType().fromTransferBytes(valueBytes);
        }
        if ((hasColumnMeta = WritableUtils.readVInt(in)) != 0) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComparisonExpressionV2 that = (ComparisonExpressionV2)o;
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        return this.collectionType != null ? this.collectionType.equals(that.collectionType) : that.collectionType == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.collectionType != null ? this.collectionType.hashCode() : 0);
        return result;
    }
}

