/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LSet;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.KeyValuePtr;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class ContainsExpression
extends Condition {
    protected ColumnKey columnKey;
    protected Set values;
    protected LCollectionType type;
    protected LColumn column;
    private Set<byte[]> rhs;

    public ContainsExpression() {
    }

    public ContainsExpression(byte[] familyName, byte[] columnName, Set values, CollectionDataType type) throws LindormException {
        if (values == null || values.size() == 0) {
            throw new IllegalDataException("This expression with null or empty values is not supported.");
        }
        this.columnKey = new ColumnKey(familyName, columnName);
        this.values = values;
        this.type = (LCollectionType)LDataTypeFactory.INSTANCE.getTypeInstance(type);
        this.checkType();
    }

    public ContainsExpression(LColumn column, Set values) {
        this.column = column;
        this.values = values;
        this.columnKey = column.getColumnKey();
        this.type = (LCollectionType)column.getDataType();
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public Set getValues() {
        return this.values;
    }

    public LCollectionType getType() {
        return this.type;
    }

    public LColumn getColumn() {
        return this.column;
    }

    @Override
    public void resetParamValues(List<Object> params) throws LindormException {
        throw new IllegalDataException("Not support resetParamValues() right now");
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.columnKey.writeTo(out);
        byte[] typeBytes = this.type.asBytes();
        byte[] valueBytes = new LSet(this.getLDataTypeOfValue()).toTransferBytes(this.values);
        Bytes.writeByteArray(out, typeBytes);
        Bytes.writeByteArray(out, valueBytes);
        if (this.column != null) {
            out.writeBoolean(true);
            this.column.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        byte[] typeBytes = Bytes.readByteArray(in);
        byte[] valueBytes = Bytes.readByteArray(in);
        this.type = (LCollectionType)LDataType.fromBytes(typeBytes);
        this.values = (Set)new LSet(this.getLDataTypeOfValue()).fromTransferBytes(valueBytes);
        boolean hasColumn = in.readBoolean();
        if (hasColumn) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
    }

    @Override
    public void reset() {
    }

    protected abstract Set<byte[]> doEvaluateRHS() throws IllegalDataException;

    protected Set<byte[]> evaluateRHS() throws IllegalDataException {
        if (this.rhs == null) {
            this.rhs = this.doEvaluateRHS();
        }
        return this.rhs;
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        if (tuple.hasAllKeyValues()) {
            List<KeyValuePtr> targetKVs = this.filterCollectionColumnKV(tuple.keyValues());
            boolean ret = this.containsAll(targetKVs, this.evaluateRHS());
            result.set(ret ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
            return true;
        }
        return false;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public boolean needEvaluateWithAllKV() {
        return true;
    }

    @Override
    public String toParseableString() {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        builder.append(this.columnKey.getQualifierAsString());
        builder.append(String.format(" %s (", this.op()));
        Iterator iter2 = this.values.iterator();
        LDataType valueLDataType = this.getLDataTypeOfValue();
        int i = 0;
        while (iter2.hasNext()) {
            if (i != 0) {
                builder.append(", ");
            }
            if (valueLDataType instanceof LCollectionType) {
                builder.append(DataTypeUtils.valueToString(((LCollectionType)valueLDataType).getCollectionDataType(), iter2.next()));
            } else {
                builder.append(DataTypeUtils.valueToString(valueLDataType.getClientType(), iter2.next()));
            }
            ++i;
        }
        builder.append(")");
        builder.append(")");
        return builder.toString();
    }

    protected abstract String op();

    protected abstract LDataType getLDataTypeOfValue();

    private void checkType() throws IllegalDataException {
        for (Object item : this.values) {
            try {
                this.getLDataTypeOfValue().validate(item);
            }
            catch (IllegalDataException e) {
                throw new IllegalDataException(item + " type missmatch. " + e.getMessage());
            }
        }
    }

    protected boolean containsAll(List<KeyValuePtr> kvs, Set<byte[]> values) {
        for (byte[] bytes : values) {
            boolean contain = false;
            for (KeyValuePtr ptr : kvs) {
                if (!this.isMatch(ptr, bytes)) continue;
                contain = true;
                break;
            }
            if (contain) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean isMatch(KeyValuePtr var1, byte[] var2);

    protected List<KeyValuePtr> filterCollectionColumnKV(KeyValuePtr[] ptrs) {
        ArrayList<KeyValuePtr> result = new ArrayList<KeyValuePtr>();
        byte[] prefix = this.column.getCollectionColumnPrefix();
        for (KeyValuePtr ptr : ptrs) {
            if (!Bytes.startsWith(ptr.getBytes(), ptr.getQualifierOffset(), ptr.getQualifierLength(), prefix, 0, prefix.length)) continue;
            result.add(ptr);
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainsExpression that = (ContainsExpression)o;
        if (this.columnKey != null ? !this.columnKey.equals(that.columnKey) : that.columnKey != null) {
            return false;
        }
        if (this.values != null ? !this.values.equals(that.values) : that.values != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return this.column != null ? this.column.equals(that.column) : that.column == null;
    }

    public int hashCode() {
        int result = this.columnKey != null ? this.columnKey.hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.column != null ? this.column.hashCode() : 0);
        return result;
    }
}

