/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.KeyValuePtr;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.MapType;
import java.util.Set;
import java.util.TreeSet;

public class ContainsKeyExpression
extends ContainsExpression {
    public ContainsKeyExpression() {
    }

    public ContainsKeyExpression(byte[] columnName, Set values, MapType mapType) throws LindormException {
        this(null, columnName, values, mapType);
    }

    public ContainsKeyExpression(byte[] familyName, byte[] columnName, Set values, MapType mapType) throws LindormException {
        super(familyName, columnName, values, mapType);
    }

    public ContainsKeyExpression(LColumn column, Set values) {
        super(column, values);
    }

    @Override
    protected Set<byte[]> doEvaluateRHS() throws IllegalDataException {
        TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Object value : this.values) {
            byte[] prefix = this.column.getCollectionColumnPrefix();
            result.add(value == null ? prefix : Bytes.add(prefix, this.getLDataTypeOfValue().toBytes(value)));
        }
        return result;
    }

    @Override
    protected String op() {
        return "contains key";
    }

    @Override
    protected LDataType getLDataTypeOfValue() {
        return this.type.getKeyType();
    }

    @Override
    protected boolean isMatch(KeyValuePtr ptr, byte[] value) {
        return Bytes.equals(value, 0, value.length, ptr.getBytes(), ptr.getQualifierOffset(), ptr.getQualifierLength());
    }
}

