/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ContainsExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LSet;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.KeyValuePtr;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import java.util.Set;
import java.util.TreeSet;

public class ContainsValueExpression
extends ContainsExpression {
    public ContainsValueExpression() {
    }

    public ContainsValueExpression(byte[] columnName, Set values, CollectionDataType type) throws LindormException {
        this(null, columnName, values, type);
    }

    public ContainsValueExpression(byte[] familyName, byte[] columnName, Set values, CollectionDataType type) throws LindormException {
        super(familyName, columnName, values, type);
    }

    public ContainsValueExpression(LColumn column, Set values) {
        super(column, values);
    }

    @Override
    protected Set<byte[]> doEvaluateRHS() throws IllegalDataException {
        TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (Object value : this.values) {
            if (this.column.getDataType() instanceof LSet) {
                byte[] prefix = this.column.getCollectionColumnPrefix();
                result.add(value == null ? prefix : Bytes.add(prefix, this.getLDataTypeOfValue().toBytes(value)));
                continue;
            }
            result.add(value == null ? Bytes.EMPTY_BYTE_ARRAY : this.getLDataTypeOfValue().toBytes(value));
        }
        return result;
    }

    @Override
    protected String op() {
        return "contains value";
    }

    @Override
    protected LDataType getLDataTypeOfValue() {
        return this.type.getValueType();
    }

    @Override
    protected boolean isMatch(KeyValuePtr ptr, byte[] value) {
        if (this.column.getDataType() instanceof LSet) {
            return Bytes.equals(value, 0, value.length, ptr.getBytes(), ptr.getQualifierOffset(), ptr.getQualifierLength());
        }
        return Bytes.equals(value, 0, value.length, ptr.getBytes(), ptr.getValueOffset(), ptr.getValueLength());
    }
}

