/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.expression.SimilarityExpression;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.SimpleConditionParser;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;

public class NotLikeExpression
extends SimilarityExpression {
    public NotLikeExpression() {
    }

    public NotLikeExpression(byte[] columnName, Object patternOrParam) {
        super(columnName, patternOrParam);
    }

    public NotLikeExpression(byte[] columnName, Object patternOrParam, Character escapeCharacter) {
        super(columnName, patternOrParam, escapeCharacter);
    }

    public NotLikeExpression(byte[] family, byte[] columnName, Object patternOrParam) {
        super(family, columnName, patternOrParam);
    }

    public NotLikeExpression(byte[] family, byte[] columnName, Object patternOrParam, Character escapeCharacter) {
        super(family, columnName, patternOrParam, escapeCharacter);
    }

    public NotLikeExpression(LColumn column, Object patternOrParam, Character escapeCharacter) {
        super(column, patternOrParam, escapeCharacter);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public String toParseableString() {
        return this.toString();
    }

    @Override
    protected String getName() {
        return "NOT LIKE";
    }

    @Override
    protected boolean getExpectedResult() {
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NotLikeExpression)) {
            return false;
        }
        NotLikeExpression other = (NotLikeExpression)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (this.pattern != null ? !this.pattern.equals(other.pattern) : other.pattern != null) {
            return false;
        }
        return this.escapeCharacter == null ? other.escapeCharacter == null : this.escapeCharacter.equals(other.escapeCharacter);
    }

    @Override
    public String toString() {
        return "(" + this.columnKey.getFullNameAsString() + " NOT LIKE " + this.pattern + (this.escapeCharacter == null ? "" : " ESCAPE " + this.escapeCharacter) + ")";
    }

    public static Condition createConditionFromArguments(ArrayList<byte[]> conditionArguments) {
        SimpleConditionParser.similarityCheck(conditionArguments);
        byte[] columnName = SimpleConditionParser.getSimilarityColumnName(conditionArguments);
        byte[] patternBytes = SimpleConditionParser.getSimilarityPattern(conditionArguments);
        Character escapeCharacter = SimpleConditionParser.getSimilarityEscapeCharacter(conditionArguments);
        String columnStr = Bytes.toString(columnName);
        if (columnStr.contains(SchemaUtils.COLUMN_NAME_SEPARATOR)) {
            return new NotLikeExpression(Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[0]), Bytes.toBytes(columnStr.split(SchemaUtils.COLUMN_NAME_SEPARATOR)[1]), Bytes.toString(patternBytes), escapeCharacter);
        }
        return new NotLikeExpression(columnName, (Object)Bytes.toString(patternBytes), escapeCharacter);
    }
}

