/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.feedstreamservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.dml.LTag;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LMessage
implements OpTimeout {
    private String streamName;
    private byte[] body = null;
    private List<LTag> bodyTags = null;
    private long messageId = 0L;
    private byte[] idempotentId = null;
    private Map<String, byte[]> tags = null;
    private Map<String, List<LTag>> tagTags = null;
    protected int operationTimeout = -1;
    protected int glitchTimeout = -1;

    public LMessage() {
    }

    public LMessage(String streamName) {
        this(streamName, 0L, null, null);
    }

    public LMessage(String streamName, long messageId, byte[] idempotentId) {
        this(streamName, messageId, idempotentId, null);
    }

    public LMessage(String streamName, byte[] body) {
        this(streamName, 0L, null, body);
    }

    public LMessage(String streamName, long messageId, byte[] idempotentId, byte[] body) {
        this.streamName = streamName;
        this.messageId = messageId;
        this.idempotentId = idempotentId;
        this.body = body;
    }

    public LMessage(LMessage oldMessage) {
        if (oldMessage == null) {
            return;
        }
        if (oldMessage.getIdempotentId() != null) {
            this.idempotentId = Arrays.copyOf(oldMessage.getIdempotentId(), oldMessage.getIdempotentId().length);
        }
        this.messageId = oldMessage.messageId;
        this.streamName = oldMessage.streamName;
        if (oldMessage.getMessageBody() != null) {
            this.body = Arrays.copyOf(oldMessage.getMessageBody(), oldMessage.getMessageBody().length);
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public LMessage setStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public LMessage setMessageId(long messageId) {
        this.messageId = messageId;
        return this;
    }

    public byte[] getIdempotentId() {
        return this.idempotentId;
    }

    public LMessage setIdempotentId(byte[] idempotentId) {
        this.idempotentId = idempotentId;
        return this;
    }

    public byte[] getMessageBody() {
        return this.body;
    }

    public LMessage setMessageBody(byte[] body) {
        this.body = body;
        return this;
    }

    public LMessage addTag(String key, byte[] value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, byte[]>();
        }
        this.tags.put(key, value);
        return this;
    }

    public LMessage setTags(Map<String, byte[]> tagMap) {
        this.tags = tagMap;
        return this;
    }

    public byte[] getTag(String key) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(key);
    }

    public Map<String, byte[]> getAllTags() {
        return this.tags;
    }

    public List<LTag> getBodyTags() {
        return this.bodyTags;
    }

    public void setBodyTags(List<LTag> bodyTags) {
        this.bodyTags = bodyTags;
    }

    public LMessage addTagTags(String tagName, List<LTag> tags) {
        if (this.tagTags == null) {
            this.tagTags = new HashMap<String, List<LTag>>();
        }
        this.tagTags.put(tagName, tags);
        return this;
    }

    public void setTagTags(Map<String, List<LTag>> tagTags) {
        this.tagTags = tagTags;
    }

    public Map<String, List<LTag>> getTagTags() {
        return this.tagTags;
    }

    public List<LTag> getTagTags(String tagName) {
        return this.tagTags == null ? null : this.tagTags.get(tagName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LMessage)) {
            return false;
        }
        LMessage other = (LMessage)o;
        if (!StringUtils.equals(this.streamName, other.streamName)) {
            return false;
        }
        if (this.messageId != other.messageId) {
            return false;
        }
        return Bytes.equals(this.idempotentId, other.idempotentId);
    }

    public String toString() {
        return "LMessage{streamName='" + this.streamName + '\'' + ", messageId=" + this.messageId + ", idempotentId=" + (this.idempotentId == null ? "null" : Bytes.toString(this.idempotentId)) + ", tags=" + this.tagsToString(this.tags) + '}';
    }

    private String tagsToString(Map<String, byte[]> tags) {
        if (tags == null || tags.size() == 0) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Map.Entry<String, byte[]> e : tags.entrySet()) {
            builder.append(e.getKey()).append("=>").append(Bytes.toStringBinary(e.getValue())).append(",");
        }
        builder.setLength(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public String toStringBrief() {
        return "streamName=" + this.streamName + (FeedStreamUtils.hasSetMessageId(this) ? ", messageId=" + this.messageId : "");
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }
}

