/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.Address;
import com.alibaba.lindorm.client.core.ipc.Invocation;
import com.alibaba.lindorm.client.core.ipc.RpcClient;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ClientProtocolEngine {
    public static final RpcClientCache RPCCLIENTS = new RpcClientCache();

    public static Object getProxy(Class<?> protocol, LindormClientConfig config, String user, String password, Address address, int rpcTimeout) throws IOException {
        Object proxy = Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new RpcInvoker(protocol, config, address, rpcTimeout, user, password));
        return proxy;
    }

    public static void stopProxy(Object proxy) {
        if (proxy != null) {
            ((RpcInvoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    public static void updateProxyConfiguration(Object proxy, LindormClientConfig newConfig) {
        InvocationHandler invoker;
        if (proxy != null && (invoker = Proxy.getInvocationHandler(proxy)) != null && invoker instanceof RpcInvoker) {
            ((RpcInvoker)invoker).updateConfiguration(newConfig);
        }
    }

    public static Integer getRpcTimeout(Object proxy) {
        InvocationHandler invoker;
        if (proxy != null && (invoker = Proxy.getInvocationHandler(proxy)) != null && invoker instanceof RpcInvoker) {
            return ((RpcInvoker)invoker).getRpcTimeout();
        }
        return null;
    }

    public static RpcClient getCachedRpcClient() {
        return RPCCLIENTS.rpcClientCached;
    }

    public static class RpcInvoker
    implements InvocationHandler {
        private RpcClient rpcClient;
        private boolean isClosed = false;
        private int rpcTimeout;
        private Address ldServerAddress;
        private Class<?> protocol;
        private String user;
        private String password;
        private int compressThreshold;

        public RpcInvoker(Class<?> protocol, LindormClientConfig conf, Address ldServer, int rpcTimeout, String user, String password) throws LindormException {
            this.rpcClient = RPCCLIENTS.getRpcClient(conf);
            this.rpcTimeout = rpcTimeout;
            this.ldServerAddress = ldServer;
            this.protocol = protocol;
            this.user = user;
            this.password = password;
            Invocation.RPC_VERSION = (byte)conf.getInt("lindorm.invocation.rpc.version", 1);
            this.compressThreshold = conf.getInt("lindorm.rpc.compress.threshold", 4096);
        }

        public int getRpcTimeout() {
            return this.rpcTimeout;
        }

        public void updateConfiguration(LindormClientConfig newConfg) {
            if (newConfg != null) {
                this.rpcTimeout = newConfg.getInt("lindorm.rpc.timeout", 60000);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object value = this.rpcClient.call(this.protocol, new Invocation(this.protocol, method, args, this.rpcClient.getSerializer(), this.compressThreshold), this.ldServerAddress, this.user, this.password, this.rpcTimeout);
            if (value == null && method.getReturnType().isPrimitive()) {
                return ReflectionUtils.returnDefaultPrimitive(method.getReturnType());
            }
            return value;
        }

        protected synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                RPCCLIENTS.stopRpcClient(this.rpcClient);
            }
        }
    }

    public static class RpcClientCache {
        private RpcClient rpcClientCached = null;

        protected RpcClientCache() {
        }

        public synchronized RpcClient getRpcClient(LindormClientConfig config) throws LindormException {
            if (this.rpcClientCached != null) {
                this.rpcClientCached.incCount();
                return this.rpcClientCached;
            }
            this.rpcClientCached = new RpcClient(config);
            return this.rpcClientCached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRpcClient(RpcClient rpcClient) {
            RpcClientCache rpcClientCache = this;
            synchronized (rpcClientCache) {
                rpcClient.decCount();
                if (rpcClient.isZeroReference()) {
                    if (this.rpcClientCached == rpcClient) {
                        this.rpcClientCached = null;
                    }
                    rpcClient.shutdown();
                }
            }
        }
    }
}

