/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.utils.VMPauseGuard;
import com.alibaba.lindorm.client.exception.OperationTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class OperationContext {
    public static final ThreadLocal<OperationContext> curOperationContext = new ThreadLocal();
    private static final Set<OperationType> writeOpSet = Collections.unmodifiableSet(EnumSet.of(OperationType.UPSERT, new OperationType[]{OperationType.DELETE, OperationType.CONDITIONAL_UPSERT, OperationType.INCREASE, OperationType.APPEND, OperationType.BATCH, OperationType.WPUT, OperationType.WMULTIDELETE, OperationType.WMULTIPUT, OperationType.WDELETE, OperationType.WINCREMENT, OperationType.WAPPEND, OperationType.CHECKANDPUT, OperationType.CHECKANDDELETE, OperationType.CHECKANDMUTATE, OperationType.PUT}));
    private static final Set<OperationType> readOpSet = Collections.unmodifiableSet(EnumSet.of(OperationType.SELECT, new OperationType[]{OperationType.BATCHGET, OperationType.AGGREGATE, OperationType.WMULTIGET, OperationType.WGET, OperationType.WSCAN, OperationType.WEXIST, OperationType.GET, OperationType.SCAN}));
    private long startTime;
    private int operationTimeout;
    private final int maxVMPauseDelay;
    private ConcurrentLinkedQueue<OperationPoint> operationPointList;
    private OperationType operationType;
    private AsyncCallback callBack;
    private final VMPauseGuard vmPauseGuard;
    private String doAsUser = null;
    private boolean skipConsistencyCheck;
    private volatile long pendingSendingTime = 0L;

    public static boolean isUserWriteOperation(OperationType operationType) {
        return writeOpSet.contains((Object)operationType);
    }

    public static boolean isUserReadOperation(OperationType operationType) {
        return readOpSet.contains((Object)operationType);
    }

    public OperationContext(OperationType operationType, int operationTimeout, String doAsUser) {
        this(operationType, operationTimeout, 0, doAsUser, false);
    }

    public OperationContext(OperationType operationType, int operationTimeout, String doAsUser, boolean skipConsistencyCheck) {
        this(operationType, operationTimeout, 0, doAsUser, skipConsistencyCheck);
    }

    public OperationContext(OperationType operationType, int operationTimeout, int maxVMPauseDelay, String doAsUser, boolean skipConsistencyCheck) {
        this.operationType = operationType;
        this.startTime = System.currentTimeMillis();
        this.operationTimeout = operationTimeout;
        this.operationPointList = new ConcurrentLinkedQueue();
        this.maxVMPauseDelay = Math.max(maxVMPauseDelay, 0);
        this.vmPauseGuard = maxVMPauseDelay > 0 ? new VMPauseGuard() : null;
        this.doAsUser = doAsUser;
        this.skipConsistencyCheck = skipConsistencyCheck;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void markOperationPoint(long pointTookTime, OperationPointType pointType, Object ... pointMessages) {
        this.operationPointList.add(new OperationPoint(pointTookTime, pointType, pointMessages));
    }

    public long getRemainingTime(long now) {
        return OperationContext.getRemainingTime(this.operationTimeout, now, this.startTime);
    }

    public int getVMPauseDelayTime() {
        if (this.vmPauseGuard != null) {
            return (int)Math.max(Math.min((long)this.maxVMPauseDelay, this.vmPauseGuard.pauseTime()), 0L);
        }
        return 0;
    }

    public static long getRemainingTime(int operationTimeout, long now, long startTime) {
        return Math.max(0L, (long)operationTimeout - (now - startTime));
    }

    public OperationTimeoutException getOperationTimeoutException(long now, String exceptionMsg, Throwable cause) {
        StringBuilder msgPrefix = new StringBuilder();
        msgPrefix.append("Failed after ").append(now - this.startTime).append("ms, operationTimeout=").append(this.operationTimeout);
        if (this.vmPauseGuard != null) {
            msgPrefix.append(", vmPauseTime=").append(this.vmPauseGuard.pauseTime());
        }
        if (this.pendingSendingTime > 0L) {
            msgPrefix.append(", beforeSentRequestTime=").append(this.pendingSendingTime);
        }
        if (exceptionMsg != null) {
            msgPrefix.append(", exceptions=").append(exceptionMsg);
        }
        msgPrefix.append(", ").append(this.toSimpleString());
        if (cause != null) {
            return new OperationTimeoutException(msgPrefix.toString(), cause);
        }
        return new OperationTimeoutException(msgPrefix.toString());
    }

    public String toString() {
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("{" + timeFormat.format(new Date(this.startTime)) + "(" + this.startTime + ") " + (Object)((Object)this.operationType) + "}");
        Collection<OperationPoint> toPrintPoints = this.trimOperationPointForPrint(20);
        for (OperationPoint operationPoint : toPrintPoints) {
            Object[] messages = operationPoint.getMessages();
            buffer.append(",{" + (operationPoint.ts - this.startTime) + "-" + operationPoint.getTookTime() + ":" + (Object)((Object)operationPoint.getType()) + (messages != null ? "," + Arrays.asList(messages) : "") + "}");
        }
        return buffer.toString();
    }

    private Collection<OperationPoint> trimOperationPointForPrint(int maxOutputNum) {
        if (this.operationPointList.size() <= maxOutputNum) {
            return this.operationPointList;
        }
        PriorityQueue<OperationPoint> topNPoints = new PriorityQueue<OperationPoint>(maxOutputNum + 1, new Comparator<OperationPoint>(){

            @Override
            public int compare(OperationPoint o1, OperationPoint o2) {
                return (int)o1.tookTime - (int)o2.tookTime;
            }
        });
        for (OperationPoint operationPoint : this.operationPointList) {
            topNPoints.add(operationPoint);
            if (topNPoints.size() <= maxOutputNum) continue;
            topNPoints.poll();
        }
        LinkedList<OperationPoint> toReturnPoints = new LinkedList<OperationPoint>();
        while (!topNPoints.isEmpty()) {
            toReturnPoints.addFirst(topNPoints.poll());
        }
        return toReturnPoints;
    }

    public String toSimpleString() {
        int opCount;
        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("{" + timeFormat.format(new Date(this.startTime)) + "(" + this.startTime + ") " + (Object)((Object)this.operationType) + "}");
        int i = 0;
        Collection<OperationPoint> toPrintPoints = this.trimOperationPointForPrint(20);
        for (OperationPoint operationPoint : toPrintPoints) {
            if (operationPoint.getTookTime() <= 2L) continue;
            Object[] messages = operationPoint.getMessages();
            buffer.append(",{" + (operationPoint.ts - this.startTime) + "-" + operationPoint.getTookTime() + ":" + (Object)((Object)operationPoint.getType()) + (messages != null ? "," + Arrays.asList(messages).subList(0, Math.min(messages.length, 2)) : "") + "}");
            if (++i != 6) continue;
            break;
        }
        if ((opCount = this.operationPointList.size()) > 6) {
            buffer.append(",{...TotalOpPoint=" + opCount + "}");
        }
        return buffer.toString();
    }

    public AsyncCallback getCallBack() {
        return this.callBack;
    }

    public void setCallBack(AsyncCallback callBack) {
        this.callBack = callBack;
    }

    public String getDoAsUser() {
        return this.doAsUser;
    }

    public boolean isSkipConsistencyCheck() {
        return this.skipConsistencyCheck;
    }

    public void addPendingSendingTime(long pendingSendingTime) {
        this.pendingSendingTime += pendingSendingTime;
    }

    public static enum OperationPointType {
        UPDATE_ROOT,
        LOCATE_REGION,
        GET_CONNECTION,
        SEND_CALL,
        WAIT_RESPONSE;

    }

    private static class OperationPoint {
        private long tookTime;
        private OperationPointType pointType;
        private Object[] messages;
        private long ts;

        OperationPoint(long tookTime, OperationPointType pointType, Object ... messages) {
            this.tookTime = tookTime;
            this.pointType = pointType;
            this.messages = messages;
            this.ts = System.currentTimeMillis();
        }

        long getTookTime() {
            return this.tookTime;
        }

        OperationPointType getType() {
            return this.pointType;
        }

        Object[] getMessages() {
            return this.messages;
        }
    }

    public static enum OperationType {
        SELECT,
        UPSERT,
        DELETE,
        WPUT,
        WMULTIPUT,
        WGET,
        WMULTIGET,
        WDELETE,
        WMULTIDELETE,
        WSCAN,
        WINCREMENT,
        WAPPEND,
        WEXIST,
        CREATE,
        DROP,
        TRUNCATE,
        CHECKSTATE,
        ENABLE,
        DISABLE,
        MODIFY,
        PERMISSION,
        DESCRIBE,
        NAMESPACE,
        USER,
        ACL,
        PING,
        GROUP,
        INCREASE,
        SYSTEM,
        CONDITIONAL_UPSERT,
        BATCH,
        BATCHGET,
        PUT,
        GET,
        CHECKANDPUT,
        SCAN,
        CHECKANDDELETE,
        APPEND,
        AGGREGATE,
        EXPORTER,
        GETEXPLOGS,
        COMPLETEEXPLOG,
        LEADERSWITCH,
        SPLIT,
        PREWARM,
        CONCENSUS,
        CONCENSUS_LOCAL,
        QUOTA,
        CIPHER,
        LOCATE,
        CHECKANDMUTATE,
        UPDATECONFIG,
        MERGE,
        WEXEC,
        EXEC,
        FLUSH,
        COMPACT,
        INDEXMULTI,
        INDEXBUILD,
        RELOAD,
        RESET;

    }
}

