/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LEncodedVarbinary;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.ColumnNotFoundException;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.PrimaryKeyOption;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LColumn
extends VersionedObjectWithAttributes {
    private static final String DATA_COLUMN_KEY_ATTR = "DATA_COLUMN_KEY";
    private static final String COLLECTION_DATA_TYPE_ATTR = "COLLECTION";
    private ColumnKey columnKey;
    private LDataType dataType;
    private SortOrder sortOrder;
    private boolean isNullable;
    private boolean isPrimaryKey;
    private int position;
    private Integer maxLength = null;
    private Integer scale = null;
    private ColumnKey dataColumnKey = null;
    private Boolean storeNull = null;
    private PrimaryKeyOption pkOption = null;
    private byte[] fullName;
    private LColumn dataColumnMeta = null;
    private List<TableMeta> leadingKeyIndexes = null;
    private boolean isDynamicColumn;

    public LColumn() {
    }

    public LColumn(PrimaryKeySchema pk, int position) {
        this(null, pk.getName(), LDataTypeFactory.INSTANCE.getTypeInstance(pk.getDataType()), pk.getSortOrder(), false, true, position);
        this.maxLength = pk.getMaxLength();
        this.scale = pk.getScale();
        this.pkOption = pk.getPkOption();
        this.setupAttributes();
    }

    public LColumn(ColumnSchema col, int position) {
        this(col.getFamilyName(), col.getColumnName(), col.getCollectionDataType() == null ? LDataTypeFactory.INSTANCE.getTypeInstance(col.getDataType()) : LDataTypeFactory.INSTANCE.getTypeInstance(col.getCollectionDataType()), SortOrder.getDefault(), false, false, position);
        this.maxLength = col.getMaxLength();
        this.scale = col.getScale();
        this.setupAttributes();
    }

    public static LColumn createIndexColumnMeta(IndexedColumnSchema columnSchema, int position, TableMeta dataTable, TableMeta indexTable) throws ColumnNotFoundException {
        LColumn colInDataTable = dataTable.resolveColumn(columnSchema.getColumnKey());
        LColumn ret = colInDataTable.deepCopy();
        byte[] qualifier = IndexUtils.getIndexColumnQualifier(colInDataTable.getColumnKey(), indexTable);
        ret.columnKey.setQualifier(qualifier);
        ret.setFamilyName(indexTable.isLocalIndex() ? SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES : SchemaUtils.DEFAULT_FAMILY_NAME_BYTES);
        ret.sortOrder = columnSchema.getSortOrder();
        ret.position = position;
        ret.isPrimaryKey = true;
        ret.dataColumnKey = colInDataTable.getColumnKey();
        ret.dataColumnMeta = colInDataTable;
        if (ret.dataType == LVarbinary.INSTANCE) {
            ret.dataType = LEncodedVarbinary.INSTANCE;
        }
        ret.pkOption = columnSchema.getPkOption();
        return ret;
    }

    public static LColumn createIndexColumnMeta(ColumnKey columnKey, TableMeta dataTable, TableMeta indexTable, int position) throws ColumnNotFoundException {
        LColumn colInDataTable = dataTable.resolveColumn(columnKey);
        LColumn ret = colInDataTable.deepCopy();
        byte[] qualifier = IndexUtils.getIndexColumnQualifier(colInDataTable.getColumnKey(), indexTable);
        ret.columnKey.setQualifier(qualifier);
        ret.setFamilyName(indexTable.isLocalIndex() ? SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES : SchemaUtils.DEFAULT_FAMILY_NAME_BYTES);
        ret.isPrimaryKey = false;
        ret.pkOption = null;
        ret.position = position;
        ret.dataColumnKey = colInDataTable.getColumnKey();
        ret.dataColumnMeta = colInDataTable;
        return ret;
    }

    public static LColumn createDefaultColumnMeta() {
        LColumn ret = new LColumn();
        ret.columnKey = new ColumnKey(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, SchemaUtils.DEFAULT_COLUMN_NAME_BYTES);
        ret.dataType = LVarbinary.INSTANCE;
        ret.sortOrder = SortOrder.getDefault();
        ret.isNullable = true;
        ret.isPrimaryKey = false;
        ret.position = -1;
        ret.pkOption = null;
        ret.init();
        return ret;
    }

    public static LColumn createDefaultLocalIndexColumnMeta() {
        LColumn ret = new LColumn();
        ret.columnKey = new ColumnKey(SchemaUtils.DEFAULT_LOCAL_INDEX_FAMILY_NAME_BYTES, SchemaUtils.DEFAULT_COLUMN_NAME_BYTES);
        ret.dataType = LVarbinary.INSTANCE;
        ret.sortOrder = SortOrder.getDefault();
        ret.isNullable = true;
        ret.isPrimaryKey = false;
        ret.position = -1;
        ret.pkOption = null;
        ret.init();
        return ret;
    }

    public static LColumn createDynamicColumnMeta(ColumnKey ck) {
        LColumn ret = new LColumn();
        ret.columnKey = !ck.hasFamily() ? new ColumnKey(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, ck.getQualifier()) : ck;
        ret.dataType = LVarbinary.INSTANCE;
        ret.sortOrder = SortOrder.getDefault();
        ret.isNullable = true;
        ret.isPrimaryKey = false;
        ret.position = -1;
        ret.pkOption = null;
        ret.isDynamicColumn = true;
        ret.init();
        return ret;
    }

    public LColumn(byte[] familyName, byte[] columnName, LDataType dataType, SortOrder sortOrder, boolean isNullable, boolean isPrimaryKey, int position) {
        this.columnKey = new ColumnKey(familyName, columnName);
        this.dataType = dataType;
        this.sortOrder = sortOrder;
        this.isNullable = isNullable;
        this.isPrimaryKey = isPrimaryKey;
        this.position = position;
        this.init();
    }

    private void init() {
        this.fullName = this.columnKey.getFullName();
    }

    private void initFromAttributes() {
        try {
            byte[] pkOptionBytes;
            byte[] hashedBytes;
            byte[] storeNullsBytes;
            byte[] dataColumnKeyBytes;
            byte[] scaleBytes;
            byte[] lengthBytes = this.getAttribute("MAX_LENGTH");
            if (lengthBytes != null) {
                this.maxLength = Bytes.toInt(lengthBytes);
            }
            if ((scaleBytes = this.getAttribute("SCALE")) != null) {
                this.scale = Bytes.toInt(scaleBytes);
            }
            if ((dataColumnKeyBytes = this.getAttribute(DATA_COLUMN_KEY_ATTR)) != null) {
                this.dataColumnKey = new ColumnKey();
                LindormObjectUtils.getWritable(dataColumnKeyBytes, this.dataColumnKey);
            }
            if ((storeNullsBytes = this.getAttribute("STORE_PK_NULLS")) != null) {
                this.storeNull = Bytes.toBoolean(storeNullsBytes);
            }
            if ((hashedBytes = this.getAttribute("PK_HASHED")) != null && Bytes.toBoolean(hashedBytes)) {
                this.pkOption = PrimaryKeyOption.HASHED;
            }
            if ((pkOptionBytes = this.getAttribute("PK_OPTION")) != null) {
                this.pkOption = PrimaryKeyOption.fromId(Bytes.toInt(pkOptionBytes));
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void setupAttributes() {
        try {
            if (this.maxLength != null) {
                this.setAttribute("MAX_LENGTH", Bytes.toBytes(this.maxLength));
            } else {
                this.removeAttribute("MAX_LENGTH");
            }
            if (this.scale != null) {
                this.setAttribute("SCALE", Bytes.toBytes(this.scale));
            } else {
                this.removeAttribute("SCALE");
            }
            if (this.dataColumnKey != null) {
                this.setAttribute(DATA_COLUMN_KEY_ATTR, LindormObjectUtils.getBytes(this.dataColumnKey));
            } else {
                this.removeAttribute(DATA_COLUMN_KEY_ATTR);
            }
            if (this.storeNull != null) {
                this.setAttribute("STORE_PK_NULLS", Bytes.toBytes(this.storeNull));
            } else {
                this.removeAttribute("STORE_PK_NULLS");
            }
            if (this.pkOption != null) {
                this.setAttribute("PK_OPTION", Bytes.toBytes(this.pkOption.getId()));
                if (this.pkOption == PrimaryKeyOption.HASHED) {
                    this.setAttribute("PK_HASHED", Bytes.toBytes(true));
                }
            } else {
                this.removeAttribute("PK_OPTION");
                this.removeAttribute("PK_HASHED");
            }
            if (this.isCollectionType()) {
                this.setAttribute(COLLECTION_DATA_TYPE_ATTR, ((LCollectionType)this.dataType).asBytes());
            } else {
                this.removeAttribute(COLLECTION_DATA_TYPE_ATTR);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean isCollectionType() {
        return this.dataType.getClientType().isCollection();
    }

    public byte[] getFullName() {
        return this.fullName;
    }

    public byte[] getFamilyName() {
        return this.columnKey.getFamily();
    }

    public void setFamilyName(byte[] familyName) {
        this.columnKey = new ColumnKey(familyName, this.columnKey.getQualifier());
        this.init();
    }

    public byte[] getColumnName() {
        return this.columnKey.getQualifier();
    }

    public byte[] getCollectionColumnPrefix() {
        assert (this.isCollectionType());
        return this.columnKey.getCollectionColumnPrefix();
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public LDataType getDataType() {
        return this.dataType;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public ColumnKey getDataColumnKey() {
        return this.dataColumnKey;
    }

    public void setDataColumnKey(ColumnKey dataColumnKey) {
        this.dataColumnKey = dataColumnKey;
        this.setupAttributes();
    }

    public LColumn getDataColumnMeta() {
        return this.dataColumnMeta;
    }

    public void setDataColumnMeta(LColumn dataColumnMeta) {
        this.dataColumnMeta = dataColumnMeta;
    }

    public List<TableMeta> getLeadingKeyIndexes() {
        return this.leadingKeyIndexes;
    }

    public void addLeadingKeyIndexes(TableMeta index) {
        if (this.leadingKeyIndexes == null) {
            this.leadingKeyIndexes = new ArrayList<TableMeta>();
        }
        this.leadingKeyIndexes.add(index);
    }

    public int getPosition() {
        return this.position;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Integer getPrecision() {
        return this.maxLength;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isStoreNull() {
        return this.storeNull == null ? false : this.storeNull;
    }

    public void setStoreNull(boolean storeNull) {
        this.storeNull = storeNull;
        this.setupAttributes();
    }

    @Override
    public String toString() {
        return Bytes.toString(this.fullName) + " " + this.dataType.toString() + DataTypeUtils.lengthToString(this.maxLength, this.scale) + (this.isPrimaryKey() && this.sortOrder == SortOrder.DESC ? " DESC" : "" + (this.pkOption != null ? " " + this.pkOption.toString() : ""));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof LColumn)) {
            return false;
        }
        LColumn other = (LColumn)obj;
        if (this.isPrimaryKey != other.isPrimaryKey) {
            return false;
        }
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (this.dataType.getClientType() != other.getDataType().getClientType()) {
            return false;
        }
        if (this.pkOption != null || other.pkOption != null) {
            if (this.pkOption == null || other.pkOption == null) {
                return false;
            }
            if (this.pkOption.getId() != other.pkOption.getId()) {
                return false;
            }
        }
        return this.equalsAttributes(other);
    }

    public boolean equalsName(LColumn other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return this.columnKey.equals(other.columnKey);
    }

    public int hashCode() {
        return this.columnKey.hashCode();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeVInt(out, this.dataType.getOrdinal());
        WritableUtils.writeVInt(out, this.sortOrder.ordinal());
        out.writeBoolean(this.isNullable);
        out.writeBoolean(this.isPrimaryKey);
        WritableUtils.writeVInt(out, this.position);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        int typeOrdinal = WritableUtils.readVInt(in);
        DataType clientType = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(typeOrdinal);
        if (clientType.isCollection()) {
            byte[] bytes = this.getAttribute(COLLECTION_DATA_TYPE_ATTR);
            assert (bytes != null && bytes.length > 0);
            this.dataType = LDataType.fromBytes(bytes);
        } else {
            this.dataType = LDataTypeFactory.INSTANCE.getTypeInstance(clientType);
        }
        this.sortOrder = SortOrder.values()[WritableUtils.readVInt(in)];
        this.isNullable = in.readBoolean();
        this.isPrimaryKey = in.readBoolean();
        this.position = WritableUtils.readVInt(in);
        this.init();
        this.initFromAttributes();
    }

    public LColumn deepCopy() {
        LColumn ret = new LColumn();
        ret.columnKey = new ColumnKey(this.columnKey);
        ret.dataType = this.dataType;
        ret.sortOrder = this.sortOrder;
        ret.isNullable = this.isNullable;
        ret.isPrimaryKey = this.isPrimaryKey;
        ret.position = this.position;
        ret.maxLength = this.maxLength;
        ret.scale = this.scale;
        ret.dataColumnKey = this.dataColumnKey;
        ret.dataColumnMeta = this.dataColumnMeta;
        ret.init();
        ret.setupAttributes();
        return ret;
    }

    public LColumn deepCopy(int position) {
        LColumn ret = this.deepCopy();
        ret.position = position;
        return ret;
    }

    public LColumn deepCopy(ColumnKey columnKey, LDataType dataType) {
        LColumn ret = this.deepCopy();
        ret.columnKey = columnKey;
        ret.dataType = dataType;
        return ret;
    }

    public LColumn deepCopy(int position, boolean isPrimaryKey) {
        LColumn ret = this.deepCopy();
        ret.position = position;
        ret.isPrimaryKey = isPrimaryKey;
        return ret;
    }

    @Deprecated
    public boolean isHashed() {
        return this.pkOption == PrimaryKeyOption.HASHED;
    }

    public PrimaryKeyOption getPkOption() {
        return this.pkOption;
    }

    public boolean isDynamicColumn() {
        return this.isDynamicColumn;
    }
}

