/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.feedstreamservice.StreamSchema;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ConflictResolverSchema;
import com.alibaba.lindorm.client.schema.DataCodec;
import com.alibaba.lindorm.client.schema.LindormTableAttributeConstants;
import com.alibaba.lindorm.client.schema.Mutability;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class TableAttributes
extends VersionedObjectWithAttributes {
    private Boolean dynamicColumnsEnabled = null;
    private ConsistencyType consistency = null;
    private LeaderBalanceType balanceType = null;
    private Mutability mutability = null;
    private Integer glitchTimeout = null;
    private Integer readGlitchTimeout = null;
    private Integer writeGlitchTimeout = null;
    private Boolean usingHashEngine = null;
    private Integer maxPkColumnLength = null;
    private Integer maxNonPkColumnLength = null;
    private StreamSchema streamSchema = null;
    private Boolean allowFiltering = null;
    private DataCodec dataCodec = null;
    private Boolean walEditWithFullRow = null;
    private Boolean fullRowEditCarryLatestData = null;
    private Boolean allowECForImmutableRows = null;
    public static final Set<String> ALL_TABLE_ATTRIBUTE_KEYS;
    public static final Set<String> ALL_TABLE_ATTRIBUTE_KEYS_WITHOUT_CONSISTENCY;

    public static boolean isTableAttributes(String attributes) {
        return ALL_TABLE_ATTRIBUTE_KEYS.contains(attributes);
    }

    public boolean isDeferredLogFlush() {
        byte[] defer = this.getAttribute("DEFERRED_LOG_FLUSH", LindormTableAttributeConstants.DEFAULT_DEFERRED_LOG_FLUSH_BYTES);
        return Boolean.valueOf(Bytes.toString(defer));
    }

    public void setDeferredLogFlush(boolean defer) {
        this.setAttribute("DEFERRED_LOG_FLUSH", Boolean.toString(defer));
    }

    public boolean isDynamicColumnsEnabled() {
        if (this.dynamicColumnsEnabled == null) {
            byte[] enabled = this.getAttribute("DYNAMIC_COLUMNS", LindormTableAttributeConstants.DEFAULT_DYNAMIC_COLUMNS_ENABLED_BYTES);
            this.dynamicColumnsEnabled = Boolean.valueOf(Bytes.toString(enabled));
        }
        return this.dynamicColumnsEnabled;
    }

    public void setDynamicColumnsEnabled(boolean enabled) {
        this.setAttribute("DYNAMIC_COLUMNS", Boolean.toString(enabled));
        this.dynamicColumnsEnabled = enabled;
    }

    public LeaderBalanceType getLeaderBalanceType() {
        if (this.balanceType == null) {
            byte[] value = this.getAttribute("LEADER_BALANCE_TYPE", LindormTableAttributeConstants.LEADER_BALANCE_TYPE_DEFAULT_BYTES);
            this.balanceType = LeaderBalanceType.getBalanceType(Bytes.toString(value));
        }
        return this.balanceType;
    }

    public void setLeaderBalanceType(LeaderBalanceType type) {
        this.balanceType = type;
        this.setAttribute("LEADER_BALANCE_TYPE", this.balanceType.description);
    }

    public ConsistencyType getConsistencyType() {
        if (this.consistency == null) {
            byte[] value = this.getAttribute("CONSISTENCY", LindormTableAttributeConstants.DEFAULT_CONSISTENCY_BYTES);
            this.consistency = ConsistencyType.getConsistencyType(Bytes.toString(value));
        }
        return this.consistency;
    }

    public void setConsistencyType(ConsistencyType type) {
        this.consistency = type;
        this.setAttribute("CONSISTENCY", type.description);
    }

    public int getGlitchTimeout() {
        if (this.glitchTimeout == null) {
            byte[] value = this.getAttribute("GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.glitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.glitchTimeout;
    }

    public int getReadGlitchTimeout() {
        if (this.readGlitchTimeout == null) {
            byte[] value = this.getAttribute("READ_GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.readGlitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.readGlitchTimeout;
    }

    public int getWriteGlitchTimeout() {
        if (this.writeGlitchTimeout == null) {
            byte[] value = this.getAttribute("WRITE_GLITCH_TIMEOUT", LindormTableAttributeConstants.DEFAULT_GLITCH_TIMEOUT_BYTES);
            this.writeGlitchTimeout = Integer.valueOf(Bytes.toString(value));
        }
        return this.writeGlitchTimeout;
    }

    public void setGlitchTimeout(int timeout) {
        this.glitchTimeout = timeout;
        this.setAttribute("GLITCH_TIMEOUT", Integer.toString(this.glitchTimeout));
    }

    public void setReadGlitchTimeout(int timeout) {
        this.readGlitchTimeout = timeout;
        this.setAttribute("READ_GLITCH_TIMEOUT", Integer.toString(this.readGlitchTimeout));
    }

    public void setWriteGlitchTimeout(int timeout) {
        this.writeGlitchTimeout = timeout;
        this.setAttribute("WRITE_GLITCH_TIMEOUT", Integer.toString(this.writeGlitchTimeout));
    }

    public Mutability getMutability() {
        if (this.mutability == null) {
            byte[] value = this.getAttribute("MUTABILITY", LindormTableAttributeConstants.DEFAULT_MUTABILITY_BYTES);
            this.mutability = Mutability.valueOf(Bytes.toString(value));
        }
        return this.mutability;
    }

    public Mutability getMutabilityNoDefault() {
        byte[] value = this.getAttribute("MUTABILITY");
        if (value != null) {
            this.mutability = Mutability.valueOf(Bytes.toString(value));
            return this.mutability;
        }
        return null;
    }

    public void setMutability(Mutability m) {
        this.mutability = m;
        this.setAttribute("MUTABILITY", Bytes.toBytes(this.mutability.toString()));
    }

    public DataCodec getDataCodec() {
        if (this.dataCodec == null) {
            byte[] value = this.getAttribute("DATA_CODEC", LindormTableAttributeConstants.DEFAULT_DATA_CODEC_BYTES);
            this.dataCodec = DataCodec.valueOf(Bytes.toString(value));
        }
        return this.dataCodec;
    }

    public DataCodec getDataCodecNoDefault() {
        byte[] value = this.getAttribute("DATA_CODEC");
        if (value != null) {
            this.dataCodec = DataCodec.valueOf(Bytes.toString(value));
            return this.dataCodec;
        }
        return null;
    }

    public void setDataCodec(DataCodec codec) {
        this.dataCodec = codec;
        this.setAttribute("DATA_CODEC", Bytes.toBytes(this.dataCodec.toString()));
    }

    public boolean isLeaderBalanceEnabled() {
        byte[] value = this.getAttribute("LEADER_BALANCE_ENABLED", LindormTableAttributeConstants.DEFAULT_LEADER_BALANCE_ENABLED_BYTES);
        return Bytes.toBoolean(value);
    }

    public void setLeaderBalance(boolean enable) {
        this.setAttribute("LEADER_BALANCE_ENABLED", Bytes.toBytes(enable));
    }

    public boolean isHashTable() {
        if (this.usingHashEngine == null) {
            byte[] value = this.getAttribute("USE_HASH_ENGINE", LindormTableAttributeConstants.DEFAULT_USING_HASH_ENGINE_BYTES);
            this.usingHashEngine = Bytes.toBoolean(value);
        }
        return this.usingHashEngine;
    }

    public Boolean isHashTableNoDefault() {
        byte[] value = this.getAttribute("USE_HASH_ENGINE");
        if (value != null) {
            this.usingHashEngine = Bytes.toBoolean(value);
            return this.usingHashEngine;
        }
        return null;
    }

    public void setUsingHashEngine(boolean enableHashEngine) {
        this.usingHashEngine = enableHashEngine;
        this.setAttribute("USE_HASH_ENGINE", Bytes.toBytes(enableHashEngine));
    }

    public Boolean isRefSplitAllowed() {
        byte[] value = this.getAttribute("REF_SPLIT_ALLOWED");
        if (value == null) {
            return null;
        }
        return Bytes.toBoolean(value);
    }

    public void setRefSplitAllowed(boolean enabled) {
        this.setAttribute("REF_SPLIT_ALLOWED", Bytes.toBytes(enabled));
    }

    public int getMaxPkColumnLength() {
        if (this.maxPkColumnLength == null) {
            byte[] value = this.getAttribute("MAX_PK_LEN", LindormTableAttributeConstants.DEFAULT_MAX_PK_COLUMN_LENGTH_BYTES);
            this.maxPkColumnLength = Bytes.toInt(value);
        }
        return this.maxPkColumnLength;
    }

    public Integer getMaxPkColumnLengthNoDefault() {
        byte[] value = this.getAttribute("MAX_PK_LEN");
        if (value != null) {
            this.maxPkColumnLength = Bytes.toInt(value);
            return this.maxPkColumnLength;
        }
        return null;
    }

    public void setMaxPkColumnLength(int maxPkColumnLength) {
        if (maxPkColumnLength <= 0) {
            throw new IllegalArgumentException("Illegal maxPkColumnLength value [" + maxPkColumnLength + "], must be a positive value.");
        }
        this.maxPkColumnLength = maxPkColumnLength;
        this.setAttribute("MAX_PK_LEN", Bytes.toBytes(maxPkColumnLength));
    }

    public int getMaxNonPkColumnLength() {
        if (this.maxNonPkColumnLength == null) {
            byte[] value = this.getAttribute("MAX_NONPK_LEN", LindormTableAttributeConstants.DEFAULT_MAX_NON_PK_COLUMN_LENGTH_BYTES);
            this.maxNonPkColumnLength = Bytes.toInt(value);
        }
        return this.maxNonPkColumnLength;
    }

    public Integer getMaxNonPkColumnLengthNoDefault() {
        byte[] value = this.getAttribute("MAX_NONPK_LEN");
        if (value != null) {
            this.maxNonPkColumnLength = Bytes.toInt(value);
            return this.maxNonPkColumnLength;
        }
        return null;
    }

    public void setMaxNonPkColumnLength(int maxNonPkColumnLength) {
        if (maxNonPkColumnLength <= 0) {
            throw new IllegalArgumentException("Illegal maxNonPkColumnLength value [" + maxNonPkColumnLength + "], must be a positive value.");
        }
        this.maxNonPkColumnLength = maxNonPkColumnLength;
        this.setAttribute("MAX_NONPK_LEN", Bytes.toBytes(maxNonPkColumnLength));
    }

    public boolean isIdempotentEnabled() {
        byte[] value;
        if (this.streamSchema == null && (value = this.getAttribute("SS_STREAM_SCHEMA")) != null) {
            this.streamSchema = new StreamSchema();
            this.streamSchema.fromBytes(value);
        }
        if (this.streamSchema == null) {
            return false;
        }
        return this.streamSchema.hasIdempotentFamily();
    }

    public StreamSchema getStreamSchema() {
        byte[] value;
        if (this.streamSchema == null && (value = this.getAttribute("SS_STREAM_SCHEMA")) != null) {
            this.streamSchema = new StreamSchema();
            this.streamSchema.fromBytes(value);
        }
        return this.streamSchema;
    }

    public void setStreamSchema(StreamSchema schema) {
        this.streamSchema = schema;
        this.setAttribute("SS_STREAM_SCHEMA", this.streamSchema.getBytes());
    }

    public void setAllowFiltering(boolean value) {
        this.allowFiltering = value;
        this.setAttribute("ALLOW_FILTERING", Bytes.toBytes(value));
    }

    public boolean isAllowFiltering() {
        if (this.allowFiltering == null) {
            byte[] value = this.getAttribute("ALLOW_FILTERING");
            this.allowFiltering = value == null ? Boolean.valueOf(true) : Boolean.valueOf(Bytes.toBoolean(value));
        }
        return this.allowFiltering;
    }

    public void setReadOnly(boolean readOnly) {
        this.setAttribute("READONLY", readOnly ? Bytes.toBytes(Boolean.TRUE.toString()) : Bytes.toBytes(Boolean.FALSE.toString()));
    }

    public Boolean isReadOnlyNoDefault() {
        byte[] value = this.getAttribute("READONLY");
        return value != null ? Boolean.valueOf(Bytes.toString(value)) : null;
    }

    public boolean isReadOnly() {
        Boolean isReadOnly = this.isReadOnlyNoDefault();
        return isReadOnly != null ? isReadOnly : false;
    }

    public Long getMemStoreFlushSizeNoDefault() {
        byte[] value = this.getAttribute("MEMSTORE_FLUSHSIZE");
        return value != null ? Long.valueOf(Long.valueOf(Bytes.toString(value))) : null;
    }

    public long getMemStoreFlushSize() {
        Long value = this.getMemStoreFlushSizeNoDefault();
        return value != null ? value : 0x8000000L;
    }

    public void setMemStoreFlushSize(long memstoreFlushSize) {
        this.setAttribute("MEMSTORE_FLUSHSIZE", Bytes.toBytes(Long.toString(memstoreFlushSize)));
    }

    public void setConflictResolver(String resolver) {
        this.setAttribute("CONFLICT_RESOLVER", resolver);
    }

    public void setConflictResolver(ConflictResolverSchema resolver) {
        this.setAttribute("CONFLICT_RESOLVER", resolver.toString());
    }

    public String getConflictResolverString() {
        byte[] value = this.getAttribute("CONFLICT_RESOLVER");
        return value == null ? null : Bytes.toString(value);
    }

    public ConflictResolverSchema getConflictResolver() {
        ConflictResolverSchema resolver = this.getConflictResolverNoDefault();
        return resolver != null ? resolver : new ConflictResolverSchema();
    }

    public ConflictResolverSchema getConflictResolverNoDefault() {
        byte[] value = this.getAttribute("CONFLICT_RESOLVER");
        if (value != null) {
            ConflictResolverSchema resolver = ConflictResolverSchema.fromString(Bytes.toString(value));
            return resolver;
        }
        return null;
    }

    public Boolean isSkipReplicaConsensusNoDefault() {
        byte[] value = this.getAttribute("SKIP_REPLICA_CONSENSUS");
        return value != null ? Boolean.valueOf(Bytes.toString(value)) : null;
    }

    public boolean isSkipReplicaConsensus() {
        Boolean value = this.isSkipReplicaConsensusNoDefault();
        return value != null ? value : false;
    }

    public void setWalEditWithFullRow(boolean enabled) {
        this.setAttribute("WAL_EDIT_WITH_FULL_ROW", Bytes.toBytes(Boolean.toString(enabled)));
    }

    public Boolean isWalEditWithFullRow() {
        if (this.walEditWithFullRow == null) {
            byte[] value = this.getAttribute("WAL_EDIT_WITH_FULL_ROW");
            this.walEditWithFullRow = value == null ? Boolean.valueOf(false) : Boolean.valueOf(Bytes.toString(value));
        }
        return this.walEditWithFullRow;
    }

    public Boolean isFullRowEditCarryLatestData() {
        if (this.fullRowEditCarryLatestData == null) {
            byte[] value = this.getAttribute("FULL_ROW_EDIT_CARRY_LATEST_DATA");
            this.fullRowEditCarryLatestData = value == null ? Boolean.valueOf(true) : Boolean.valueOf(Bytes.toString(value));
        }
        return this.fullRowEditCarryLatestData;
    }

    public void setFullRowEditCarryLatestData(boolean carried) {
        this.setAttribute("FULL_ROW_EDIT_CARRY_LATEST_DATA", Bytes.toBytes(Boolean.toString(carried)));
    }

    public void setSkipReplicaConsensus(boolean skipReplicaConsensus) {
        this.setAttribute("SKIP_REPLICA_CONSENSUS", Bytes.toBytes(Boolean.toString(skipReplicaConsensus)));
    }

    public Boolean allowECForImmutableRows() {
        if (this.allowECForImmutableRows == null) {
            byte[] value = this.getAttribute("IMMUTABLE_ROWS_EC_ENABLED");
            this.allowECForImmutableRows = value == null ? Boolean.valueOf(false) : Boolean.valueOf(Bytes.toString(value));
        }
        return this.allowECForImmutableRows;
    }

    public void setAllowECForImmutableRows(boolean allowECForImmutableRows) {
        this.setAttribute("IMMUTABLE_ROWS_EC_ENABLED", Bytes.toBytes(Boolean.toString(allowECForImmutableRows)));
        this.allowECForImmutableRows = allowECForImmutableRows;
    }

    public void addCoprocessorByClass(String className) throws LindormException {
        this.addCoprocessorByArgs("|" + className + "||");
    }

    public void addCoprocessorByArgs(String fullArgs) throws LindormException {
        Matcher valueMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_VALUE_PATTERN.matcher(fullArgs);
        if (!valueMatcher.matches()) {
            throw new LindormException("The args '" + fullArgs + "' don't match the pattern");
        }
        String classNameFromArgs = valueMatcher.group(2).trim();
        if (this.hasCoprocessor(classNameFromArgs)) {
            throw new LindormException("Coprocessor " + classNameFromArgs + " already exists.");
        }
        int maxCoprocessorNumber = 0;
        for (Map.Entry e : this.attributes.entrySet()) {
            Matcher keyMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_KEY_PATTERN.matcher((CharSequence)e.getKey());
            if (!keyMatcher.matches()) continue;
            maxCoprocessorNumber = Math.max(Integer.parseInt(keyMatcher.group(1)), maxCoprocessorNumber);
        }
        String key = "coprocessor$" + Integer.toString(++maxCoprocessorNumber);
        this.setAttribute(key, fullArgs);
    }

    public boolean hasCoprocessor(String className) {
        for (Map.Entry e : this.attributes.entrySet()) {
            String clazz;
            Matcher valueMatcher;
            Matcher keyMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_KEY_PATTERN.matcher((CharSequence)e.getKey());
            if (!keyMatcher.matches() || !(valueMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_VALUE_PATTERN.matcher(Bytes.toString((byte[])e.getValue()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
            return true;
        }
        return false;
    }

    public void removeCoprocessor(String className) {
        String match = null;
        for (Map.Entry e : this.attributes.entrySet()) {
            String clazz;
            Matcher valueMatcher;
            Matcher keyMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_KEY_PATTERN.matcher((CharSequence)e.getKey());
            if (!keyMatcher.matches() || !(valueMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_VALUE_PATTERN.matcher(Bytes.toString((byte[])e.getValue()))).matches() || !(clazz = valueMatcher.group(2).trim()).equals(className.trim())) continue;
            match = (String)e.getKey();
            break;
        }
        if (match != null) {
            this.removeAttribute(match);
        }
    }

    public Map<String, byte[]> getCoprocessorAttrs() {
        HashMap cpAttributes = null;
        for (Map.Entry e : this.attributes.entrySet()) {
            Matcher keyMatcher = LindormTableAttributeConstants.CP_TABLE_ATTR_KEY_PATTERN.matcher((CharSequence)e.getKey());
            if (!keyMatcher.matches()) continue;
            if (cpAttributes == null) {
                cpAttributes = new HashMap();
            }
            cpAttributes.put(e.getKey(), e.getValue());
        }
        return cpAttributes;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    static {
        HashSet<String> tmp = new HashSet<String>(64);
        tmp.add("DEFERRED_LOG_FLUSH");
        tmp.add("MUTABILITY");
        tmp.add("CONSISTENCY");
        tmp.add("DYNAMIC_COLUMNS");
        tmp.add("GLITCH_TIMEOUT");
        tmp.add("READ_GLITCH_TIMEOUT");
        tmp.add("WRITE_GLITCH_TIMEOUT");
        tmp.add("LEADER_BALANCE_ENABLED");
        tmp.add("REF_SPLIT_ALLOWED");
        tmp.add("MAX_PK_LEN");
        tmp.add("MAX_NONPK_LEN");
        tmp.add("ALLOW_FILTERING");
        tmp.add("READONLY");
        tmp.add("MEMSTORE_FLUSHSIZE");
        tmp.add("SKIP_REPLICA_CONSENSUS");
        tmp.add("LEADER_BALANCE_TYPE");
        tmp.add("DATA_CODEC");
        tmp.add("WAL_EDIT_WITH_FULL_ROW");
        tmp.add("FULL_ROW_EDIT_CARRY_LATEST_DATA");
        tmp.add("CONFLICT_RESOLVER");
        tmp.add("IMMUTABLE_ROWS_EC_ENABLED");
        ALL_TABLE_ATTRIBUTE_KEYS = Collections.unmodifiableSet(tmp);
        HashSet ntmp = new HashSet(tmp);
        ntmp.remove("CONSISTENCY");
        ALL_TABLE_ATTRIBUTE_KEYS_WITHOUT_CONSISTENCY = Collections.unmodifiableSet(ntmp);
    }

    public static enum LeaderBalanceType {
        RoundRobin("roundrobin"),
        Single("single"),
        None("none");

        private final String description;
        private static Map<String, LeaderBalanceType> stringToBalanceType;

        private LeaderBalanceType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static LeaderBalanceType getBalanceType(String description) {
            LeaderBalanceType type = stringToBalanceType.get(description);
            if (type == null) {
                throw new IllegalArgumentException("No balance type: " + description + ", Supported: roundrobin, single, none");
            }
            return type;
        }

        static {
            stringToBalanceType = new HashMap<String, LeaderBalanceType>();
            for (LeaderBalanceType type : LeaderBalanceType.values()) {
                stringToBalanceType.put(type.description, type);
            }
        }
    }

    public static enum ConsistencyType {
        Eventual("eventual"),
        TimeStamp("timestamp"),
        Basic("basic"),
        Strong("strong");

        private final String description;
        private static Map<String, ConsistencyType> stringToConsistencyType;

        private ConsistencyType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static ConsistencyType getConsistencyType(String description) {
            ConsistencyType type = stringToConsistencyType.get(description);
            if (type == null) {
                throw new IllegalArgumentException("No consistency type: " + description + ", Supported: eventual, timestamp, basic, strong");
            }
            return type;
        }

        static {
            stringToConsistencyType = new HashMap<String, ConsistencyType>();
            for (ConsistencyType type : ConsistencyType.values()) {
                stringToConsistencyType.put(type.description, type);
            }
        }
    }
}

