/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.AggregateType;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AggregateOperation
extends VersionedObjectWithAttributes {
    private AggregateType type;
    private ColumnKey column = null;
    private String aliasedName;
    private DataType interpreterDatatype;
    private static final byte VERSION_V2 = 2;

    public static AggregateOperation count() {
        return AggregateOperation.count(null);
    }

    public static AggregateOperation count(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.COUNT.toString(), column);
        return new AggregateOperation(AggregateType.COUNT, column, aliasedName);
    }

    public static AggregateOperation count(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.COUNT, column, aliasedName);
    }

    public static AggregateOperation avg(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.AVG.toString(), column);
        return new AggregateOperation(AggregateType.AVG, column, aliasedName);
    }

    public static AggregateOperation avg(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.AVG, column, aliasedName);
    }

    public static AggregateOperation sum(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.SUM.toString(), column);
        return new AggregateOperation(AggregateType.SUM, column, aliasedName);
    }

    public static AggregateOperation sum(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.SUM, column, aliasedName);
    }

    public static AggregateOperation min(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.MIN.toString(), column);
        return new AggregateOperation(AggregateType.MIN, column, aliasedName);
    }

    public static AggregateOperation min(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.MIN, column, aliasedName);
    }

    public static AggregateOperation max(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.MAX.toString(), column);
        return new AggregateOperation(AggregateType.MAX, column, aliasedName);
    }

    public static AggregateOperation max(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.MAX, column, aliasedName);
    }

    public static AggregateOperation distinct(ColumnKey column) {
        String aliasedName = AggregateOperation.getDefaultAliasedName(AggregateType.DISTINCT.toString(), column);
        return new AggregateOperation(AggregateType.DISTINCT, column, aliasedName);
    }

    public static AggregateOperation distinct(ColumnKey column, String aliasedName) {
        return new AggregateOperation(AggregateType.DISTINCT, column, aliasedName);
    }

    public static String getDefaultAliasedName(String func, ColumnKey column) {
        return func + "(" + (column != null ? column.toString() : "*") + ")";
    }

    public AggregateOperation() {
    }

    private AggregateOperation(AggregateType type, ColumnKey column, String aliasedName) {
        this.type = type;
        this.column = column;
        this.aliasedName = aliasedName;
    }

    public ColumnKey getColumn() {
        return this.column;
    }

    public String getAliasedName() {
        return this.aliasedName;
    }

    public AggregateType getType() {
        return this.type;
    }

    public DataType getInterpreterDatatype() {
        return this.interpreterDatatype;
    }

    public AggregateOperation setInterpreterDatatype(DataType interpreterDatatype) {
        this.interpreterDatatype = interpreterDatatype;
        return this;
    }

    @Override
    protected byte getSupportedVersion() {
        return this.useV2Version() ? (byte)2 : (byte)this.getVersion();
    }

    private boolean useV2Version() {
        return this.interpreterDatatype != null;
    }

    @Override
    public String toString() {
        return this.getAliasedName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AggregateOperation)) {
            return false;
        }
        AggregateOperation other = (AggregateOperation)obj;
        if (this.type != other.type) {
            return false;
        }
        if (!this.aliasedName.equals(other.aliasedName)) {
            return false;
        }
        if (this.column != null != (other.column != null)) {
            return false;
        }
        return this.column == null || this.column.equals(other.column);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.column != null) {
            out.writeBoolean(true);
            this.column.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        WritableUtils.writeString(out, this.aliasedName);
        out.writeByte(this.type.getId());
        if (this.useV2Version()) {
            WritableUtils.writeString(out, this.interpreterDatatype.name());
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        boolean hasColumn = in.readBoolean();
        if (hasColumn) {
            this.column = new ColumnKey();
            this.column.readFrom(in);
        } else {
            this.column = null;
        }
        this.aliasedName = WritableUtils.readString(in);
        this.type = AggregateType.fromId(in.readByte());
        if (this.getVersion() >= 2) {
            this.interpreterDatatype = DataType.valueOf(WritableUtils.readString(in));
        }
    }
}

