/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.LindormTableService;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LColumnRange;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.Delete;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public class LDelete
extends DmlOperation
implements Delete {
    public static final String DELETE_COLUMNS_ATTR = "COLUMNS";
    public static final String COLUMN_RANGES_ATTR = "COLUMN_RANGES";
    public static final String DELETE_TIMESTAMP_ATTR = "TIMESTAMP";
    public static final String DELETE_TYPE_ATTR = "TYPE";
    public static final String DELETE_STREAM_ATTR = "STREAM";
    private Condition where;
    private List<ColumnKey> columnsToDelete = null;
    private List<LColumnRange> columnRanges = null;
    private Long timestamp = null;
    private DeleteType type = null;

    public LDelete() {
    }

    public LDelete(LindormTableService service) {
        super(service);
    }

    @Override
    public Delete from(String tableName) throws LindormException {
        if (this.service != null) {
            this.namespace = this.service.getNamespace();
        }
        this.tableName = tableName;
        return this;
    }

    @Override
    public Delete columns(String ... columns) {
        if (columns != null && columns.length > 0) {
            this.columnsToDelete = CollectionUtils.newArrayListWithCapacity(columns.length);
            for (String col : columns) {
                if (col == null || col.isEmpty()) {
                    throw new IllegalArgumentException("Column name to delete must not be null or empty.");
                }
                this.columnsToDelete.add(new ColumnKey(Bytes.toBytes(col)));
            }
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete columns(byte[] ... columns) {
        if (columns != null && columns.length > 0) {
            this.columnsToDelete = CollectionUtils.newArrayListWithCapacity(columns.length);
            for (byte[] col : columns) {
                if (col == null || col.length == 0) {
                    throw new IllegalArgumentException("Column name to delete must not be null or empty.");
                }
                this.columnsToDelete.add(new ColumnKey(col));
            }
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete columns(List<ColumnKey> columns) {
        if (columns != null && columns.size() > 0) {
            for (ColumnKey ck : columns) {
                if (ck != null) continue;
                throw new IllegalArgumentException("Column key must not be null.");
            }
            this.columnsToDelete = columns;
        } else {
            this.columnsToDelete = null;
        }
        return this;
    }

    @Override
    public Delete columnRange(ColumnKey start, ColumnKey end) {
        return this.columnRange(start, true, end, false);
    }

    @Override
    public Delete columnRangeStartFrom(ColumnKey start, boolean startInclusive) {
        return this.columnRange(start, startInclusive, null, true);
    }

    @Override
    public Delete columnRangeEndWith(ColumnKey end, boolean endInclusive) {
        return this.columnRange(null, true, end, endInclusive);
    }

    @Override
    public Delete columnRange(ColumnKey start, boolean startInclusive, ColumnKey end, boolean endInclusive) {
        if (start != null && end != null) {
            if (Bytes.compareTo(start.getFamily(), end.getFamily()) != 0) {
                throw new IllegalArgumentException("family must be the same for start and end, start: " + start + ", end: " + end);
            }
            if (start.compareTo(end) >= 0) {
                throw new IllegalArgumentException("start must less than end, start: " + start + ", end: " + end);
            }
        }
        if (start == null && end == null) {
            throw new IllegalArgumentException("start and end can't both be null");
        }
        if (this.columnRanges == null) {
            this.columnRanges = new ArrayList<LColumnRange>();
        }
        this.columnRanges.add(new LColumnRange(start, startInclusive, end, endInclusive));
        return this;
    }

    @Override
    public Delete where(Condition where) {
        if (where == null) {
            throw new IllegalArgumentException("DELETE must have a valid WHERE clause, but has null.");
        }
        this.where = where;
        return this;
    }

    @Override
    public void internalSetTTL(long ttl) {
        throw new UnsupportedOperationException("Setting TTLs on Delete is not supported");
    }

    @Override
    public Delete timestamp(long timestamp) {
        this.timestamp = timestamp;
        this.type = DeleteType.ALL;
        return this;
    }

    @Override
    public Delete timestamp(long timestamp, boolean deleteAllVersions) {
        this.timestamp = timestamp;
        this.type = deleteAllVersions ? DeleteType.ALL : DeleteType.SINGLE;
        return this;
    }

    private LServerCallable<LMutationResult> buildDeleteCallable() {
        return new LServerCallable<LMutationResult>((DmlOperation)this, OperationContext.OperationType.DELETE){

            @Override
            public LMutationResult call() throws Exception {
                return this.server.delete(LDelete.this);
            }
        };
    }

    public void resetParamValues(List<List<Object>> params) throws LindormException {
        ArrayList<Object> all = new ArrayList<Object>();
        for (List<Object> param : params) {
            all.addAll(param);
        }
        if (this.where != null) {
            this.where.resetParamValues(all);
        }
    }

    @Override
    public Future<Integer> executeAsync() throws LindormException {
        final ClientCompletableFuture<Integer> future = new ClientCompletableFuture<Integer>();
        this.executeAsync(new AsyncCallback<Integer>(){

            @Override
            public void onComplete(Integer result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public Future<Integer> executeAsync(List<List<Object>> params) throws LindormException {
        this.resetParamValues(params);
        return this.executeAsync();
    }

    @Override
    public void executeAsync(AsyncCallback<Integer> callback) throws LindormException {
        this.validate();
        this.setupRouteKey();
        OperationContext.OperationType operationType = OperationContext.OperationType.DELETE;
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        LServerCallable<LMutationResult> deleteCallable = this.buildDeleteCallable();
        Object traceContext = this.service.startOperationAsync(this.tableName, operationType);
        AsyncDeleteHandler asyncDeleteHandler = new AsyncDeleteHandler(callback, operationType, System.currentTimeMillis(), traceContext, retryingCaller);
        retryingCaller.withRetriesAsync(deleteCallable, asyncDeleteHandler);
    }

    @Override
    public void executeAsync(List<List<Object>> params, AsyncCallback<Integer> callback) throws LindormException {
        this.resetParamValues(params);
        this.executeAsync(callback);
    }

    @Override
    public int execute() throws LindormException {
        this.validate();
        long start = System.currentTimeMillis();
        this.service.startOperation(this.tableName, OperationContext.OperationType.DELETE);
        RetryingCaller<LMutationResult> retryingCaller = this.service.getLConnection().getDMLRetryingCaller(this.getOperationTimeout(), this.getGlitchTimeout(), this.service.getDoAsUser());
        try {
            this.setupRouteKey();
            LDelete delete = this;
            LServerCallable<LMutationResult> deleteCallable = this.buildDeleteCallable();
            LMutationResult result = retryingCaller.withRetries(deleteCallable);
            this.handleResultAttributes(delete, result);
            this.service.getLConnection().getTableMetricsManager().onOperationSuccess(this.namespace, this.tableName, OperationContext.OperationType.DELETE, System.currentTimeMillis() - start, 1);
            this.service.endOperationSuccessfully(this.tableName, retryingCaller);
            return result.getNumberOfRowsAffected();
        }
        catch (Throwable t) {
            if (t instanceof TableNotFoundException) {
                this.service.getLConnection().getTableMetaCache().removeTable(this.namespace, this.tableName);
            }
            String msg = this.buildErrorMsg(OperationContext.OperationType.DELETE, t, System.currentTimeMillis() - start);
            LindormException error = new LindormException(msg);
            if (this.service.isInitCauseBy()) {
                error.initCause(t);
            }
            this.service.getLConnection().getTableMetricsManager().onOperationError(this.namespace, this.tableName, OperationContext.OperationType.DELETE, error);
            this.service.endOperationExceptionally(this.tableName, retryingCaller, t);
            throw error;
        }
    }

    @Override
    public int execute(List<List<Object>> params) throws LindormException {
        this.resetParamValues(params);
        return this.execute();
    }

    public List<ColumnKey> getColumnsToDelete() {
        return this.columnsToDelete;
    }

    public List<LColumnRange> getColumnRanges() {
        return this.columnRanges;
    }

    public Condition getWhere() {
        return this.where;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public DeleteType getType() {
        return this.type;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        if (this.columnsToDelete != null) {
            byte[] data = SchemaUtils.columnKeysToBytes(this.columnsToDelete);
            this.setAttribute(DELETE_COLUMNS_ATTR, data);
        }
        if (this.timestamp != null) {
            assert (this.type != null);
            this.setAttribute(DELETE_TIMESTAMP_ATTR, Bytes.toBytes(this.timestamp));
            this.setAttribute(DELETE_TYPE_ATTR, this.type.getValueBytes());
        }
        if (this.columnRanges != null && !this.columnRanges.isEmpty()) {
            this.setAttribute(COLUMN_RANGES_ATTR, this.columnRangeAsBytes(this.columnRanges));
        }
        super.writeTo(out);
        assert (this.where != null);
        WritableUtils.writeVInt(out, ExpressionType.getOrdinal(this.where));
        this.where.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.where = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
        assert (this.where != null);
        this.where.readFrom(in);
        this.handleAttributes();
    }

    private void handleAttributes() throws IOException {
        byte[] columnRangeBytes;
        byte[] timestampBytes;
        byte[] columnBytes = this.getAttribute(DELETE_COLUMNS_ATTR);
        if (columnBytes != null && columnBytes.length > 0) {
            this.columnsToDelete = SchemaUtils.bytesToColumnKeys(columnBytes);
        }
        if ((timestampBytes = this.getAttribute(DELETE_TIMESTAMP_ATTR)) != null && timestampBytes.length > 0) {
            this.timestamp = Bytes.toLong(timestampBytes);
            this.type = DeleteType.fromValue(this.getAttribute(DELETE_TYPE_ATTR)[0]);
        }
        if ((columnRangeBytes = this.getAttribute(COLUMN_RANGES_ATTR)) != null && columnRangeBytes.length > 0) {
            this.columnRanges = this.columnRangeFromBytes(columnRangeBytes);
        }
    }

    @Override
    public String toString() {
        String columnRangeStr;
        StringBuilder str = new StringBuilder();
        str.append("DELETE ");
        boolean hasColumns = false;
        if (this.columnsToDelete != null && this.columnsToDelete.size() > 0) {
            for (ColumnKey ck : this.columnsToDelete) {
                str.append(ck.toString());
                str.append(",");
            }
            str.setLength(str.length() - 1);
            hasColumns = true;
        }
        if ((columnRangeStr = this.columnRangeToString()) != null) {
            if (hasColumns) {
                str.append(",");
            }
            str.append(columnRangeStr);
        }
        str.append(" FROM ");
        str.append(this.tableName);
        str.append(" WHERE ");
        str.append(this.where.toString());
        if (this.timestamp != null) {
            if (this.type == DeleteType.ALL) {
                str.append(" TS <= ");
            } else {
                str.append(" TS == ");
            }
            str.append(this.timestamp);
        }
        return str.toString();
    }

    private String columnRangeToString() {
        if (this.columnRanges == null || this.columnRanges.isEmpty()) {
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (LColumnRange item : this.columnRanges) {
            strings.add(this.columnRangeToString(item));
        }
        return StringUtils.join("+", strings);
    }

    private String columnRangeToString(LColumnRange columnRange) {
        String start = (columnRange.getStart() == null ? "[..." : (columnRange.getStartInclusive() != false ? "[" : "(") + columnRange.getStart().toString()) + ",";
        String end = columnRange.getEnd() == null ? "...]" : columnRange.getEnd().toString() + (columnRange.getEndInclusive() != false ? "]" : ")");
        return start + end;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof LDelete)) {
            return false;
        }
        LDelete other = (LDelete)obj;
        return this.where.equals(other.where);
    }

    @Override
    protected byte[] computeRowKey(TableMeta meta) throws LindormException {
        return CompilerUtils.getRowKeyForRouting(meta, this.where);
    }

    private void validate() throws LindormException {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalRequestException("Table name must not be null or empty for DELETE.");
        }
        if (this.where == null) {
            throw new IllegalRequestException("Empty WHERE clause for DELETE " + this.tableName);
        }
    }

    private byte[] columnRangeAsBytes(List<LColumnRange> columnRange) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(stream);
        output.writeInt(columnRange.size());
        for (LColumnRange range : columnRange) {
            range.writeTo(output);
        }
        return stream.toByteArray();
    }

    private List<LColumnRange> columnRangeFromBytes(byte[] rangeBytes) throws IOException {
        return this.columnRangeFromBytes(rangeBytes, 0, rangeBytes.length);
    }

    private List<LColumnRange> columnRangeFromBytes(byte[] bytes, int offset, int length) throws IOException {
        if (offset + length > bytes.length) {
            throw new IllegalArgumentException("byte array overflow. offset: " + offset + ", length: " + length + ", bytes length: " + bytes.length);
        }
        if (length < 4) {
            throw new IllegalArgumentException("byte array length must > 4, length: " + length);
        }
        ArrayList<LColumnRange> result = new ArrayList<LColumnRange>();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes, offset, length);
        DataInputStream input = new DataInputStream(stream);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            LColumnRange columnRange = new LColumnRange();
            columnRange.readFrom(input);
            result.add(columnRange);
        }
        return result;
    }

    private class AsyncDeleteHandler
    extends DmlOperation.AsyncLMutationResultHandler<Integer> {
        public AsyncDeleteHandler(AsyncCallback<Integer> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super((DmlOperation)LDelete.this, callback, operationType, startTime, traceContext, caller);
        }

        @Override
        protected Integer getReturnValue(LMutationResult result) {
            return result.getNumberOfRowsAffected();
        }
    }

    public static enum DeleteType {
        ALL(1),
        SINGLE(2);

        private byte value;
        private byte[] valueBytes;

        private DeleteType(byte v) {
            this.value = v;
            this.valueBytes = new byte[]{v};
        }

        public byte getValue() {
            return this.value;
        }

        public byte[] getValueBytes() {
            return this.valueBytes;
        }

        public static DeleteType fromValue(byte v) {
            switch (v) {
                case 1: {
                    return ALL;
                }
                case 2: {
                    return SINGLE;
                }
            }
            throw new IllegalArgumentException("Unknown delete type value: " + v);
        }
    }
}

