/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice.index;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.IndexUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BuildIndexRequest
extends VersionedObjectWithAttributes {
    private String namespace;
    private String dataTableName;
    private String indexName;

    public BuildIndexRequest() {
    }

    public BuildIndexRequest(String namespace, String dataTableName, String indexName) {
        this.namespace = namespace;
        this.dataTableName = dataTableName;
        this.indexName = indexName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getIndexFullName() {
        return IndexUtils.getIndexFullName(this.namespace, this.dataTableName, this.indexName);
    }

    public String getTableFullName() {
        return this.namespace + "." + this.dataTableName;
    }

    @Override
    public String toString() {
        return this.namespace + "." + this.dataTableName + "." + this.indexName;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.dataTableName);
        WritableUtils.writeString(out, this.indexName);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.dataTableName = WritableUtils.readString(in);
        this.indexName = WritableUtils.readString(in);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.dataTableName != null ? this.dataTableName.hashCode() : 0);
        result = 31 * result + (this.indexName != null ? this.indexName.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof BuildIndexRequest)) {
            return false;
        }
        BuildIndexRequest other = (BuildIndexRequest)obj;
        return other.namespace.equals(this.namespace) && other.dataTableName.equals(this.dataTableName) && other.indexName.equals(this.indexName);
    }
}

