/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice.index;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.index.LSearchIndexDescriptor;
import com.alibaba.lindorm.client.core.tableservice.index.LSecondaryIndexDescriptor;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.schema.LindormSearchIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormSecondaryIndexDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class IndexList
extends VersionedObjectWithAttributes {
    private String namespace;
    private String tableName;
    private List<LSecondaryIndexDescriptor> secondaryIndexDescriptorList = new ArrayList<LSecondaryIndexDescriptor>();
    private List<LSearchIndexDescriptor> searchIndexDescriptorList = new ArrayList<LSearchIndexDescriptor>();
    private List<LindormSecondaryIndexDescriptor> secondaryIndexList;
    private List<LindormSearchIndexDescriptor> searchIndexList;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addSecondaryIndexDescriptor(LSecondaryIndexDescriptor secondaryIndexDescriptor) {
        this.secondaryIndexDescriptorList.add(secondaryIndexDescriptor);
    }

    public void addSearchIndexDescriptor(LSearchIndexDescriptor searchIndexDescriptor) {
        this.searchIndexDescriptorList.add(searchIndexDescriptor);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        int i;
        this.setupAttributes();
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
        if (null != this.secondaryIndexDescriptorList) {
            WritableUtils.writeVInt(out, this.secondaryIndexDescriptorList.size());
            for (i = 0; i < this.secondaryIndexDescriptorList.size(); ++i) {
                this.secondaryIndexDescriptorList.get(i).writeTo(out);
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
        if (null != this.searchIndexDescriptorList) {
            WritableUtils.writeVInt(out, this.searchIndexDescriptorList.size());
            for (i = 0; i < this.searchIndexDescriptorList.size(); ++i) {
                this.searchIndexDescriptorList.get(i).writeTo(out);
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        int searchIndexSize;
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        int secondaryIndexSize = WritableUtils.readVInt(in);
        if (secondaryIndexSize > 0) {
            this.secondaryIndexDescriptorList = new ArrayList<LSecondaryIndexDescriptor>(secondaryIndexSize);
            for (int i = 0; i < secondaryIndexSize; ++i) {
                LSecondaryIndexDescriptor tmp = new LSecondaryIndexDescriptor();
                tmp.readFrom(in);
                this.secondaryIndexDescriptorList.add(tmp);
            }
        }
        if ((searchIndexSize = WritableUtils.readVInt(in)) > 0) {
            this.searchIndexDescriptorList = new ArrayList<LSearchIndexDescriptor>(searchIndexSize);
            for (int i = 0; i < searchIndexSize; ++i) {
                LSearchIndexDescriptor tmp = new LSearchIndexDescriptor();
                tmp.readFrom(in);
                this.searchIndexDescriptorList.add(tmp);
            }
        }
        this.initSecondaryIndexList();
        this.initSearchIndexList();
        this.initFromAttributes();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Namespace [" + this.namespace + "], ");
        builder.append("Table [" + this.tableName + "]\n\n");
        builder.append("Secondary Index List {\n");
        int count = 0;
        for (LindormSecondaryIndexDescriptor lindormSecondaryIndexDescriptor : this.secondaryIndexList) {
            builder.append(++count + ".");
            builder.append("[");
            builder.append(lindormSecondaryIndexDescriptor);
            builder.append("]\n");
        }
        builder.append("}\n\n");
        builder.append("Search Index List {\n");
        count = 0;
        for (LindormSearchIndexDescriptor lindormSearchIndexDescriptor : this.searchIndexList) {
            builder.append(++count + ".");
            builder.append("[");
            builder.append(lindormSearchIndexDescriptor);
            builder.append("]\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    private void setupAttributes() throws IOException {
    }

    private void initFromAttributes() throws IOException {
    }

    private synchronized void initSecondaryIndexList() {
        this.secondaryIndexList = new ArrayList<LindormSecondaryIndexDescriptor>(this.secondaryIndexDescriptorList.size());
        for (int i = 0; i < this.secondaryIndexDescriptorList.size(); ++i) {
            this.secondaryIndexList.add(this.secondaryIndexDescriptorList.get(i).toLindormSecondaryIndexDescriptor());
        }
    }

    public synchronized LindormSecondaryIndexDescriptor getSecondaryIndexDescriptor(String indexName) {
        if (StringUtils.isNullOrEmpty(indexName)) {
            throw new IllegalArgumentException("Index name is illegal:" + indexName);
        }
        if (null == this.secondaryIndexList) {
            this.initSecondaryIndexList();
        }
        for (LindormSecondaryIndexDescriptor indexDescriptor : this.secondaryIndexList) {
            if (!indexDescriptor.getIndexName().equals(indexName)) continue;
            return indexDescriptor;
        }
        return null;
    }

    public synchronized List<LindormSecondaryIndexDescriptor> getSecondaryIndexDescriptorList() {
        if (null == this.secondaryIndexList) {
            this.initSecondaryIndexList();
        }
        return this.secondaryIndexList;
    }

    private synchronized void initSearchIndexList() {
        this.searchIndexList = new ArrayList<LindormSearchIndexDescriptor>(this.searchIndexDescriptorList.size());
        for (int i = 0; i < this.searchIndexDescriptorList.size(); ++i) {
            this.searchIndexList.add(this.searchIndexDescriptorList.get(i).toLindormSearchIndexDescriptor());
        }
    }

    public synchronized LindormSearchIndexDescriptor getSearchIndexDescriptor(String indexName) {
        if (StringUtils.isNullOrEmpty(indexName)) {
            throw new IllegalArgumentException("Index name is illegal:" + indexName);
        }
        if (null == this.searchIndexList) {
            this.initSearchIndexList();
        }
        for (LindormSearchIndexDescriptor indexDescriptor : this.searchIndexList) {
            if (!indexDescriptor.getIndexName().equals(indexName)) continue;
            return indexDescriptor;
        }
        return null;
    }

    public synchronized List<LindormSearchIndexDescriptor> getSearchIndexDescriptorList() {
        if (null == this.searchIndexList) {
            this.initSearchIndexList();
        }
        return this.searchIndexList;
    }
}

