/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTimestamp;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.sql.Date;

public class LDate
extends LDataType<Date> {
    public static final LDate INSTANCE = new LDate();

    private LDate() {
        super(DataType.DATE, Date.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (DataTypeUtils.equalsAny(targetType, INSTANCE, LTimestamp.INSTANCE)) {
            return true;
        }
        return LLong.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        long v = ((Date)value).getTime();
        return LLong.INSTANCE.toBytes(v, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long v;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LUnsignedDate.INSTANCE)) {
            return value;
        }
        if (actualType == LString.INSTANCE) {
            try {
                return Date.valueOf((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalDataException("Cannot convert string '" + value + "' into Date value.", e);
            }
        }
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException t) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        return new Date(v);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        long v;
        try {
            v = (Long)LLong.INSTANCE.toObject(value, offset, length, sortOrder);
        }
        catch (IllegalDataException e) {
            throw new IllegalDataException("Cannot convert byte[] to Date, because it's not a long value", e);
        }
        return new Date(v);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_LONG_ARRAY;
    }

    @Override
    public Date randomData(DataGenerator dataGenerator) {
        return new Date(dataGenerator.getRandom().nextInt(Integer.MAX_VALUE));
    }
}

