/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public class LDouble
extends LRealNumberType<Double> {
    public static final LDouble INSTANCE = new LDouble();

    protected LDouble(DataType dataType) {
        super(dataType, Double.class);
    }

    private LDouble() {
        this(DataType.DOUBLE);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType instanceof LRealNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE, LDecimal.INSTANCE, LDecimalV2.INSTANCE);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeDouble(((Number)value).doubleValue(), ret, 0, sortOrder);
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        double ret;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LUnsignedDouble.INSTANCE, LAccDouble.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, LFloat.INSTANCE, LUnsignedFloat.INSTANCE)) {
            ret = ((Float)value).floatValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Double.parseDouble((String)value);
                return ret;
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to double value.", e);
            }
        } else if (DataTypeUtils.equalsAny(actualType, LLong.INSTANCE, LUnsignedLong.INSTANCE, LAccLong.INSTANCE)) {
            ret = ((Long)value).longValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LInteger.INSTANCE, LUnsignedInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LShort.INSTANCE, LUnsignedShort.INSTANCE)) {
            ret = ((Short)value).shortValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LByte.INSTANCE, LUnsignedByte.INSTANCE)) {
            ret = ((Byte)value).byteValue();
            return ret;
        } else if (actualType == LDecimal.INSTANCE || actualType == LDecimalV2.INSTANCE) {
            BigDecimal bd = (BigDecimal)value;
            if (bd.compareTo(DataTypeUtils.MAX_DOUBLE_AS_DECIMAL) > 0 || bd.compareTo(DataTypeUtils.MIN_DOUBLE_AS_DECIMAL) < 0) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = bd.doubleValue();
            return ret;
        } else if (DataTypeUtils.equalsAny(actualType, LDate.INSTANCE, LUnsignedDate.INSTANCE)) {
            ret = ((Date)value).getTime();
            return ret;
        } else {
            if (!DataTypeUtils.equalsAny(actualType, LTime.INSTANCE, LUnsignedTime.INSTANCE)) throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            ret = ((Time)value).getTime();
        }
        return ret;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeDouble(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_DOUBLE_ARRAY;
    }

    @Override
    public Double randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextDouble();
    }
}

