/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.ListType;
import java.util.ArrayList;
import java.util.List;

public class LList<K>
extends LCollectionType<List<K>> {
    private static final int HEADER_SIZE = 2;
    private final LDataType<K> elementType;
    public static final LList FAKE_INSTANCE = new LList<String>(LString.INSTANCE);

    public LList(LDataType<K> elementType) {
        super(DataType.LIST, List.class);
        this.elementType = elementType;
    }

    public LList(ListType listType) {
        super(DataType.LIST, List.class);
        this.elementType = listType.getCollectionDataType() != null ? LDataTypeFactory.INSTANCE.getTypeInstance(listType.getCollectionDataType()) : LDataTypeFactory.INSTANCE.getTypeInstance(listType.getDataType());
    }

    public LList(byte[] bytes, int offset, int length) throws IllegalDataException {
        super(DataType.LIST, List.class);
        assert (bytes[offset] == DataType.LIST.ordinal());
        byte elementTypeBytesLength = bytes[offset + 1];
        assert (elementTypeBytesLength > 0);
        this.elementType = LDataType.fromBytes(bytes, offset + 2, elementTypeBytesLength);
    }

    public LDataType<K> getElementType() {
        return this.elementType;
    }

    @Override
    public byte[] asBytes() {
        byte[] elementTypeBytes = LDataType.asBytes(this.elementType);
        int length = elementTypeBytes.length + 2;
        assert (length < 127);
        byte[] result = new byte[length];
        result[0] = (byte)DataType.LIST.ordinal();
        result[1] = (byte)elementTypeBytes.length;
        System.arraycopy(elementTypeBytes, 0, result, 2, elementTypeBytes.length);
        return result;
    }

    @Override
    public CollectionDataType getCollectionDataType() {
        if (this.elementType instanceof LCollectionType) {
            return DataType.list(((LCollectionType)this.elementType).getCollectionDataType());
        }
        return DataType.list(this.elementType.getClientType());
    }

    @Override
    public LDataType getValueType() {
        return this.getElementType();
    }

    @Override
    public LDataType getKeyType() {
        return LInteger.INSTANCE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LList lList = (LList)o;
        return this.elementType != null ? this.elementType.equals(lList.elementType) : lList.elementType == null;
    }

    public int hashCode() {
        return this.elementType != null ? this.elementType.hashCode() : 0;
    }

    @Override
    public List<K> randomData(DataGenerator dataGen) {
        ArrayList<K> result = new ArrayList<K>();
        int count = Math.max(10, dataGen.getCount());
        for (int i = 0; i < count; ++i) {
            result.add(this.elementType.randomData(dataGen));
        }
        return result;
    }

    @Override
    public byte[] toTransferBytes(Object data) throws IllegalDataException {
        return this.toTransferBytes((List)data, this.elementType);
    }

    @Override
    public List<K> fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        ArrayList result = new ArrayList();
        this.fromTransferBytes(bytes, offset, length, this.elementType, result);
        return result;
    }

    @Override
    public void validate(Object data) throws IllegalDataException {
        super.validate(data);
        for (Object item : (List)data) {
            this.elementType.validate(item);
        }
    }

    @Override
    public int getByteSize(Object o) {
        List list = (List)o;
        int result = 0;
        for (Object item : list) {
            if (item == null) continue;
            result += this.elementType.getByteSize(item);
        }
        return result;
    }

    @Override
    public String toString() {
        return String.format("List<%s>", this.elementType);
    }
}

