/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LAccDouble;
import com.alibaba.lindorm.client.core.types.LAccLong;
import com.alibaba.lindorm.client.core.types.LByte;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDate;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.types.LDecimalV2;
import com.alibaba.lindorm.client.core.types.LDouble;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.types.LShort;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.types.LTime;
import com.alibaba.lindorm.client.core.types.LUnsignedByte;
import com.alibaba.lindorm.client.core.types.LUnsignedDate;
import com.alibaba.lindorm.client.core.types.LUnsignedDouble;
import com.alibaba.lindorm.client.core.types.LUnsignedFloat;
import com.alibaba.lindorm.client.core.types.LUnsignedInteger;
import com.alibaba.lindorm.client.core.types.LUnsignedLong;
import com.alibaba.lindorm.client.core.types.LUnsignedShort;
import com.alibaba.lindorm.client.core.types.LUnsignedTime;
import com.alibaba.lindorm.client.core.types.LWholeNumberType;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;

public class LLong
extends LWholeNumberType<Long> {
    public static final LLong INSTANCE = new LLong();

    protected LLong(DataType accLong) {
        super(accLong, Long.class);
    }

    private LLong() {
        super(DataType.LONG, Long.class);
    }

    @Override
    public int getByteSize() {
        return 8;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        if (targetType instanceof LWholeNumberType && DataTypeUtils.equalsAny(targetType, INSTANCE)) {
            return true;
        }
        return targetType instanceof LRealNumberType;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeLong(((Number)value).longValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long ret;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LUnsignedLong.INSTANCE, LAccLong.INSTANCE)) {
            return value;
        }
        if (DataTypeUtils.equalsAny(actualType, LInteger.INSTANCE, LUnsignedInteger.INSTANCE)) {
            ret = ((Integer)value).intValue();
        } else if (DataTypeUtils.equalsAny(actualType, LString.INSTANCE)) {
            try {
                ret = Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                throw new IllegalDataException("Cannot convert string value '" + value + "' to long value.", e);
            }
        } else if (DataTypeUtils.equalsAny(actualType, LShort.INSTANCE, LUnsignedShort.INSTANCE)) {
            ret = ((Short)value).shortValue();
        } else if (DataTypeUtils.equalsAny(actualType, LByte.INSTANCE, LUnsignedByte.INSTANCE)) {
            ret = ((Byte)value).byteValue();
        } else if (DataTypeUtils.equalsAny(actualType, LDouble.INSTANCE, LUnsignedDouble.INSTANCE, LAccDouble.INSTANCE)) {
            Double v = (Double)value;
            if (v < -9.223372036854776E18 || v > 9.223372036854776E18) {
                throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            }
            ret = v.longValue();
        } else if (DataTypeUtils.equalsAny(actualType, LFloat.INSTANCE, LUnsignedFloat.INSTANCE)) {
            Float v = (Float)value;
            if (v.floatValue() < -9.223372E18f || v.floatValue() > 9.223372E18f) {
                throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            }
            ret = v.longValue();
        } else if (actualType == LDecimal.INSTANCE || actualType == LDecimalV2.INSTANCE) {
            BigDecimal bd = (BigDecimal)value;
            try {
                ret = bd.longValueExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
            }
        } else if (DataTypeUtils.equalsAny(actualType, LDate.INSTANCE, LUnsignedDate.INSTANCE)) {
            ret = ((Date)value).getTime();
        } else if (DataTypeUtils.equalsAny(actualType, LTime.INSTANCE, LUnsignedTime.INSTANCE)) {
            ret = ((Time)value).getTime();
        } else {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        return ret;
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return DataTypeUtils.decodeLong(value, offset, sortOrder);
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_LONG_ARRAY;
    }

    @Override
    public Long randomData(DataGenerator dataGenerator) {
        return dataGenerator.getRandom().nextInt(Integer.MAX_VALUE);
    }
}

