/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LString;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.MapType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class LMap<K, V>
extends LCollectionType<Map<K, V>> {
    private static final int HEADER_SIZE = 3;
    private LDataType<K> keyType;
    private LDataType<V> valueType;
    public static final LMap FAKE_INSTANCE = new LMap<String, String>(LString.INSTANCE, LString.INSTANCE);

    public LMap(LDataType<K> keyType, LDataType<V> valueType) {
        super(DataType.MAP, Map.class);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public LMap(MapType mapType) {
        super(DataType.MAP, Map.class);
        this.keyType = mapType.getKeyDataType() != null ? LDataTypeFactory.INSTANCE.getTypeInstance(mapType.getKeyDataType()) : LDataTypeFactory.INSTANCE.getTypeInstance(mapType.getKeyCollectionDataType());
        this.valueType = mapType.getValueDataType() != null ? LDataTypeFactory.INSTANCE.getTypeInstance(mapType.getValueDataType()) : LDataTypeFactory.INSTANCE.getTypeInstance(mapType.getValueCollectionDataType());
    }

    public LMap(byte[] bytes, int offset, int length) throws IllegalDataException {
        super(DataType.MAP, Map.class);
        assert (bytes[offset] == DataType.MAP.ordinal());
        byte keyTypeBytesLength = bytes[offset + 1];
        byte valueTypeBytesLength = bytes[offset + 2];
        assert (keyTypeBytesLength > 0);
        assert (valueTypeBytesLength > 0);
        this.keyType = LDataType.fromBytes(bytes, offset + 3, keyTypeBytesLength);
        this.valueType = LDataType.fromBytes(bytes, offset + 3 + keyTypeBytesLength, valueTypeBytesLength);
    }

    @Override
    public LDataType getKeyType() {
        return this.keyType;
    }

    @Override
    public LDataType getValueType() {
        return this.valueType;
    }

    @Override
    public byte[] asBytes() {
        byte[] keyTypeBytes = LDataType.asBytes(this.keyType);
        byte[] valueTypeBytes = LDataType.asBytes(this.valueType);
        int length = keyTypeBytes.length + valueTypeBytes.length + 3;
        assert (length < 127);
        byte[] result = new byte[length];
        result[0] = (byte)DataType.MAP.ordinal();
        result[1] = (byte)keyTypeBytes.length;
        result[2] = (byte)valueTypeBytes.length;
        System.arraycopy(keyTypeBytes, 0, result, 3, keyTypeBytes.length);
        System.arraycopy(valueTypeBytes, 0, result, 3 + keyTypeBytes.length, valueTypeBytes.length);
        return result;
    }

    @Override
    public CollectionDataType getCollectionDataType() {
        if (this.keyType instanceof LCollectionType) {
            CollectionDataType keyCollectionDataType = ((LCollectionType)this.keyType).getCollectionDataType();
            if (this.valueType instanceof LCollectionType) {
                return DataType.map(keyCollectionDataType, ((LCollectionType)this.valueType).getCollectionDataType());
            }
            return DataType.map(keyCollectionDataType, this.valueType.getClientType());
        }
        DataType keyDataType = this.keyType.getClientType();
        if (this.valueType instanceof LCollectionType) {
            return DataType.map(keyDataType, ((LCollectionType)this.valueType).getCollectionDataType());
        }
        return DataType.map(keyDataType, this.valueType.getClientType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMap lMap = (LMap)o;
        if (this.keyType != null ? !this.keyType.equals(lMap.keyType) : lMap.keyType != null) {
            return false;
        }
        return this.valueType != null ? this.valueType.equals(lMap.valueType) : lMap.valueType == null;
    }

    public int hashCode() {
        int result = this.keyType != null ? this.keyType.hashCode() : 0;
        result = 31 * result + (this.valueType != null ? this.valueType.hashCode() : 0);
        return result;
    }

    @Override
    public Map<K, V> randomData(DataGenerator dataGen) {
        HashMap<K, V> result = new HashMap<K, V>();
        int count = Math.max(10, dataGen.getCount());
        for (int i = 0; i < count; ++i) {
            result.put(this.keyType.randomData(dataGen), this.valueType.randomData(dataGen));
        }
        return result;
    }

    @Override
    public byte[] toTransferBytes(Object map) throws IllegalDataException {
        Map data = (Map)map;
        byte[] typeBytes = this.asBytes();
        int length = 1 + typeBytes.length + 4 + 8 * data.size();
        ArrayList<byte[]> keyList = new ArrayList<byte[]>();
        ArrayList<byte[]> valueList = new ArrayList<byte[]>();
        for (Map.Entry item : data.entrySet()) {
            byte[] bytes = item.getKey() == null ? null : this.keyType.toTransferBytes(item.getKey());
            length += bytes == null ? 0 : bytes.length;
            keyList.add(bytes);
            bytes = item.getValue() == null ? null : this.valueType.toTransferBytes(item.getValue());
            length += bytes == null ? 0 : bytes.length;
            valueList.add(bytes);
        }
        byte[] result = new byte[length];
        int offset = 0;
        result[offset++] = (byte)typeBytes.length;
        offset = Bytes.putBytes(result, offset, typeBytes, 0, typeBytes.length);
        offset = Bytes.putInt(result, offset, data.size());
        for (int i = 0; i < data.size(); ++i) {
            byte[] keyBytes = (byte[])keyList.get(i);
            byte[] valueBytes = (byte[])valueList.get(i);
            int keyBytesLength = keyBytes == null ? 0 : keyBytes.length;
            int valueBytesLength = valueBytes == null ? 0 : valueBytes.length;
            offset = Bytes.putInt(result, offset, keyBytesLength);
            if (keyBytesLength != 0) {
                offset = Bytes.putBytes(result, offset, keyBytes, 0, keyBytesLength);
            }
            offset = Bytes.putInt(result, offset, valueBytesLength);
            if (valueBytesLength == 0) continue;
            offset = Bytes.putBytes(result, offset, valueBytes, 0, valueBytesLength);
        }
        return result;
    }

    @Override
    public Map<K, V> fromTransferBytes(byte[] bytes, int offset, int length) throws IllegalDataException {
        byte typeBytesLength = bytes[offset++];
        LDataType typeFromBytes = LDataType.fromBytes(bytes, offset, typeBytesLength);
        assert (this.equals(typeFromBytes));
        int size = Bytes.toInt(bytes, offset += typeBytesLength, 4);
        offset += 4;
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            int keyLength = Bytes.toInt(bytes, offset, 4);
            Object key = keyLength == 0 ? null : this.keyType.fromTransferBytes(bytes, offset += 4, keyLength);
            int valueLength = Bytes.toInt(bytes, offset += keyLength, 4);
            Object value = valueLength == 0 ? null : this.valueType.fromTransferBytes(bytes, offset += 4, valueLength);
            offset += valueLength;
            result.put(key, value);
        }
        return result;
    }

    @Override
    public void validate(Object data) throws IllegalDataException {
        super.validate(data);
        Map map = (Map)data;
        for (Map.Entry entry : map.entrySet()) {
            this.keyType.validate(entry.getKey());
            this.valueType.validate(entry.getValue());
        }
    }

    @Override
    public int getByteSize(Object o) {
        Map map = (Map)o;
        int result = 0;
        for (Map.Entry item : map.entrySet()) {
            if (item.getKey() != null) {
                result += this.keyType.getByteSize(item.getKey());
            }
            if (item.getValue() == null) continue;
            result += this.valueType.getByteSize(item.getValue());
        }
        return result;
    }

    @Override
    public String toString() {
        return String.format("Map<%s, %s>", this.keyType, this.valueType);
    }
}

