/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LInteger;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LParam
extends LDataType<Param> {
    public static final LParam INSTANCE = new LParam();

    private LParam() {
        super(DataType.PARAM, Param.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return false;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return LInteger.INSTANCE.toBytes(((Param)value).id);
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        return LInteger.INSTANCE.toBytes(((Param)value).id, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        DataType t = actualType.getClientType();
        if (t == DataType.PARAM) {
            return value;
        }
        if (t == DataType.INT || t == DataType.UNSIGNED_INTEGER) {
            return new Param((Integer)value);
        }
        throw new IllegalDataException(t, value, this.clientType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return new Param((Integer)LInteger.INSTANCE.toObject(value));
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        return new Param((Integer)LInteger.INSTANCE.toObject(value, offset, length, sortOrder));
    }

    @Override
    public Param randomData(DataGenerator dataGenerator) {
        return new Param(LInteger.INSTANCE.randomData(dataGenerator));
    }

    public static int getParamValue(Object value) throws LindormException {
        if (value instanceof Param) {
            return ((Param)value).getId();
        }
        throw new IllegalDataException("This is not a parameterized value, should not call getParamValue()");
    }

    public static class Param {
        private final int id;

        public Param(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return ":" + this.id;
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Param)) {
                return false;
            }
            Param other = (Param)obj;
            return this.id == other.id;
        }
    }
}

