/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LBinary;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LEncodedVarbinary;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LVarbinary
extends LDataType<byte[]> {
    public static final LVarbinary INSTANCE = new LVarbinary();
    private static byte[] DEFAULT_NULL_VALUE = new byte[]{0};

    private LVarbinary() {
        super(DataType.VARBINARY, byte[].class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LDataType#estimateByteSize() for variable length data types");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((byte[])obj).length;
    }

    @Override
    public boolean isFixedWidth() {
        return false;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LEncodedVarbinary.INSTANCE || targetType == LBinary.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return (byte[])value;
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] v = this.toBytes(value);
        if (sortOrder == SortOrder.DESC) {
            byte[] descValue = new byte[v.length];
            DataTypeUtils.invert(v, 0, descValue, 0, v.length);
            return descValue;
        }
        return v;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.isDirectBytesType(actualType.getClientType())) {
            return (byte[])value;
        }
        if (actualType.getClientType() == DataType.BYTE) {
            byte actualValue = (Byte)value;
            return new byte[]{actualValue};
        }
        throw new IllegalDataException("Cannot convert " + actualType.getClientType().toString() + " to binary/varbinary, value = " + value);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return value;
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[length];
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(value, offset, ret, 0, length);
        } else {
            System.arraycopy(value, offset, ret, 0, length);
        }
        return ret;
    }

    @Override
    public byte[] getNullValue() {
        return DEFAULT_NULL_VALUE;
    }

    @Override
    public byte[] randomData(DataGenerator dataGenerator) {
        return LBinary.INSTANCE.randomData(dataGenerator);
    }

    @Override
    public void validate(Object data) throws IllegalDataException {
        super.validate(data);
        byte[] bytes = (byte[])data;
        if (bytes != null && bytes.length == 0) {
            throw new IllegalDataException("Must not use byte[0] for VARBINARY, please use null instead");
        }
    }
}

