/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.parser.Function;
import com.alibaba.lindorm.client.core.utils.parser.LLParser;
import com.alibaba.lindorm.client.core.utils.parser.Mapper;
import com.alibaba.lindorm.client.core.utils.parser.ParseResult;
import com.alibaba.lindorm.client.core.utils.parser.Parser;
import com.alibaba.lindorm.client.core.utils.parser.Status;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionFactory;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ConditionParser {
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String IN = "IN";
    private static final String NOT_IN = "NOT IN";
    private static final String LIKE = "LIKE";
    private static final String NOT_LIKE = "NOT LIKE";
    private static final Parser TRUE_LITERAL = LLParser.regex("(?i)true").map(new Mapper<String, Boolean>(){

        @Override
        public Boolean map(String value) {
            return true;
        }
    });
    private static final Parser FALSE_LITERAL = LLParser.regex("(?i)false").map(new Mapper<String, Boolean>(){

        @Override
        public Boolean map(String value) {
            return false;
        }
    });
    private static final Parser BOOLEAN_LITERAL = TRUE_LITERAL.or(FALSE_LITERAL);
    private static final Parser PLUS_SIGN = LLParser.string("+");
    private static final Parser MINUS_SIGN = LLParser.string("-");
    private static final Parser UNSIGNED_INTEGER_LITERAL = LLParser.regex("\\d+").map(new Mapper<String, Long>(){

        @Override
        public Long map(String value) {
            return Long.parseLong(value);
        }
    });
    private static final Mapper SIGN_MAPPER = new Mapper<List<String>, Long>(){

        @Override
        public Long map(List<String> values) {
            return values.isEmpty() || values.get(0).equals("+") ? 1L : -1L;
        }
    };
    private static final Parser INTEGER_LITERAL = LLParser.sequence(ConditionParser.tokenize(LLParser.alternative(PLUS_SIGN, MINUS_SIGN).atMost(1).map(SIGN_MAPPER)), UNSIGNED_INTEGER_LITERAL).map(new Mapper<List<Long>, Long>(){

        @Override
        public Long map(List<Long> values) {
            return values.get(0) * values.get(1);
        }
    });
    private static final Parser PERIOD = LLParser.string(".");
    private static final Parser DECIMAL_LITERAL = LLParser.sequence(ConditionParser.tokenize(LLParser.alternative(PLUS_SIGN, MINUS_SIGN).atMost(1).map(SIGN_MAPPER)), LLParser.alternative(LLParser.sequence(UNSIGNED_INTEGER_LITERAL, PERIOD, LLParser.regex("\\d*")).map(new Mapper<List<Object>, Double>(){

        @Override
        public Double map(List<Object> values) {
            String value = values.get(0).toString() + StringUtils.join("", values.subList(1, values.size()));
            return Double.parseDouble(value);
        }
    }), LLParser.sequence(PERIOD, LLParser.regex("\\d+")).map(new Mapper<List<String>, Double>(){

        @Override
        public Double map(List<String> values) {
            return Double.parseDouble(StringUtils.join("", values));
        }
    }))).map(new Mapper<List<Object>, Double>(){

        @Override
        public Double map(List<Object> values) {
            boolean sign = (Long)values.get(0) == 1L;
            Double value = (Double)values.get(1);
            return sign ? value : 0.0 - value;
        }
    });
    private static final Parser NUMERIC_LITERAL = DECIMAL_LITERAL.or(INTEGER_LITERAL);
    private static final Parser UNESCAPED_STRING_LITERAL = LLParser.string("'").then(LLParser.regex("[^']*")).skip(LLParser.string("'"));
    private static final Parser STRING_LITERAL = UNESCAPED_STRING_LITERAL.atLeast(1).map(new Mapper<List<String>, String>(){

        @Override
        public String map(List<String> values) {
            return StringUtils.join("'", values);
        }
    });
    private static final Parser HEX_STRING_LITERAL = LLParser.string("x").then(STRING_LITERAL).map(new Mapper<String, byte[]>(){

        @Override
        public byte[] map(String value) {
            return Bytes.toBytesBinary(value);
        }
    });
    private static final Parser LEFT_PARENTHESIS = LLParser.string("(");
    private static final Parser RIGHT_PARENTHESIS = LLParser.string(")");
    private static final Parser COMMA_SIGN = ConditionParser.tokenize(LLParser.string(","));
    private static final Parser BOOLEAN_LIST_LITERAL = LEFT_PARENTHESIS.skip(LLParser.OPTIONAL_WHITESPACES).then(LLParser.sequence(BOOLEAN_LITERAL, LLParser.OPTIONAL_WHITESPACES.then(COMMA_SIGN).then(BOOLEAN_LITERAL).atLeast(0).skip(LLParser.OPTIONAL_WHITESPACES))).skip(RIGHT_PARENTHESIS).map(new Mapper<List<Object>, List<Boolean>>(){

        @Override
        public List<Boolean> map(List<Object> values) {
            ArrayList<Boolean> fetched = new ArrayList<Boolean>();
            fetched.add((Boolean)values.get(0));
            fetched.addAll((List)values.get(1));
            return fetched;
        }
    });
    private static final Parser NUMERIC_LIST_LITERAL = LEFT_PARENTHESIS.skip(LLParser.OPTIONAL_WHITESPACES).then(LLParser.sequence(NUMERIC_LITERAL, LLParser.OPTIONAL_WHITESPACES.then(COMMA_SIGN).then(NUMERIC_LITERAL).atLeast(0).skip(LLParser.OPTIONAL_WHITESPACES))).skip(RIGHT_PARENTHESIS).map(new Mapper<List<Object>, List<Object>>(){

        @Override
        public List<Object> map(List<Object> values) {
            ArrayList<Object> fetched = new ArrayList<Object>();
            fetched.add(values.get(0));
            fetched.addAll((List)values.get(1));
            return this.unify(fetched);
        }

        private List<Object> unify(List<Object> values) {
            ArrayList<Object> unifiedValues = null;
            if (this.hasDoubles(values)) {
                unifiedValues = new ArrayList<Object>(values.size());
                for (Object value : values) {
                    if (value instanceof Double) {
                        unifiedValues.add(value);
                        continue;
                    }
                    unifiedValues.add(new Double(((Long)value).longValue()));
                }
            } else {
                unifiedValues = new ArrayList(values.size());
                unifiedValues.addAll(values);
            }
            return unifiedValues;
        }

        private boolean hasDoubles(List<Object> values) {
            for (Object value : values) {
                if (!(value instanceof Double)) continue;
                return true;
            }
            return false;
        }
    });
    private static final Parser STRING_LIST_LITERAL = LEFT_PARENTHESIS.skip(LLParser.OPTIONAL_WHITESPACES).then(LLParser.sequence(STRING_LITERAL, LLParser.OPTIONAL_WHITESPACES.then(COMMA_SIGN).then(STRING_LITERAL).atLeast(0).skip(LLParser.OPTIONAL_WHITESPACES))).skip(RIGHT_PARENTHESIS).map(new Mapper<List<Object>, List<String>>(){

        @Override
        public List<String> map(List<Object> values) {
            ArrayList<String> fetched = new ArrayList<String>();
            fetched.add((String)values.get(0));
            fetched.addAll((List)values.get(1));
            return fetched;
        }
    });
    private static final Parser HEX_STRING_LIST_LITERAL = LEFT_PARENTHESIS.skip(LLParser.OPTIONAL_WHITESPACES).then(LLParser.sequence(HEX_STRING_LITERAL, LLParser.OPTIONAL_WHITESPACES.then(COMMA_SIGN).then(HEX_STRING_LITERAL).atLeast(0).skip(LLParser.OPTIONAL_WHITESPACES))).skip(RIGHT_PARENTHESIS).map(new Mapper<List<Object>, List<byte[]>>(){

        @Override
        public List<byte[]> map(List<Object> values) {
            ArrayList<byte[]> fetched = new ArrayList<byte[]>();
            fetched.add((byte[])values.get(0));
            fetched.addAll((List)values.get(1));
            return fetched;
        }
    });
    private static final Parser VALUE_LIST_LITERAL = LLParser.alternative(NUMERIC_LIST_LITERAL, STRING_LIST_LITERAL, HEX_STRING_LIST_LITERAL, BOOLEAN_LIST_LITERAL);
    private static final Parser LESS_OR_EQUAL_SIGN_LITERAL = ConditionParser.tokenize(LLParser.string("<=").map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.LESS_OR_EQUAL;
        }
    }));
    private static final Parser NOT_EQUAL_SIGN_LITERAL = ConditionParser.tokenize(LLParser.alternative(LLParser.string("<>"), LLParser.string("!=")).map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.NOT_EQUAL;
        }
    }));
    private static final Parser LESS_SIGN_LITERAL = ConditionParser.tokenize(LLParser.string("<").map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.LESS;
        }
    }));
    private static final Parser EQUAL_SIGN_LITERAL = ConditionParser.tokenize(LLParser.string("=").map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.EQUAL;
        }
    }));
    private static final Parser GREATER_OR_EQUAL_SIGN_LITERAL = ConditionParser.tokenize(LLParser.string(">=").map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.GREATER_OR_EQUAL;
        }
    }));
    private static final Parser GREATER_SIGN_LITERAL = ConditionParser.tokenize(LLParser.string(">").map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.GREATER;
        }
    }));
    private static final Parser IS_LITERAL = LLParser.regex("(?i)is").skip(LLParser.WHITESPACES).map(new Mapper<String, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(String value) {
            return ConditionFactory.CompareOp.IS;
        }
    });
    private static final Parser IS_NOT_LITERAL = LLParser.sequence(IS_LITERAL, LLParser.regex("(?i)not")).skip(LLParser.WHITESPACES).map(new Mapper<List<Object>, ConditionFactory.CompareOp>(){

        @Override
        public ConditionFactory.CompareOp map(List<Object> value) {
            return ConditionFactory.CompareOp.IS_NOT;
        }
    });
    private static final Parser COMPARISON_SIGN_LITERAL = LLParser.alternative(LESS_OR_EQUAL_SIGN_LITERAL, NOT_EQUAL_SIGN_LITERAL, LESS_SIGN_LITERAL, EQUAL_SIGN_LITERAL, GREATER_OR_EQUAL_SIGN_LITERAL, GREATER_SIGN_LITERAL, IS_NOT_LITERAL, IS_LITERAL);
    private static final Parser COLUMN_NAME_LITERAL = ConditionParser.tokenize(LLParser.regex("[\\w:-]+")).map(new Mapper<String, ColumnKey>(){

        @Override
        public ColumnKey map(String value) {
            int index = value.indexOf(":");
            if (index <= 0) {
                return new ColumnKey(value);
            }
            String family = value.substring(0, index);
            String qualifier = value.substring(index + 1);
            return new ColumnKey(family, qualifier);
        }
    });
    private static final Parser NULL_LITERAL = LLParser.regex("(?i)null").map(new Mapper<String, byte[]>(){

        @Override
        public byte[] map(String value) {
            return null;
        }
    });
    private static final Parser VALUE_LITERAL = LLParser.alternative(NUMERIC_LITERAL, STRING_LITERAL, HEX_STRING_LITERAL, NULL_LITERAL, BOOLEAN_LITERAL);
    private static final Parser COMPARISON_EXPRESSION_LITERAL = LLParser.sequence(COLUMN_NAME_LITERAL, COMPARISON_SIGN_LITERAL, VALUE_LITERAL).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            try {
                ColumnKey columnKey = (ColumnKey)values.get(0);
                return ConditionFactory.compare(columnKey.getFamily(), columnKey.getQualifier(), (ConditionFactory.CompareOp)((Object)values.get(1)), values.get(2));
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final Parser IN_LITERAL = LLParser.regex("(?i)in").skip(LLParser.WHITESPACES).map(new Mapper<String, String>(){

        @Override
        public String map(String value) {
            return ConditionParser.IN;
        }
    });
    private static final Parser NOT_IN_LITERAL = LLParser.regex("(?i)not").skip(LLParser.WHITESPACES).then(IN_LITERAL).map(new Mapper<String, String>(){

        @Override
        public String map(String values) {
            return ConditionParser.NOT_IN;
        }
    });
    private static final Parser IN_EXPRESSION_LITERAL = LLParser.sequence(COLUMN_NAME_LITERAL, IN_LITERAL.then(VALUE_LIST_LITERAL)).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            try {
                ColumnKey columnKey = (ColumnKey)values.get(0);
                return ConditionFactory.in(columnKey.getFamily(), columnKey.getQualifier(), (List)values.get(1));
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final Parser NOT_IN_EXPRESSION_LITERAL = LLParser.sequence(COLUMN_NAME_LITERAL, NOT_IN_LITERAL.then(VALUE_LIST_LITERAL)).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            try {
                ColumnKey columnKey = (ColumnKey)values.get(0);
                return ConditionFactory.notIn(columnKey.getFamily(), columnKey.getQualifier(), (List)values.get(1));
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final Parser LIKE_LITERAL = LLParser.regex("(?i)like").skip(LLParser.WHITESPACES).map(new Mapper<String, String>(){

        @Override
        public String map(String value) {
            return ConditionParser.LIKE;
        }
    });
    private static final Parser NOT_LIKE_LITERAL = LLParser.regex("(?i)not").skip(LLParser.WHITESPACES).then(LIKE_LITERAL).map(new Mapper<String, String>(){

        @Override
        public String map(String value) {
            return ConditionParser.NOT_LIKE;
        }
    });
    private static final Parser ESCAPE_CHARACTER_LITERAL = LLParser.regex("(?i)escape").skip(LLParser.WHITESPACES).then(STRING_LITERAL).map(new Mapper<String, Character>(){

        @Override
        public Character map(String value) {
            if (value.length() != 1) {
                throw new IllegalArgumentException("Invalid escape character: " + value);
            }
            return Character.valueOf(value.charAt(0));
        }
    });
    private static final Parser LIKE_EXPRESSION_LITERAL = LLParser.sequence(COLUMN_NAME_LITERAL, LIKE_LITERAL.then(STRING_LITERAL), LLParser.WHITESPACES.then(ESCAPE_CHARACTER_LITERAL).atMost(1)).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            try {
                ColumnKey columnKey = (ColumnKey)values.get(0);
                if (((List)values.get(2)).isEmpty()) {
                    return ConditionFactory.like(columnKey.getFamily(), columnKey.getQualifier(), (String)values.get(1));
                }
                return ConditionFactory.like(columnKey.getFamily(), columnKey.getQualifier(), (String)values.get(1), (Character)((List)values.get(2)).get(0));
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final Parser NOT_LIKE_EXPRESSION_LITERAL = LLParser.sequence(COLUMN_NAME_LITERAL, NOT_LIKE_LITERAL.then(STRING_LITERAL), LLParser.WHITESPACES.then(ESCAPE_CHARACTER_LITERAL).atMost(1)).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            try {
                ColumnKey columnKey = (ColumnKey)values.get(0);
                if (((List)values.get(2)).isEmpty()) {
                    return ConditionFactory.notLike(columnKey.getFamily(), columnKey.getQualifier(), (String)values.get(1));
                }
                return ConditionFactory.notLike(columnKey.getFamily(), columnKey.getQualifier(), (String)values.get(1), (Character)((List)values.get(2)).get(0));
            }
            catch (LindormException e) {
                throw new IllegalArgumentException(e);
            }
        }
    });
    private static final Parser AND_LITERAL = LLParser.regex("(?i)and").skip(LLParser.WHITESPACES).map(new Mapper<String, String>(){

        @Override
        public String map(String value) {
            return ConditionParser.AND;
        }
    });
    private static final Parser OR_LITERAL = LLParser.regex("(?i)or").skip(LLParser.WHITESPACES).map(new Mapper<String, String>(){

        @Override
        public String map(String value) {
            return ConditionParser.OR;
        }
    });
    private static final Parser LOGIC_OPERATOR_LITERAL = LLParser.alternative(AND_LITERAL, OR_LITERAL);
    private static final Parser CONDITION_LITERAL = LLParser.alternative(COMPARISON_EXPRESSION_LITERAL, IN_EXPRESSION_LITERAL, NOT_IN_EXPRESSION_LITERAL, LIKE_EXPRESSION_LITERAL, NOT_LIKE_EXPRESSION_LITERAL);
    private static final Parser GENERAL_EXPRESSION_LITERAL = new LLParser(new Function(){

        public ParseResult apply(String input, int index) {
            return LLParser.sequence(LOGIC_EXPRESSION_LITERAL, LLParser.sequence(LLParser.WHITESPACES.then(LOGIC_OPERATOR_LITERAL), LOGIC_EXPRESSION_LITERAL).atLeast(0)).map(new Mapper<List<Object>, List<Object>>(){

                @Override
                public List<Object> map(List<Object> values) {
                    ArrayList<Object> collected = new ArrayList<Object>();
                    collected.add(values.get(0));
                    for (List value : (List)values.get(1)) {
                        collected.addAll(value);
                    }
                    return collected;
                }
            }).parse(input, index);
        }
    }).map(new Mapper<List<Object>, Condition>(){

        @Override
        public Condition map(List<Object> values) {
            return ConditionParser.evaluate(values);
        }
    });
    private static final Parser LOGIC_EXPRESSION_LITERAL = CONDITION_LITERAL.or(LEFT_PARENTHESIS.skip(LLParser.OPTIONAL_WHITESPACES).then(GENERAL_EXPRESSION_LITERAL).skip(LLParser.OPTIONAL_WHITESPACES).skip(RIGHT_PARENTHESIS));
    private static Parser PARSER = LLParser.lazy(LLParser.OPTIONAL_WHITESPACES.then(GENERAL_EXPRESSION_LITERAL).skip(LLParser.OPTIONAL_WHITESPACES));

    private static Condition evaluate(List<Object> values) {
        LinkedList<String> operatorStack = new LinkedList<String>();
        LinkedList<Condition> conditionStack = new LinkedList<Condition>();
        conditionStack.push((Condition)values.get(0));
        try {
            for (int i = 1; i < values.size(); i += 2) {
                String op = (String)values.get(i);
                Condition condition = (Condition)values.get(i + 1);
                if (operatorStack.isEmpty() || !ConditionParser.doesPrecedeTheLast(op, (String)operatorStack.peek())) {
                    operatorStack.push(op);
                    conditionStack.push(condition);
                    continue;
                }
                Condition newCondition = ConditionParser.createConditionByOP(op);
                ((ConditionList)newCondition).add((Condition)conditionStack.pop());
                ((ConditionList)newCondition).add(condition);
                conditionStack.push(newCondition);
            }
            Condition result = (Condition)conditionStack.pollLast();
            while (!conditionStack.isEmpty()) {
                Condition hold = ConditionParser.createConditionByOP((String)operatorStack.pollLast());
                ((ConditionList)hold).add(result);
                ((ConditionList)hold).add((Condition)conditionStack.pollLast());
                result = hold;
            }
            return result;
        }
        catch (IllegalRequestException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean doesPrecedeTheLast(String op, String lastOP) {
        return op.equals(AND) && lastOP.equals(OR);
    }

    private static Condition createConditionByOP(String op) {
        if (op.equals(AND)) {
            return ConditionFactory.and();
        }
        if (op.equals(OR)) {
            return ConditionFactory.or();
        }
        throw new IllegalArgumentException("Invalid op: " + op);
    }

    private static Parser tokenize(Parser parser) {
        return parser.skip(LLParser.OPTIONAL_WHITESPACES);
    }

    public Condition parse(String text) {
        ParseResult result = PARSER.parse(text);
        if (result.status == Status.SUCCESS) {
            return (Condition)result.value;
        }
        int index = result.index;
        int left = index - 3;
        int right = index + 6;
        String content = (left > 0 ? "(... " : "( ") + text.substring(Math.max(0, left), Math.min(right, text.length())) + (right < text.length() - 1 ? " ...)" : " )");
        throw new IllegalArgumentException("Failed to parse the condition. columns: " + result.index + ", expected: " + result.expected + ", content: " + content + "");
    }
}

