/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.LongMath;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.ListType;
import com.alibaba.lindorm.client.schema.MapType;
import com.alibaba.lindorm.client.schema.SetType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataTypeUtils {
    public static final byte TRUE_BYTE = 1;
    public static final byte FALSE_BYTE = 0;
    public static final byte[] TRUE_BYTES = new byte[]{1};
    public static final byte[] FALSE_BYTES = new byte[]{0};
    public static final int MAX_BYTES_TO_PRINT = 1024;
    public static final String MAX_LENGTH_ATTR = "MAX_LENGTH";
    public static final String SCALE_ATTR = "SCALE";
    public static final BigDecimal ZERO_DECIMAL = BigDecimal.valueOf(0L);
    public static final BigDecimal MIN_DOUBLE_AS_DECIMAL = BigDecimal.valueOf(-1.7976931348623157E308);
    public static final BigDecimal MAX_DOUBLE_AS_DECIMAL = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_FLOAT_AS_DECIMAL = BigDecimal.valueOf(-3.4028234663852886E38);
    public static final BigDecimal MAX_FLOAT_AS_DECIMAL = BigDecimal.valueOf(3.4028234663852886E38);
    public static final int DECIMAL_MIN_PRECISION = 1;
    public static final int DECIMAL_MAX_PRECISION = 38;
    public static final int DECIMAL_DEFAULT_SCALE = 0;
    public static final MathContext DEFAULT_MATH_CONTEXT = new MathContext(38, RoundingMode.HALF_UP);
    private static final int DECIMAL_V2_EXP_BYTE_OFFSET = 64;
    private static final int DECIMAL_V2_POS_DIGIT_OFFSET = 10;
    private static final byte DECIMAL_V2_POS_TERMINAL_BYTE = 1;
    private static final byte DECIMAL_V2_POS_TERMINAL_BYTE_IF_SCALE_ODD = 2;
    private static final int DECIMAL_V2_NEG_DIGIT_OFFSET = 100;
    private static final byte DECIMAL_V2_NEG_TERMINAL_BYTE = 101;
    private static final byte DECIMAL_V2_NEG_TERMINAL_BYTE_IF_SCALE_ODD = 102;
    private static final byte ZERO_BYTE = -128;
    private static final byte NEG_TERMINAL_BYTE = 102;
    private static final int MAX_DECIMAL_BYTES = 21;
    private static final int EXP_BYTE_OFFSET = 65;
    private static final int POS_DIGIT_OFFSET = 1;
    private static final int NEG_DIGIT_OFFSET = 101;
    private static final long MAX_LONG_FOR_DESERIALIZE = 9223372036854775L;
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger ONE_HUNDRED = BigInteger.valueOf(100L);
    public static final short EB_GROUP_LEN = 8;
    public static final byte EB_GROUP_SIGNAL = 9;
    public static final byte[] ZERO_BYTE_ARRAY = new byte[1];
    public static final byte[] ZERO_SHORT_ARRAY = new byte[2];
    public static final byte[] ZERO_INT_ARRAY = new byte[4];
    public static final byte[] ZERO_LONG_ARRAY = new byte[8];
    public static final byte[] ZERO_FLOAT_ARRAY = new byte[4];
    public static final byte[] ZERO_DOUBLE_ARRAY = new byte[8];
    public static final byte[] ZERO_TIMESTAMP_ARRAY = new byte[12];
    public static final byte[] ZERO_UUID_ARRAY = new byte[16];
    public static final byte[] ZERO_STRING_ARRAY = Bytes.toBytes("");

    public static byte invert(byte b) {
        return (byte)(b ^ 0xFF);
    }

    public static byte[] invert(byte[] src, int srcOffset, int length) {
        byte[] result = new byte[length];
        DataTypeUtils.invert(src, srcOffset, result, 0, length);
        return result;
    }

    public static void invert(byte[] src, int srcOffset, byte[] dest, int dstOffset, int length) {
        for (int i = 0; i < length; ++i) {
            dest[dstOffset + i] = (byte)(src[srcOffset + i] ^ 0xFF);
        }
    }

    public static void inPlaceByteReverse(byte[] src, int srcOffset, int length) {
        assert (src != null);
        assert (srcOffset + length <= src.length);
        int l = srcOffset;
        int r = srcOffset + length - 1;
        for (int step = 0; step < length / 2; ++step) {
            byte temp = src[l];
            src[l] = src[r];
            src[r] = temp;
            ++l;
            --r;
        }
    }

    public static int encodeByte(byte v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 1);
        out[offset] = sortOrder == SortOrder.ASC ? (byte)(v ^ 0x80) : (byte)(v ^ 0x80 ^ 0xFF);
        return 1;
    }

    public static byte decodeByte(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 1);
        int ret = sortOrder == SortOrder.ASC ? v[offset] ^ 0x80 : v[offset] ^ 0xFF ^ 0x80;
        return (byte)ret;
    }

    public static int encodeUnsignedByte(byte v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 1);
        out[offset] = sortOrder == SortOrder.ASC ? v : (byte)(v ^ 0xFF);
        return 1;
    }

    public static byte decodeUnsignedByte(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 1);
        int ret = sortOrder == SortOrder.ASC ? v[offset] : v[offset] ^ 0xFF;
        return (byte)ret;
    }

    public static int encodeShort(short v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 2);
        if (sortOrder == SortOrder.ASC) {
            out[offset + 0] = (byte)(v >> 8 ^ 0x80);
            out[offset + 1] = (byte)v;
        } else {
            out[offset + 0] = (byte)(v >> 8 ^ 0x80 ^ 0xFF);
            out[offset + 1] = (byte)(v ^ 0xFF);
        }
        return 2;
    }

    public static short decodeShort(byte[] v, int offset, SortOrder sortOrder) {
        int ret;
        if (sortOrder == SortOrder.ASC) {
            ret = v[offset] ^ 0x80;
            for (int i = 1; i < 2; ++i) {
                ret = (ret << 8) + (v[offset + i] & 0xFF);
            }
        } else {
            ret = v[offset] ^ 0xFF ^ 0x80;
            for (int i = 1; i < 2; ++i) {
                ret = (ret << 8) + ((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return (short)ret;
    }

    public static int encodeUnsignedShort(short v, byte[] out, int offset, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(out, offset, 2);
        if (v < 0) {
            throw new IllegalDataException("Cannot encode negative value to UNSIGNED_SHORT , value=" + v);
        }
        if (sortOrder == SortOrder.ASC) {
            out[offset + 0] = (byte)(v >> 8);
            out[offset + 1] = (byte)v;
        } else {
            out[offset + 0] = (byte)(v >> 8 ^ 0xFF);
            out[offset + 1] = (byte)(v ^ 0xFF);
        }
        return 2;
    }

    public static short decodeUnsignedShort(byte[] v, int offset, SortOrder sortOrder) {
        int ret = v[offset];
        if (sortOrder == SortOrder.ASC) {
            for (int i = 0; i < 2; ++i) {
                ret = (ret << 8) + (v[offset + i] & 0xFF);
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                ret = (ret << 8) + ((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return (short)ret;
    }

    public static int encodeInt(int v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 4);
        if (sortOrder == SortOrder.ASC) {
            out[offset + 0] = (byte)(v >> 24 ^ 0x80);
            out[offset + 1] = (byte)(v >> 16);
            out[offset + 2] = (byte)(v >> 8);
            out[offset + 3] = (byte)v;
        } else {
            out[offset + 0] = (byte)(v >> 24 ^ 0x80 ^ 0xFF);
            out[offset + 1] = (byte)(v >> 16 ^ 0xFF);
            out[offset + 2] = (byte)(v >> 8 ^ 0xFF);
            out[offset + 3] = (byte)(v ^ 0xFF);
        }
        return 4;
    }

    public static int decodeInt(byte[] v, int offset, SortOrder sortOrder) {
        int ret;
        DataTypeUtils.checkForSufficientLength(v, offset, 4);
        if (sortOrder == SortOrder.ASC) {
            ret = v[offset] ^ 0x80;
            for (int i = 1; i < 4; ++i) {
                ret = (ret << 8) + (v[offset + i] & 0xFF);
            }
        } else {
            ret = v[offset] ^ 0xFF ^ 0x80;
            for (int i = 1; i < 4; ++i) {
                ret = (ret << 8) + ((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return ret;
    }

    public static int encodeUnsignedInt(int v, byte[] out, int offset, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(out, offset, 4);
        if (v < 0) {
            throw new IllegalDataException("Cannot encode negative value to UNSIGNED_INTEGER , value=" + v);
        }
        if (sortOrder == SortOrder.ASC) {
            out[offset + 0] = (byte)(v >> 24);
            out[offset + 1] = (byte)(v >> 16);
            out[offset + 2] = (byte)(v >> 8);
            out[offset + 3] = (byte)v;
        } else {
            out[offset + 0] = (byte)(v >> 24 ^ 0xFF);
            out[offset + 1] = (byte)(v >> 16 ^ 0xFF);
            out[offset + 2] = (byte)(v >> 8 ^ 0xFF);
            out[offset + 3] = (byte)(v ^ 0xFF);
        }
        return 4;
    }

    public static int decodeUnsignedInt(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 4);
        int ret = v[offset];
        if (sortOrder == SortOrder.ASC) {
            for (int i = 0; i < 4; ++i) {
                ret = (ret << 8) + (v[offset + i] & 0xFF);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                ret = (ret << 8) + ((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return ret;
    }

    public static int encodeLong(long v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 8);
        if (sortOrder == SortOrder.ASC) {
            for (int i = offset + 7; i > offset; --i) {
                out[i] = (byte)v;
                v >>>= 8;
            }
            out[offset] = (byte)(v ^ 0x80L);
        } else {
            for (int i = offset + 7; i > offset; --i) {
                out[i] = (byte)(v ^ 0xFFL);
                v >>>= 8;
            }
            out[offset] = (byte)(v ^ 0x80L ^ 0xFFL);
        }
        return 8;
    }

    public static long decodeLong(byte[] v, int offset, SortOrder sortOrder) {
        long ret;
        DataTypeUtils.checkForSufficientLength(v, offset, 8);
        if (sortOrder == SortOrder.ASC) {
            ret = v[offset] ^ 0x80;
            for (int i = 1; i < 8; ++i) {
                ret = (ret << 8) + (long)(v[offset + i] & 0xFF);
            }
        } else {
            ret = v[offset] ^ 0xFF ^ 0x80;
            for (int i = 1; i < 8; ++i) {
                ret = (ret << 8) + (long)((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return ret;
    }

    public static int encodeUnsignedLong(long v, byte[] out, int offset, SortOrder sortOrder) throws IllegalDataException {
        return DataTypeUtils.encodeUnsignedLong(v, out, offset, sortOrder, true);
    }

    public static int encodeUnsignedLong(long v, byte[] out, int offset, SortOrder sortOrder, boolean checkNegative) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(out, offset, 8);
        if (checkNegative && v < 0L) {
            throw new IllegalDataException("Cannot encode negative value to UNSIGNED_LONG , value=" + v);
        }
        if (sortOrder == SortOrder.ASC) {
            for (int i = offset + 7; i >= offset; --i) {
                out[i] = (byte)v;
                v >>>= 8;
            }
        } else {
            for (int i = offset + 7; i >= offset; --i) {
                out[i] = (byte)(v ^ 0xFFL);
                v >>>= 8;
            }
        }
        return 8;
    }

    public static long decodeUnsignedLong(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 8);
        long ret = 0L;
        if (sortOrder == SortOrder.ASC) {
            for (int i = 0; i < 8; ++i) {
                ret = (ret << 8) + (long)(v[offset + i] & 0xFF);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                ret = (ret << 8) + (long)((v[offset + i] ^ 0xFF) & 0xFF);
            }
        }
        return ret;
    }

    public static int encodeFloat(float v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 4);
        int i = Float.floatToIntBits(v);
        i = (i ^ (i >> 31 | Integer.MIN_VALUE)) + 1;
        Bytes.putInt(out, offset, i);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(out, offset, out, offset, 4);
        }
        return 4;
    }

    public static float decodeFloat(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 4);
        int tmp = 0;
        if (sortOrder == SortOrder.DESC) {
            for (int i = offset; i < offset + 4; ++i) {
                tmp <<= 8;
                tmp ^= (v[i] ^ 0xFF) & 0xFF;
            }
        } else {
            tmp = Bytes.toInt(v, offset);
        }
        --tmp;
        tmp ^= ~tmp >> 31 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(tmp);
    }

    public static int encodeUnsignedFloat(float v, byte[] out, int offset, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(out, offset, 4);
        if (v < 0.0f) {
            throw new IllegalDataException("Cannot encode negative value to UNSIGNED_FLOAT , value=" + v);
        }
        int i = Float.floatToIntBits(v);
        Bytes.putInt(out, offset, i);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(out, offset, out, offset, 4);
        }
        return 4;
    }

    public static float decodeUnsignedFloat(byte[] v, int offset, SortOrder sortOrder) throws IllegalDataException {
        float value;
        DataTypeUtils.checkForSufficientLength(v, offset, 4);
        if (sortOrder == SortOrder.DESC) {
            byte[] tmp = new byte[4];
            DataTypeUtils.invert(v, offset, tmp, 0, 4);
            value = Bytes.toFloat(tmp);
        } else {
            value = Bytes.toFloat(v, offset);
        }
        if (value < 0.0f) {
            throw new IllegalDataException("Illegal data , Cannot decode negative value for UNSIGNED_FLOAT type, actual value=" + value);
        }
        return value;
    }

    public static int encodeDouble(double v, byte[] out, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(out, offset, 8);
        long tmp = Double.doubleToLongBits(v);
        tmp = (tmp ^ (tmp >> 63 | Long.MIN_VALUE)) + 1L;
        Bytes.putLong(out, offset, tmp);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(out, offset, out, offset, 8);
        }
        return 8;
    }

    public static double decodeDouble(byte[] v, int offset, SortOrder sortOrder) {
        DataTypeUtils.checkForSufficientLength(v, offset, 8);
        long tmp = 0L;
        if (sortOrder == SortOrder.DESC) {
            for (int i = offset; i < offset + 8; ++i) {
                tmp <<= 8;
                tmp ^= (long)((v[i] ^ 0xFF) & 0xFF);
            }
        } else {
            tmp = Bytes.toLong(v, offset);
        }
        --tmp;
        tmp ^= (tmp ^ 0xFFFFFFFFFFFFFFFFL) >> 63 | Long.MIN_VALUE;
        return Double.longBitsToDouble(tmp);
    }

    public static int encodeUnsignedDouble(double v, byte[] out, int offset, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(out, offset, 8);
        if (v < 0.0) {
            throw new IllegalDataException("Cannot encode negative value to UNSIGNED_DOUBLE , value=" + v);
        }
        long tmp = Double.doubleToLongBits(v);
        Bytes.putLong(out, offset, tmp);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(out, offset, out, offset, 8);
        }
        return 8;
    }

    public static double decodeUnsignedDouble(byte[] v, int offset, SortOrder sortOrder) throws IllegalDataException {
        double value;
        DataTypeUtils.checkForSufficientLength(v, offset, 8);
        if (sortOrder == SortOrder.DESC) {
            byte[] tmp = new byte[8];
            DataTypeUtils.invert(v, offset, tmp, 0, 8);
            value = Bytes.toDouble(tmp);
        } else {
            value = Bytes.toDouble(v, offset);
        }
        if (value < 0.0) {
            throw new IllegalDataException("Illegal data , Cannot decode negative value for UNSIGNED_DOUBLE type, actual value=" + value);
        }
        return value;
    }

    public static int getDecimalByteSize(BigDecimal bd) {
        return DataTypeUtils.getDecimalByteSize(bd, DataType.DECIMAL);
    }

    public static int getDecimalByteSize(BigDecimal bd, DataType dataType) {
        assert (bd != null);
        int signum = bd.signum();
        if (signum == 0) {
            return 1;
        }
        if (dataType == DataType.DECIMAL_V2) {
            return 2 + (bd.precision() + (bd.scale() % 2 == 0 ? 0 : 1) + 1) / 2;
        }
        return (signum < 0 ? 2 : 1) + (bd.precision() + 1 + (bd.scale() % 2 == 0 ? 0 : 1)) / 2;
    }

    public static byte[] encodeDecimal(BigDecimal v, SortOrder sortOrder) {
        return DataTypeUtils.encodeDecimal(v, sortOrder, DataType.DECIMAL);
    }

    public static byte[] encodeDecimal(BigDecimal v, SortOrder sortOrder, DataType dataType) {
        BigDecimal bd = dataType == DataType.DECIMAL_V2 ? v : DataTypeUtils.normalize(v);
        int len = DataTypeUtils.getDecimalByteSize(bd, dataType);
        byte[] ret = new byte[len];
        int actualLen = dataType == DataType.DECIMAL_V2 ? DataTypeUtils.decimalV2ToBytes(bd, ret, 0, len) : DataTypeUtils.decimalToBytes(bd, ret, 0, len);
        if (actualLen != len) {
            byte[] tmp = new byte[actualLen];
            System.arraycopy(ret, 0, tmp, 0, actualLen);
            ret = tmp;
        }
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(ret, 0, ret, 0, ret.length);
        }
        return ret;
    }

    public static BigDecimal decodeDecimal(byte[] v, int offset, int length, SortOrder sortOrder) {
        return DataTypeUtils.decodeDecimal(v, offset, length, sortOrder, DataType.DECIMAL);
    }

    public static BigDecimal decodeDecimal(byte[] v, int offset, int length, SortOrder sortOrder, DataType dataType) {
        if (sortOrder == SortOrder.DESC) {
            byte[] copy = new byte[length];
            DataTypeUtils.invert(v, offset, copy, 0, length);
            offset = 0;
            v = copy;
        }
        if (dataType == DataType.DECIMAL_V2) {
            return DataTypeUtils.decimalV2FromBytes(v, offset, length);
        }
        return DataTypeUtils.decimalFromBytes(v, offset, length);
    }

    private static int decimalV2ToBytes(BigDecimal v, byte[] result, int offset, int length) {
        long divBy;
        BigInteger compareAgainst;
        int digitOffset;
        BigInteger divideBy;
        int multiplyBy;
        int scale;
        int signum = v.signum();
        if (signum == 0) {
            result[offset] = -128;
            return 1;
        }
        int index = offset + length;
        int expOffset = scale % 2 * ((scale = v.scale()) < 0 ? -1 : 1);
        if (expOffset == 0) {
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        } else {
            multiplyBy = 10;
            divideBy = BigInteger.TEN;
        }
        if (signum == 1) {
            digitOffset = 10;
            compareAgainst = MAX_LONG;
            result[--index] = scale % 2 == 0 ? 1 : 2;
            result[offset] = (byte)(-((scale -= (length - 1 - 1 - 1) * 2) + expOffset) / 2 + 64 | 0x80);
        } else {
            digitOffset = 100;
            compareAgainst = MIN_LONG;
            result[--index] = scale % 2 == 0 ? 101 : 102;
            result[offset] = (byte)(~(-((scale -= (length - 1 - 1 - 1) * 2) + expOffset) / 2 + 64 + 128) & 0x7F);
        }
        BigInteger bi = v.unscaledValue();
        while (bi.compareTo(compareAgainst) * signum > 0) {
            BigInteger[] dandr = bi.divideAndRemainder(divideBy);
            bi = dandr[0];
            int digit = dandr[1].intValue();
            result[--index] = (byte)(digit * multiplyBy + digitOffset);
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        }
        long l = bi.longValue();
        do {
            divBy = 100 / multiplyBy;
            long digit = l % divBy;
            result[--index] = (byte)(digit * (long)multiplyBy + (long)digitOffset);
            multiplyBy = 1;
        } while ((l /= divBy) != 0L);
        return length;
    }

    private static int decimalToBytes(BigDecimal v, byte[] result, int offset, int length) {
        long divBy;
        BigInteger compareAgainst;
        int digitOffset;
        BigInteger divideBy;
        int multiplyBy;
        int scale;
        int signum = v.signum();
        if (signum == 0) {
            result[offset] = -128;
            return 1;
        }
        int index = offset + length;
        int expOffset = scale % 2 * ((scale = v.scale()) < 0 ? -1 : 1);
        if (expOffset == 0) {
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        } else {
            multiplyBy = 10;
            divideBy = BigInteger.TEN;
        }
        if (signum == 1) {
            digitOffset = 1;
            compareAgainst = MAX_LONG;
            result[offset] = (byte)(-((scale -= (length - 2) * 2) + expOffset) / 2 + 65 | 0x80);
        } else {
            digitOffset = 101;
            compareAgainst = MIN_LONG;
            result[offset] = (byte)(~(-((scale -= (length - 2 - 1) * 2) + expOffset) / 2 + 65 + 128) & 0x7F);
            if (length <= 21) {
                result[--index] = 102;
            } else {
                length = 21;
                index = offset + length;
            }
        }
        BigInteger bi = v.unscaledValue();
        while (bi.compareTo(compareAgainst) * signum > 0) {
            BigInteger[] dandr = bi.divideAndRemainder(divideBy);
            bi = dandr[0];
            int digit = dandr[1].intValue();
            result[--index] = (byte)(digit * multiplyBy + digitOffset);
            multiplyBy = 1;
            divideBy = ONE_HUNDRED;
        }
        long l = bi.longValue();
        do {
            divBy = 100 / multiplyBy;
            long digit = l % divBy;
            result[--index] = (byte)(digit * (long)multiplyBy + (long)digitOffset);
            multiplyBy = 1;
        } while ((l /= divBy) != 0L);
        return length;
    }

    private static BigDecimal decimalV2FromBytes(byte[] bytes, int offset, int length) {
        BigInteger bi;
        int digitOffset;
        byte terminal;
        int index;
        int scale;
        if (length == 1 && bytes[offset] == -128) {
            return BigDecimal.ZERO;
        }
        int signum = (bytes[offset] & 0x80) == 0 ? -1 : 1;
        long multiplier = 100L;
        int begIndex = offset + 1;
        if (signum == 1) {
            scale = ((bytes[offset] & 0x7F) - 64) * -2;
            index = offset + length - 1;
            terminal = bytes[index];
            digitOffset = 10;
        } else {
            scale = (byte)((~bytes[offset] - 64 - 128) * -2);
            index = offset + length - 1;
            terminal = bytes[index];
            digitOffset = -100;
        }
        length = index - offset;
        long l = signum * bytes[--index] - digitOffset;
        if (l % 10L == 0L && (terminal == 102 || terminal == 2)) {
            --scale;
            l /= 10L;
            multiplier = 10L;
        }
        while (index > begIndex) {
            if (l >= 9223372036854775L || multiplier >= 92233720368547758L) {
                multiplier = LongMath.divide(multiplier, 100L, RoundingMode.UNNECESSARY);
                break;
            }
            int digit100 = signum * bytes[--index] - digitOffset;
            l += (long)digit100 * multiplier;
            multiplier = LongMath.checkedMultiply(multiplier, 100L);
        }
        if (index > begIndex) {
            bi = BigInteger.valueOf(l);
            BigInteger biMultiplier = BigInteger.valueOf(multiplier).multiply(ONE_HUNDRED);
            do {
                int digit100 = signum * bytes[--index] - digitOffset;
                bi = bi.add(biMultiplier.multiply(BigInteger.valueOf(digit100)));
                biMultiplier = biMultiplier.multiply(ONE_HUNDRED);
            } while (index > begIndex);
            if (signum == -1) {
                bi = bi.negate();
            }
        } else {
            bi = BigInteger.valueOf(l * (long)signum);
        }
        BigDecimal v = new BigDecimal(bi, scale += (length - 2) * 2);
        return v;
    }

    private static BigDecimal decimalFromBytes(byte[] bytes, int offset, int length) {
        BigInteger bi;
        int digitOffset;
        int index;
        int scale;
        if (length == 1 && bytes[offset] == -128) {
            return BigDecimal.ZERO;
        }
        int signum = (bytes[offset] & 0x80) == 0 ? -1 : 1;
        long multiplier = 100L;
        int begIndex = offset + 1;
        if (signum == 1) {
            scale = ((bytes[offset] & 0x7F) - 65) * -2;
            index = offset + length;
            digitOffset = 1;
        } else {
            scale = (byte)((~bytes[offset] - 65 - 128) * -2);
            index = offset + length - (bytes[offset + length - 1] == 102 ? 1 : 0);
            digitOffset = -101;
        }
        length = index - offset;
        long l = signum * bytes[--index] - digitOffset;
        if (l % 10L == 0L) {
            --scale;
            l /= 10L;
            multiplier = 10L;
        }
        while (index > begIndex) {
            if (l >= 9223372036854775L || multiplier >= 92233720368547758L) {
                multiplier = LongMath.divide(multiplier, 100L, RoundingMode.UNNECESSARY);
                break;
            }
            int digit100 = signum * bytes[--index] - digitOffset;
            l += (long)digit100 * multiplier;
            multiplier = LongMath.checkedMultiply(multiplier, 100L);
        }
        if (index > begIndex) {
            bi = BigInteger.valueOf(l);
            BigInteger biMultiplier = BigInteger.valueOf(multiplier).multiply(ONE_HUNDRED);
            do {
                int digit100 = signum * bytes[--index] - digitOffset;
                bi = bi.add(biMultiplier.multiply(BigInteger.valueOf(digit100)));
                biMultiplier = biMultiplier.multiply(ONE_HUNDRED);
            } while (index > begIndex);
            if (signum == -1) {
                bi = bi.negate();
            }
        } else {
            bi = BigInteger.valueOf(l * (long)signum);
        }
        BigDecimal v = new BigDecimal(bi, scale += (length - 2) * 2);
        return v;
    }

    public static void checkForSufficientLength(byte[] b, int offset, int requiredLength) {
        if (b.length < offset + requiredLength) {
            throw new RuntimeException("Not enough bytes, required:" + requiredLength + ", had: " + (b.length - offset));
        }
    }

    public static void checkForSufficientLength(int actualLength, int requiredLength, DataType type) throws IllegalDataException {
        if (actualLength < requiredLength) {
            throw new IllegalDataException("Not enough bytes to parse " + (Object)((Object)type) + " value, required length=" + requiredLength + ", actual length=" + actualLength);
        }
    }

    public static boolean equalsAny(LDataType lhs, LDataType ... rhs) {
        for (int i = 0; i < rhs.length; ++i) {
            if (!lhs.equals(rhs[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean needLength(DataType type) {
        return type == DataType.BINARY || type == DataType.CHAR || type == DataType.DECIMAL;
    }

    public static boolean needPadding(DataType type) {
        return type == DataType.BINARY || type == DataType.CHAR;
    }

    public static boolean isDirectBytesType(DataType type) {
        return type == DataType.BINARY || type == DataType.VARBINARY;
    }

    public static boolean isBytesType(DataType type) {
        return type == DataType.BINARY || type == DataType.VARBINARY || type == DataType.ENCODED_VARBINARY;
    }

    public static boolean isUnsignedType(DataType type) {
        return type.name().startsWith("UNSIGNED_");
    }

    public static String lengthToString(Integer maxLength, Integer scale) {
        if (maxLength != null) {
            StringBuilder str = new StringBuilder();
            str.append("(");
            str.append(maxLength);
            if (scale != null) {
                str.append(",");
                str.append(scale);
            }
            str.append(")");
            return str.toString();
        }
        return "";
    }

    public static void validateLength(int length) throws IllegalArgumentException {
        if (length <= 0) {
            throw new IllegalArgumentException("Data type length must be greater than zero, but has " + length);
        }
    }

    public static void validatePrecisionAndScale(int precision, int scale) throws IllegalArgumentException {
        if (precision < 1 || precision > 38) {
            throw new IllegalArgumentException("Illegal precision for DECIMAL, must be within [1, 38], but has " + precision);
        }
        if (scale < 0 || scale > precision) {
            throw new IllegalArgumentException("Illegal scale for DECIMAL, must be within [0, precision], but has " + scale);
        }
    }

    public static BigDecimal normalize(BigDecimal bigDecimal) {
        return bigDecimal.round(DEFAULT_MATH_CONTEXT).stripTrailingZeros();
    }

    public static Object roundForDecimalIfNecessary(Object value, LDataType actualType, LColumn meta) throws IllegalDataException {
        if (actualType.getClientType() == DataType.DECIMAL && meta.getDataType().getClientType() == DataType.DECIMAL) {
            return DataTypeUtils.setDecimalWidthAndScale((BigDecimal)value, meta.getPrecision(), meta.getScale());
        }
        return value;
    }

    public static BigDecimal setDecimalWidthAndScale(BigDecimal decimal, int precision, Integer scaleOrNull) throws IllegalDataException {
        int scale;
        int n = scale = scaleOrNull == null ? 0 : scaleOrNull;
        if (precision - scale < decimal.precision() - decimal.scale()) {
            throw new IllegalDataException("Illegal decimal value " + decimal + " " + DataTypeUtils.lengthToString(decimal.precision(), decimal.scale()) + ", but schema is " + DataTypeUtils.lengthToString(precision, scale));
        }
        if (scaleOrNull != null) {
            decimal = decimal.setScale(scale, 1);
        }
        return decimal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String valueToString(CollectionDataType type, Object value) {
        if (value == null) return "null";
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            ArrayList<String> elementStrList = new ArrayList<String>();
            for (Object obj : (Set)value) {
                if (setType.getDataType() == null) {
                    elementStrList.add(DataTypeUtils.valueToString(setType.getCollectionDataType(), obj));
                    continue;
                }
                elementStrList.add(DataTypeUtils.valueToString(setType.getDataType(), obj));
            }
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append(StringUtils.join(",", elementStrList));
            builder.append("}");
            return builder.toString();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            ArrayList<String> elementStrList = new ArrayList<String>();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                String keyStr = mapType.getKeyDataType() == null ? DataTypeUtils.valueToString(mapType.getKeyCollectionDataType(), entry.getKey()) : DataTypeUtils.valueToString(mapType.getKeyDataType(), entry.getKey());
                String valueStr = mapType.getValueDataType() == null ? DataTypeUtils.valueToString(mapType.getValueCollectionDataType(), entry.getValue()) : DataTypeUtils.valueToString(mapType.getValueDataType(), entry.getValue());
                elementStrList.add(keyStr + ":" + valueStr);
            }
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append(StringUtils.join(",", elementStrList));
            builder.append("}");
            return builder.toString();
        }
        if (!(type instanceof ListType)) throw new RuntimeException("unknown collection data type: " + type);
        ListType listType = (ListType)type;
        ArrayList<String> elementStrList = new ArrayList<String>();
        for (Object obj : (List)value) {
            if (listType.getDataType() == null) {
                elementStrList.add(DataTypeUtils.valueToString(listType.getCollectionDataType(), obj));
                continue;
            }
            elementStrList.add(DataTypeUtils.valueToString(listType.getDataType(), obj));
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(StringUtils.join(",", elementStrList));
        builder.append("]");
        return builder.toString();
    }

    public static String valueToString(DataType type, Object value) {
        String printableValue;
        block7: {
            block6: {
                if (value == null) break block6;
                switch (type) {
                    case VARBINARY: 
                    case BINARY: 
                    case ENCODED_VARBINARY: {
                        byte[] bytes = (byte[])value;
                        if (bytes.length > 1024) {
                            printableValue = Bytes.toStringBinary((byte[])value, 0, 1024);
                            printableValue = printableValue + " ...<" + (bytes.length - 1024) + " bytes more>";
                            break;
                        }
                        printableValue = Bytes.toStringBinary((byte[])value);
                        break;
                    }
                    case STRING: {
                        printableValue = (String)value;
                        if (printableValue.length() > 1024) {
                            printableValue = printableValue.substring(0, 1024);
                            printableValue = printableValue + "...<" + (((String)value).length() - 1024) + " chars more>";
                            break;
                        }
                        break block7;
                    }
                    default: {
                        printableValue = value.toString();
                        break;
                    }
                }
                break block7;
            }
            printableValue = "null";
        }
        return printableValue;
    }

    public static int compareValueBytes(byte[] lhs, int lhsOffset, int lhsLength, byte[] rhs, int rhsOffset, int rhsLength, SortOrder sortOrder) {
        int ret = Bytes.compareTo(lhs, lhsOffset, lhsLength, rhs, rhsOffset, rhsLength);
        if (sortOrder == SortOrder.ASC) {
            return ret;
        }
        return ret * -1;
    }

    public static byte[] encodeEVarbinary(byte[] src, int offset, int length, SortOrder sortOrder) {
        byte[] v = DataTypeUtils.encodeEVarbinaryToBytes(src, offset, length);
        if (sortOrder == SortOrder.DESC) {
            DataTypeUtils.invert(v, 0, v, 0, v.length);
        }
        return v;
    }

    public static byte[] decodeEVarbinary(byte[] value, int offset, int length, SortOrder sortOrder) {
        if (sortOrder == SortOrder.DESC) {
            byte[] copy = new byte[length];
            DataTypeUtils.invert(value, offset, copy, 0, length);
            return DataTypeUtils.decodeEVarbinaryFromBytes(copy, 0, length);
        }
        return DataTypeUtils.decodeEVarbinaryFromBytes(value, offset, length);
    }

    public static int getEVarbinaryLen(byte[] v, int offset, int len) {
        if (len <= 8) {
            throw new IllegalArgumentException("length " + len + " must be greater than " + 8);
        }
        byte mark = v[offset + 8];
        if (mark != 9 && mark != -10) {
            return 9;
        }
        int group = 1;
        while (v[offset + (9 * group - 1)] == mark) {
            ++group;
        }
        return 9 * group;
    }

    private static byte[] encodeEVarbinaryToBytes(byte[] v, int offset, int len) {
        int retLen = 0;
        int retOffset = 0;
        int group = len / 8;
        retLen = len % 8 == 0 ? group * 9 : (group + 1) * 9;
        byte[] ret = new byte[retLen];
        while (group > 0) {
            --group;
            System.arraycopy(v, offset, ret, retOffset, 8);
            offset += 8;
            retOffset += 8;
            if ((len -= 8) == 0) {
                ret[retOffset++] = 8;
                continue;
            }
            ret[retOffset++] = 9;
        }
        if (len != 0) {
            System.arraycopy(v, offset, ret, retOffset, len);
            ret[retOffset + 8] = (byte)len;
        }
        return ret;
    }

    private static byte[] decodeEVarbinaryFromBytes(byte[] v, int offset, int len) {
        assert (len % 9 == 0);
        int group = len / 9;
        int retLen = (group - 1) * 8 + v[offset + (len - 1)];
        byte[] ret = new byte[retLen];
        int retOffset = 0;
        while (group > 0) {
            --group;
            int flag = v[offset + 8];
            if (9 != flag) {
                len = flag;
                System.arraycopy(v, offset, ret, retOffset, len);
                break;
            }
            System.arraycopy(v, offset, ret, retOffset, 8);
            retOffset += 8;
            offset += 9;
            len -= 9;
        }
        return ret;
    }
}

