/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.dml.PagingContext;
import com.alibaba.lindorm.client.dml.QueryResults;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class QueryResultsWrapper {
    public static QueryResults wrapSingleRow(Row r) {
        return new WrappedQueryResults(r);
    }

    public static QueryResults wrapRows(List<Row> rows) {
        return new WrappedQueryResults(rows);
    }

    private QueryResultsWrapper() {
    }

    private static class WrappedQueryResults
    implements QueryResults {
        private final List<Row> rows;
        private final Iterator<Row> iterator;

        WrappedQueryResults(List<Row> rows) {
            this.rows = Collections.unmodifiableList(rows);
            this.iterator = this.rows.iterator();
        }

        WrappedQueryResults(Row r) {
            this.rows = Collections.singletonList(r);
            this.iterator = this.rows.iterator();
        }

        @Override
        public Row next() throws LindormException {
            return this.iterator.next();
        }

        @Override
        public List<Row> next(int maxNumberOfRows) throws LindormException {
            Row r;
            if (maxNumberOfRows < 1) {
                throw new IllegalRequestException("maxNumberOfRows must >= 1, but has " + maxNumberOfRows);
            }
            ArrayList<Row> ret = new ArrayList<Row>(maxNumberOfRows);
            for (int i = 0; i < maxNumberOfRows && (r = this.next()) != null; ++i) {
                ret.add(r);
            }
            return ret;
        }

        @Override
        public byte[] getDigest() throws LindormException {
            return null;
        }

        @Override
        public PagingContext getPagingContext() throws LindormException {
            return null;
        }

        @Override
        public String getSearchCursor() {
            return null;
        }

        @Override
        public LQueryResults.SelectContext.SearchResponsePayload getPayload() {
            return null;
        }

        @Override
        public boolean isPagingContextAvailable() {
            return false;
        }

        @Override
        public boolean isExhausted() {
            return !this.iterator.hasNext();
        }

        @Override
        public Iterator<Row> iterator() {
            return this.iterator;
        }
    }
}

