/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WRow;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class WMutation
extends WRow
implements OpTimeout {
    public static final long NOLOCK = -1L;
    protected long lockId = -1L;
    protected boolean writeToWAL = true;
    private int operationTimeout = -1;
    private int glitchTimeout = -1;
    private static final String CLUSTER_ID_ATTR = "CID";
    private static final String CONSUMED_CLUSTER_IDS = "_cs.id";
    private static final String REPLICA_SYNC = "REPLICA_SYNC";
    private static final String EXPORTER2_SYNC = "EXPORTER2_SYNC";
    public static final String OP_ATTRIBUTE_TTL = "_ttl";

    public WMutation() {
    }

    public WMutation(byte[] rowKey) {
        this(rowKey, Long.MAX_VALUE, -1L);
    }

    public WMutation(byte[] row, long ts) {
        this(row, ts, -1L);
    }

    public WMutation(byte[] rowKey, long ts, long lockId) {
        super(rowKey, ts);
        this.lockId = lockId;
    }

    public WMutation(WMutation wMutationToCopy) {
        super(wMutationToCopy);
        this.lockId = wMutationToCopy.lockId;
        this.writeToWAL = wMutationToCopy.writeToWAL;
    }

    public long getLockId() {
        return this.lockId;
    }

    public boolean isWriteToWAL() {
        return this.writeToWAL;
    }

    public void setLockId(long lockId) {
        this.lockId = lockId;
    }

    public void setWriteToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
    }

    public void setTTL(long ttl) {
        this.setAttribute(OP_ATTRIBUTE_TTL, Bytes.toBytes(ttl));
    }

    public long getTTL() {
        byte[] ttlBytes = this.getAttribute(OP_ATTRIBUTE_TTL);
        if (ttlBytes != null) {
            return Bytes.toLong(ttlBytes);
        }
        return Long.MAX_VALUE;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVLong(out, this.lockId);
        out.writeBoolean(this.writeToWAL);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.lockId = WritableUtils.readVLong(in);
        this.writeToWAL = in.readBoolean();
    }

    public void setClusterId(UUID clusterId) {
        byte[] val = new byte[16];
        Bytes.putLong(val, 0, clusterId.getMostSignificantBits());
        Bytes.putLong(val, 8, clusterId.getLeastSignificantBits());
        this.setAttribute(CLUSTER_ID_ATTR, val);
    }

    public void setClusterIds(List<UUID> clusterIds) throws IOException {
        if (clusterIds.size() > 0) {
            int size = 2 * clusterIds.size() * 8 + 4;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream(size);
            DataOutputStream out = new DataOutputStream(outStream);
            out.writeInt(clusterIds.size());
            for (UUID clusterId : clusterIds) {
                out.writeLong(clusterId.getMostSignificantBits());
                out.writeLong(clusterId.getLeastSignificantBits());
            }
            this.setAttribute(CONSUMED_CLUSTER_IDS, outStream.toByteArray());
        }
    }

    public UUID getClusterId() {
        byte[] attr = this.getAttribute(CLUSTER_ID_ATTR);
        if (attr == null) {
            return null;
        }
        return new UUID(Bytes.toLong(attr, 0), Bytes.toLong(attr, 8));
    }

    public List<UUID> getClusterIds() throws IOException {
        ArrayList<UUID> clusterIds = new ArrayList<UUID>();
        byte[] bytes = this.getAttribute(CONSUMED_CLUSTER_IDS);
        if (bytes != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                UUID uuid = new UUID(in.readLong(), in.readLong());
                clusterIds.add(uuid);
            }
            in.close();
        }
        return clusterIds;
    }

    public boolean isFromReplica() {
        return this.getAttribute(REPLICA_SYNC) != null;
    }

    public boolean isFromExporter2() {
        return this.getAttribute(EXPORTER2_SYNC) != null;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    @Override
    public String toString() {
        return this.toStringWithLimitKVs(10, 256);
    }

    @Override
    public String toStringWithLimitKVs(int maxKVToString, int capacity) {
        StringBuilder builder = new StringBuilder(capacity);
        builder.append("[").append("wal=").append(this.writeToWAL);
        if (this.getTTL() != Long.MAX_VALUE) {
            builder.append("ttl").append(this.getTTL());
        }
        builder.append("]");
        builder.append(super.toStringWithLimitKVs(maxKVToString, capacity));
        return builder.toString();
    }
}

