/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WColumn;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WRow
extends VersionedObjectWithAttributes {
    protected byte[] rowKey;
    private boolean allSameTS = true;
    protected long ts = Long.MAX_VALUE;
    protected Map<byte[], List<WColumn>> familyMap = new TreeMap<byte[], List<WColumn>>(Bytes.BYTES_COMPARATOR);

    public WRow() {
    }

    public WRow(byte[] rowKey) {
        this(rowKey, Long.MAX_VALUE);
    }

    public WRow(byte[] rowKey, List<WColumn> wColumns) {
        this(rowKey, Long.MAX_VALUE);
        for (WColumn wColumn : wColumns) {
            this.addColumn(wColumn.getFamily(), wColumn);
        }
    }

    public WRow(byte[] rowKey, long ts) {
        this.rowKey = rowKey;
        this.ts = ts;
    }

    public WRow(WRow wRowToCopy) {
        this(wRowToCopy.rowKey, wRowToCopy.ts);
        this.allSameTS = wRowToCopy.allSameTS;
        this.familyMap = new TreeMap<byte[], List<WColumn>>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], List<WColumn>> entry : wRowToCopy.getFamilyMap().entrySet()) {
            this.familyMap.put(entry.getKey(), entry.getValue());
        }
    }

    public byte[] getRowKey() {
        return this.rowKey;
    }

    public long getTimeStamp() {
        return this.ts;
    }

    public Map<byte[], List<WColumn>> getFamilyMap() {
        return this.familyMap;
    }

    protected void addNewTimestamp(long newTS) {
        if (this.allSameTS & this.ts != newTS) {
            this.allSameTS = false;
        }
    }

    protected void addColumn(byte[] family, WColumn column) {
        List<WColumn> columns = this.getColumnList(family);
        if (columns == null) {
            columns = new ArrayList<WColumn>();
            this.familyMap.put(family, columns);
        }
        columns.add(column);
        this.addNewTimestamp(column.getTs());
    }

    protected List<WColumn> getColumnList(byte[] family) {
        return this.familyMap.get(family);
    }

    public boolean isEmpty() {
        return this.familyMap.isEmpty();
    }

    public void validate(long maxRowColumnSize) throws IllegalArgumentException {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.getRowKey() == null) {
            throw new IllegalArgumentException("rowkey is null");
        }
        if (maxRowColumnSize > 0L) {
            int rowSize = this.getRowKey().length;
            for (Map.Entry<byte[], List<WColumn>> familySet : this.getFamilyMap().entrySet()) {
                if (familySet.getKey() == null) {
                    throw new IllegalArgumentException("family is null");
                }
                int familySize = familySet.getKey().length;
                for (WColumn wColumn : familySet.getValue()) {
                    long totalSize = (long)(rowSize + familySize) + wColumn.getLength();
                    if (totalSize <= maxRowColumnSize) continue;
                    throw new IllegalArgumentException("RowColumn size too large, expected max size=" + maxRowColumnSize + ", actual size=" + totalSize);
                }
            }
        }
    }

    protected void writeFamilyMap(DataOutput out) throws IOException {
        WritableUtils.writeVInt(out, this.familyMap.size());
        for (Map.Entry<byte[], List<WColumn>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            List<WColumn> list = entry.getValue();
            out.writeInt(list.size());
            for (WColumn column : list) {
                if (this.allSameTS) {
                    column.setTs(0L);
                }
                column.writeTo(out);
            }
        }
    }

    protected void readFamilyMap(DataInput in) throws IOException {
        int numFamilies = WritableUtils.readVInt(in);
        if (!this.familyMap.isEmpty()) {
            this.familyMap.clear();
        }
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = in.readInt();
            ArrayList<WColumn> list = new ArrayList<WColumn>(numColumns);
            for (int j = 0; j < numColumns; ++j) {
                WColumn column = new WColumn();
                column.readFrom(in);
                column.setFamily(family);
                if (this.allSameTS) {
                    column.setTs(this.ts);
                }
                list.add(column);
            }
            this.familyMap.put(family, list);
        }
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.rowKey);
        out.writeBoolean(this.allSameTS);
        WritableUtils.writeVLong(out, this.ts);
        this.writeFamilyMap(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.rowKey = Bytes.readByteArray(in);
        this.allSameTS = in.readBoolean();
        this.ts = WritableUtils.readVLong(in);
        this.readFamilyMap(in);
    }

    @Override
    public String toString() {
        return this.toStringWithLimitKVs(10, 256);
    }

    public String toStringWithLimitKVs(int maxKVToString, int capacity) {
        int appendNum = 0;
        int totalkv = 0;
        StringBuilder buffer = new StringBuilder(capacity);
        buffer.append("[Row=");
        buffer.append(Bytes.toStringBinary(this.rowKey));
        buffer.append("]");
        block0: for (Map.Entry<byte[], List<WColumn>> entry : this.familyMap.entrySet()) {
            totalkv += entry.getValue().size();
            for (WColumn column : entry.getValue()) {
                if (appendNum >= maxKVToString) continue block0;
                buffer.append("[");
                buffer.append(column);
                buffer.append("]");
                ++appendNum;
            }
        }
        if (appendNum >= maxKVToString) {
            buffer.append("[...]");
            buffer.insert(0, "[kv count=" + totalkv + "]");
        }
        return buffer.toString();
    }

    public int getEstimatedSize() {
        int size = 0;
        ++size;
        size += 16;
        size += this.getAttrEstimatedSize();
        if (this.familyMap != null) {
            for (Map.Entry<byte[], List<WColumn>> entry : this.familyMap.entrySet()) {
                if (entry.getKey() == null) continue;
                size += entry.getKey().length;
                for (WColumn column : entry.getValue()) {
                    size += column.getEstimatedSize();
                }
            }
        }
        return size;
    }
}

