/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DataType;

public class CHSColumnSchema {
    private byte[] column;
    private LColumn lcolumn;
    public static final String DELIMETER = "\\|";

    public CHSColumnSchema() {
    }

    public CHSColumnSchema(byte[] column) {
        this.column = column;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public LColumn getLcolumn() {
        return this.lcolumn;
    }

    public void setLcolumn(LColumn lcolumn) {
        this.lcolumn = lcolumn;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("COLUMN=");
        sb.append(Bytes.toString(this.column));
        return sb.toString();
    }

    public static CHSColumnSchema fromString(String schema) {
        String[] parts = schema.split(DELIMETER);
        String columnPars = parts[0];
        CHSColumnSchema chsColumnSchema = new CHSColumnSchema();
        boolean columnSet = false;
        String[] configParts = columnPars.split("=");
        if (configParts.length != 2) {
            throw new IllegalArgumentException("Invalid CHS config " + schema + ", Example" + "COLUMN=column");
        }
        if (configParts[0].equals("COLUMN")) {
            columnSet = true;
            chsColumnSchema.setColumn(Bytes.toBytes(configParts[1]));
        }
        if (!columnSet) {
            throw new IllegalArgumentException("Invalid schema type " + schema + ", Example" + "COLUMN=column");
        }
        return chsColumnSchema;
    }

    public static void validateCHSColumnSchema(TableMeta tableMeta) throws IllegalRequestException {
        String columnAndPolicy = tableMeta.getFamilyAttributes().getChsColumn();
        if (columnAndPolicy == null) {
            return;
        }
        String[] parts = columnAndPolicy.split(DELIMETER);
        if (parts.length > 2) {
            throw new IllegalRequestException("Invalid CHS_COLUMN:," + columnAndPolicy + ",example:" + "COLUMN=c1" + "\n" + "COLUMN=c1|POLICY=com.alibaba.lindorm.server.ldserver.chspolicy.CHSColumnPolicy");
        }
        CHSColumnSchema schema = CHSColumnSchema.fromString(parts[0]);
        if (schema != null) {
            if (tableMeta.getFamilies().size() > 1) {
                throw new IllegalRequestException("Default CHS Schema can only be set on Single family table");
            }
            if (tableMeta.getFamilies().isEmpty()) {
                CHSColumnSchema.verify(tableMeta, SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, schema);
            } else {
                CHSColumnSchema.verify(tableMeta, tableMeta.getFamilies().get(0).getName(), schema);
            }
        }
        for (ColumnFamilyDescriptor descriptor : tableMeta.getFamilies()) {
            FamilyAttributes colAttributes = descriptor.getFamilyAttributes();
            String columnAndPolicyFromFamily = colAttributes.getChsColumn();
            if (columnAndPolicyFromFamily == null) {
                return;
            }
            parts = columnAndPolicyFromFamily.split(DELIMETER);
            if (parts.length > 2) {
                throw new IllegalRequestException("Invalid CHS_COLUMN:," + columnAndPolicy + ",example:" + "COLUMN=c1" + "\n" + "COLUMN=c1|POLICY=com.alibaba.lindorm.server.ldserver.chspolicy.CHSColumnPolicy");
            }
            schema = CHSColumnSchema.fromString(parts[0]);
            if (schema == null) continue;
            CHSColumnSchema.verify(tableMeta, descriptor.getName(), schema);
        }
    }

    private static void verify(TableMeta meta, byte[] familyName, CHSColumnSchema schema) throws IllegalRequestException {
        if (schema.getColumn() == null) {
            throw new IllegalRequestException("Must explicitly specify column name for CHS_COLUMN");
        }
        for (LColumn lcolumn : meta.getAllColumns()) {
            if (lcolumn.getFamilyName() == null) {
                if (!Bytes.equals(lcolumn.getColumnName(), schema.getColumn()) || !Bytes.equals(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, familyName)) continue;
                if (lcolumn.getDataType().getClientType() == DataType.INT || lcolumn.getDataType().getClientType() == DataType.LONG) break;
                throw new IllegalRequestException("CHS column must be Int or Long type");
            }
            if (!Bytes.equals(lcolumn.getColumnName(), schema.getColumn()) || !Bytes.equals(lcolumn.getFamilyName(), familyName)) continue;
            if (lcolumn.getDataType().getClientType() == DataType.INT || lcolumn.getDataType().getClientType() == DataType.LONG) break;
            throw new IllegalRequestException("CHS column must be Int or Long type");
        }
    }
}

