/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.types.LCollectionType;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.schema.CollectionDataType;
import com.alibaba.lindorm.client.schema.ListType;
import com.alibaba.lindorm.client.schema.MapType;
import com.alibaba.lindorm.client.schema.SetType;

public enum DataType {
    BYTE(0, true, true),
    BOOLEAN(1, true, true),
    SHORT(2, true, true),
    INT(3, true, true),
    LONG(4, true, true),
    FLOAT(5, true, true),
    DOUBLE(6, true, true),
    STRING(7, true, true),
    VARBINARY(8, true, true),
    BINARY(9, true, true),
    DECIMAL(10, true, true),
    UNSIGNED_BYTE(11, true, true),
    UNSIGNED_SHORT(12, true, true),
    UNSIGNED_INTEGER(13, true, true),
    UNSIGNED_LONG(14, true, true),
    UNSIGNED_FLOAT(15, true, true),
    UNSIGNED_DOUBLE(16, true, true),
    ENCODED_VARBINARY(17, true, true),
    ACC_LONG(18, false, false),
    ACC_DOUBLE(19, false, false),
    DATE(20, true, true),
    UNSIGNED_DATE(21, true, true),
    TIME(22, true, true),
    UNSIGNED_TIME(23, true, true),
    TIMESTAMP(24, true, true),
    UNSIGNED_TIMESTAMP(25, true, true),
    CHAR(26, true, true),
    UUID(27, true, true),
    DECIMAL_V2(28, true, true),
    NESTED(29, false, false),
    SET(4029, false, false, true),
    MAP(4030, false, false, true),
    LIST(4031, false, false, true),
    PARAM(1000, false, false);

    private final int id;
    private final boolean pkSupported;
    private final boolean indexSupported;
    private final boolean isCollection;

    private DataType(int id, boolean pkSupported, boolean indexSupported) {
        this(id, pkSupported, indexSupported, false);
    }

    private DataType(int id, boolean pkSupported, boolean indexSupported, boolean isCollection) {
        this.id = id;
        this.pkSupported = pkSupported;
        this.indexSupported = indexSupported;
        this.isCollection = isCollection;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public boolean pkSupported() {
        return this.pkSupported;
    }

    public boolean indexSupported() {
        return this.indexSupported;
    }

    public static SetType set(DataType elementType) {
        return new SetType(elementType);
    }

    public static SetType set(CollectionDataType elementType) {
        return new SetType(elementType);
    }

    public static SetType set(LDataType lDataType) {
        if (lDataType instanceof LCollectionType) {
            return DataType.set(((LCollectionType)lDataType).getCollectionDataType());
        }
        return DataType.set(lDataType.getClientType());
    }

    public static ListType list(DataType elementType) {
        return new ListType(elementType);
    }

    public static ListType list(CollectionDataType elementType) {
        return new ListType(elementType);
    }

    public static MapType map(DataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static MapType map(CollectionDataType keyType, CollectionDataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static MapType map(DataType keyType, CollectionDataType valueType) {
        return new MapType(keyType, valueType);
    }

    public static MapType map(CollectionDataType keyType, DataType valueType) {
        return new MapType(keyType, valueType);
    }
}

