/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.BytesKeyAttributes;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.schema.ConflictResolverSchema;
import com.alibaba.lindorm.client.schema.DataCodec;
import com.alibaba.lindorm.client.schema.Mutability;
import com.alibaba.lindorm.client.schema.RowTTLSchema;
import java.util.concurrent.TimeUnit;

public abstract class DescriptorAttributes {
    protected FamilyAttributes familyAttributes = new FamilyAttributes();
    protected TableAttributes tableAttributes = new TableAttributes();
    protected BytesKeyAttributes otherAttributes = null;

    public boolean isDynamicColumnsEnabled() {
        return this.tableAttributes.isDynamicColumnsEnabled();
    }

    public void setDynamicColumnsEnabled(boolean enabled) {
        this.tableAttributes.setDynamicColumnsEnabled(enabled);
    }

    public void setGlitchTimeout(int timeout) {
        this.tableAttributes.setGlitchTimeout(timeout);
    }

    public int getGlitchTimeout() {
        return this.tableAttributes.getGlitchTimeout();
    }

    public void setWriteGlitchTimeout(int timeout) {
        this.tableAttributes.setWriteGlitchTimeout(timeout);
    }

    public int getWriteGlitchTimeout() {
        return this.tableAttributes.getWriteGlitchTimeout();
    }

    public void setReadGlitchTimeout(int timeout) {
        this.tableAttributes.setReadGlitchTimeout(timeout);
    }

    public int getReadGlitchTimeout() {
        return this.tableAttributes.getReadGlitchTimeout();
    }

    public void setMutability(Mutability mutability) {
        this.tableAttributes.setMutability(mutability);
    }

    public void setMutability(String mutabilityS) {
        Mutability mutability = Mutability.getMutability(mutabilityS);
        this.tableAttributes.setMutability(mutability);
    }

    public Mutability getMutability() {
        return this.tableAttributes.getMutability();
    }

    public void setDataCodec(DataCodec codec) {
        this.tableAttributes.setDataCodec(codec);
    }

    public void setDataCodec(String codecS) {
        DataCodec codec = DataCodec.valueOf(codecS);
        this.setDataCodec(codec);
    }

    public DataCodec getDataCodec() {
        return this.tableAttributes.getDataCodec();
    }

    public void setUsingHashEngine(boolean enableHash) {
        this.tableAttributes.setUsingHashEngine(enableHash);
    }

    public boolean isHashTable() {
        return this.tableAttributes.isHashTable();
    }

    @Deprecated
    public void setLeaderBalance(boolean enabled) throws IllegalArgumentException {
        if (this.tableAttributes.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalArgumentException("Leader balance attributes should only be set on a strong consistent table, current type: " + (Object)((Object)this.tableAttributes.getConsistencyType()));
        }
        this.tableAttributes.setLeaderBalance(enabled);
    }

    @Deprecated
    public boolean isLeaderBalanceEnabled() throws IllegalArgumentException {
        if (this.tableAttributes.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalArgumentException("Leader balance attributes should only be checked on a strong consistent table, current type: " + (Object)((Object)this.tableAttributes.getConsistencyType()));
        }
        return this.tableAttributes.isLeaderBalanceEnabled();
    }

    public DescriptorAttributes setLeaderBalanceType(TableAttributes.LeaderBalanceType type) {
        if (this.tableAttributes.getConsistencyType() != TableAttributes.ConsistencyType.Strong) {
            throw new IllegalArgumentException("Leader balance attributes should only be checked on a strong consistent table, current type: " + (Object)((Object)this.tableAttributes.getConsistencyType()));
        }
        this.tableAttributes.setLeaderBalanceType(type);
        return this;
    }

    public void setLeaderBalanceType(String leaderBalanceTypeS) {
        TableAttributes.LeaderBalanceType type = TableAttributes.LeaderBalanceType.getBalanceType(leaderBalanceTypeS);
        this.setLeaderBalanceType(type);
    }

    public TableAttributes.LeaderBalanceType getLeaderBalanceType() {
        return this.tableAttributes.getLeaderBalanceType();
    }

    public DescriptorAttributes setConsistencyType(TableAttributes.ConsistencyType consistencyType) {
        this.tableAttributes.setConsistencyType(consistencyType);
        return this;
    }

    public void setConsistencyType(String consistencyTypeS) {
        TableAttributes.ConsistencyType consistencyType = TableAttributes.ConsistencyType.getConsistencyType(consistencyTypeS);
        this.tableAttributes.setConsistencyType(consistencyType);
    }

    public TableAttributes.ConsistencyType getConsistencyType() {
        return this.tableAttributes.getConsistencyType();
    }

    public DescriptorAttributes setRefSplitAllowed(boolean enable) {
        this.tableAttributes.setRefSplitAllowed(enable);
        return this;
    }

    public boolean isRefSplitAllowed() {
        Boolean allowed = this.tableAttributes.isRefSplitAllowed();
        return allowed == null ? false : allowed;
    }

    public DescriptorAttributes setMaxPkColumnLength(int maxPkColumnLength) {
        this.tableAttributes.setMaxPkColumnLength(maxPkColumnLength);
        return this;
    }

    public int getMaxPkColumnLength() {
        return this.tableAttributes.getMaxPkColumnLength();
    }

    public DescriptorAttributes setMaxNonPkColumnLength(int maxNonPkColumnLength) {
        this.tableAttributes.setMaxNonPkColumnLength(maxNonPkColumnLength);
        return this;
    }

    public int getMaxNonPkColumnLength() {
        return this.tableAttributes.getMaxNonPkColumnLength();
    }

    public DescriptorAttributes setDeferredLogFlush(boolean defer) {
        this.tableAttributes.setDeferredLogFlush(defer);
        return this;
    }

    public boolean isDeferredLogFlush() {
        return this.tableAttributes.isDeferredLogFlush();
    }

    public DescriptorAttributes setWalEditWithFullData(boolean enabled) {
        this.tableAttributes.setWalEditWithFullRow(enabled);
        return this;
    }

    public boolean isWalEditWithFullData() {
        return this.tableAttributes.isWalEditWithFullRow();
    }

    public DescriptorAttributes setFullRowEditCarryLatestData(boolean carried) {
        this.tableAttributes.setFullRowEditCarryLatestData(carried);
        return this;
    }

    public boolean isFullRowEditCarryLatestData() {
        return this.tableAttributes.isFullRowEditCarryLatestData();
    }

    public void setAllowFiltering(boolean value) {
        this.tableAttributes.setAllowFiltering(value);
    }

    public boolean isAllowFiltering() {
        return this.tableAttributes.isAllowFiltering();
    }

    public void setReadOnly(boolean value) {
        this.tableAttributes.setReadOnly(value);
    }

    public boolean isReadOnly() {
        return this.tableAttributes.isReadOnly();
    }

    public void setMemStoreFlushSize(long value) {
        this.tableAttributes.setMemStoreFlushSize(value);
    }

    public long getMemStoreFlushSize() {
        return this.tableAttributes.getMemStoreFlushSize();
    }

    public DescriptorAttributes setConflictResolver(String resolver) {
        this.tableAttributes.setConflictResolver(resolver);
        return this;
    }

    public DescriptorAttributes setConflictResolver(ConflictResolverSchema resolver) {
        this.tableAttributes.setConflictResolver(resolver);
        return this;
    }

    public ConflictResolverSchema getConflictResolver() {
        return this.tableAttributes.getConflictResolver();
    }

    public boolean isSkipReplicaConsensus() {
        return this.tableAttributes.isSkipReplicaConsensus();
    }

    public void setSkipReplicaConsensus(boolean skipReplicaConsensus) {
        this.tableAttributes.setSkipReplicaConsensus(skipReplicaConsensus);
    }

    public DescriptorAttributes setBloomFilterType(String bloomFilter) {
        this.familyAttributes.setBloomFilterType(bloomFilter);
        return this;
    }

    public String getBloomFilterType() {
        return this.familyAttributes.getBloomFilterType();
    }

    public boolean isBFOptimizeOnMajor() {
        return this.familyAttributes.isBFOptimizeOnMajor();
    }

    public DescriptorAttributes setBFOptimizeOnMajor(String shouldOptimize) {
        this.familyAttributes.setBFOptimizeOnMajor(shouldOptimize);
        return this;
    }

    public DescriptorAttributes setCompression(String compression) {
        this.familyAttributes.setCompression(compression);
        return this;
    }

    public String getCompression() {
        return this.familyAttributes.getCompression();
    }

    public DescriptorAttributes setCompressionCompact(String compression) {
        this.familyAttributes.setCompressionCompact(compression);
        return this;
    }

    public String getCompressionCompact() {
        return this.familyAttributes.getCompressionCompact();
    }

    public DescriptorAttributes setCompactionCompressionLevel(short level) {
        this.familyAttributes.setCompactionCompressionLevel(level);
        return this;
    }

    public short getCompactionCompressionLevel() {
        return this.familyAttributes.getCompactionCompressionLevel();
    }

    public DescriptorAttributes setDataBlockEncoding(String encoding) {
        this.familyAttributes.setDataBlockEncoding(encoding);
        return this;
    }

    public String getDataBlockEncoding() {
        return this.familyAttributes.getDataBlockEncoding();
    }

    public DescriptorAttributes setDfsReplication(short dfsReplication) {
        this.familyAttributes.setDfsReplication(dfsReplication);
        return this;
    }

    public short getDfsReplication() {
        return this.familyAttributes.getDfsReplication();
    }

    public DescriptorAttributes setStorageType(String storageType) {
        this.familyAttributes.setStorageType(storageType);
        return this;
    }

    public String getStorageType() {
        return this.familyAttributes.getStorageType();
    }

    public DescriptorAttributes setStorageTypeCompact(String storageType) {
        this.familyAttributes.setStorageTypeCompact(storageType);
        return this;
    }

    public String getStorageTypeCompact() {
        return this.familyAttributes.getStorageTypeCompact();
    }

    public DescriptorAttributes setTimeToLive(int ttl, TimeUnit unit) {
        int seconds = (int)unit.toSeconds(ttl);
        this.familyAttributes.setTimeToLive(seconds);
        return this;
    }

    public int getTimeToLive() {
        return this.familyAttributes.getTimeToLive();
    }

    public DescriptorAttributes setMaxVersions(int maxVersions) {
        this.familyAttributes.setMaxVersions(maxVersions);
        return this;
    }

    public int getMaxVersions() {
        return this.familyAttributes.getMaxVersions();
    }

    public DescriptorAttributes setMinVersions(int minVersions) {
        this.familyAttributes.setMinVersions(minVersions);
        return this;
    }

    public int getMinVersions() {
        return this.familyAttributes.getMinVersions();
    }

    public DescriptorAttributes setMemstoreFilterType(String type) {
        this.familyAttributes.setMemStoreFilterType(type);
        return this;
    }

    public String getMemstoreFilterType() {
        return this.familyAttributes.getMemstoreFilterType();
    }

    public DescriptorAttributes setTimeToPurgeDeletes(long timeToPurgeDelete, TimeUnit unit) {
        long ms = unit.toMillis(timeToPurgeDelete);
        this.familyAttributes.setTimeToPurgeDeletes(ms);
        return this;
    }

    public long getTimeToPurgeDeletes() {
        return this.familyAttributes.getTimeToPurgeDeletes();
    }

    public DescriptorAttributes setInMemory(boolean inMemory) {
        this.familyAttributes.setInMemory(inMemory);
        return this;
    }

    public boolean isInMemory() {
        return this.familyAttributes.isInMemory();
    }

    public DescriptorAttributes setBlockCacheEnabled(boolean enabled) {
        this.familyAttributes.setBlockCacheEnabled(enabled);
        return this;
    }

    public boolean isBlockCacheEnabled() {
        return this.familyAttributes.isBlockCacheEnabled();
    }

    public DescriptorAttributes setBlockSize(int blockSize) {
        this.familyAttributes.setBlockSize(blockSize);
        return this;
    }

    public int getBlockSize() {
        return this.familyAttributes.getBlockSize();
    }

    public DescriptorAttributes setColdHotSeparateBoundary(String config) {
        this.familyAttributes.setColdHotSeparateBoundary(config);
        return this;
    }

    public String getColdHotSeparateBoundary() {
        return this.familyAttributes.getColdHotSeparateBoundary();
    }

    public DescriptorAttributes setColdHotLayerConfig(int i, String config) {
        this.familyAttributes.setColdHotLayerConfig(i, config);
        return this;
    }

    public String getColdHotLayerConfig(int i) {
        return this.familyAttributes.getColdHotLayerConfig(i);
    }

    public DescriptorAttributes setRowTTLSchema(String schema) {
        this.familyAttributes.setRowTTLSchema(schema);
        return this;
    }

    public DescriptorAttributes setRowTTLSchema(RowTTLSchema schema) {
        this.familyAttributes.setRowTTLSchema(schema);
        return this;
    }

    public RowTTLSchema getRowTTLSchema() {
        return this.familyAttributes.getRowTTLSchema();
    }

    public DescriptorAttributes setChsColumn(String columnAndPolicy) {
        this.familyAttributes.setChsColumn(columnAndPolicy);
        return this;
    }

    public String getChsColumn() {
        return this.familyAttributes.getChsColumn();
    }

    public DescriptorAttributes setColdHotPromoteOnMajor(boolean promoteOnMajor) {
        this.familyAttributes.setColdHotPromoteOnMajor(promoteOnMajor);
        return this;
    }

    public boolean isColdHotPromoteOnMajor() {
        return this.familyAttributes.isColdHotPromoteOnMajor();
    }

    public DescriptorAttributes setKeepDeletedData(boolean keepDeletedData) {
        this.familyAttributes.setKeepDeletedData(keepDeletedData);
        return this;
    }

    public boolean getKeepDeletedData() {
        return this.familyAttributes.getKeepDeletedData();
    }

    public DescriptorAttributes setCompactionMajorPeriod(long compactionMajorPeriod) {
        this.familyAttributes.setCompactionMajorPeriod(compactionMajorPeriod);
        return this;
    }

    public Long getCompactionMajorPeriodNoDefault() {
        return this.familyAttributes.getCompactionMajorPeriodNoDefault();
    }

    public DescriptorAttributes setHotCompactionPeriod(long period) {
        this.familyAttributes.setHotCompactionPeriod(period);
        return this;
    }

    public Long getHotCompactionPeriod() {
        return this.familyAttributes.getHotCompactionPeriod();
    }

    public DescriptorAttributes setFileVersion(int version) {
        this.familyAttributes.setFileVersion(version);
        return this;
    }

    public Integer getFileVersion() {
        return this.familyAttributes.getFileVersion();
    }

    public DescriptorAttributes setCompactionMaxKVNum(int compactionMaxKVNum) {
        this.familyAttributes.setCompactionMaxKVNum(compactionMaxKVNum);
        return this;
    }

    public Integer getCompactionMaxKVNumNoDefault() {
        return this.familyAttributes.getCompactionMaxKVNumNoDefault();
    }

    public void setTableAttributes(String name, String value) {
        if (name.equals("CONSISTENCY")) {
            this.setConsistencyType(value);
        } else if (name.equals("MUTABILITY")) {
            this.setMutability(value);
        }
        this.tableAttributes.setAttribute(name, value);
    }

    public void setTableAttributes(String name, byte[] value) {
        if (name.equals("CONSISTENCY")) {
            this.setConsistencyType(Bytes.toString(value));
        } else if (name.equals("MUTABILITY")) {
            this.setMutability(Bytes.toString(value));
        }
        this.tableAttributes.setAttribute(name, value);
    }

    public void setFamilyAttributes(String name, String value) {
        this.familyAttributes.setAttribute(name, value);
    }

    public FamilyAttributes getFamilyAttributes() {
        return this.familyAttributes;
    }

    public abstract void setFamilyAttributes(byte[] var1, String var2, String var3) throws IllegalRequestException;

    public TableAttributes getTableAttributes() {
        return this.tableAttributes;
    }

    public void setFamilyAttributes(FamilyAttributes familyAttributes) {
        this.familyAttributes = familyAttributes;
    }

    public DescriptorAttributes setTableAttributes(TableAttributes tableAttributes) {
        this.tableAttributes = tableAttributes;
        return this;
    }

    public BytesKeyAttributes getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setOtherAttributes(BytesKeyAttributes otherAttributes) {
        this.otherAttributes = otherAttributes;
    }
}

