/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.schema.BuildIndexJobStatus;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class IndexBuildingProgress
extends VersionedObjectWithAttributes {
    private BuildIndexJobStatus status;
    private int doneSubJobsNum = 0;
    private int totalSubJobsNum = 0;

    public IndexBuildingProgress() {
    }

    public IndexBuildingProgress(BuildIndexJobStatus status, int doneSubJobsNum, int totalSubJobsNum) {
        this.status = status;
        this.doneSubJobsNum = doneSubJobsNum;
        this.totalSubJobsNum = totalSubJobsNum;
    }

    public BuildIndexJobStatus getStatus() {
        return this.status;
    }

    public Pair<Integer, Integer> getSubJobProcess() {
        return new Pair<Integer, Integer>(this.doneSubJobsNum, this.totalSubJobsNum);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.status.getId());
        WritableUtils.writeVInt(out, this.totalSubJobsNum);
        WritableUtils.writeVInt(out, this.doneSubJobsNum);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.status = BuildIndexJobStatus.fromId(WritableUtils.readVInt(in));
        this.totalSubJobsNum = WritableUtils.readVInt(in);
        this.doneSubJobsNum = WritableUtils.readVInt(in);
    }

    @Override
    public String toString() {
        return "BuildIndexJob current status = " + (Object)((Object)this.status) + ", total subJobs number = " + this.totalSubJobsNum + ", already done subJobs number = " + this.doneSubJobsNum;
    }
}

