/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.LindormEntityDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LindormEntities {
    private final List<LindormEntityDescriptor> entities;
    private LindormEntityDescriptor activeEntity;
    private List<LindormEntityDescriptor> building;
    private List<LindormEntityDescriptor> archived;
    private List<LindormEntityDescriptor> disabled;
    private Map<String, LindormEntityDescriptor> entitiesMap = null;

    public LindormEntities(List<LindormEntityDescriptor> entities) throws LindormException {
        this.entities = Collections.unmodifiableList(entities);
        this.init();
    }

    public String toString() {
        return "active:" + this.activeEntity + ", all=" + this.entities.size() + "@" + this.entities;
    }

    public boolean hasEntity() {
        return !this.entities.isEmpty();
    }

    public List<LindormEntityDescriptor> getAllEntities() {
        return this.entities;
    }

    public Map<String, LindormEntityDescriptor> getAllEntitiesAsMap() {
        if (this.entitiesMap == null) {
            this.entitiesMap = new HashMap<String, LindormEntityDescriptor>();
            for (LindormEntityDescriptor desc : this.entities) {
                this.entitiesMap.put(desc.getEntityName(), desc);
            }
        }
        return this.entitiesMap;
    }

    public LindormEntityDescriptor getActiveEntity() {
        return this.activeEntity;
    }

    public List<LindormEntityDescriptor> getBuildingEntities() {
        return this.building;
    }

    public List<LindormEntityDescriptor> getArchivedEntities() {
        return this.archived;
    }

    public List<LindormEntityDescriptor> getDisabledEntities() {
        return this.disabled;
    }

    private void init() {
        ArrayList<LindormEntityDescriptor> tmpBuilding = new ArrayList<LindormEntityDescriptor>();
        ArrayList<LindormEntityDescriptor> tmpArchived = new ArrayList<LindormEntityDescriptor>();
        ArrayList<LindormEntityDescriptor> tmpDisabled = new ArrayList<LindormEntityDescriptor>();
        for (LindormEntityDescriptor e : this.entities) {
            switch (e.getState()) {
                case BUILDING: {
                    tmpBuilding.add(e);
                    break;
                }
                case ACTIVE: {
                    this.activeEntity = e;
                    break;
                }
                case ARCHIVED: {
                    tmpArchived.add(e);
                    break;
                }
                case DISABLED: {
                    tmpDisabled.add(e);
                }
            }
        }
        this.building = Collections.unmodifiableList(tmpBuilding);
        this.archived = Collections.unmodifiableList(tmpArchived);
        this.disabled = Collections.unmodifiableList(tmpDisabled);
    }
}

