/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LindormTableInfoOptions
extends VersionedObjectWithAttributes {
    private static final String TABLE_SIZE_OPTIONS = "TABLE_SIZE_OPTION";
    private static final String INDEX_OPTION = "INDEX_OPTION";
    public static final String INDEX_NAMES = "INDEX_NAMES";
    private String idcName;
    private String namespace;
    private String tableName;

    public LindormTableInfoOptions() {
    }

    public LindormTableInfoOptions(String namespace, String tableName) {
        this(null, namespace, tableName);
    }

    public LindormTableInfoOptions(String idcName, String namespace, String tableName) {
        this.idcName = idcName;
        this.namespace = namespace;
        this.tableName = tableName;
    }

    public String getIdcName() {
        return this.idcName;
    }

    public void setIdcName(String idcName) {
        this.idcName = idcName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTableSizeOption(TableSizeOption sizeOption) {
        this.setAttribute(TABLE_SIZE_OPTIONS, sizeOption.name());
    }

    public TableSizeOption getTableSizeOption() {
        String optionString = this.getAttribute(TABLE_SIZE_OPTIONS, TableSizeOption.GET_STORE_FILE_SIZE.name());
        return TableSizeOption.valueOf(optionString);
    }

    public void setIndexOption(IndexOption option) throws IllegalRequestException {
        if (option == IndexOption.SPECIFIC_INDEX_ONLY || option == IndexOption.INCLUDE_SPECIFIC_INDEX) {
            throw new IllegalRequestException("Please call the override method to set index names for " + (Object)((Object)option));
        }
        this.setAttribute(INDEX_OPTION, option.name());
    }

    public void setIndexNames(IndexOption option, List<String> indexNames) throws IllegalRequestException {
        if (option != IndexOption.SPECIFIC_INDEX_ONLY && option != IndexOption.INCLUDE_SPECIFIC_INDEX) {
            throw new IllegalRequestException("Please call the override method to set index option without index names for " + (Object)((Object)option));
        }
        this.setAttribute(INDEX_OPTION, option.name());
        this.setAttribute(INDEX_NAMES, SchemaUtils.indexNamesToBytes(indexNames));
    }

    public IndexOption getIndexOption() {
        String optionString = this.getAttribute(INDEX_OPTION, IndexOption.NO_INDEX.name());
        return IndexOption.valueOf(optionString);
    }

    public List<String> getIndexNames() {
        byte[] indexNameBytes = this.getAttribute(INDEX_NAMES);
        if (indexNameBytes != null) {
            return SchemaUtils.indexNamesFromBytes(indexNameBytes);
        }
        return null;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.idcName);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.idcName = WritableUtils.readString(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof LindormTableInfoOptions)) {
            return false;
        }
        LindormTableInfoOptions other = (LindormTableInfoOptions)obj;
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        if (!this.tableName.equals(other.tableName)) {
            return false;
        }
        if (!this.getTableSizeOption().name().equals(other.getTableSizeOption().name())) {
            return false;
        }
        return this.getIndexOption().name().equals(other.getIndexOption().name());
    }

    public int hashCode() {
        int prime = 37;
        int result = this.namespace.hashCode() + prime * this.tableName.hashCode() + prime * prime * this.getIndexOption().hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtils.isNullOrEmpty(this.idcName) ? "" : this.idcName + ":");
        builder.append(this.namespace);
        builder.append(".");
        builder.append(this.tableName);
        builder.append(", params");
        builder.append(this.getAttributesMap().size());
        builder.append("[");
        for (Map.Entry<String, byte[]> entry : this.getAttributesMap().entrySet()) {
            builder.append(entry.getKey());
            builder.append(" => ");
            builder.append(Bytes.toString(entry.getValue()));
        }
        builder.append("]");
        return builder.toString();
    }

    public static enum IndexOption {
        NO_INDEX,
        INCLUDE_ALL_INDEX,
        SPECIFIC_INDEX_ONLY,
        INCLUDE_SPECIFIC_INDEX;

    }

    public static enum TableSizeOption {
        GET_STORE_FILE_SIZE,
        GET_DFS_DIR_SIZE;

    }
}

