/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.DataType;

public class RowTTLSchema
implements Comparable<RowTTLSchema> {
    public static final String DELIMETER = "\\|";
    private byte[] column;
    private boolean expireKvsOnRead = true;
    private RowTimeType type;
    private LColumn lcolumn;

    public RowTTLSchema() {
        this.expireKvsOnRead = true;
        this.type = RowTimeType.TTLCOLUMN;
    }

    public RowTTLSchema(byte[] column, boolean expireKvsOnRead, RowTimeType type) {
        this.column = column;
        this.expireKvsOnRead = expireKvsOnRead;
        this.type = type;
    }

    public void setColumn(byte[] column) {
        this.column = column;
    }

    public byte[] getColumn() {
        return this.column;
    }

    public void setType(RowTimeType type) {
        this.type = type;
    }

    public RowTimeType getType() {
        return this.type;
    }

    public void setExpireKvsOnRead(boolean expireKvsOnRead) {
        this.expireKvsOnRead = expireKvsOnRead;
    }

    public boolean isExpireKvsOnRead() {
        return this.expireKvsOnRead;
    }

    public LColumn getLcolumn() {
        return this.lcolumn;
    }

    public void setLcolumn(LColumn lcolumn) {
        this.lcolumn = lcolumn;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RowTTLSchema)) {
            return false;
        }
        return this.compareTo((RowTTLSchema)obj) == 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.expireKvsOnRead ? 0 : 1);
        hash = 31 * hash + (this.column == null ? 0 : this.column.hashCode());
        hash = 31 * hash + (this.type == null ? 0 : this.type.hashCode());
        return hash;
    }

    @Override
    public int compareTo(RowTTLSchema o) {
        int result = Bytes.compareTo(this.column, o.column);
        if (result == 0) {
            int n = result = this.expireKvsOnRead == o.expireKvsOnRead ? 0 : 1;
        }
        if (result == 0) {
            result = this.type.getName().equals(o.getType().getName()) ? 0 : 1;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("COLUMN=");
        sb.append(Bytes.toString(this.column));
        if (this.type != RowTimeType.TTLCOLUMN) {
            sb.append("|TYPE=");
            sb.append(this.type.toString());
        }
        if (!this.expireKvsOnRead) {
            sb.append("|EXPIREONREAD=");
            sb.append(Boolean.toString(this.expireKvsOnRead));
        }
        return sb.toString();
    }

    public static RowTTLSchema fromString(String schema) {
        String[] parts = schema.split(DELIMETER);
        if (parts.length < 1 || parts.length > 3) {
            throw new IllegalArgumentException("Invalid schema type " + schema + ", Example" + "COLUMN=column" + "COLUMN=column|TYPE=TTLCOLUMN " + "COLUMN=column|TYPE=TTLCOLUMN|EXPIREONREAD=true ");
        }
        RowTTLSchema ttlSchema = new RowTTLSchema();
        boolean columnSet = false;
        for (String part : parts) {
            String[] configParts = part.split("=");
            if (configParts.length != 2) {
                throw new IllegalArgumentException("Invalid schema type " + schema + ", Example" + "COLUMN=column" + "COLUMN=column|TYPE=TTLCOLUMN " + "COLUMN=column|TYPE=TTLCOLUMN|EXPIREONREAD=true ");
            }
            if (configParts[0].equals("COLUMN")) {
                columnSet = true;
                ttlSchema.setColumn(Bytes.toBytes(configParts[1]));
            }
            if (configParts[0].equals("TYPE")) {
                ttlSchema.setType(RowTimeType.valueOf(configParts[1]));
            }
            if (!configParts[0].equals("EXPIREONREAD")) continue;
            ttlSchema.setExpireKvsOnRead(Boolean.valueOf(configParts[1]));
        }
        if (!columnSet) {
            throw new IllegalArgumentException("Invalid schema type " + schema + ", Example" + "COLUMN=column" + "COLUMN=column|TYPE=TTLCOLUMN " + "COLUMN=column|TYPE=TTLCOLUMN|EXPIREONREAD=true ");
        }
        return ttlSchema;
    }

    public static void validateRowTTLSchema(TableMeta tableMeta) throws LindormException {
        FamilyAttributes attributes = tableMeta.getFamilyAttributes();
        RowTTLSchema ttlSchema = attributes.getRowTTLSchema();
        if (ttlSchema != null) {
            if (tableMeta.getFamilies().size() > 1 || tableMeta.getFamilies().size() == 1 && !SchemaUtils.isDefaultFamily(tableMeta.getFamilies().get(0).getName()) && SchemaUtils.hasDefaultFamilyByMeta(tableMeta.getNonPkColumns())) {
                throw new LindormException("Default ROW TTL Schema can only be set on Single family table");
            }
            if (tableMeta.getFamilies().isEmpty()) {
                RowTTLSchema.verify(tableMeta, SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, ttlSchema);
            } else {
                RowTTLSchema.verify(tableMeta, tableMeta.getFamilies().get(0).getName(), ttlSchema);
            }
        }
        for (ColumnFamilyDescriptor descriptor : tableMeta.getFamilies()) {
            FamilyAttributes colAttributes = descriptor.getFamilyAttributes();
            ttlSchema = colAttributes.getRowTTLSchema();
            if (ttlSchema == null) continue;
            RowTTLSchema.verify(tableMeta, descriptor.getName(), ttlSchema);
        }
    }

    private static void verify(TableMeta meta, byte[] familyName, RowTTLSchema ttlSchema) throws LindormException {
        if (ttlSchema.getColumn() == null) {
            throw new LindormException("Must explicitly specify column name for ROWTTL");
        }
        for (LColumn lcolumn : meta.getNonPkColumns()) {
            if (lcolumn.getFamilyName() == null) {
                if (!Bytes.equals(lcolumn.getColumnName(), ttlSchema.getColumn()) || !Bytes.equals(SchemaUtils.DEFAULT_FAMILY_NAME_BYTES, familyName)) continue;
                if (lcolumn.getDataType().getClientType() == DataType.INT) break;
                throw new LindormException("Row TTL column must be Int type");
            }
            if (!Bytes.equals(lcolumn.getColumnName(), ttlSchema.getColumn()) || !Bytes.equals(lcolumn.getFamilyName(), familyName)) continue;
            if (lcolumn.getDataType().getClientType() == DataType.INT) break;
            throw new LindormException("Row TTL column must be Int type");
        }
    }

    public static enum RowTimeType {
        OLDEST("OLDEST"),
        LATEST("LATEST"),
        TTLCOLUMN("TTLCOLUMN");

        final String name;

        private RowTimeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static RowTimeType fromString(String typeString) {
            for (RowTimeType type : RowTimeType.values()) {
                if (!type.getName().equals(typeString)) continue;
                return type;
            }
            throw new UnsupportedOperationException("Unknown Row TTL type" + typeString);
        }
    }
}

