/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.client.ExtendedElementConvertor;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.meta.FamilyAttributes;
import com.alibaba.lindorm.client.core.meta.SilenceIndex;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.utils.BytesKeyAttributes;
import com.alibaba.lindorm.client.core.utils.DataInputBuffer;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WColumn;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBinaryPrefixComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WBitComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnCountGetFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnPaginationFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnRangeFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WColumnValueFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WDependentColumnFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFamilyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilterList;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFirstKeyOnlyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFirstKeyValueMatchingQualifiersFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFuzzyRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WInclusiveStopFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WKeyOnlyFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WMultiRowRangeFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WMultipleColumnPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WNullComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WPageFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WPrefixFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WQualifierFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRandomRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRegexStringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WRowFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSingleColumnValueExcludeFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSingleColumnValueFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSkipFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WSubstringComparator;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WTimestampsFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WValueFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WWhileMatchFilter;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.LeaseException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.exception.NameSpaceNotFoundException;
import com.alibaba.lindorm.client.exception.QuotaExceededException;
import com.alibaba.lindorm.client.exception.TableNotEnabledException;
import com.alibaba.lindorm.client.exception.TableNotFoundException;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.Mutability;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.BigDecimalColumnInterpreter;
import org.apache.hadoop.hbase.client.coprocessor.DoubleColumnInterpreter;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.client.index.AliHBaseColumn;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;

public class ElementConvertor {
    private static final long DEFAULT_MAX_RESULT_SIZE = -1L;
    private static final String TABLEMETAVERSION = "TABLEMETAVERSION";
    private static final byte[] TABLEMETAVERSIONBYTES = Bytes.toBytes((String)"TABLEMETAVERSION");
    private static final String COLD_HOT_COLD_STORAGETYPE_CONFIG = "storagetype=COLD";
    private static final byte[] ROWKEY_NAME = Bytes.toBytes((String)"ROW");
    private static final Map<String, DataType> INTERPRETER_DATATYPE_MAP = new HashMap<String, DataType>();
    public static ExtendedElementConvertor EXTENDED_CONVERTTOR = new ExtendedElementConvertor();

    private static WColumn.Type convertTypeToWType(byte type) {
        switch (KeyValue.Type.codeToType((byte)type)) {
            case Minimum: {
                return WColumn.Type.Minimum;
            }
            case Put: {
                return WColumn.Type.Put;
            }
            case Delete: {
                return WColumn.Type.Delete;
            }
            case DeleteColumn: {
                return WColumn.Type.DeleteColumn;
            }
            case DeleteFamily: {
                return WColumn.Type.DeleteFamily;
            }
            case Maximum: {
                return WColumn.Type.Maximum;
            }
        }
        throw new UnsupportedOperationException("Unsupport op type " + KeyValue.Type.codeToType((byte)type));
    }

    private static KeyValue.Type convertWTypeToHType(WColumn.Type type) {
        switch (type) {
            case Minimum: {
                return KeyValue.Type.Minimum;
            }
            case Put: {
                return KeyValue.Type.Put;
            }
            case Delete: {
                return KeyValue.Type.Delete;
            }
            case DeleteColumn: {
                return KeyValue.Type.DeleteColumn;
            }
            case DeleteFamily: {
                return KeyValue.Type.DeleteFamily;
            }
            case Maximum: {
                return KeyValue.Type.Maximum;
            }
        }
        throw new UnsupportedOperationException("Unsupport op type " + (Object)((Object)type));
    }

    public static WDelete toLindormDelete(Delete delete) throws IOException {
        ElementConvertor.checkDeleteSupport(delete);
        WDelete wdel = new WDelete(delete.getRow(), delete.getTimestamp());
        for (Map.Entry entry : delete.getFamilyCellMap().entrySet()) {
            for (Cell kv : (List)entry.getValue()) {
                wdel.addDeleteMarker(new WColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv), kv.getTimestamp(), ElementConvertor.convertTypeToWType(kv.getType().getCode())));
            }
        }
        ElementConvertor.copyAttributes(wdel, delete.getAttributesMap());
        return wdel;
    }

    public static List<Delete> toHBaseDeletes(List<WDelete> in) throws IOException {
        ArrayList<Delete> out = new ArrayList<Delete>(in.size());
        for (WDelete delete : in) {
            out.add(ElementConvertor.toHBaseDelete(delete));
        }
        return out;
    }

    public static Delete toHBaseDelete(WDelete in) {
        Delete out = new Delete(in.getRowKey());
        Map<byte[], List<WColumn>> familyMap = in.getFamilyMap();
        for (byte[] family : familyMap.keySet()) {
            for (WColumn columnValue : familyMap.get(family)) {
                byte[] qualifier = columnValue.getQualifier();
                long timestamp = columnValue.getTs();
                if (columnValue.getType() == WColumn.Type.Delete) {
                    out.addColumn(family, qualifier, timestamp);
                    continue;
                }
                if (columnValue.getType() == WColumn.Type.DeleteColumn) {
                    out.addColumns(family, qualifier, timestamp);
                    continue;
                }
                if (columnValue.getType() != WColumn.Type.DeleteFamily) continue;
                out.addFamily(family, timestamp);
            }
        }
        return out;
    }

    private static void checkPutSupport(Put in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Put#setACL() is not supported");
        }
    }

    private static void checkIncrementSupport(Increment in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Increment#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Increment#setTTL() is not supported");
        }
    }

    private static void checkAppendSupport(Append in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Append#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Append#setTTL() is not supported");
        }
    }

    private static void checkDeleteSupport(Delete in) throws IOException {
        if (in.getACL() != null) {
            throw new IOException("Delete#setACL() is not supported");
        }
        if (in.getTTL() != Long.MAX_VALUE) {
            throw new IOException("Delete#setTTL() is not supported");
        }
    }

    public static List<WDelete> toLindormDeleteList(List<Delete> in) throws IOException {
        ArrayList<WDelete> out = new ArrayList<WDelete>(in.size());
        for (Delete delete : in) {
            if (delete == null) continue;
            out.add(ElementConvertor.toLindormDelete(delete));
        }
        return out;
    }

    private static boolean isQueryHotOnly(Query query) {
        byte[] value = query.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean((byte[])value);
    }

    private static boolean isHotColdAutoMerge(Query query) {
        byte[] value = query.getAttribute("COLD_HOT_MERGE");
        return value != null && Bytes.toBoolean((byte[])value);
    }

    public static WGet toLindormGet(Get get2) throws IOException {
        ElementConvertor.checkGetRowSupport(get2);
        WGet wget = new WGet(get2.getRow());
        wget.setCacheBlocks(get2.getCacheBlocks());
        wget.setMaxVersions(get2.getMaxVersions());
        TimeRange tr = get2.getTimeRange();
        if (!tr.isAllTime()) {
            wget.setTimeRange(tr.getMin(), tr.getMax());
        }
        wget.setFamilyMap(get2.getFamilyMap());
        wget.setFilter(ElementConvertor.toLindormFilter(get2.getFilter()));
        if (ElementConvertor.isQueryHotOnly((Query)get2)) {
            wget.setQueryHotOnly(true);
        } else if (ElementConvertor.isHotColdAutoMerge((Query)get2)) {
            wget.setHotColdAutoMerge(true);
        }
        ElementConvertor.copyAttributes(wget, get2.getAttributesMap());
        return wget;
    }

    private static void checkGetRowSupport(Get in) throws IOException {
        if (in.isClosestRowBefore()) {
            throw new IOException("Get#setClosestRowBefore(true) is not supported");
        }
        if (in.getACL() != null) {
            throw new IOException("Get#setACL() is not supported");
        }
    }

    static WFilter toLindormFilter(Filter filter) throws IOException {
        if (filter == null) {
            return null;
        }
        if (filter instanceof FilterList) {
            FilterList filterList = (FilterList)filter;
            WFilterList wlist = null;
            wlist = filterList.getOperator() == FilterList.Operator.MUST_PASS_ALL ? new WFilterList(WFilterList.Operator.MUST_PASS_ALL) : new WFilterList(WFilterList.Operator.MUST_PASS_ONE);
            for (Filter childFilter : filterList.getFilters()) {
                wlist.addFilter(ElementConvertor.toLindormFilter(childFilter));
            }
            return wlist;
        }
        if (filter instanceof SingleColumnValueExcludeFilter) {
            SingleColumnValueExcludeFilter sFilter = (SingleColumnValueExcludeFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WSingleColumnValueExcludeFilter(sFilter.getFamily(), sFilter.getQualifier(), op, wComparator);
        }
        if (filter instanceof SingleColumnValueFilter) {
            SingleColumnValueFilter sFilter = (SingleColumnValueFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            WSingleColumnValueFilter wsFilter = new WSingleColumnValueFilter(sFilter.getFamily(), sFilter.getQualifier(), op, wComparator);
            wsFilter.setLatestVersionOnly(sFilter.getLatestVersionOnly());
            wsFilter.setFilterIfMissing(sFilter.getFilterIfMissing());
            return wsFilter;
        }
        if (filter instanceof ColumnCountGetFilter) {
            ColumnCountGetFilter sFilter = (ColumnCountGetFilter)filter;
            return new WColumnCountGetFilter(sFilter.getLimit());
        }
        if (filter instanceof ColumnPrefixFilter) {
            ColumnPrefixFilter sFilter = (ColumnPrefixFilter)filter;
            return new WColumnPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof ColumnRangeFilter) {
            ColumnRangeFilter sFilter = (ColumnRangeFilter)filter;
            return new WColumnRangeFilter(sFilter.getMinColumn(), sFilter.getMinColumnInclusive(), sFilter.getMaxColumn(), sFilter.getMaxColumnInclusive());
        }
        if (filter instanceof DependentColumnFilter) {
            DependentColumnFilter sFilter = (DependentColumnFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = null;
            if (null != sFilter.getComparator()) {
                wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            }
            return new WDependentColumnFilter(sFilter.getFamily(), sFilter.getQualifier(), sFilter.getDropDependentColumn(), op, wComparator);
        }
        if (filter instanceof FamilyFilter) {
            FamilyFilter sFilter = (FamilyFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WFamilyFilter(op, wComparator);
        }
        if (filter instanceof QualifierFilter) {
            QualifierFilter sFilter = (QualifierFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WQualifierFilter(op, wComparator);
        }
        if (filter instanceof RowFilter) {
            RowFilter sFilter = (RowFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WRowFilter(op, wComparator);
        }
        if (filter instanceof ValueFilter) {
            ValueFilter sFilter = (ValueFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(sFilter.getOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(sFilter.getComparator());
            return new WValueFilter(op, wComparator);
        }
        if (filter instanceof FirstKeyValueMatchingQualifiersFilter) {
            FirstKeyValueMatchingQualifiersFilter firstKeyValueMatchingQualifiersFilter = (FirstKeyValueMatchingQualifiersFilter)filter;
            return new WFirstKeyValueMatchingQualifiersFilter(ElementConvertor.getQualifierFromFirstKeyValueMatchingQualifiersFilter(firstKeyValueMatchingQualifiersFilter));
        }
        if (filter instanceof FirstKeyOnlyFilter) {
            return new WFirstKeyOnlyFilter();
        }
        if (filter instanceof InclusiveStopFilter) {
            InclusiveStopFilter sFilter = (InclusiveStopFilter)filter;
            return new WInclusiveStopFilter(sFilter.getStopRowKey());
        }
        if (filter instanceof MultipleColumnPrefixFilter) {
            MultipleColumnPrefixFilter sFilter = (MultipleColumnPrefixFilter)filter;
            return new WMultipleColumnPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof PrefixFilter) {
            PrefixFilter sFilter = (PrefixFilter)filter;
            return new WPrefixFilter(sFilter.getPrefix());
        }
        if (filter instanceof RandomRowFilter) {
            RandomRowFilter sFilter = (RandomRowFilter)filter;
            return new WRandomRowFilter(sFilter.getChance());
        }
        if (filter instanceof SkipFilter) {
            SkipFilter sFilter = (SkipFilter)filter;
            return new WSkipFilter(ElementConvertor.toLindormFilter(sFilter.getFilter()));
        }
        if (filter instanceof TimestampsFilter) {
            TimestampsFilter sFilter = (TimestampsFilter)filter;
            return new WTimestampsFilter(sFilter.getTimestamps());
        }
        if (filter instanceof WhileMatchFilter) {
            WhileMatchFilter sFilter = (WhileMatchFilter)filter;
            return new WWhileMatchFilter(ElementConvertor.toLindormFilter(sFilter.getFilter()));
        }
        if (filter instanceof FuzzyRowFilter) {
            FilterProtos.FuzzyRowFilter proto;
            FuzzyRowFilter fuzzyRowFilter = (FuzzyRowFilter)filter;
            byte[] bytes = fuzzyRowFilter.toByteArray();
            try {
                proto = FilterProtos.FuzzyRowFilter.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e);
            }
            int count = proto.getFuzzyKeysDataCount();
            ArrayList<Pair<byte[], byte[]>> fuzzyKeysData = new ArrayList<Pair<byte[], byte[]>>(count);
            for (int i = 0; i < count; ++i) {
                HBaseProtos.BytesBytesPair current = proto.getFuzzyKeysData(i);
                byte[] keyBytes = current.getFirst().toByteArray();
                byte[] keyMeta = current.getSecond().toByteArray();
                keyMeta = ElementConvertor.maskAdapter(keyMeta);
                fuzzyKeysData.add(new Pair<byte[], byte[]>(keyBytes, keyMeta));
            }
            return new WFuzzyRowFilter(fuzzyKeysData);
        }
        if (filter instanceof KeyOnlyFilter) {
            FilterProtos.KeyOnlyFilter proto;
            KeyOnlyFilter keyOnlyFilter = (KeyOnlyFilter)filter;
            byte[] bytes = keyOnlyFilter.toByteArray();
            try {
                proto = FilterProtos.KeyOnlyFilter.parseFrom((byte[])bytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e);
            }
            return new WKeyOnlyFilter(proto.getLenAsVal());
        }
        if (filter instanceof PageFilter) {
            PageFilter pageFilter = (PageFilter)filter;
            return new WPageFilter(pageFilter.getPageSize());
        }
        if (filter instanceof ColumnPaginationFilter) {
            ColumnPaginationFilter columnPaginationFilter = (ColumnPaginationFilter)filter;
            return new WColumnPaginationFilter(columnPaginationFilter.getLimit(), columnPaginationFilter.getOffset());
        }
        if (filter instanceof MultiRowRangeFilter) {
            MultiRowRangeFilter multiRowRangeFilter = (MultiRowRangeFilter)filter;
            return new WMultiRowRangeFilter(ElementConvertor.convertToWRowRangeList(multiRowRangeFilter.getRowRanges()));
        }
        if (filter instanceof ColumnValueFilter) {
            ColumnValueFilter columnValueFilter = (ColumnValueFilter)filter;
            WCompareFilter.CompareOp op = ElementConvertor.toLindormCompareOp(columnValueFilter.getCompareOperator());
            WByteArrayComparable wComparator = ElementConvertor.toLindormComparator(columnValueFilter.getComparator());
            WColumnValueFilter wColumnValueFilter = new WColumnValueFilter(columnValueFilter.getFamily(), columnValueFilter.getQualifier(), op, wComparator);
            return wColumnValueFilter;
        }
        if (EXTENDED_CONVERTTOR != null) {
            return EXTENDED_CONVERTTOR.toLindormFilter(filter);
        }
        throw new IOException("Unsupport filter " + filter.getClass().getName());
    }

    public static List<WMultiRowRangeFilter.WRowRange> convertToWRowRangeList(List<MultiRowRangeFilter.RowRange> rowRanges) {
        ArrayList<WMultiRowRangeFilter.WRowRange> ranges = new ArrayList<WMultiRowRangeFilter.WRowRange>();
        for (MultiRowRangeFilter.RowRange rowRange : rowRanges) {
            ranges.add(ElementConvertor.convertToWRowRange(rowRange));
        }
        return ranges;
    }

    public static WMultiRowRangeFilter.WRowRange convertToWRowRange(MultiRowRangeFilter.RowRange rowRange) {
        return new WMultiRowRangeFilter.WRowRange(rowRange.getStartRow(), rowRange.isStartRowInclusive(), rowRange.getStopRow(), rowRange.isStopRowInclusive());
    }

    private static Set<byte[]> getQualifierFromFirstKeyValueMatchingQualifiersFilter(FirstKeyValueMatchingQualifiersFilter filter) throws IOException {
        try {
            Field field = FirstKeyValueMatchingQualifiersFilter.class.getDeclaredField("qualifiers");
            field.setAccessible(true);
            return (Set)field.get(filter);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static byte[] maskAdapter(byte[] mask) {
        if (!ElementConvertor.isPreprocessedMask(mask)) {
            return mask;
        }
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1) {
                mask[i] = 0;
                continue;
            }
            if (mask[i] != 2) continue;
            mask[i] = 1;
        }
        return mask;
    }

    private static boolean isPreprocessedMask(byte[] mask) {
        for (int i = 0; i < mask.length; ++i) {
            if (mask[i] == -1 || mask[i] == 2) continue;
            return false;
        }
        return true;
    }

    public static WCompareFilter.CompareOp toLindormCompareOp(CompareFilter.CompareOp operator) throws IOException {
        switch (operator) {
            case LESS: {
                return WCompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return WCompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return WCompareFilter.CompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return WCompareFilter.CompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return WCompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return WCompareFilter.CompareOp.GREATER;
            }
            case NO_OP: {
                return WCompareFilter.CompareOp.NO_OP;
            }
        }
        throw new IOException("Unkown operator " + operator);
    }

    public static WCompareFilter.CompareOp toLindormCompareOp(CompareOperator operator) throws IOException {
        switch (operator) {
            case LESS: {
                return WCompareFilter.CompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return WCompareFilter.CompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return WCompareFilter.CompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return WCompareFilter.CompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return WCompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return WCompareFilter.CompareOp.GREATER;
            }
            case NO_OP: {
                return WCompareFilter.CompareOp.NO_OP;
            }
        }
        throw new IOException("Unkown operator " + operator);
    }

    private static WBitComparator.BitwiseOp toLindormBitwiseOp(BitComparator.BitwiseOp bitwiseOp) throws IOException {
        switch (bitwiseOp) {
            case AND: {
                return WBitComparator.BitwiseOp.AND;
            }
            case OR: {
                return WBitComparator.BitwiseOp.OR;
            }
            case XOR: {
                return WBitComparator.BitwiseOp.XOR;
            }
        }
        throw new IOException("Unkown BitwiseOp " + bitwiseOp);
    }

    private static WByteArrayComparable toLindormComparator(ByteArrayComparable comparator) throws IOException {
        if (comparator instanceof BinaryComparator) {
            return new WBinaryComparator(comparator.getValue());
        }
        if (comparator instanceof BinaryPrefixComparator) {
            return new WBinaryPrefixComparator(comparator.getValue());
        }
        if (comparator instanceof BitComparator) {
            WBitComparator.BitwiseOp wbitWistOp = ElementConvertor.toLindormBitwiseOp(((BitComparator)comparator).getOperator());
            return new WBitComparator(comparator.getValue(), wbitWistOp);
        }
        if (comparator instanceof NullComparator) {
            return new WNullComparator();
        }
        if (comparator instanceof RegexStringComparator) {
            ComparatorProtos.RegexStringComparator proto;
            try {
                proto = ComparatorProtos.RegexStringComparator.parseFrom((byte[])comparator.toByteArray());
            }
            catch (InvalidProtocolBufferException e) {
                throw new IOException(e.getMessage());
            }
            return new WRegexStringComparator(proto.getPattern());
        }
        if (comparator instanceof SubstringComparator) {
            return new WSubstringComparator(Bytes.toString((byte[])comparator.getValue()));
        }
        throw new IOException("Unknow comparator " + comparator);
    }

    public static List<Put> toHBasePuts(List<WPut> in) {
        ArrayList<Put> out = new ArrayList<Put>(in.size());
        for (WPut put2 : in) {
            out.add(ElementConvertor.toHBasePut(put2));
        }
        return out;
    }

    public static Put toHBasePut(WPut in) {
        if (in.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        Put out = new Put(in.getRowKey());
        Map<byte[], List<WColumn>> familyMap = in.getFamilyMap();
        for (byte[] family : familyMap.keySet()) {
            for (WColumn col : familyMap.get(family)) {
                out.addColumn(col.getFamily(), col.getQualifier(), col.getTs(), col.getValue());
            }
        }
        return out;
    }

    public static List<WPut> toLindormPuts(List<Put> in) throws IOException {
        ArrayList<WPut> out = new ArrayList<WPut>(in.size());
        for (Put put2 : in) {
            out.add(ElementConvertor.toLindormPut(put2));
        }
        return out;
    }

    public static WPut toLindormPut(Put put2) throws IOException {
        if (put2.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        ElementConvertor.checkPutSupport(put2);
        WPut wput = new WPut(put2.getRow());
        for (List list : put2.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                wput.add(new WColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv), kv.getTimestamp(), ElementConvertor.convertTypeToWType(kv.getType().getCode())));
            }
        }
        ElementConvertor.copyAttributes(wput, put2.getAttributesMap());
        return wput;
    }

    public static WIncrement toLindormIncrement(Increment inc) throws IOException {
        if (inc.isEmpty()) {
            throw new IllegalArgumentException("No incremented values found.");
        }
        ElementConvertor.checkIncrementSupport(inc);
        WIncrement winc = new WIncrement(inc.getRow(), inc.getTimeStamp());
        for (List list : inc.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                winc.addColumn(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kv)));
            }
        }
        winc.setTimeRange(inc.getTimeRange().getMin(), inc.getTimeRange().getMax());
        ElementConvertor.copyAttributes(winc, inc.getAttributesMap());
        return winc;
    }

    public static WAppend toLindormAppend(Append append2) throws IOException {
        if (append2.isEmpty()) {
            throw new IllegalArgumentException("No append values found.");
        }
        ElementConvertor.checkAppendSupport(append2);
        WAppend wAppend = new WAppend(append2.getRow(), append2.getTimeStamp());
        for (List list : append2.getFamilyCellMap().values()) {
            for (Cell kv : list) {
                wAppend.add(CellUtil.cloneFamily((Cell)kv), CellUtil.cloneQualifier((Cell)kv), CellUtil.cloneValue((Cell)kv));
            }
        }
        wAppend.setReturnResults(append2.isReturnResults());
        ElementConvertor.copyAttributes(wAppend, append2.getAttributesMap());
        return wAppend;
    }

    static byte[] createClosestRowAfter(byte[] row) {
        return Arrays.copyOf(row, row.length + 1);
    }

    public static WScan toLindormScan(Scan scan) throws IOException {
        TimeRange timeRange;
        ElementConvertor.checkScanSupport(scan);
        byte[] startRow = scan.getStartRow();
        byte[] stopRow = scan.getStopRow();
        if (!Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])startRow) && !scan.includeStartRow()) {
            startRow = ElementConvertor.createClosestRowAfter(startRow);
        }
        if (!Bytes.equals((byte[])HConstants.EMPTY_END_ROW, (byte[])stopRow) && scan.includeStopRow()) {
            stopRow = ElementConvertor.createClosestRowAfter(stopRow);
        }
        WScan wScan = new WScan(startRow, stopRow);
        wScan.setFamilyMap(scan.getFamilyMap());
        wScan.setCacheBlocks(scan.getCacheBlocks());
        wScan.setCaching(scan.getCaching());
        if (scan.getMaxResultSize() > 0L) {
            wScan.setMaxResultSize(scan.getMaxResultSize());
        }
        if (scan.getRowOffsetPerColumnFamily() > 0) {
            wScan.setOffset(scan.getRowOffsetPerColumnFamily());
        }
        if (scan.getMaxResultsPerColumnFamily() > 0) {
            wScan.setLimit(scan.getMaxResultsPerColumnFamily());
        }
        if (scan.getLimit() >= 0) {
            wScan.setLimit(scan.getLimit());
        }
        wScan.setReversed(scan.isReversed());
        if (scan.getMaxVersions() > 1) {
            wScan.setMaxVersions(scan.getMaxVersions());
        }
        if (!(timeRange = scan.getTimeRange()).isAllTime()) {
            wScan.setTimeRange(timeRange.getMin(), timeRange.getMax());
        }
        wScan.setRaw(scan.isRaw());
        wScan.setIsolationLevel(ElementConvertor.toLindormIsolationLevel(scan.getIsolationLevel()));
        if (scan.getFilter() != null) {
            wScan.setFilter(ElementConvertor.toLindormFilter(scan.getFilter()));
        }
        if (scan.getAttribute("ALLOW_FULL_TALBE_SCAN") != null) {
            boolean allowFilter = Bytes.toBoolean((byte[])scan.getAttribute("ALLOW_FULL_TALBE_SCAN"));
            wScan.setAllowFiltering(allowFilter);
        }
        if (ElementConvertor.isQueryHotOnly((Query)scan)) {
            wScan.setQueryHotOnly(true);
        } else if (ElementConvertor.isHotColdAutoMerge((Query)scan)) {
            wScan.setHotColdAutoMerge(true);
        }
        ElementConvertor.copyAttributes(wScan, scan.getAttributesMap());
        return wScan;
    }

    private static WScan.IsolationLevel toLindormIsolationLevel(IsolationLevel isolationLevel) throws IOException {
        switch (isolationLevel) {
            case READ_COMMITTED: {
                return WScan.IsolationLevel.READ_COMMITTED;
            }
            case READ_UNCOMMITTED: {
                return WScan.IsolationLevel.READ_UNCOMMITTED;
            }
        }
        throw new IOException("Unkown isolationLevel " + isolationLevel);
    }

    private static void checkScanSupport(Scan in) throws IOException {
    }

    public static List<WGet> toLindormGets(List<Get> in) throws IOException {
        ArrayList<WGet> out = new ArrayList<WGet>(in.size());
        for (Get get2 : in) {
            out.add(ElementConvertor.toLindormGet(get2));
        }
        return out;
    }

    public static Result[] toHBaseResults(List<WResult> in) {
        ArrayList<Result> out = new ArrayList<Result>(in.size());
        for (WResult result : in) {
            out.add(ElementConvertor.toHBaseResult(result));
        }
        return out.toArray(new Result[0]);
    }

    public static Result[] toHBaseResults(WResult[] in) {
        ArrayList<Result> out = new ArrayList<Result>(in.length);
        for (WResult result : in) {
            out.add(ElementConvertor.toHBaseResult(result));
        }
        return out.toArray(new Result[0]);
    }

    public static Result[] toHBaseResults(WResult[] in, List<Get> gets) {
        ArrayList<Result> out = new ArrayList<Result>(in.length);
        for (int i = 0; i < in.length; ++i) {
            out.add(ElementConvertor.toHBaseResult(in[i], gets.get(i).isCheckExistenceOnly()));
        }
        return out.toArray(new Result[0]);
    }

    public static Result toHBaseResult(WResult in) {
        return ElementConvertor.toHBaseResult(in, false);
    }

    public static Result toHBaseResult(WResult in, boolean isCheckExistenceOnly) {
        Cell[] cells = new Cell[in.size()];
        int i = 0;
        for (WColumn c : in.raw()) {
            Cell cell;
            cells[i] = cell = CellUtil.createCell((byte[])in.getRowKey(), (byte[])c.getFamily(), (byte[])c.getQualifier(), (long)c.getTs(), (byte)ElementConvertor.convertWTypeToHType(c.getType()).getCode(), (byte[])c.getValue());
            ++i;
        }
        Arrays.sort(cells, CellComparator.getInstance());
        return Result.create((Cell[])cells, isCheckExistenceOnly ? Boolean.valueOf(cells.length != 0) : null, (boolean)false);
    }

    public static HColumnDescriptor toHbasecolumnFamilyDescriptor(LindormTableDescriptor tableDescriptor, com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor in) {
        String value;
        String key;
        HColumnDescriptor builder = new HColumnDescriptor(in.getName());
        builder.setValue("COMPRESSION", tableDescriptor.getCompression());
        builder.setValue("DATA_BLOCK_ENCODING", tableDescriptor.getDataBlockEncoding());
        if (tableDescriptor.getFamilyAttributes().getDfsReplicationNoDefault() != null) {
            builder.setDFSReplication(tableDescriptor.getDfsReplication());
        }
        builder.setMaxVersions(tableDescriptor.getMaxVersions());
        builder.setMinVersions(tableDescriptor.getMinVersions());
        builder.setTimeToLive(tableDescriptor.getTimeToLive());
        builder.setStoragePolicy(tableDescriptor.getStorageType());
        builder.setValue("CHS", tableDescriptor.getColdHotSeparateBoundary());
        for (int i = 1; i <= 5; ++i) {
            key = "CHS_L" + i;
            value = tableDescriptor.getColdHotLayerConfig(i);
            builder.setValue(key, value);
        }
        builder.setValue("CHS_PROMOTE_ON_MAJOR", Boolean.toString(tableDescriptor.isColdHotPromoteOnMajor()));
        builder.setBloomFilterType(BloomType.valueOf((String)in.getBloomFilterType()));
        builder.setValue("COMPRESSION", in.getCompression());
        builder.setValue("DATA_BLOCK_ENCODING", in.getDataBlockEncoding());
        if (in.getFamilyAttributes().getDfsReplicationNoDefault() != null) {
            builder.setDFSReplication(in.getDfsReplication());
        }
        builder.setMaxVersions(in.getMaxVersions());
        builder.setMinVersions(in.getMinVersions());
        builder.setTimeToLive(in.getTimeToLive());
        builder.setStoragePolicy(in.getStorageType());
        builder.setValue("CHS", in.getColdHotSeparateBoundary());
        builder.setBlockCacheEnabled(in.isBlockCacheEnabled());
        builder.setDFSReplication(tableDescriptor.getDfsReplication());
        try {
            Long hotCompactionPeriod;
            Long period = in.getCompactionMajorPeriodNoDefault();
            if (period != null) {
                builder.setConfiguration("hbase.hregion.majorcompaction", String.valueOf(period));
            }
            if ((hotCompactionPeriod = in.getHotCompactionPeriod()) != null) {
                builder.setValue("HOT_COMPACTION_PERIOD", Long.toString(hotCompactionPeriod));
            }
        }
        catch (Throwable period) {
            // empty catch block
        }
        for (int i = 1; i <= 5; ++i) {
            key = "CHS_L" + i;
            value = in.getColdHotLayerConfig(i);
            builder.setValue(key, value);
        }
        builder.setValue("CHS_PROMOTE_ON_MAJOR", Boolean.toString(in.isColdHotPromoteOnMajor()));
        return builder;
    }

    public static com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor toLindormcolumnFamilyDescriptor(ColumnFamilyDescriptor in, boolean limitedDescriptorEnable) {
        com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor out = new com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor(in.getName());
        if (limitedDescriptorEnable) {
            out.setTimeToLive(in.getTimeToLive(), TimeUnit.SECONDS);
            out.setMaxVersions(in.getMaxVersions());
            out.setMinVersions(in.getMinVersions());
        } else {
            int oldestIndex;
            out.setCompression(Bytes.toString((byte[])in.getValue(Bytes.toBytes((String)"COMPRESSION"))));
            out.setDataBlockEncoding(Bytes.toString((byte[])in.getValue(Bytes.toBytes((String)"DATA_BLOCK_ENCODING"))));
            out.setBlockCacheEnabled(in.isBlockCacheEnabled());
            try {
                String majorPeriod = in.getConfigurationValue("hbase.hregion.majorcompaction");
                if (majorPeriod != null && majorPeriod.length() > 0) {
                    long period = Long.valueOf(majorPeriod);
                    out.setCompactionMajorPeriod(period);
                }
            }
            catch (Throwable majorPeriod) {
                // empty catch block
            }
            if (in.getDFSReplication() > 0 && in.getDFSReplication() <= 3) {
                out.setDfsReplication(in.getDFSReplication());
            }
            out.setMaxVersions(in.getMaxVersions());
            out.setMinVersions(in.getMinVersions());
            out.setTimeToLive(in.getTimeToLive(), TimeUnit.SECONDS);
            if (in.getStoragePolicy() != null) {
                String storageType = in.getStoragePolicy().toUpperCase();
                if (storageType.equals("DEFAULT") || storageType.equals("COLD")) {
                    out.setStorageType(in.getStoragePolicy());
                } else {
                    throw new IllegalArgumentException("only accept storage type:DEFAULT or COLD");
                }
            }
            byte[] key = Bytes.toBytes((String)"CHS");
            String boundary = null;
            if (in.getValue(key) != null) {
                if (in.getStoragePolicy() != null && in.getStoragePolicy().toUpperCase().equals("COLD")) {
                    throw new IllegalArgumentException("can not both set cold hot separate and cold storage type on family:" + in.getNameAsString());
                }
                boundary = Bytes.toString((byte[])in.getValue(key));
                if (StringUtils.isNullOrEmpty(boundary)) {
                    boundary = null;
                } else {
                    out.setColdHotSeparateBoundary(boundary);
                }
            }
            for (int i = 1; i <= 5 && !StringUtils.isNullOrEmpty(boundary); ++i) {
                String layer = "CHS_L" + i;
                key = Bytes.toBytes((String)layer);
                if (in.getValue(key) == null) continue;
                out.setColdHotLayerConfig(i, Bytes.toString((byte[])in.getValue(key)));
            }
            if (!StringUtils.isNullOrEmpty(boundary) && (oldestIndex = boundary.split(",").length + 1) <= 5 && in.getValue(key = Bytes.toBytes((String)("CHS_L" + oldestIndex))) == null) {
                out.setColdHotLayerConfig(oldestIndex, COLD_HOT_COLD_STORAGETYPE_CONFIG);
            }
            if (in.getValue(key = Bytes.toBytes((String)"CHS_PROMOTE_ON_MAJOR")) != null) {
                String value = Bytes.toString((byte[])in.getValue(key));
                out.setColdHotPromoteOnMajor(Boolean.valueOf(value));
            }
            if (in.getValue(key = Bytes.toBytes((String)"HOT_COMPACTION_PERIOD")) != null) {
                String value = Bytes.toString((byte[])in.getValue(key));
                out.setHotCompactionPeriod(Long.valueOf(value));
            }
        }
        return out;
    }

    public static List<LindormFamilyAttributes> toLindormFamilyAttributes(ColumnFamilyDescriptor in, boolean limitedDescriptorEnable) throws IOException {
        ArrayList<LindormAttribute> lindormAttributes = new ArrayList<LindormAttribute>();
        if (limitedDescriptorEnable) {
            if (in.getTimeToLive() > 0) {
                lindormAttributes.add(new LindormAttribute("TTL", Integer.toString(in.getTimeToLive())));
            }
            if (in.getMaxVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("VERSIONS", Integer.toString(in.getMaxVersions())));
            }
            if (in.getMinVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("MIN_VERSIONS", Integer.toString(in.getMinVersions())));
            }
        } else {
            if (in.getValue(Bytes.toBytes((String)"COMPRESSION")) != null) {
                lindormAttributes.add(new LindormAttribute("COMPRESSION", Bytes.toString((byte[])in.getValue(Bytes.toBytes((String)"COMPRESSION")))));
            }
            if (in.getValue(Bytes.toBytes((String)"DATA_BLOCK_ENCODING")) != null) {
                lindormAttributes.add(new LindormAttribute("DATA_BLOCK_ENCODING", Bytes.toString((byte[])in.getValue(Bytes.toBytes((String)"DATA_BLOCK_ENCODING")))));
            }
            if (in.getMaxVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("VERSIONS", Integer.toString(in.getMaxVersions())));
            }
            if (in.getMinVersions() > 0) {
                lindormAttributes.add(new LindormAttribute("MIN_VERSIONS", Integer.toString(in.getMinVersions())));
            }
            if (in.getTimeToLive() > 0) {
                lindormAttributes.add(new LindormAttribute("TTL", Integer.toString(in.getTimeToLive())));
            }
            if (in.getStoragePolicy() != null) {
                lindormAttributes.add(new LindormAttribute("STORAGETYPE", in.getStoragePolicy()));
            }
        }
        LindormFamilyAttributes lindormFamilyAttributes = new LindormFamilyAttributes(Bytes.toString((byte[])in.getName()), lindormAttributes);
        return Arrays.asList(lindormFamilyAttributes);
    }

    public static HTableDescriptor toHbaseTableDescriptor(String namespace, LindormTableDescriptor in) {
        Map<String, SilenceIndex> silenceIndexMap;
        Map<Byte, String> indexIds;
        HTableDescriptor builder = new HTableDescriptor(TableName.valueOf((String)namespace, (String)in.getName()));
        for (com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor column : in.getFamilies()) {
            if ((column.getFamilyAttributes() == null || column.getFamilyAttributes().getAttributesMap().size() == 0) && in.getFamilyAttributes() != null) {
                column.setFamilyAttributes(in.getFamilyAttributes());
            }
            builder.addFamily(ElementConvertor.toHbasecolumnFamilyDescriptor(in, column));
        }
        if (in.getTableAttributes() != null) {
            try {
                byte[] tableAttrs = LindormObjectUtils.getBytes(in.getTableAttributes());
                builder.setValue(Bytes.toBytes((String)"LINDORM_TABLE_ATTRS"), tableAttrs);
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor" + in, ioE);
            }
        }
        if (in.getFamilyAttributes() != null) {
            try {
                byte[] familyAttrs = LindormObjectUtils.getBytes(in.getFamilyAttributes());
                builder.setValue(AliHBaseConstants.FAMILY_ATTRIBUTES_KEY_BYTES, familyAttrs);
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor" + in, ioE);
            }
        }
        boolean isTableSerivce = false;
        if (in.getPkColumns() != null && in.getPkColumns().size() > 0) {
            try {
                byte[] pkAttrs = ElementConvertor.getBytesFromPkColumn(in.getPkColumns());
                builder.setValue(AliHBaseConstants.PK_ATTRIBUTES_KEY_BYTES, pkAttrs);
                isTableSerivce = ElementConvertor.possibleTableServiceWithPk(in.getPkColumns());
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor" + in, ioE);
            }
        }
        if (in.getNonPkColumns() != null && in.getNonPkColumns().size() > 0) {
            try {
                byte[] nonPkAttrs = ElementConvertor.getBytesFromNonPkColumn(in.getNonPkColumns());
                builder.setValue(AliHBaseConstants.NONPK_ATTRIBUTES_KEY_BYTES, nonPkAttrs);
                isTableSerivce = ElementConvertor.possibleTableServiceWithNonPk(in.getNonPkColumns());
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor" + in, ioE);
            }
        }
        builder.setValue(AliHBaseConstants.TABLESERVICE_ATTRIBUTES_KEY_BYTES, Bytes.toBytes((boolean)isTableSerivce));
        if (in.getOtherAttributes() != null && in.getOtherAttributes().getAttributes() != null) {
            for (Map.Entry<ImmutableBytesPtr, ImmutableBytesPtr> entry : in.getOtherAttributes().getAttributes().entrySet()) {
                builder.setValue(entry.getKey().get(), entry.getValue().get());
            }
        }
        builder.setValue(TABLEMETAVERSIONBYTES, Bytes.toBytes((int)in.getMetaVersion()));
        List<String> indexNames = in.getIndexNames();
        if (indexNames != null && !indexNames.isEmpty()) {
            builder.setValue(AliHBaseConstants.INDEX_NAMES_KEY_BYTES, SchemaUtils.indexNamesToBytes(indexNames));
        }
        if ((indexIds = in.getIndexIds()) != null && !indexIds.isEmpty()) {
            try {
                builder.setValue(AliHBaseConstants.INDEX_ID_KEY_BYTES, SchemaUtils.indexIdToBytes(indexIds));
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor, index ids, " + in, ioE);
            }
        }
        if ((silenceIndexMap = in.getSilenceIndexs()) != null && !silenceIndexMap.isEmpty()) {
            try {
                builder.setValue(AliHBaseConstants.SILENCE_INDEXES_KEY_BYTES, SchemaUtils.silenceIndexToBytes(silenceIndexMap));
            }
            catch (IOException ioE) {
                throw new RuntimeException("Error converting LindormTableDescriptor to HTableDescriptor, silence index, " + in, ioE);
            }
        }
        if (in.isDeferredLogFlush()) {
            builder.setDurability(Durability.ASYNC_WAL);
        } else {
            builder.setDurability(Durability.USE_DEFAULT);
        }
        if (in.getTableAttributes().getMemStoreFlushSizeNoDefault() != null) {
            builder.setMemStoreFlushSize(in.getTableAttributes().getMemStoreFlushSize());
        }
        return builder;
    }

    public static LindormTableDescriptor toLindormTableDescripter(TableDescriptor htd, boolean limitedDescriptorEnable) {
        String mutabilityStr;
        byte[] metaVersion;
        LindormTableDescriptor lindormTableDesc = new LindormTableDescriptor(htd.getTableName().getQualifierAsString());
        for (ColumnFamilyDescriptor hbaseFamily : htd.getColumnFamilies()) {
            com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor column = ElementConvertor.toLindormcolumnFamilyDescriptor(hbaseFamily, limitedDescriptorEnable);
            lindormTableDesc.addFamily(column);
        }
        if (htd.getValues() != null) {
            BytesKeyAttributes otherAttributes = new BytesKeyAttributes();
            if (!limitedDescriptorEnable) {
                for (Map.Entry entry : htd.getValues().entrySet()) {
                    if (((Bytes)entry.getKey()).compareTo(TABLEMETAVERSIONBYTES) == 0 || ((Bytes)entry.getKey()).compareTo(AliHBaseConstants.TABLESERVICE_ATTRIBUTES_KEY_BYTES) == 0) continue;
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.TABLE_ATTRIBUTES_KEY_BYTES) == 0) {
                        TableAttributes tableAttributes = new TableAttributes();
                        try {
                            LindormObjectUtils.getWritable(((Bytes)entry.getValue()).get(), tableAttributes);
                            lindormTableDesc.setTableAttributes(tableAttributes);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor" + htd, ioE);
                        }
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.INDEX_NAMES_KEY_BYTES) == 0) {
                        List<String> indexNames = SchemaUtils.indexNamesFromBytes(((Bytes)entry.getValue()).copyBytes());
                        lindormTableDesc.setIndexNames(indexNames);
                        continue;
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.INDEX_ID_KEY_BYTES) == 0) {
                        try {
                            Map<Byte, String> indexIds = SchemaUtils.indexIdFromBytes(((Bytes)entry.getValue()).copyBytes());
                            lindormTableDesc.setIndexIds(indexIds);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor, index names, htd = " + htd, ioE);
                        }
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.SILENCE_INDEXES_KEY_BYTES) == 0) {
                        try {
                            Map<String, SilenceIndex> silenceIndexMap = SchemaUtils.silenceIndexFromBytes(((Bytes)entry.getValue()).copyBytes());
                            lindormTableDesc.setSilenceIndex(silenceIndexMap);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor, silence index map, htd = " + htd, ioE);
                        }
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.FAMILY_ATTRIBUTES_KEY_BYTES) == 0) {
                        FamilyAttributes familyAttributes = new FamilyAttributes();
                        try {
                            LindormObjectUtils.getWritable(((Bytes)entry.getValue()).get(), familyAttributes);
                            lindormTableDesc.setFamilyAttributes(familyAttributes);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor" + htd, ioE);
                        }
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.PK_ATTRIBUTES_KEY_BYTES) == 0) {
                        try {
                            List<PrimaryKeySchema> pks = ElementConvertor.getPkColumnFromBytes(((Bytes)entry.getValue()).get());
                            lindormTableDesc.setPkColumns(pks);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor" + htd, ioE);
                        }
                    }
                    if (((Bytes)entry.getKey()).compareTo(AliHBaseConstants.NONPK_ATTRIBUTES_KEY_BYTES) == 0) {
                        try {
                            List<ColumnSchema> nonPks = ElementConvertor.getNonPkColumnFromBytes(((Bytes)entry.getValue()).get());
                            lindormTableDesc.setNonPkColumns(nonPks);
                            continue;
                        }
                        catch (IOException ioE) {
                            throw new RuntimeException("Error converting HTableDescriptor to LindormTableDescriptor" + htd, ioE);
                        }
                    }
                    if (TableAttributes.isTableAttributes(Bytes.toString((byte[])((Bytes)entry.getKey()).get()))) continue;
                    otherAttributes.set(new ImmutableBytesPtr(((Bytes)entry.getKey()).get()), new ImmutableBytesPtr(((Bytes)entry.getValue()).get()));
                }
            }
            lindormTableDesc.setOtherAttributes(otherAttributes);
        }
        if ((metaVersion = htd.getValue(TABLEMETAVERSIONBYTES)) != null && metaVersion.length != 0) {
            lindormTableDesc.setMetaVersion(Bytes.toInt((byte[])metaVersion));
        }
        if ((mutabilityStr = htd.getValue("MUTABILITY")) != null) {
            Mutability mutability = Mutability.valueOf(mutabilityStr);
            lindormTableDesc.getTableAttributes().setMutability(mutability);
        }
        lindormTableDesc.setDynamicColumnsEnabled(true);
        if (htd.getDurability().equals((Object)Durability.ASYNC_WAL)) {
            lindormTableDesc.setDeferredLogFlush(true);
        } else {
            lindormTableDesc.setDeferredLogFlush(false);
        }
        if (htd.getMemStoreFlushSize() > 0L) {
            lindormTableDesc.getTableAttributes().setMemStoreFlushSize(htd.getMemStoreFlushSize());
        }
        return lindormTableDesc;
    }

    public static TableName toHBaseTableName(String table) {
        int pos = table.indexOf(".");
        if (pos < 0) {
            return TableName.valueOf((String)table);
        }
        String namespace = table.substring(0, pos);
        String name = table.substring(pos + 1);
        return TableName.valueOf((String)namespace, (String)name);
    }

    public static WRowMutations toLindormWRowMutation(RowMutations rowMutations) throws IOException {
        WRowMutations wRowMutations = new WRowMutations(rowMutations.getRow());
        for (Mutation mutation : rowMutations.getMutations()) {
            if (mutation instanceof Put) {
                WPut wPut = ElementConvertor.toLindormPut((Put)mutation);
                wRowMutations.add(wPut);
                continue;
            }
            if (mutation instanceof Delete) {
                WDelete wDelete = ElementConvertor.toLindormDelete((Delete)mutation);
                wRowMutations.add(wDelete);
                continue;
            }
            throw new IOException("Only Put or Delete is supported in RowMutation: " + mutation);
        }
        return wRowMutations;
    }

    public static DataType toInterpreterDataType(String interpreterClassName) {
        DataType dataType = INTERPRETER_DATATYPE_MAP.get(interpreterClassName);
        if (dataType == null) {
            throw new UnsupportedOperationException("Unsupported interpreterClass " + interpreterClassName);
        }
        return dataType;
    }

    public static byte[] toValueBytes(ColumnValue cv, ColumnInterpreter interpreterClassName) {
        BigDecimal bigDecimal = cv.getDecimal();
        if (interpreterClassName instanceof LongColumnInterpreter) {
            return Bytes.toBytes((long)bigDecimal.longValue());
        }
        if (interpreterClassName instanceof DoubleColumnInterpreter) {
            return Bytes.toBytes((double)bigDecimal.doubleValue());
        }
        if (interpreterClassName instanceof BigDecimalColumnInterpreter) {
            return Bytes.toBytes((BigDecimal)bigDecimal);
        }
        throw new UnsupportedOperationException("Unsupported interpreterClass " + interpreterClassName.getClass());
    }

    public static String toLindormTableFullName(TableName tableName) {
        return tableName.getNamespaceAsString() + "." + tableName.getQualifierAsString();
    }

    private static void initLindormIndexFamilyDescriptor(LindormIndexDescriptor out, HColumnDescriptor in) {
        int oldestIndex;
        out.setCompression(in.getCompressionType().toString());
        out.setDataBlockEncoding(in.getDataBlockEncoding().name());
        out.setBlockCacheEnabled(in.isBlockCacheEnabled());
        if (in.getStoragePolicy() != null) {
            String storageType = in.getStoragePolicy().toUpperCase();
            if (storageType.equals("DEFAULT") || storageType.equals("COLD")) {
                out.setStorageType(in.getStoragePolicy());
            } else {
                throw new IllegalArgumentException("only accept storage type:DEFAULT or COLD");
            }
        }
        byte[] key = Bytes.toBytes((String)"CHS");
        String boundary = null;
        if (in.getValue(key) != null) {
            if (in.getStoragePolicy() != null && in.getStoragePolicy().toUpperCase().equals("COLD")) {
                throw new IllegalArgumentException("can not both set cold hot separate and cold storage type on index:" + out.getIndexName());
            }
            boundary = Bytes.toString((byte[])in.getValue(key));
            if (StringUtils.isNullOrEmpty(boundary)) {
                boundary = null;
            } else {
                out.setColdHotSeparateBoundary(boundary);
            }
        }
        for (int i = 1; i <= 5 && !StringUtils.isNullOrEmpty(boundary); ++i) {
            String layer = "CHS_L" + i;
            key = Bytes.toBytes((String)layer);
            if (in.getValue(key) == null) continue;
            out.setColdHotLayerConfig(i, Bytes.toString((byte[])in.getValue(key)));
        }
        if (!StringUtils.isNullOrEmpty(boundary) && (oldestIndex = boundary.split(",").length + 1) <= 5 && in.getValue(key = Bytes.toBytes((String)("CHS_L" + oldestIndex))) == null) {
            out.setColdHotLayerConfig(oldestIndex, COLD_HOT_COLD_STORAGETYPE_CONFIG);
        }
        if (in.getValue(key = Bytes.toBytes((String)"CHS_PROMOTE_ON_MAJOR")) != null) {
            String value = Bytes.toString((byte[])in.getValue(key));
            out.setColdHotPromoteOnMajor(Boolean.getBoolean(value));
        }
    }

    public static LindormIndexDescriptor toLindormIndexDescriptor(AliHBaseIndexDescriptor idxDesc) {
        LindormIndexDescriptor lid = new LindormIndexDescriptor(idxDesc.getIndexName(), idxDesc.getDataTable().getQualifierAsString());
        ElementConvertor.initLindormIndexFamilyDescriptor(lid, idxDesc.getFamilyDescriptor());
        for (AliHBaseColumn ic : idxDesc.getIndexedColumns()) {
            SortOrder order = SortOrder.getDefault();
            if (ic.getSortOrder() != null) {
                order = ic.getSortOrder() == AliHBaseColumn.SortOrder.ASC ? SortOrder.ASC : SortOrder.DESC;
            }
            IndexedColumnSchema ics = new IndexedColumnSchema(ic.getFamily(), ic.getQualifier(), order);
            lid.addIndexedColumns(ics);
        }
        for (AliHBaseColumn cc : idxDesc.getCoveredColumns()) {
            if (cc == AliHBaseColumn.COVER_ALL) {
                lid.addCoveredColumn(LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS);
                break;
            }
            lid.addCoveredColumn(new ColumnKey(cc.getFamily(), cc.getQualifier()));
        }
        lid.setIndexState(IndexState.BUILDING);
        return lid;
    }

    public static AliHBaseIndexDescriptor toAliHBaseIndexDescriptor(String namespace, LindormIndexDescriptor desc) {
        String indexName = desc.getIndexName();
        TableName dataTableName = TableName.valueOf((String)namespace, (String)desc.getDataTableName());
        AliHBaseIndexDescriptor ret = new AliHBaseIndexDescriptor(indexName, dataTableName);
        for (IndexedColumnSchema col : desc.getIndexedColumns()) {
            if (ElementConvertor.isRowkeyField(col.getColumnKey())) {
                if (!col.getSortOrder().equals((Object)SortOrder.DESC)) continue;
                ret.addIndexedColumn(null, col.getColumnKey().getQualifier(), AliHBaseColumn.SortOrder.fromImplSortOrder(col.getSortOrder()));
                continue;
            }
            ret.addIndexedColumn(ElementConvertor.getFamilyName(col.getColumnKey()), col.getColumnKey().getQualifier(), AliHBaseColumn.SortOrder.fromImplSortOrder(col.getSortOrder()));
        }
        for (ColumnKey ck : desc.getCoveredColumns()) {
            if (ck == LindormIndexDescriptor.COVERED_DYNAMIC_COLUMNS) {
                ret.setCoveredAllColumns();
                break;
            }
            ret.addCoveredColumn(ElementConvertor.getFamilyName(ck), ck.getQualifier());
        }
        return ret;
    }

    private static boolean isRowkeyField(ColumnKey ck) {
        byte[] f = ck.getFamily();
        return (f == null || f.length == 0) && Arrays.equals(ck.getQualifier(), ROWKEY_NAME);
    }

    private static byte[] getFamilyName(ColumnKey ck) {
        byte[] family = ck.getFamily();
        if (family == null || family.length == 0) {
            family = SchemaUtils.DEFAULT_FAMILY_NAME_BYTES;
        }
        return family;
    }

    public static String indexSchemaToString(List<AliHBaseIndexDescriptor> indexes, String dataTableName) {
        if (indexes == null || indexes.isEmpty()) {
            return "No index found for table " + dataTableName;
        }
        StringBuilder str = new StringBuilder();
        for (AliHBaseIndexDescriptor idx : indexes) {
            str.append(idx.getSchema());
            str.append("\n");
        }
        str.append("Total " + indexes.size() + " indexes found for table " + dataTableName);
        return str.toString();
    }

    private static void copyAttributes(Attributes attributes, Map<String, byte[]> attributesMap) {
        for (Map.Entry<String, byte[]> entry : attributesMap.entrySet()) {
            attributes.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static TableName handlePhoenixSystemTable(TableName name) {
        String tableName = name.getQualifierAsString();
        if (tableName.startsWith("SYSTEM.")) {
            tableName = tableName.substring(7);
            return TableName.valueOf((String)"SYSTEM", (String)tableName);
        }
        return name;
    }

    public static IOException toHBaseIOException(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof HBaseIOException || t instanceof org.apache.hadoop.hbase.DoNotRetryIOException) {
            return (IOException)t;
        }
        Throwable cause = t;
        if (t instanceof LindormException && t.getCause() != null) {
            cause = t.getCause();
        }
        if (cause instanceof DoNotRetryIOException) {
            if (cause instanceof com.alibaba.lindorm.client.exception.TableExistsException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.TableExistsException.class.getName())) {
                return new TableExistsException(cause.getMessage());
            }
            if (cause instanceof TableNotFoundException || cause.getMessage().contains(TableNotFoundException.class.getName())) {
                return new org.apache.hadoop.hbase.TableNotFoundException(cause.getMessage());
            }
            if (cause instanceof TableNotEnabledException || cause.getMessage().contains(TableNotEnabledException.class.getName())) {
                return new org.apache.hadoop.hbase.TableNotEnabledException(cause.getMessage());
            }
            if (cause instanceof NameSpaceNotFoundException || cause.getMessage().contains(NameSpaceNotFoundException.class.getName())) {
                return new NamespaceNotFoundException(cause.getMessage());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.NoSuchColumnFamilyException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.NoSuchColumnFamilyException.class.getName())) {
                return new NoSuchColumnFamilyException(cause.getMessage());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.NotAllMetaRegionsOnlineException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.NotAllMetaRegionsOnlineException.class.getName())) {
                return new NotAllMetaRegionsOnlineException(cause.getMessage());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.TableNotDisabledException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.TableNotDisabledException.class.getName())) {
                return new TableNotDisabledException(cause.getMessage());
            }
            if (cause instanceof LeaseException || cause.getMessage().contains(LeaseException.class.getName())) {
                return new org.apache.hadoop.hbase.regionserver.LeaseException(cause.getMessage());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.UnknownScannerException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.UnknownScannerException.class.getName())) {
                return new UnknownScannerException(cause.getMessage());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.AccessDeniedException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.AccessDeniedException.class.getName())) {
                return new AccessDeniedException(cause.getMessage());
            }
            if (cause instanceof QuotaExceededException || cause.getMessage().contains(QuotaExceededException.class.getName())) {
                return new org.apache.hadoop.hbase.quotas.QuotaExceededException(cause.getMessage(), cause.getCause());
            }
            if (cause instanceof com.alibaba.lindorm.client.exception.UnknownProtocolException || cause.getMessage().contains(com.alibaba.lindorm.client.exception.UnknownProtocolException.class.getName())) {
                return new UnknownProtocolException(cause.getMessage());
            }
            return new org.apache.hadoop.hbase.DoNotRetryIOException(cause.getMessage(), cause.getCause());
        }
        return new HBaseIOException(cause.getMessage(), cause.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromPkColumn(List<PrimaryKeySchema> pks) throws IOException {
        byte[] result;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(byteStream);){
            WritableUtils.writeVInt(out, pks.size());
            for (PrimaryKeySchema pk : pks) {
                ElementConvertor.pkColumnWriteTo(out, pk);
            }
            out.close();
            out = null;
            result = byteStream.toByteArray();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromNonPkColumn(List<ColumnSchema> nonPks) throws IOException {
        byte[] result;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(byteStream);){
            WritableUtils.writeVInt(out, nonPks.size());
            for (ColumnSchema nonPk : nonPks) {
                ElementConvertor.nonPkColumnWriteTo(out, nonPk);
            }
            out.close();
            out = null;
            result = byteStream.toByteArray();
        }
        return result;
    }

    public static List<PrimaryKeySchema> getPkColumnFromBytes(byte[] bytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        in.reset(bytes, bytes.length);
        int count = WritableUtils.readVInt(in);
        ArrayList<PrimaryKeySchema> pks = new ArrayList<PrimaryKeySchema>();
        for (int i = 0; i < count; ++i) {
            PrimaryKeySchema pk = ElementConvertor.pkColumnReadFrom(in);
            pks.add(pk);
        }
        return pks;
    }

    public static List<ColumnSchema> getNonPkColumnFromBytes(byte[] bytes) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        in.reset(bytes, bytes.length);
        int count = WritableUtils.readVInt(in);
        ArrayList<ColumnSchema> nonPks = new ArrayList<ColumnSchema>();
        for (int i = 0; i < count; ++i) {
            ColumnSchema nonPk = ElementConvertor.nonPkColumnReadFrom(in);
            nonPks.add(nonPk);
        }
        return nonPks;
    }

    public static void pkColumnWriteTo(DataOutputStream out, PrimaryKeySchema pk) throws IOException {
        if (pk == null) {
            return;
        }
        WritableUtils.writeString(out, "name");
        Bytes.writeByteArray((DataOutput)out, (byte[])pk.getName());
        WritableUtils.writeString(out, "dataType");
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)pk.getDataType().toString()));
        WritableUtils.writeString(out, "maxLength");
        WritableUtils.writeVInt(out, pk.getMaxLength() != null ? pk.getMaxLength() : -1);
        WritableUtils.writeString(out, "scale");
        WritableUtils.writeVInt(out, pk.getScale() != null ? pk.getMaxLength() : -1);
        WritableUtils.writeString(out, "sortOrder");
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)pk.getSortOrder().toString()));
        WritableUtils.writeString(out, "hashed");
        WritableUtils.writeVInt(out, pk.isHashed() ? 1 : 0);
    }

    public static PrimaryKeySchema pkColumnReadFrom(DataInputBuffer in) throws IOException {
        PrimaryKeySchema pk = new PrimaryKeySchema();
        ElementConvertor.setPkAttributes(in, pk, WritableUtils.readString(in));
        ElementConvertor.setPkAttributes(in, pk, WritableUtils.readString(in));
        ElementConvertor.setPkAttributes(in, pk, WritableUtils.readString(in));
        ElementConvertor.setPkAttributes(in, pk, WritableUtils.readString(in));
        return pk;
    }

    public static void setPkAttributes(DataInputBuffer in, PrimaryKeySchema pk, String name) throws IOException {
        switch (name) {
            case "name": {
                pk.setName(Bytes.readByteArray((DataInput)in));
                break;
            }
            case "dataType": {
                DataType dataType = DataType.valueOf(Bytes.toString((byte[])Bytes.readByteArray((DataInput)in)));
                WritableUtils.readString(in);
                int maxLength = WritableUtils.readVInt(in);
                WritableUtils.readString(in);
                int scale = WritableUtils.readVInt(in);
                if (maxLength == -1) {
                    pk.setType(dataType);
                    break;
                }
                if (scale == -1) {
                    pk.setType(dataType, maxLength);
                    break;
                }
                pk.setType(dataType, maxLength, scale);
                break;
            }
            case "sortOrder": {
                pk.setSortOrder(SortOrder.valueOf(Bytes.toString((byte[])Bytes.readByteArray((DataInput)in))));
                break;
            }
            case "hashed": {
                pk.setHashed(WritableUtils.readVInt(in) > 0);
                break;
            }
            default: {
                throw new IOException("set pk attributes failed, unsupported attribute " + name);
            }
        }
    }

    public static void nonPkColumnWriteTo(DataOutputStream out, ColumnSchema nonPk) throws IOException {
        if (nonPk == null) {
            return;
        }
        WritableUtils.writeString(out, "familyName");
        Bytes.writeByteArray((DataOutput)out, (byte[])nonPk.getFamilyName());
        WritableUtils.writeString(out, "columnName");
        Bytes.writeByteArray((DataOutput)out, (byte[])nonPk.getColumnName());
        WritableUtils.writeString(out, "dataType");
        Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)nonPk.getDataType().toString()));
        WritableUtils.writeString(out, "maxLength");
        WritableUtils.writeVInt(out, nonPk.getMaxLength() != null ? nonPk.getMaxLength() : -1);
        WritableUtils.writeString(out, "scale");
        WritableUtils.writeVInt(out, nonPk.getScale() != null ? nonPk.getScale() : -1);
    }

    public static ColumnSchema nonPkColumnReadFrom(DataInputBuffer in) throws IOException {
        ColumnSchema nonPk = new ColumnSchema();
        ElementConvertor.setNonPkAttributes(in, nonPk, WritableUtils.readString(in));
        ElementConvertor.setNonPkAttributes(in, nonPk, WritableUtils.readString(in));
        ElementConvertor.setNonPkAttributes(in, nonPk, WritableUtils.readString(in));
        return nonPk;
    }

    public static void setNonPkAttributes(DataInputBuffer in, ColumnSchema nonPk, String name) throws IOException {
        switch (name) {
            case "familyName": {
                nonPk.setFamilyName(Bytes.readByteArray((DataInput)in));
                break;
            }
            case "columnName": {
                nonPk.setColumnName(Bytes.readByteArray((DataInput)in));
                break;
            }
            case "dataType": {
                DataType dataType = DataType.valueOf(Bytes.toString((byte[])Bytes.readByteArray((DataInput)in)));
                WritableUtils.readString(in);
                int maxLength = WritableUtils.readVInt(in);
                WritableUtils.readString(in);
                int scale = WritableUtils.readVInt(in);
                if (maxLength == -1) {
                    nonPk.setDataType(dataType);
                    break;
                }
                if (scale == -1) {
                    nonPk.setDataType(dataType, maxLength);
                    break;
                }
                nonPk.setDataType(dataType, maxLength, scale);
                break;
            }
            default: {
                throw new IOException("set nonpk attributes failed, unsupported attribute " + name);
            }
        }
    }

    public static boolean possibleTableServiceWithPk(List<PrimaryKeySchema> pks) {
        if (pks.size() != 1) {
            return true;
        }
        PrimaryKeySchema pk = pks.get(0);
        return pk == null || !"ROW".equals(Bytes.toString((byte[])pk.getName())) || pk.getDataType() != DataType.VARBINARY;
    }

    public static boolean possibleTableServiceWithNonPk(List<ColumnSchema> nonPks) {
        if (nonPks.size() != 1) {
            return true;
        }
        ColumnSchema nonPk = nonPks.get(0);
        return nonPk == null || !"COL".equals(Bytes.toString((byte[])nonPk.getColumnName())) || nonPk.getDataType() != DataType.VARBINARY;
    }

    static {
        INTERPRETER_DATATYPE_MAP.put(LongColumnInterpreter.class.getName(), DataType.LONG);
        INTERPRETER_DATATYPE_MAP.put(DoubleColumnInterpreter.class.getName(), DataType.DOUBLE);
        INTERPRETER_DATATYPE_MAP.put(BigDecimalColumnInterpreter.class.getName(), DataType.DECIMAL);
    }
}

