/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.thrift2.generated.TAppend;
import com.alibaba.hbase.thrift2.generated.TAuthorization;
import com.alibaba.hbase.thrift2.generated.TBloomFilterType;
import com.alibaba.hbase.thrift2.generated.TCellVisibility;
import com.alibaba.hbase.thrift2.generated.TColumn;
import com.alibaba.hbase.thrift2.generated.TColumnFamilyDescriptor;
import com.alibaba.hbase.thrift2.generated.TColumnIncrement;
import com.alibaba.hbase.thrift2.generated.TColumnValue;
import com.alibaba.hbase.thrift2.generated.TCompareOp;
import com.alibaba.hbase.thrift2.generated.TCompressionAlgorithm;
import com.alibaba.hbase.thrift2.generated.TConsistency;
import com.alibaba.hbase.thrift2.generated.TDataBlockEncoding;
import com.alibaba.hbase.thrift2.generated.TDelete;
import com.alibaba.hbase.thrift2.generated.TDeleteType;
import com.alibaba.hbase.thrift2.generated.TDurability;
import com.alibaba.hbase.thrift2.generated.TGet;
import com.alibaba.hbase.thrift2.generated.THRegionInfo;
import com.alibaba.hbase.thrift2.generated.THRegionLocation;
import com.alibaba.hbase.thrift2.generated.TIncrement;
import com.alibaba.hbase.thrift2.generated.TKeepDeletedCells;
import com.alibaba.hbase.thrift2.generated.TMutation;
import com.alibaba.hbase.thrift2.generated.TNamespaceDescriptor;
import com.alibaba.hbase.thrift2.generated.TPut;
import com.alibaba.hbase.thrift2.generated.TReadType;
import com.alibaba.hbase.thrift2.generated.TResult;
import com.alibaba.hbase.thrift2.generated.TRowMutations;
import com.alibaba.hbase.thrift2.generated.TScan;
import com.alibaba.hbase.thrift2.generated.TServerName;
import com.alibaba.hbase.thrift2.generated.TTableDescriptor;
import com.alibaba.hbase.thrift2.generated.TTableName;
import com.alibaba.hbase.thrift2.generated.TTimeRange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.ExtendedCellBuilder;
import org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class ThriftUtilities {
    private static final Cell[] EMPTY_CELL_ARRAY = new Cell[0];
    private static final Result EMPTY_RESULT = Result.create((Cell[])EMPTY_CELL_ARRAY);
    private static final Result EMPTY_RESULT_STALE = Result.create((Cell[])EMPTY_CELL_ARRAY, null, (boolean)true);

    private ThriftUtilities() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    public static Get getFromThrift(TGet in) throws IOException {
        Get out = new Get(in.getRow());
        if (in.isSetTimestamp()) {
            out.setTimestamp(in.getTimestamp());
        } else if (in.isSetTimeRange()) {
            out.setTimeRange(in.getTimeRange().getMinStamp(), in.getTimeRange().getMaxStamp());
        }
        if (in.isSetMaxVersions()) {
            out.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetFilterString()) {
            ParseFilter parseFilter = new ParseFilter();
            out.setFilter(parseFilter.parseFilterString(in.getFilterString()));
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetAuthorizations()) {
            out.setAuthorizations(new Authorizations(in.getAuthorizations().getLabels()));
        }
        if (in.isSetConsistency()) {
            out.setConsistency(ThriftUtilities.consistencyFromThrift(in.getConsistency()));
        }
        if (in.isSetTargetReplicaId()) {
            out.setReplicaId(in.getTargetReplicaId());
        }
        if (in.isSetCacheBlocks()) {
            out.setCacheBlocks(in.isCacheBlocks());
        }
        if (in.isSetStoreLimit()) {
            out.setMaxResultsPerColumnFamily(in.getStoreLimit());
        }
        if (in.isSetStoreOffset()) {
            out.setRowOffsetPerColumnFamily(in.getStoreOffset());
        }
        if (in.isSetExistence_only()) {
            out.setCheckExistenceOnly(in.isExistence_only());
        }
        if (in.isSetColumns()) {
            for (TColumn column : in.getColumns()) {
                if (column.isSetQualifier()) {
                    out.addColumn(column.getFamily(), column.getQualifier());
                    continue;
                }
                out.addFamily(column.getFamily());
            }
        }
        if (in.isSetFilterBytes()) {
            out.setFilter(ThriftUtilities.filterFromThrift(in.getFilterBytes()));
        }
        return out;
    }

    public static TResult resultFromHBase(Result in) {
        Cell[] raw = in.rawCells();
        TResult out = new TResult();
        byte[] row = in.getRow();
        if (row != null) {
            out.setRow(in.getRow());
        }
        ArrayList<TColumnValue> columnValues = new ArrayList<TColumnValue>(raw.length);
        for (Cell kv : raw) {
            TColumnValue col = new TColumnValue();
            col.setFamily(CellUtil.cloneFamily((Cell)kv));
            col.setQualifier(CellUtil.cloneQualifier((Cell)kv));
            col.setTimestamp(kv.getTimestamp());
            col.setValue(CellUtil.cloneValue((Cell)kv));
            col.setType(kv.getType().getCode());
            if (kv.getTagsLength() > 0) {
                col.setTags(PrivateCellUtil.cloneTags((Cell)kv));
            }
            columnValues.add(col);
        }
        out.setColumnValues(columnValues);
        out.setStale(in.isStale());
        out.setPartial(in.mayHaveMoreCellsInRow());
        return out;
    }

    public static Put putFromThrift(TPut in) {
        Put out = in.isSetTimestamp() ? new Put(in.getRow(), in.getTimestamp()) : new Put(in.getRow());
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        for (TColumnValue columnValue : in.getColumnValues()) {
            try {
                if (columnValue.isSetTimestamp()) {
                    out.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(out.getRow()).setFamily(columnValue.getFamily()).setQualifier(columnValue.getQualifier()).setTimestamp(columnValue.getTimestamp()).setType(Cell.Type.Put).setValue(columnValue.getValue()).build());
                    continue;
                }
                out.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.DEEP_COPY).setRow(out.getRow()).setFamily(columnValue.getFamily()).setQualifier(columnValue.getQualifier()).setTimestamp(out.getTimestamp()).setType(Cell.Type.Put).setValue(columnValue.getValue()).build());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.getCellVisibility() != null) {
            out.setCellVisibility(new CellVisibility(in.getCellVisibility().getExpression()));
        }
        return out;
    }

    public static Delete deleteFromThrift(TDelete in) {
        Delete out;
        if (in.isSetColumns()) {
            out = new Delete(in.getRow());
            for (TColumn column : in.getColumns()) {
                if (in.isSetDeleteType()) {
                    switch (in.getDeleteType()) {
                        case DELETE_COLUMN: {
                            if (column.isSetTimestamp()) {
                                out.addColumn(column.getFamily(), column.getQualifier(), column.getTimestamp());
                                break;
                            }
                            out.addColumn(column.getFamily(), column.getQualifier());
                            break;
                        }
                        case DELETE_COLUMNS: {
                            if (column.isSetTimestamp()) {
                                out.addColumns(column.getFamily(), column.getQualifier(), column.getTimestamp());
                                break;
                            }
                            out.addColumns(column.getFamily(), column.getQualifier());
                            break;
                        }
                        case DELETE_FAMILY: {
                            if (column.isSetTimestamp()) {
                                out.addFamily(column.getFamily(), column.getTimestamp());
                                break;
                            }
                            out.addFamily(column.getFamily());
                            break;
                        }
                        case DELETE_FAMILY_VERSION: {
                            if (column.isSetTimestamp()) {
                                out.addFamilyVersion(column.getFamily(), column.getTimestamp());
                                break;
                            }
                            throw new IllegalArgumentException("Timestamp is required for TDelete with DeleteFamilyVersion type");
                        }
                    }
                    continue;
                }
                throw new IllegalArgumentException("DeleteType is required for TDelete");
            }
        } else {
            out = in.isSetTimestamp() ? new Delete(in.getRow(), in.getTimestamp()) : new Delete(in.getRow());
        }
        if (in.isSetAttributes()) {
            ThriftUtilities.addAttributes((OperationWithAttributes)out, in.getAttributes());
        }
        if (in.isSetDurability()) {
            out.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        return out;
    }

    public static TDeleteType deleteTypeFromHBase(Cell.Type type) {
        switch (type) {
            case Delete: {
                return TDeleteType.DELETE_COLUMN;
            }
            case DeleteColumn: {
                return TDeleteType.DELETE_COLUMNS;
            }
            case DeleteFamily: {
                return TDeleteType.DELETE_FAMILY;
            }
            case DeleteFamilyVersion: {
                return TDeleteType.DELETE_FAMILY_VERSION;
            }
        }
        throw new IllegalArgumentException("Unknow delete type " + type);
    }

    public static TDelete deleteFromHBase(Delete in) {
        TDelete out = new TDelete(ByteBuffer.wrap(in.getRow()));
        ArrayList<TColumn> columns = new ArrayList<TColumn>(in.getFamilyCellMap().entrySet().size());
        long rowTimestamp = in.getTimestamp();
        if (rowTimestamp != Long.MAX_VALUE) {
            out.setTimestamp(rowTimestamp);
        }
        for (Map.Entry attribute : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)attribute.getKey()))), ByteBuffer.wrap((byte[])attribute.getValue()));
        }
        if (in.getDurability() != Durability.USE_DEFAULT) {
            out.setDurability(ThriftUtilities.durabilityFromHBase(in.getDurability()));
        }
        if (in.getFamilyCellMap().size() == 0) {
            return out;
        }
        TDeleteType type = null;
        for (Map.Entry familyEntry : in.getFamilyCellMap().entrySet()) {
            byte[] family = (byte[])familyEntry.getKey();
            TColumn column = new TColumn(ByteBuffer.wrap((byte[])familyEntry.getKey()));
            for (Cell cell : (List)familyEntry.getValue()) {
                TDeleteType cellDeleteType = ThriftUtilities.deleteTypeFromHBase(cell.getType());
                if (type == null) {
                    type = cellDeleteType;
                } else if (type != cellDeleteType) {
                    throw new RuntimeException("Only the same delete type is supported, but two delete type is founded, one is " + (Object)((Object)type) + " the other one is " + (Object)((Object)cellDeleteType));
                }
                byte[] qualifier = CellUtil.cloneQualifier((Cell)cell);
                long timestamp = cell.getTimestamp();
                column.setFamily(family);
                if (qualifier != null) {
                    column.setQualifier(qualifier);
                }
                if (timestamp == Long.MAX_VALUE) continue;
                column.setTimestamp(timestamp);
            }
            columns.add(column);
        }
        out.setColumns(columns);
        out.setDeleteType(type);
        return out;
    }

    public static byte[] filterFromHBase(Filter filter) throws IOException {
        FilterProtos.Filter filterPB = ProtobufUtil.toFilter((Filter)filter);
        return filterPB.toByteArray();
    }

    public static Filter filterFromThrift(byte[] filterBytes) throws IOException {
        FilterProtos.Filter filterPB = FilterProtos.Filter.parseFrom((byte[])filterBytes);
        return ProtobufUtil.toFilter((FilterProtos.Filter)filterPB);
    }

    public static TScan scanFromHBase(Scan in) throws IOException {
        TScan out = new TScan();
        out.setStartRow(in.getStartRow());
        out.setStopRow(in.getStopRow());
        out.setCaching(in.getCaching());
        out.setMaxVersions(in.getMaxVersions());
        for (Map.Entry family : in.getFamilyMap().entrySet()) {
            if (family.getValue() != null && !((NavigableSet)family.getValue()).isEmpty()) {
                for (byte[] qualifier : (NavigableSet)family.getValue()) {
                    TColumn column = new TColumn();
                    column.setFamily((byte[])family.getKey());
                    column.setQualifier(qualifier);
                    out.addToColumns(column);
                }
                continue;
            }
            TColumn tColumn = new TColumn();
            tColumn.setFamily((byte[])family.getKey());
            out.addToColumns(tColumn);
        }
        TTimeRange tTimeRange = new TTimeRange();
        tTimeRange.setMinStamp(in.getTimeRange().getMin()).setMaxStamp(in.getTimeRange().getMax());
        out.setTimeRange(tTimeRange);
        out.setBatchSize(in.getBatch());
        for (Map.Entry entry : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)entry.getKey()))), ByteBuffer.wrap((byte[])entry.getValue()));
        }
        try {
            Authorizations authorizations = in.getAuthorizations();
            if (authorizations != null) {
                TAuthorization tAuthorization = new TAuthorization();
                tAuthorization.setLabels(authorizations.getLabels());
                out.setAuthorizations(tAuthorization);
            }
        }
        catch (DeserializationException e) {
            throw new RuntimeException(e);
        }
        out.setReversed(in.isReversed());
        out.setCacheBlocks(in.getCacheBlocks());
        out.setReadType(ThriftUtilities.readTypeFromHBase(in.getReadType()));
        out.setLimit(in.getLimit());
        out.setConsistency(ThriftUtilities.consistencyFromHBase(in.getConsistency()));
        out.setTargetReplicaId(in.getReplicaId());
        for (Map.Entry entry : in.getColumnFamilyTimeRange().entrySet()) {
            if (entry.getValue() == null) continue;
            TTimeRange timeRange = new TTimeRange();
            timeRange.setMinStamp(((TimeRange)entry.getValue()).getMin()).setMaxStamp(((TimeRange)entry.getValue()).getMax());
            out.putToColFamTimeRangeMap(ByteBuffer.wrap((byte[])entry.getKey()), timeRange);
        }
        if (in.getFilter() != null) {
            try {
                out.setFilterBytes(ThriftUtilities.filterFromHBase(in.getFilter()));
            }
            catch (IOException ioE) {
                throw new RuntimeException(ioE);
            }
        }
        return out;
    }

    public static THRegionLocation regionLocationFromHBase(HRegionLocation hrl) {
        HRegionInfo hri = hrl.getRegionInfo();
        ServerName serverName = hrl.getServerName();
        THRegionInfo thRegionInfo = new THRegionInfo();
        THRegionLocation thRegionLocation = new THRegionLocation();
        TServerName tServerName = new TServerName();
        tServerName.setHostName(serverName.getHostname());
        tServerName.setPort(serverName.getPort());
        tServerName.setStartCode(serverName.getStartcode());
        thRegionInfo.setTableName(hri.getTable().getName());
        thRegionInfo.setEndKey(hri.getEndKey());
        thRegionInfo.setStartKey(hri.getStartKey());
        thRegionInfo.setOffline(hri.isOffline());
        thRegionInfo.setSplit(hri.isSplit());
        thRegionInfo.setReplicaId(hri.getReplicaId());
        thRegionLocation.setRegionInfo(thRegionInfo);
        thRegionLocation.setServerName(tServerName);
        return thRegionLocation;
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary((byte[])Bytes.getBytes((ByteBuffer)entry.getKey()));
            byte[] value = Bytes.getBytes((ByteBuffer)entry.getValue());
            op.setAttribute(name, value);
        }
    }

    private static Durability durabilityFromThrift(TDurability tDurability) {
        switch (tDurability.getValue()) {
            case 0: {
                return Durability.USE_DEFAULT;
            }
            case 1: {
                return Durability.SKIP_WAL;
            }
            case 2: {
                return Durability.ASYNC_WAL;
            }
            case 3: {
                return Durability.SYNC_WAL;
            }
            case 4: {
                return Durability.FSYNC_WAL;
            }
        }
        return Durability.USE_DEFAULT;
    }

    private static TReadType readTypeFromHBase(Scan.ReadType readType) {
        switch (readType) {
            case DEFAULT: {
                return TReadType.DEFAULT;
            }
            case STREAM: {
                return TReadType.STREAM;
            }
            case PREAD: {
                return TReadType.PREAD;
            }
        }
        return TReadType.DEFAULT;
    }

    private static Consistency consistencyFromThrift(TConsistency tConsistency) {
        switch (tConsistency.getValue()) {
            case 1: {
                return Consistency.STRONG;
            }
            case 2: {
                return Consistency.TIMELINE;
            }
        }
        return Consistency.STRONG;
    }

    public static TableName tableNameFromThrift(TTableName tableName) {
        return TableName.valueOf((byte[])tableName.getNs(), (byte[])tableName.getQualifier());
    }

    public static TableName[] tableNamesArrayFromThrift(List<TTableName> tableNames) {
        TableName[] out = new TableName[tableNames.size()];
        int index = 0;
        for (TTableName tableName : tableNames) {
            out[index++] = ThriftUtilities.tableNameFromThrift(tableName);
        }
        return out;
    }

    public static TTableName tableNameFromHBase(TableName table) {
        TTableName tableName = new TTableName();
        tableName.setNs(table.getNamespace());
        tableName.setQualifier(table.getQualifier());
        return tableName;
    }

    public static BloomType bloomFilterFromThrift(TBloomFilterType in) {
        switch (in.getValue()) {
            case 0: {
                return BloomType.NONE;
            }
            case 1: {
                return BloomType.ROW;
            }
            case 2: {
                return BloomType.ROWCOL;
            }
        }
        return BloomType.ROW;
    }

    public static Compression.Algorithm compressionAlgorithmFromThrift(TCompressionAlgorithm in) {
        switch (in.getValue()) {
            case 0: {
                return Compression.Algorithm.LZO;
            }
            case 1: {
                return Compression.Algorithm.GZ;
            }
            case 2: {
                return Compression.Algorithm.NONE;
            }
            case 3: {
                return Compression.Algorithm.SNAPPY;
            }
            case 4: {
                return Compression.Algorithm.LZ4;
            }
            case 5: {
                return Compression.Algorithm.BZIP2;
            }
            case 6: {
                return Compression.Algorithm.ZSTD;
            }
        }
        return Compression.Algorithm.NONE;
    }

    public static DataBlockEncoding dataBlockEncodingFromThrift(TDataBlockEncoding in) {
        switch (in.getValue()) {
            case 0: {
                return DataBlockEncoding.NONE;
            }
            case 2: {
                return DataBlockEncoding.PREFIX;
            }
            case 3: {
                return DataBlockEncoding.DIFF;
            }
            case 4: {
                return DataBlockEncoding.FAST_DIFF;
            }
            case 7: {
                return DataBlockEncoding.ROW_INDEX_V1;
            }
        }
        return DataBlockEncoding.NONE;
    }

    public static KeepDeletedCells keepDeletedCellsFromThrift(TKeepDeletedCells in) {
        switch (in.getValue()) {
            case 0: {
                return KeepDeletedCells.FALSE;
            }
            case 1: {
                return KeepDeletedCells.TRUE;
            }
            case 2: {
                return KeepDeletedCells.TTL;
            }
        }
        return KeepDeletedCells.FALSE;
    }

    public static ColumnFamilyDescriptor columnFamilyDescriptorFromThrift(TColumnFamilyDescriptor in) {
        ColumnFamilyDescriptorBuilder builder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])in.getName());
        if (in.isSetAttributes()) {
            for (Map.Entry<Object, Object> entry : in.getAttributes().entrySet()) {
                builder.setValue(((ByteBuffer)entry.getKey()).array(), ((ByteBuffer)entry.getValue()).array());
            }
        }
        if (in.isSetConfiguration()) {
            for (Map.Entry<Object, Object> entry : in.getConfiguration().entrySet()) {
                builder.setConfiguration((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (in.isSetBlockSize()) {
            builder.setBlocksize(in.getBlockSize());
        }
        if (in.isSetBloomnFilterType()) {
            builder.setBloomFilterType(ThriftUtilities.bloomFilterFromThrift(in.getBloomnFilterType()));
        }
        if (in.isSetCompressionType()) {
            builder.setCompressionType(ThriftUtilities.compressionAlgorithmFromThrift(in.getCompressionType()));
        }
        if (in.isSetDfsReplication()) {
            builder.setDFSReplication(in.getDfsReplication());
        }
        if (in.isSetDataBlockEncoding()) {
            builder.setDataBlockEncoding(ThriftUtilities.dataBlockEncodingFromThrift(in.getDataBlockEncoding()));
        }
        if (in.isSetKeepDeletedCells()) {
            builder.setKeepDeletedCells(ThriftUtilities.keepDeletedCellsFromThrift(in.getKeepDeletedCells()));
        }
        if (in.isSetMaxVersions()) {
            builder.setMaxVersions(in.getMaxVersions());
        }
        if (in.isSetMinVersions()) {
            builder.setMinVersions(in.getMinVersions());
        }
        if (in.isSetScope()) {
            builder.setScope(in.getScope());
        }
        if (in.isSetTimeToLive()) {
            builder.setTimeToLive(in.getTimeToLive());
        }
        if (in.isSetBlockCacheEnabled()) {
            builder.setBlockCacheEnabled(in.isBlockCacheEnabled());
        }
        if (in.isSetCacheBloomsOnWrite()) {
            builder.setCacheBloomsOnWrite(in.isCacheBloomsOnWrite());
        }
        if (in.isSetCacheDataOnWrite()) {
            builder.setCacheDataOnWrite(in.isCacheDataOnWrite());
        }
        if (in.isSetCacheIndexesOnWrite()) {
            builder.setCacheIndexesOnWrite(in.isCacheIndexesOnWrite());
        }
        if (in.isSetCompressTags()) {
            builder.setCompressTags(in.isCompressTags());
        }
        if (in.isSetEvictBlocksOnClose()) {
            builder.setEvictBlocksOnClose(in.isEvictBlocksOnClose());
        }
        if (in.isSetInMemory()) {
            builder.setInMemory(in.isInMemory());
        }
        return builder.build();
    }

    public static NamespaceDescriptor namespaceDescriptorFromThrift(TNamespaceDescriptor in) {
        NamespaceDescriptor.Builder builder = NamespaceDescriptor.create((String)in.getName());
        if (in.isSetConfiguration()) {
            for (Map.Entry<String, String> conf : in.getConfiguration().entrySet()) {
                builder.addConfiguration(conf.getKey(), conf.getValue());
            }
        }
        return builder.build();
    }

    public static TNamespaceDescriptor namespaceDescriptorFromHBase(NamespaceDescriptor in) {
        TNamespaceDescriptor out = new TNamespaceDescriptor();
        out.setName(in.getName());
        for (Map.Entry conf : in.getConfiguration().entrySet()) {
            out.putToConfiguration((String)conf.getKey(), (String)conf.getValue());
        }
        return out;
    }

    public static TableDescriptor tableDescriptorFromThrift(TTableDescriptor in) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)ThriftUtilities.tableNameFromThrift(in.getTableName()));
        for (TColumnFamilyDescriptor tColumnFamilyDescriptor : in.getColumns()) {
            builder.setColumnFamily(ThriftUtilities.columnFamilyDescriptorFromThrift(tColumnFamilyDescriptor));
        }
        if (in.isSetAttributes()) {
            for (Map.Entry entry : in.getAttributes().entrySet()) {
                builder.setValue(((ByteBuffer)entry.getKey()).array(), ((ByteBuffer)entry.getValue()).array());
            }
        }
        if (in.isSetDurability()) {
            builder.setDurability(ThriftUtilities.durabilityFromThrift(in.getDurability()));
        }
        return builder.build();
    }

    public static HTableDescriptor hTableDescriptorFromThrift(TTableDescriptor in) {
        return new HTableDescriptor(ThriftUtilities.tableDescriptorFromThrift(in));
    }

    public static HTableDescriptor[] hTableDescriptorsFromThrift(List<TTableDescriptor> in) {
        HTableDescriptor[] out = new HTableDescriptor[in.size()];
        int index = 0;
        for (TTableDescriptor tTableDescriptor : in) {
            out[index++] = ThriftUtilities.hTableDescriptorFromThrift(tTableDescriptor);
        }
        return out;
    }

    public static List<TableDescriptor> tableDescriptorsFromThrift(List<TTableDescriptor> in) {
        ArrayList<TableDescriptor> out = new ArrayList<TableDescriptor>();
        for (TTableDescriptor tableDescriptor : in) {
            out.add(ThriftUtilities.tableDescriptorFromThrift(tableDescriptor));
        }
        return out;
    }

    private static TDurability durabilityFromHBase(Durability durability) {
        switch (durability) {
            case USE_DEFAULT: {
                return TDurability.USE_DEFAULT;
            }
            case SKIP_WAL: {
                return TDurability.SKIP_WAL;
            }
            case ASYNC_WAL: {
                return TDurability.ASYNC_WAL;
            }
            case SYNC_WAL: {
                return TDurability.SYNC_WAL;
            }
            case FSYNC_WAL: {
                return TDurability.FSYNC_WAL;
            }
        }
        return null;
    }

    public static TTableDescriptor tableDescriptorFromHBase(TableDescriptor in) {
        TTableDescriptor out = new TTableDescriptor();
        out.setTableName(ThriftUtilities.tableNameFromHBase(in.getTableName()));
        Map attributes = in.getValues();
        for (Map.Entry attribute : attributes.entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(((Bytes)attribute.getKey()).get()), ByteBuffer.wrap(((Bytes)attribute.getValue()).get()));
        }
        for (ColumnFamilyDescriptor column : in.getColumnFamilies()) {
            out.addToColumns(ThriftUtilities.columnFamilyDescriptorFromHBase(column));
        }
        out.setDurability(ThriftUtilities.durabilityFromHBase(in.getDurability()));
        return out;
    }

    public static TBloomFilterType bloomFilterFromHBase(BloomType in) {
        switch (in) {
            case NONE: {
                return TBloomFilterType.NONE;
            }
            case ROW: {
                return TBloomFilterType.ROW;
            }
            case ROWCOL: {
                return TBloomFilterType.ROWCOL;
            }
        }
        return TBloomFilterType.ROW;
    }

    public static TCompressionAlgorithm compressionAlgorithmFromHBase(Compression.Algorithm in) {
        switch (in) {
            case LZO: {
                return TCompressionAlgorithm.LZO;
            }
            case GZ: {
                return TCompressionAlgorithm.GZ;
            }
            case NONE: {
                return TCompressionAlgorithm.NONE;
            }
            case SNAPPY: {
                return TCompressionAlgorithm.SNAPPY;
            }
            case LZ4: {
                return TCompressionAlgorithm.LZ4;
            }
            case BZIP2: {
                return TCompressionAlgorithm.BZIP2;
            }
            case ZSTD: {
                return TCompressionAlgorithm.ZSTD;
            }
        }
        return TCompressionAlgorithm.NONE;
    }

    public static TDataBlockEncoding dataBlockEncodingFromHBase(DataBlockEncoding in) {
        switch (in) {
            case NONE: {
                return TDataBlockEncoding.NONE;
            }
            case PREFIX: {
                return TDataBlockEncoding.PREFIX;
            }
            case DIFF: {
                return TDataBlockEncoding.DIFF;
            }
            case FAST_DIFF: {
                return TDataBlockEncoding.FAST_DIFF;
            }
            case ROW_INDEX_V1: {
                return TDataBlockEncoding.ROW_INDEX_V1;
            }
        }
        return TDataBlockEncoding.NONE;
    }

    public static TKeepDeletedCells keepDeletedCellsFromHBase(KeepDeletedCells in) {
        switch (in) {
            case FALSE: {
                return TKeepDeletedCells.FALSE;
            }
            case TRUE: {
                return TKeepDeletedCells.TRUE;
            }
            case TTL: {
                return TKeepDeletedCells.TTL;
            }
        }
        return TKeepDeletedCells.FALSE;
    }

    public static TColumnFamilyDescriptor columnFamilyDescriptorFromHBase(ColumnFamilyDescriptor in) {
        TColumnFamilyDescriptor out = new TColumnFamilyDescriptor();
        out.setName(in.getName());
        for (Map.Entry attribute : in.getValues().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(((Bytes)attribute.getKey()).get()), ByteBuffer.wrap(((Bytes)attribute.getValue()).get()));
        }
        for (Map.Entry conf : in.getConfiguration().entrySet()) {
            out.putToConfiguration((String)conf.getKey(), (String)conf.getValue());
        }
        out.setBlockSize(in.getBlocksize());
        out.setBloomnFilterType(ThriftUtilities.bloomFilterFromHBase(in.getBloomFilterType()));
        out.setCompressionType(ThriftUtilities.compressionAlgorithmFromHBase(in.getCompressionType()));
        out.setDfsReplication(in.getDFSReplication());
        out.setDataBlockEncoding(ThriftUtilities.dataBlockEncodingFromHBase(in.getDataBlockEncoding()));
        out.setKeepDeletedCells(ThriftUtilities.keepDeletedCellsFromHBase(in.getKeepDeletedCells()));
        out.setMaxVersions(in.getMaxVersions());
        out.setMinVersions(in.getMinVersions());
        out.setScope(in.getScope());
        out.setTimeToLive(in.getTimeToLive());
        out.setBlockCacheEnabled(in.isBlockCacheEnabled());
        out.setCacheBloomsOnWrite(in.isCacheBloomsOnWrite());
        out.setCacheDataOnWrite(in.isCacheDataOnWrite());
        out.setCacheIndexesOnWrite(in.isCacheIndexesOnWrite());
        out.setCompressTags(in.isCompressTags());
        out.setEvictBlocksOnClose(in.isEvictBlocksOnClose());
        out.setInMemory(in.isInMemory());
        return out;
    }

    private static TConsistency consistencyFromHBase(Consistency consistency) {
        switch (consistency) {
            case STRONG: {
                return TConsistency.STRONG;
            }
            case TIMELINE: {
                return TConsistency.TIMELINE;
            }
        }
        return TConsistency.STRONG;
    }

    public static TGet getFromHBase(Get in) {
        TGet out = new TGet();
        out.setRow(in.getRow());
        TTimeRange tTimeRange = new TTimeRange();
        tTimeRange.setMaxStamp(in.getTimeRange().getMax()).setMinStamp(in.getTimeRange().getMin());
        out.setTimeRange(tTimeRange);
        out.setMaxVersions(in.getMaxVersions());
        for (Map.Entry attribute : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)attribute.getKey()))), ByteBuffer.wrap((byte[])attribute.getValue()));
        }
        try {
            Authorizations authorizations = in.getAuthorizations();
            if (authorizations != null) {
                TAuthorization tAuthorization = new TAuthorization();
                tAuthorization.setLabels(authorizations.getLabels());
                out.setAuthorizations(tAuthorization);
            }
        }
        catch (DeserializationException e) {
            throw new RuntimeException(e);
        }
        out.setConsistency(ThriftUtilities.consistencyFromHBase(in.getConsistency()));
        out.setTargetReplicaId(in.getReplicaId());
        out.setCacheBlocks(in.getCacheBlocks());
        out.setStoreLimit(in.getMaxResultsPerColumnFamily());
        out.setStoreOffset(in.getRowOffsetPerColumnFamily());
        out.setExistence_only(in.isCheckExistenceOnly());
        for (Map.Entry family : in.getFamilyMap().entrySet()) {
            if (family.getValue() != null && !((NavigableSet)family.getValue()).isEmpty()) {
                for (byte[] qualifier : (NavigableSet)family.getValue()) {
                    TColumn column = new TColumn();
                    column.setFamily((byte[])family.getKey());
                    column.setQualifier(qualifier);
                    out.addToColumns(column);
                }
                continue;
            }
            TColumn column = new TColumn();
            column.setFamily((byte[])family.getKey());
            out.addToColumns(column);
        }
        if (in.getFilter() != null) {
            try {
                out.setFilterBytes(ThriftUtilities.filterFromHBase(in.getFilter()));
            }
            catch (IOException ioE) {
                throw new RuntimeException(ioE);
            }
        }
        return out;
    }

    public static Cell toCell(ExtendedCellBuilder cellBuilder, byte[] row, TColumnValue columnValue) {
        return cellBuilder.clear().setRow(row).setFamily(columnValue.getFamily()).setQualifier(columnValue.getQualifier()).setTimestamp(columnValue.getTimestamp()).setType(columnValue.getType()).setValue(columnValue.getValue()).setTags(columnValue.getTags()).build();
    }

    public static Result resultFromThrift(TResult in) {
        if (in == null) {
            return null;
        }
        if (!in.isSetColumnValues() || in.getColumnValues().isEmpty()) {
            return in.isStale() ? EMPTY_RESULT_STALE : EMPTY_RESULT;
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(in.getColumnValues().size());
        ExtendedCellBuilder builder = ExtendedCellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY);
        for (TColumnValue columnValue : in.getColumnValues()) {
            cells.add(ThriftUtilities.toCell(builder, in.getRow(), columnValue));
        }
        return Result.create(cells, null, (boolean)in.isStale(), (boolean)in.isPartial());
    }

    public static TPut putFromHBase(Put in) {
        TPut out = new TPut();
        out.setRow(in.getRow());
        if (in.getTimestamp() != Long.MAX_VALUE) {
            out.setTimestamp(in.getTimestamp());
        }
        if (in.getDurability() != Durability.USE_DEFAULT) {
            out.setDurability(ThriftUtilities.durabilityFromHBase(in.getDurability()));
        }
        for (Map.Entry entry : in.getFamilyCellMap().entrySet()) {
            byte[] family = (byte[])entry.getKey();
            for (Cell cell : (List)entry.getValue()) {
                TColumnValue columnValue = new TColumnValue();
                columnValue.setFamily(family).setQualifier(CellUtil.cloneQualifier((Cell)cell)).setType(cell.getType().getCode()).setTimestamp(cell.getTimestamp()).setValue(CellUtil.cloneValue((Cell)cell));
                if (cell.getTagsLength() != 0) {
                    columnValue.setTags(CellUtil.cloneTags((Cell)cell));
                }
                out.addToColumnValues(columnValue);
            }
        }
        for (Map.Entry attribute : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)attribute.getKey()))), ByteBuffer.wrap((byte[])attribute.getValue()));
        }
        try {
            CellVisibility cellVisibility = in.getCellVisibility();
            if (cellVisibility != null) {
                TCellVisibility tCellVisibility = new TCellVisibility();
                tCellVisibility.setExpression(cellVisibility.getExpression());
                out.setCellVisibility(tCellVisibility);
            }
        }
        catch (DeserializationException e) {
            throw new RuntimeException(e);
        }
        return out;
    }

    public static List<TPut> putsFromHBase(List<Put> in) {
        ArrayList<TPut> out = new ArrayList<TPut>(in.size());
        for (Put put2 : in) {
            out.add(ThriftUtilities.putFromHBase(put2));
        }
        return out;
    }

    public static NamespaceDescriptor[] namespaceDescriptorsFromThrift(List<TNamespaceDescriptor> in) {
        NamespaceDescriptor[] out = new NamespaceDescriptor[in.size()];
        int index = 0;
        for (TNamespaceDescriptor descriptor : in) {
            out[index++] = ThriftUtilities.namespaceDescriptorFromThrift(descriptor);
        }
        return out;
    }

    public static List<TDelete> deletesFromHBase(List<Delete> in) {
        ArrayList<TDelete> out = new ArrayList<TDelete>(in.size());
        for (Delete delete : in) {
            out.add(ThriftUtilities.deleteFromHBase(delete));
        }
        return out;
    }

    public static TAppend appendFromHBase(Append in) throws IOException {
        TAppend out = new TAppend();
        out.setRow(in.getRow());
        if (in.getDurability() != Durability.USE_DEFAULT) {
            out.setDurability(ThriftUtilities.durabilityFromHBase(in.getDurability()));
        }
        for (Map.Entry entry : in.getFamilyCellMap().entrySet()) {
            byte[] family = (byte[])entry.getKey();
            for (Cell cell : (List)entry.getValue()) {
                TColumnValue columnValue = new TColumnValue();
                columnValue.setFamily(family).setQualifier(CellUtil.cloneQualifier((Cell)cell)).setType(cell.getType().getCode()).setTimestamp(cell.getTimestamp()).setValue(CellUtil.cloneValue((Cell)cell));
                if (cell.getTagsLength() != 0) {
                    columnValue.setTags(CellUtil.cloneTags((Cell)cell));
                }
                out.addToColumns(columnValue);
            }
        }
        for (Map.Entry attribute : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)attribute.getKey()))), ByteBuffer.wrap((byte[])attribute.getValue()));
        }
        try {
            CellVisibility cellVisibility = in.getCellVisibility();
            if (cellVisibility != null) {
                TCellVisibility tCellVisibility = new TCellVisibility();
                tCellVisibility.setExpression(cellVisibility.getExpression());
                out.setCellVisibility(tCellVisibility);
            }
        }
        catch (DeserializationException e) {
            throw new RuntimeException(e);
        }
        out.setReturnResults(in.isReturnResults());
        return out;
    }

    public static TIncrement incrementFromHBase(Increment in) throws IOException {
        TIncrement out = new TIncrement();
        out.setRow(in.getRow());
        if (in.getDurability() != Durability.USE_DEFAULT) {
            out.setDurability(ThriftUtilities.durabilityFromHBase(in.getDurability()));
        }
        for (Map.Entry entry : in.getFamilyCellMap().entrySet()) {
            byte[] family = (byte[])entry.getKey();
            for (Cell cell : (List)entry.getValue()) {
                TColumnIncrement columnValue = new TColumnIncrement();
                columnValue.setFamily(family).setQualifier(CellUtil.cloneQualifier((Cell)cell));
                columnValue.setAmount(Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
                out.addToColumns(columnValue);
            }
        }
        for (Map.Entry attribute : in.getAttributesMap().entrySet()) {
            out.putToAttributes(ByteBuffer.wrap(Bytes.toBytes((String)((String)attribute.getKey()))), ByteBuffer.wrap((byte[])attribute.getValue()));
        }
        try {
            CellVisibility cellVisibility = in.getCellVisibility();
            if (cellVisibility != null) {
                TCellVisibility tCellVisibility = new TCellVisibility();
                tCellVisibility.setExpression(cellVisibility.getExpression());
                out.setCellVisibility(tCellVisibility);
            }
        }
        catch (DeserializationException e) {
            throw new RuntimeException(e);
        }
        out.setReturnResults(in.isReturnResults());
        return out;
    }

    public static TRowMutations rowMutationsFromHBase(RowMutations in) {
        TRowMutations tRowMutations = new TRowMutations();
        tRowMutations.setRow(in.getRow());
        for (Mutation mutation : in.getMutations()) {
            TMutation tMutation = new TMutation();
            if (mutation instanceof Put) {
                tMutation.setPut(ThriftUtilities.putFromHBase((Put)mutation));
            } else if (mutation instanceof Delete) {
                tMutation.setDeleteSingle(ThriftUtilities.deleteFromHBase((Delete)mutation));
            } else {
                throw new IllegalArgumentException("Only Put and Delete is supported in mutateRow, but muation=" + mutation);
            }
            tRowMutations.addToMutations(tMutation);
        }
        return tRowMutations;
    }

    public static TCompareOp compareOpFromHBase(CompareOperator compareOp) {
        switch (compareOp) {
            case LESS: {
                return TCompareOp.LESS;
            }
            case LESS_OR_EQUAL: {
                return TCompareOp.LESS_OR_EQUAL;
            }
            case EQUAL: {
                return TCompareOp.EQUAL;
            }
            case NOT_EQUAL: {
                return TCompareOp.NOT_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return TCompareOp.GREATER_OR_EQUAL;
            }
            case GREATER: {
                return TCompareOp.GREATER;
            }
            case NO_OP: {
                return TCompareOp.NO_OP;
            }
        }
        return null;
    }

    public static List<ByteBuffer> splitKeyFromHBase(byte[][] in) {
        if (in == null || in.length == 0) {
            return null;
        }
        ArrayList<ByteBuffer> out = new ArrayList<ByteBuffer>(in.length);
        for (byte[] key : in) {
            out.add(ByteBuffer.wrap(key));
        }
        return out;
    }

    public static Result[] resultsFromThrift(List<TResult> in) {
        Result[] out = new Result[in.size()];
        int index = 0;
        for (TResult tResult : in) {
            out[index++] = ThriftUtilities.resultFromThrift(tResult);
        }
        return out;
    }

    public static List<TGet> getsFromHBase(List<Get> in) {
        ArrayList<TGet> out = new ArrayList<TGet>(in.size());
        for (Get get2 : in) {
            out.add(ThriftUtilities.getFromHBase(get2));
        }
        return out;
    }
}

