/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.Switchable;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ClusterSwitchTracker
implements Watcher {
    private static final Log LOG = LogFactory.getLog(ClusterSwitchTracker.class);
    private String quorum;
    private CountDownLatch syncLatch;
    private RecoverableZooKeeper zooKeeper;
    public String redirectNode;
    private String identifier;
    private final Switchable switchable;
    private Configuration conf;
    private volatile boolean stopped = false;
    private boolean everConnected = false;
    private int expireTime;
    private Lock zkConnectionLock = new ReentrantLock();

    public ClusterSwitchTracker(Configuration conf, Switchable switchable) throws IOException {
        this(conf, switchable, null);
    }

    public ClusterSwitchTracker(Configuration conf, Switchable switchable, CountDownLatch syncLatch) throws IOException {
        this.conf = conf;
        this.switchable = switchable;
        this.syncLatch = syncLatch;
        this.quorum = ZKConfig.getZKQuorumServersString((Configuration)conf);
        this.redirectNode = ZNodePaths.joinZNode((String)ClusterSwitchUtil.getBaseNode(conf.get("haclient.base.node", "/haclient"), AliHBaseConstants.getHaClusterID(conf)), (String)conf.get(ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE, ClusterSwitchUtil.ZOOKEEPER_REDIRECT_NODE_DEFAULT));
        this.expireTime = conf.getInt("zookeeper.session.timeout", 90000);
        this.identifier = this.quorum + "_ClusterSwitchTracker0x0";
        this.zooKeeper = ZKUtil.connect((Configuration)conf, (String)this.quorum, (Watcher)this, (String)this.identifier);
    }

    private void fetchKeyAndSwitch() {
        try {
            if (this.zooKeeper.exists(this.redirectNode, true) != null) {
                byte[] bytes = this.zooKeeper.getData(this.redirectNode, true, null);
                this.switchable.onNodeChange(bytes);
            } else {
                this.switchable.onNodeChange(null);
            }
            if (!this.everConnected && this.syncLatch != null) {
                this.syncLatch.countDown();
            }
        }
        catch (KeeperException.NoNodeException noNodeEx) {
            this.switchable.onNodeChange(null);
            if (!this.everConnected && this.syncLatch != null) {
                this.syncLatch.countDown();
            }
        }
        catch (KeeperException keeperException) {
            LOG.warn((Object)"Switch failed since", (Throwable)keeperException);
        }
        catch (InterruptedException ie) {
            LOG.error((Object)(this.toString() + " is interrupted"), (Throwable)ie);
            Thread.currentThread().interrupt();
        }
    }

    public String getRedirectNode() {
        return this.redirectNode;
    }

    public String getQuorum() {
        return this.quorum;
    }

    public void process(WatchedEvent event) {
        LOG.trace((Object)(this.toString() + "Received ZooKeeper Event, type=" + event.getType() + ", state=" + event.getState() + ", path=" + event.getPath()));
        switch (event.getType()) {
            case None: {
                this.connectionEvent(event);
                break;
            }
            case NodeCreated: 
            case NodeDeleted: 
            case NodeDataChanged: {
                this.fetchKeyAndSwitch();
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + event.getState());
            }
        }
    }

    public void connectionEvent(WatchedEvent event) {
        switch (event.getState()) {
            case SyncConnected: {
                if (this.zooKeeper == null) {
                    long finished = System.currentTimeMillis() + this.conf.getLong("hbase.zookeeper.watcher.sync.connected.wait", 2000L);
                    while (System.currentTimeMillis() < finished) {
                        try {
                            if (this.zooKeeper != null) break;
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Object)"Interrupted while sleeping");
                            throw new RuntimeException("Interrupted while waiting for recoverableZooKeeper is set");
                        }
                    }
                    if (this.zooKeeper == null) {
                        LOG.error((Object)("ZK is null on connection event for " + this.quorum));
                        throw new NullPointerException("ZK is null for " + this.quorum);
                    }
                }
                this.identifier = this.identifier + "-0x" + Long.toHexString(this.zooKeeper.getSessionId());
                LOG.debug((Object)(this.identifier + " connected"));
                this.fetchKeyAndSwitch();
                if (this.everConnected) break;
                this.everConnected = true;
                break;
            }
            case Disconnected: {
                LOG.debug((Object)(this.toString() + "Received Disconnected from ZooKeeper, ignoring"));
                break;
            }
            case Expired: {
                LOG.debug((Object)(this.toString() + " received expired from ZooKeeper, reconnecting"));
                this.startThreadForZKReconnection();
                break;
            }
            case ConnectedReadOnly: 
            case SaslAuthenticated: 
            case AuthFailed: {
                break;
            }
            default: {
                throw new IllegalStateException("Received event is not valid: " + event.getState());
            }
        }
    }

    public synchronized void stop() {
        if (!this.stopped) {
            this.stopped = true;
            LOG.info((Object)("Stopping tracker on cluster " + this.quorum));
            this.closeZookeeper();
        }
    }

    private void closeZookeeper() {
        if (this.zooKeeper != null) {
            try {
                if (this.zooKeeper != null) {
                    this.zooKeeper.close();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.zooKeeper = null;
        }
    }

    private void startThreadForZKReconnection() {
        if (this.zooKeeper == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                if (!ClusterSwitchTracker.this.zkConnectionLock.tryLock()) {
                    return;
                }
                try {
                    ClusterSwitchTracker.this.closeZookeeper();
                    while (!ClusterSwitchTracker.this.stopped) {
                        try {
                            if (ClusterSwitchTracker.this.zooKeeper == null) {
                                ClusterSwitchTracker.this.zooKeeper = ZKUtil.connect((Configuration)ClusterSwitchTracker.this.conf, (String)ClusterSwitchTracker.this.quorum, (Watcher)ClusterSwitchTracker.this, (String)ClusterSwitchTracker.this.identifier);
                            }
                            LOG.info((Object)("Successfully reconnected to cluster switch tracker on zk '" + ClusterSwitchTracker.this.quorum + "'"));
                            break;
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)("Failed reconnecting to cluster switch tracker on zk '" + ClusterSwitchTracker.this.quorum + "', will retry again..."), t);
                            Threads.sleep((long)30000L);
                        }
                    }
                }
                finally {
                    ClusterSwitchTracker.this.zkConnectionLock.unlock();
                }
            }
        };
        t.setDaemon(true);
        t.setName("ClusterSwitchTracker-ZK-Reconnection-" + System.currentTimeMillis());
        t.start();
    }

    @VisibleForTesting
    public RecoverableZooKeeper getZooKeeper() {
        return this.zooKeeper;
    }

    public String toString() {
        return this.identifier + ", trackNode=" + this.redirectNode + " ";
    }
}

