/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultCounter {
    private static final Log LOG = LogFactory.getLog(ResultCounter.class);
    private AtomicLong activeErrorCount = new AtomicLong(0L);
    private AtomicLong activeTimeoutCount = new AtomicLong(0L);
    private AtomicLong standbySuccessCount = new AtomicLong(0L);
    private AtomicLong totalRequestCount = new AtomicLong(0L);
    private AtomicLong totalActiveErrorCount = new AtomicLong(0L);
    private AtomicLong totalActiveTimeoutCount = new AtomicLong(0L);
    private volatile double activeFailPecentage = 0.0;
    private CountStrategy strategy;

    public ResultCounter(CountStrategy strategy) {
        this.strategy = strategy;
    }

    public <T> void increment(DualContext<T> dualContext) {
        if (this.strategy == CountStrategy.PERCENTAGE) {
            this.totalRequestCount.incrementAndGet();
        }
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.DEFAULT) {
            if (dualContext.usePrimaryAsResult().booleanValue()) {
                this.activeCountClear();
                return;
            }
            if (dualContext.activeHasError()) {
                this.activeErrorCount.incrementAndGet();
                if (this.strategy == CountStrategy.PERCENTAGE) {
                    this.totalActiveErrorCount.incrementAndGet();
                }
            } else if (dualContext.useStandbyAsResult()) {
                this.activeTimeoutCount.incrementAndGet();
                if (this.strategy == CountStrategy.PERCENTAGE) {
                    this.totalActiveTimeoutCount.incrementAndGet();
                }
                this.standbySuccessCount.incrementAndGet();
            } else {
                this.standbySuccessCount.set(0L);
            }
        } else {
            if (dualContext.useStandbyAsResult()) {
                if (dualContext.activeHasError()) {
                    this.standbySuccessCount.set(0L);
                }
                return;
            }
            if (dualContext.usePrimaryAsResult().booleanValue()) {
                this.standbySuccessCount.incrementAndGet();
                return;
            }
            this.standbySuccessCount.set(0L);
        }
    }

    public long getActiveFailCount() {
        return this.activeErrorCount.get() + this.activeTimeoutCount.get();
    }

    public long getTotalActiveFailCount() {
        return this.totalActiveErrorCount.get() + this.totalActiveTimeoutCount.get();
    }

    public long getStandbySuccessCount() {
        return this.standbySuccessCount.get();
    }

    public long totalRequestCount() {
        return this.totalRequestCount.get();
    }

    public void activeCountClear() {
        this.activeErrorCount.set(0L);
        this.activeTimeoutCount.set(0L);
    }

    public void totalActiveCountClear() {
        this.totalActiveErrorCount.set(0L);
        this.totalActiveTimeoutCount.set(0L);
    }

    public void totalAndActiveCountClear() {
        this.totalRequestCount.set(0L);
        this.totalActiveCountClear();
    }

    public void standbyCountClear() {
        this.standbySuccessCount.set(0L);
    }

    public void updateActiveErrorPercentage() {
        long errorCount = this.getTotalActiveFailCount();
        long total = this.totalRequestCount.get();
        if (total == 0L || total <= 100L) {
            this.activeFailPecentage = 0.0;
        }
        this.activeFailPecentage = (double)errorCount / (double)total;
        this.totalAndActiveCountClear();
    }

    public double getActiveFailPercentage() {
        return this.activeFailPecentage;
    }

    public static enum CountStrategy {
        SUCCESSION,
        PERCENTAGE;

    }
}

