/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormThinDriver
extends Driver {
    public static final Log LOG = LogFactory.getLog(LindormThinDriver.class);
    public static final String CONNECT_STRING_PREFIX = "jdbc:lindorm:thin:";
    private static final String DEFAULT_SERIALIZATION = "PROTOBUF";

    protected static Properties getProperties(String user, String password) {
        Properties properties = new Properties();
        properties.put("user", user);
        properties.put("password", password);
        return properties;
    }

    public static String getConnectionUrl(String hostname, int port) {
        return LindormThinDriver.getConnectionUrl("http", hostname, port);
    }

    private static String getConnectionUrl(String protocol, String hostname, int port) {
        return LindormThinDriver.getConnectionUrl(protocol, hostname, port, DEFAULT_SERIALIZATION);
    }

    private static String getConnectionUrl(String protocol, String hostname, int port, String serialization) {
        String urlFmt = "jdbc:lindorm:thin:url=%s://%s:%s;serialization=%s";
        return String.format(urlFmt, protocol, hostname, port, serialization);
    }

    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, (String)"com-alibaba-lindorm-remote-jdbc.properties", (String)"Lindorm Remote JDBC Driver", (String)"unknown version", (String)"Alibaba Lindorm", (String)"unknown version");
    }

    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        try {
            return super.connect(url, info);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LOG.info((Object)"register lindorm thin driver");
        new LindormThinDriver().register();
    }
}

