/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.compile;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.exception.LindormException;

public class LikePattern {
    private static Node accept = new TerminationNode();
    private Node root;

    private LikePattern(String pattern, Character escapeCharacter) throws LindormException {
        this.build(pattern, escapeCharacter, false);
    }

    private LikePattern(String pattern, Character escapeCharacter, boolean invert) throws LindormException {
        this.build(pattern, escapeCharacter, invert);
    }

    private void build(String pattern, Character escapeCharacter, boolean invert) throws LindormException {
        Node current = this.root = new DepartureNode();
        Node newNode = null;
        PercentSignNode lastPercentSignNode = null;
        Node lastUnmatchedNext = null;
        Object nodeBeforeFristUnderScore = null;
        int i = 0;
        int patternLength = pattern.length();
        while (i < patternLength) {
            char c = pattern.charAt(i);
            if (escapeCharacter != null && escapeCharacter.equals(Character.valueOf(c))) {
                if (!this.isWildcard(pattern, ++i)) continue;
                c = pattern.charAt(i);
            } else if (c == '%') {
                if (lastPercentSignNode != null && current == lastPercentSignNode) {
                    ++i;
                    continue;
                }
                lastPercentSignNode = newNode = new PercentSignNode(invert);
                lastUnmatchedNext = lastPercentSignNode;
            } else if (c == '_') {
                newNode = new UnderscoreNode(invert);
            }
            if (newNode == null || newNode != lastPercentSignNode) {
                if (lastPercentSignNode != null) {
                    if (current == lastPercentSignNode) {
                        if (newNode == null) {
                            newNode = new BranchNode(c, null, invert);
                        }
                    } else {
                        lastUnmatchedNext = this.findLastUnmatchedNext(lastUnmatchedNext, lastPercentSignNode, current);
                        if (newNode == null) {
                            newNode = new BranchNode(c, lastUnmatchedNext, invert);
                        } else {
                            newNode.unmatchedNext = lastUnmatchedNext;
                        }
                    }
                } else if (newNode == null) {
                    newNode = new CharacterNode(c, invert);
                }
            }
            current.next = newNode;
            current = newNode;
            newNode = null;
            ++i;
        }
        if (lastPercentSignNode != null && current != lastPercentSignNode) {
            lastUnmatchedNext = this.findLastUnmatchedNext(lastUnmatchedNext, lastPercentSignNode, current);
            current.next = new TerminationNode(lastUnmatchedNext);
        }
    }

    private Node findLastUnmatchedNext(Node lastUnmatchedNext, Node lastPercentSignNode, Node current) {
        while (lastUnmatchedNext != lastPercentSignNode && !current.match(lastUnmatchedNext)) {
            lastUnmatchedNext = lastUnmatchedNext.unmatchedNext != null ? lastUnmatchedNext.unmatchedNext : lastPercentSignNode;
        }
        lastUnmatchedNext = lastUnmatchedNext.next;
        return lastUnmatchedNext;
    }

    private boolean isWildcard(String pattern, int index) throws LindormException {
        if (index >= pattern.length()) {
            throw new LindormException("pattern must not end with escape character");
        }
        char c = pattern.charAt(index);
        return c == '%' || c == '_';
    }

    public static LikePattern compile(String pattern) throws LindormException {
        return LikePattern.compile(pattern, null, false);
    }

    public static LikePattern compile(String pattern, boolean invert) throws LindormException {
        return LikePattern.compile(pattern, null, invert);
    }

    public static LikePattern compile(String pattern, Character escapeCharacter) throws LindormException {
        return LikePattern.compile(pattern, escapeCharacter, false);
    }

    public static LikePattern compile(String pattern, Character escapeCharacter, boolean invert) throws LindormException {
        if (pattern == null) {
            return null;
        }
        return new LikePattern(pattern, escapeCharacter, invert);
    }

    public LikeMatcher matcher(String input) {
        return new StringLikeMatcher(this, input);
    }

    public LikeMatcher matcher(byte[] input) {
        return new BytesLikeMatcher(this, input, 0, input.length);
    }

    public LikeMatcher matcher(byte[] input, int offset, int length) {
        return new BytesLikeMatcher(this, input, offset, length);
    }

    public static boolean isWildcard(char c) {
        return c == '_' || c == '%';
    }

    public static void check(String pattern, Character escapeCharacter) throws LindormException {
        if (escapeCharacter == null || pattern.length() == 0) {
            return;
        }
        if (pattern.charAt(pattern.length() - 1) == escapeCharacter.charValue()) {
            throw new LindormException("pattern must not end with escape character");
        }
    }

    private static int getNumBytesInUTF8(byte[] bytes, int index, boolean invert) {
        if (index < 0 || index > bytes.length) {
            return -1;
        }
        byte leadingByte = bytes[index];
        int mask = !invert ? 0 : -1;
        if (((leadingByte ^ mask) & 0x80) == 0) {
            return 1;
        }
        if ((((leadingByte = (byte)(leadingByte << 1)) ^ mask) & 0x80) == 0) {
            return -1;
        }
        int count = 1;
        while (((leadingByte ^ mask) & 0x80) == 128) {
            leadingByte = (byte)(leadingByte << 1);
            ++count;
        }
        return count;
    }

    private static boolean matchEncodedVarbinary(byte[] b, ImmutableBytesPtr text, int i) {
        boolean matched;
        int remainingLengthInGroup = LikePattern.getRemainingLengthInGroup(i);
        int length = Math.min(b.length, remainingLengthInGroup);
        boolean bl = matched = Bytes.compareTo(b, 0, length, text.get(), text.getOffset() + i, length) == 0;
        if (!matched || b.length - length == 0) {
            return matched;
        }
        int remainingLength = b.length - length;
        if ((i += length + 1) + remainingLength > text.getLength()) {
            return false;
        }
        return Bytes.compareTo(b, length, remainingLength, text.get(), text.getOffset() + i, remainingLength) == 0;
    }

    private static int getRemainingLengthInGroup(int position) {
        return 8 - (position - position / 9) % 8;
    }

    private static int getSkippedBytes(int numBytes, int textPosition, MatchContext context) {
        int remainingLengthInGroup;
        if (context.matchingEncodedVarbinary && numBytes >= (remainingLengthInGroup = LikePattern.getRemainingLengthInGroup(textPosition))) {
            ++numBytes;
        }
        return numBytes;
    }

    private static void resetContext(MatchContext context) {
        context.backtrackPosition = -1;
        context.firstUnmatchedExpectedInUnderscore = null;
    }

    public String toString() {
        if (this.root == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        Node current = this.root;
        while (current != null) {
            builder.append(current.toString());
            if (!(current instanceof TerminationNode)) {
                builder.append(" -> ");
            }
            current = current.next;
        }
        return builder.toString();
    }

    public static class BytesLikeMatcher
    extends LikeMatcher {
        private byte[] text;
        private int offset;
        private int length;

        public BytesLikeMatcher(LikePattern pattern, byte[] text, int offset, int length) {
            super(pattern);
            this.text = text;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public boolean matches() {
            MatchStatus status;
            if (this.pattern.root == null) {
                return false;
            }
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(this.text, this.offset, this.length);
            MatchContext context = new MatchContext();
            Node current = this.pattern.root;
            do {
                status = current.match(ptr, context.textPosition, context);
                current = context.current;
            } while (status.equals((Object)MatchStatus.UNCERTAIN));
            return status.equals((Object)MatchStatus.MATCHED);
        }

        public boolean matchesEncodedVarbinary() {
            MatchStatus status;
            if (this.pattern.root == null) {
                return false;
            }
            int textLength = this.getTextLengthForEncodedVarbinary(this.text, this.offset, this.length);
            MatchContext context = new MatchContext();
            context.matchingEncodedVarbinary = true;
            ImmutableBytesPtr ptr = new ImmutableBytesPtr(this.text, this.offset, textLength);
            Node current = this.pattern.root;
            do {
                status = current.match(ptr, context.textPosition, context);
                current = context.current;
            } while (status.equals((Object)MatchStatus.UNCERTAIN));
            return status.equals((Object)MatchStatus.MATCHED);
        }

        private int getTextLengthForEncodedVarbinary(byte[] text, int offset, int length) {
            if (text.length == 0) {
                return 0;
            }
            byte len = text[offset + length - 1];
            if ((len & 0xFFFFFF80) == -128) {
                len = ~len;
            }
            return length - 1 - 8 + len;
        }
    }

    public static class StringLikeMatcher
    extends LikeMatcher {
        private String text;

        public StringLikeMatcher(LikePattern pattern, String text) {
            super(pattern);
            this.text = text;
        }

        @Override
        public boolean matches() {
            MatchStatus status;
            if (this.pattern.root == null) {
                return false;
            }
            MatchContext context = new MatchContext();
            Node current = this.pattern.root;
            do {
                status = current.match(this.text, context.textPosition, context);
                current = context.current;
            } while (status.equals((Object)MatchStatus.UNCERTAIN));
            return status.equals((Object)MatchStatus.MATCHED);
        }
    }

    public static abstract class LikeMatcher {
        protected LikePattern pattern;

        LikeMatcher(LikePattern pattern) {
            this.pattern = pattern;
        }

        public abstract boolean matches();
    }

    private static class UnderscoreNode
    extends Node {
        private Character expected;
        private byte[] expectedBytes;
        private boolean invert;

        public UnderscoreNode(boolean invert) {
            this.invert = invert;
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            if (i >= text.length()) {
                return MatchStatus.NOT_MATCHED;
            }
            if (this.expected != null && this.expected.charValue() != text.charAt(i) && context.firstUnmatchedExpectedInUnderscore == null) {
                context.backtrackPosition = i;
                context.firstUnmatchedExpectedInUnderscore = this;
            }
            context.current = this.next;
            context.textPosition = i + 1;
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            int numBytes;
            if (i >= text.getLength()) {
                return MatchStatus.NOT_MATCHED;
            }
            if (this.expected != null) {
                boolean matched;
                if (this.expectedBytes == null) {
                    this.expectedBytes = Bytes.toBytes(String.valueOf(this.expected));
                    if (this.invert) {
                        DataTypeUtils.invert(this.expectedBytes, 0, this.expectedBytes, 0, this.expectedBytes.length);
                    }
                }
                boolean bl = matched = i + this.expectedBytes.length <= text.getLength();
                if (matched) {
                    boolean bl2 = !context.matchingEncodedVarbinary ? Bytes.compareTo(this.expectedBytes, 0, this.expectedBytes.length, text.get(), text.getOffset() + i, this.expectedBytes.length) == 0 : (matched = LikePattern.matchEncodedVarbinary(this.expectedBytes, text, i));
                }
                if (!matched && context.firstUnmatchedExpectedInUnderscore == null) {
                    context.backtrackPosition = i;
                    context.firstUnmatchedExpectedInUnderscore = this;
                }
            }
            if ((numBytes = LikePattern.getNumBytesInUTF8(text.get(), text.getOffset() + i, this.invert)) <= 0) {
                return MatchStatus.NOT_MATCHED;
            }
            context.current = this.next;
            context.textPosition = i + LikePattern.getSkippedBytes(numBytes, i, context);
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public boolean match(Node node) {
            if (node instanceof UnderscoreNode) {
                UnderscoreNode other = (UnderscoreNode)node;
                this.expected = other.expected;
                return true;
            }
            CharacterNode other = (CharacterNode)node;
            this.expected = Character.valueOf(other.c);
            return true;
        }

        public String toString() {
            if (this.expected == null && this.unmatchedNext == null) {
                return "_";
            }
            String underscore = this.expected == null ? "_" : "_(" + String.valueOf(this.expected) + ")";
            int count = 0;
            if (this.unmatchedNext != null) {
                Node node = this.unmatchedNext;
                while (node != this) {
                    ++count;
                    node = node.next;
                }
            }
            return underscore + "|" + (this.unmatchedNext == null ? "null" : "(" + -count + ")");
        }
    }

    private static class BranchNode
    extends CharacterNode {
        private BranchNode(char c, Node unmatchedNext) {
            super(c);
            this.unmatchedNext = unmatchedNext;
        }

        private BranchNode(char c, Node unmatchedNext, boolean invert) {
            super(c, invert);
            this.unmatchedNext = unmatchedNext;
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            boolean matched;
            if (i >= text.length()) {
                return MatchStatus.NOT_MATCHED;
            }
            boolean bl = matched = this.c == text.charAt(i);
            if (matched) {
                context.current = this.next;
                context.textPosition = i + 1;
                return MatchStatus.UNCERTAIN;
            }
            int textPosition = i;
            Node node = this;
            if (context.firstUnmatchedExpectedInUnderscore != null) {
                textPosition = context.backtrackPosition;
                node = context.firstUnmatchedExpectedInUnderscore;
                LikePattern.resetContext(context);
            }
            if (node.unmatchedNext == null) {
                context.current = node;
                context.textPosition = textPosition + 1;
            } else {
                context.current = node.unmatchedNext;
                context.textPosition = textPosition;
            }
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            boolean matched;
            if (i >= text.getLength()) {
                return MatchStatus.NOT_MATCHED;
            }
            if (this.b == null) {
                this.b = Bytes.toBytes(String.valueOf(this.c));
                if (this.invert) {
                    DataTypeUtils.invert(this.b, 0, this.b, 0, this.b.length);
                }
            }
            if (i + this.b.length > text.getLength()) {
                return MatchStatus.NOT_MATCHED;
            }
            boolean bl = !context.matchingEncodedVarbinary ? Bytes.compareTo(this.b, 0, this.b.length, text.get(), text.getOffset() + i, this.b.length) == 0 : (matched = LikePattern.matchEncodedVarbinary(this.b, text, i));
            if (matched) {
                context.current = this.next;
                context.textPosition = i + LikePattern.getSkippedBytes(this.b.length, i, context);
                return MatchStatus.UNCERTAIN;
            }
            int textPosition = i;
            Node node = this;
            if (context.firstUnmatchedExpectedInUnderscore != null) {
                textPosition = context.backtrackPosition;
                node = context.firstUnmatchedExpectedInUnderscore;
                LikePattern.resetContext(context);
            }
            if (node.unmatchedNext == null) {
                int numBytes = LikePattern.getNumBytesInUTF8(text.get(), text.getOffset() + i, this.invert);
                if (numBytes <= 0) {
                    return MatchStatus.NOT_MATCHED;
                }
                context.current = node;
                context.textPosition = textPosition + LikePattern.getSkippedBytes(numBytes, i, context);
            } else {
                context.current = node.unmatchedNext;
                context.textPosition = textPosition;
            }
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public boolean match(Node node) {
            if (node instanceof UnderscoreNode) {
                UnderscoreNode other = (UnderscoreNode)node;
                return other.expected == null || this.c == other.expected.charValue();
            }
            CharacterNode other = (CharacterNode)node;
            return this.c == other.c;
        }

        @Override
        public String toString() {
            int count = 0;
            if (this.unmatchedNext != null) {
                Node node = this.unmatchedNext;
                while (node != this) {
                    ++count;
                    node = node.next;
                }
            }
            return super.toString() + "|" + (this.unmatchedNext == null ? "null" : "(" + -count + ")");
        }
    }

    private static class CharacterNode
    extends Node {
        protected char c;
        protected byte[] b;
        protected boolean invert;

        private CharacterNode(char c) {
            this.c = c;
        }

        private CharacterNode(char c, boolean invert) {
            this.c = c;
            this.invert = invert;
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            if (i >= text.length()) {
                return MatchStatus.NOT_MATCHED;
            }
            if (this.c != text.charAt(i)) {
                return MatchStatus.NOT_MATCHED;
            }
            context.current = this.next;
            context.textPosition = i + 1;
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            boolean matched;
            if (i >= text.getLength()) {
                return MatchStatus.NOT_MATCHED;
            }
            if (this.b == null) {
                this.b = Bytes.toBytes(String.valueOf(this.c));
                if (this.invert) {
                    DataTypeUtils.invert(this.b, 0, this.b, 0, this.b.length);
                }
            }
            if (i + this.b.length > text.getLength()) {
                return MatchStatus.NOT_MATCHED;
            }
            boolean bl = !context.matchingEncodedVarbinary ? Bytes.compareTo(this.b, 0, this.b.length, text.get(), text.getOffset() + i, this.b.length) == 0 : (matched = LikePattern.matchEncodedVarbinary(this.b, text, i));
            if (!matched) {
                return MatchStatus.NOT_MATCHED;
            }
            context.current = this.next;
            context.textPosition = i + LikePattern.getSkippedBytes(this.b.length, i, context);
            return MatchStatus.UNCERTAIN;
        }

        public String toString() {
            if (this.c == '%') {
                return "\\%";
            }
            if (this.c == '_') {
                return "\\_";
            }
            return String.valueOf(this.c);
        }
    }

    private static class PercentSignNode
    extends Node {
        private boolean invert;

        public PercentSignNode(boolean invert) {
            this.invert = invert;
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            if (this.next == accept && i < text.length()) {
                return MatchStatus.MATCHED;
            }
            LikePattern.resetContext(context);
            context.current = this.next;
            context.textPosition = i;
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            if (this.next == accept && i < text.getLength()) {
                int numBytes;
                do {
                    if ((numBytes = LikePattern.getNumBytesInUTF8(text.get(), text.getOffset() + i, this.invert)) > 0) continue;
                    return MatchStatus.NOT_MATCHED;
                } while ((i += LikePattern.getSkippedBytes(numBytes, i, context)) < text.getLength());
                return MatchStatus.MATCHED;
            }
            LikePattern.resetContext(context);
            context.current = this.next;
            context.textPosition = i;
            return MatchStatus.UNCERTAIN;
        }

        public String toString() {
            return "%";
        }
    }

    private static class TerminationNode
    extends Node {
        TerminationNode() {
            this(null);
        }

        TerminationNode(Node unmatchedNext) {
            this.next = null;
            this.unmatchedNext = unmatchedNext;
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            if (i >= text.length()) {
                return MatchStatus.MATCHED;
            }
            if (this.unmatchedNext == null) {
                return MatchStatus.NOT_MATCHED;
            }
            int textPosition = i;
            Node node = this;
            if (context.firstUnmatchedExpectedInUnderscore != null) {
                textPosition = context.backtrackPosition;
                node = context.firstUnmatchedExpectedInUnderscore;
                LikePattern.resetContext(context);
            }
            context.current = node.unmatchedNext;
            context.textPosition = textPosition;
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            if (i >= text.getLength()) {
                return MatchStatus.MATCHED;
            }
            if (this.unmatchedNext == null) {
                return MatchStatus.NOT_MATCHED;
            }
            int textPosition = i;
            Node node = this;
            if (context.firstUnmatchedExpectedInUnderscore != null) {
                textPosition = context.backtrackPosition;
                node = context.firstUnmatchedExpectedInUnderscore;
                LikePattern.resetContext(context);
            }
            context.current = node.unmatchedNext;
            context.textPosition = textPosition;
            return MatchStatus.UNCERTAIN;
        }

        public String toString() {
            int count = 0;
            if (this.unmatchedNext != null) {
                Node node = this.unmatchedNext;
                while (node != this) {
                    ++count;
                    node = node.next;
                }
            }
            return this.unmatchedNext == null ? "END" : "END|(" + -count + ")";
        }
    }

    private static class DepartureNode
    extends Node {
        private DepartureNode() {
        }

        @Override
        public MatchStatus match(String text, int i, MatchContext context) {
            context.current = this.next;
            context.textPosition = i;
            return MatchStatus.UNCERTAIN;
        }

        @Override
        public MatchStatus match(ImmutableBytesPtr text, int i, MatchContext context) {
            context.current = this.next;
            context.textPosition = i;
            return MatchStatus.UNCERTAIN;
        }

        public String toString() {
            return "START";
        }
    }

    private static abstract class Node {
        protected Node unmatchedNext;
        protected Node next = LikePattern.access$000();

        Node() {
        }

        public abstract MatchStatus match(String var1, int var2, MatchContext var3);

        public abstract MatchStatus match(ImmutableBytesPtr var1, int var2, MatchContext var3);

        public boolean match(Node node) {
            throw new UnsupportedOperationException();
        }
    }

    private static enum MatchStatus {
        NOT_MATCHED,
        MATCHED,
        UNCERTAIN;

    }

    private static class MatchContext {
        private Node current;
        private int textPosition = 0;
        private UnderscoreNode firstUnmatchedExpectedInUnderscore;
        private int backtrackPosition = -1;
        private boolean matchingEncodedVarbinary;

        private MatchContext() {
        }
    }
}

