/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.ExistenceExpression;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NotExistExpression
extends ExistenceExpression {
    private LColumn column;

    public NotExistExpression() {
    }

    public NotExistExpression(byte[] columnName) {
        super(columnName);
    }

    public NotExistExpression(byte[] family, byte[] columnName) {
        super(family, columnName);
    }

    public NotExistExpression(LColumn column) {
        super(column.getColumnKey());
        this.column = column;
    }

    @Override
    public String toParseableString() {
        return "(" + this.columnKey.toString() + " not exist)";
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        assert (this.column != null);
        if (this.column.isPrimaryKey()) {
            result.set(DataTypeUtils.FALSE_BYTES);
            return true;
        }
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        tuple.getKeyValue(this.columnKey.getFamily(), this.columnKey.getQualifier(), ptr);
        if (ptr.get() == Bytes.EMPTY_BYTE_ARRAY) {
            return false;
        }
        result.set(DataTypeUtils.FALSE_BYTES);
        return true;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws LindormException {
        return visitor.visit(this);
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        if (this.column != null) {
            WritableUtils.writeVInt(out, 1);
            this.column.writeTo(out);
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int hasColumnMeta = WritableUtils.readVInt(in);
        if (hasColumnMeta != 0) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
    }

    @Override
    public String toString() {
        return this.toParseableString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NotExistExpression)) {
            return false;
        }
        NotExistExpression other = (NotExistExpression)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        return this.column == null ? other.column == null : this.column.equals(other.column);
    }

    public int hashCode() {
        return this.columnKey.hashCode() + (this.column == null ? 0 : this.column.hashCode());
    }
}

