/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LLong;
import com.alibaba.lindorm.client.core.types.LUnsignedTimestamp;
import com.alibaba.lindorm.client.core.utils.DataGenerator;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.sql.Timestamp;

public class LTimestamp
extends LDataType<Timestamp> {
    public static final int MAX_NANO_VALUE = 1000000;
    public static final LTimestamp INSTANCE = new LTimestamp();

    private LTimestamp() {
        super(DataType.TIMESTAMP, Timestamp.class);
    }

    @Override
    public int getByteSize() {
        return 12;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        Timestamp ts = (Timestamp)value;
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeLong(ts.getTime(), ret, 0, sortOrder);
        DataTypeUtils.encodeUnsignedInt(ts.getNanos() % 1000000, ret, 8, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        long v;
        if (value == null) {
            return null;
        }
        if (DataTypeUtils.equalsAny(actualType, INSTANCE, LUnsignedTimestamp.INSTANCE)) {
            return value;
        }
        try {
            v = (Long)LLong.INSTANCE.toObject(value, actualType);
        }
        catch (IllegalDataException t) {
            throw new IllegalDataException(actualType.getClientType(), value, this.clientType);
        }
        return new Timestamp(v);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        long ms = DataTypeUtils.decodeLong(value, offset, sortOrder);
        int nanos = DataTypeUtils.decodeUnsignedInt(value, offset + 8, sortOrder);
        Timestamp ts = new Timestamp(ms);
        if (nanos < 1000000) {
            ts.setNanos(ts.getNanos() + nanos);
        } else {
            ts.setNanos(nanos);
        }
        return ts;
    }

    @Override
    public byte[] getNullValue() {
        return DataTypeUtils.ZERO_TIMESTAMP_ARRAY;
    }

    @Override
    public Timestamp randomData(DataGenerator dataGenerator) {
        return new Timestamp(dataGenerator.getRandom().nextInt(Integer.MAX_VALUE));
    }
}

