/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WColumn;
import com.alibaba.lindorm.client.core.widecolumnservice.WRow;
import com.alibaba.lindorm.client.quota.ClientQuotaContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class WResult
extends VersionedObjectWithAttributes {
    public static final String QUOTACONTEXT = "_quotacontext_";
    private WRow wRow;
    private List<WColumn> rawColumns = null;
    private NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> familyVersionMap = null;

    public WResult() {
    }

    public WResult(WRow row) {
        this.wRow = row;
    }

    public boolean isEmptyResultRow() {
        return this.wRow.getRowKey().length > 0 && this.wRow.getFamilyMap().size() == 0;
    }

    public byte[] getRowKey() {
        return this.wRow.getRowKey();
    }

    public List<WColumn> raw() {
        if (this.rawColumns != null) {
            return this.rawColumns;
        }
        ArrayList<WColumn> columns = new ArrayList<WColumn>();
        for (Map.Entry<byte[], List<WColumn>> entry : this.wRow.getFamilyMap().entrySet()) {
            columns.addAll((Collection<WColumn>)entry.getValue());
        }
        this.rawColumns = columns;
        return this.rawColumns;
    }

    public List<WColumn> getColumn(byte[] family, byte[] qualifier) {
        ArrayList<WColumn> ret = new ArrayList<WColumn>();
        List<WColumn> columns = this.wRow.getColumnList(family);
        if (columns == null) {
            return ret;
        }
        for (WColumn column : columns) {
            if (!column.isMatchingQualifier(qualifier)) continue;
            ret.add(column);
        }
        return ret;
    }

    public ClientQuotaContext getClientQuotaContext() {
        byte[] bytes = this.getAttribute(QUOTACONTEXT);
        if (bytes != null && bytes.length > 0) {
            ClientQuotaContext clientQuotaContext = new ClientQuotaContext();
            try {
                return (ClientQuotaContext)WritableUtils.getWritable(bytes, clientQuotaContext);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public void setClientQuotaContext(ClientQuotaContext clientQuotaContext) {
        if (clientQuotaContext != null) {
            try {
                byte[] bytes = WritableUtils.getBytes(clientQuotaContext);
                this.setAttribute(QUOTACONTEXT, bytes);
            }
            catch (Throwable throwable) {}
        } else {
            this.removeAttribute(QUOTACONTEXT);
        }
    }

    public WColumn getColumnLatest(byte[] family, byte[] qualifier) {
        List<WColumn> columns = this.wRow.getColumnList(family);
        if (columns == null) {
            return null;
        }
        for (WColumn column : columns) {
            if (!column.isMatchingQualifier(qualifier)) continue;
            return column;
        }
        return null;
    }

    public byte[] getValue(byte[] family, byte[] qualifier) {
        WColumn column = this.getColumnLatest(family, qualifier);
        if (column == null) {
            return null;
        }
        return column.getValue();
    }

    public boolean containsColumn(byte[] family, byte[] qualifier) {
        WColumn kv = this.getColumnLatest(family, qualifier);
        return kv != null;
    }

    public boolean containsQualifier(byte[] qualifier) {
        List<WColumn> columns = this.raw();
        for (WColumn column : columns) {
            if (!column.isMatchingQualifier(qualifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        List<WColumn> columns = this.raw();
        return columns == null || columns.size() == 0;
    }

    public int size() {
        List<WColumn> columns = this.raw();
        if (columns == null) {
            return 0;
        }
        return columns.size();
    }

    List<WColumn> getFamily(byte[] family) {
        return this.wRow.getFamilyMap().get(family);
    }

    @Override
    public String toString() {
        return this.wRow.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.wRow.writeTo(out);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.wRow = new WRow();
        this.wRow.readFrom(in);
    }

    public NavigableMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>> getMap() {
        if (this.familyVersionMap != null) {
            return this.familyVersionMap;
        }
        if (this.isEmpty()) {
            return null;
        }
        this.familyVersionMap = new TreeMap<byte[], NavigableMap<byte[], NavigableMap<Long, byte[]>>>(Bytes.BYTES_COMPARATOR);
        for (byte[] family : this.wRow.getFamilyMap().keySet()) {
            TreeMap<byte[], TreeMap<Long, byte[]>> columnMap = (TreeMap<byte[], TreeMap<Long, byte[]>>)this.familyVersionMap.get(family);
            if (columnMap == null) {
                columnMap = new TreeMap<byte[], TreeMap<Long, byte[]>>(Bytes.BYTES_COMPARATOR);
                this.familyVersionMap.put(family, columnMap);
            }
            List<WColumn> columns = this.wRow.getFamilyMap().get(family);
            for (WColumn column : columns) {
                byte[] qualifier = column.getQualifier();
                TreeMap<Long, byte[]> versionMap = (TreeMap<Long, byte[]>)columnMap.get(qualifier);
                if (versionMap == null) {
                    versionMap = new TreeMap<Long, byte[]>(new Comparator<Long>(){

                        @Override
                        public int compare(Long l1, Long l2) {
                            return l2.compareTo(l1);
                        }
                    });
                    columnMap.put(qualifier, versionMap);
                }
                byte[] value = column.getValue();
                versionMap.put(column.getTs(), value);
            }
        }
        return this.familyVersionMap;
    }

    public int getEstimatedSize() {
        int size = 0;
        size += this.wRow.getEstimatedSize();
        return size += this.getAttrEstimatedSize();
    }
}

